/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.functiongraph.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.widgets.dialogs.ObjectChooserDialog;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FgEnv;
import ghidra.features.codecompare.functiongraph.FgComparisonContext;
import ghidra.features.codecompare.functiongraph.FgDisplay;
import ghidra.features.codecompare.functiongraph.FunctionGraphCodeComparisonView;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Duo;
import java.util.ArrayList;

public class FgRelayoutAction
extends DockingAction {
    private FunctionGraphCodeComparisonView fgProvider;

    public FgRelayoutAction(FunctionGraphCodeComparisonView fgProvider) {
        super("Relayout Graph", fgProvider.getOwner(), KeyBindingType.SHARED);
        this.fgProvider = fgProvider;
        this.setPopupMenuData(new MenuData(new String[]{"Relayout Graph"}));
        this.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Function_Graph_Action_Layout"));
    }

    public void actionPerformed(ActionContext context) {
        Duo<FgDisplay> displays = this.fgProvider.getDisplays();
        FgDisplay leftDisplay = (FgDisplay)displays.get(Duo.Side.LEFT);
        FGController leftController = leftDisplay.getController();
        FgEnv env = leftController.getEnv();
        ArrayList layoutProviders = new ArrayList(env.getLayoutProviders());
        ObjectChooserDialog dialog = new ObjectChooserDialog("Choose Layout", FGLayoutProvider.class, layoutProviders, new String[]{"getLayoutName"});
        FGLayoutProvider currentLayout = leftController.getLayoutProvider();
        dialog.setSelectedObject((Object)currentLayout);
        PluginTool tool = env.getTool();
        tool.showDialog((DialogComponentProvider)dialog);
        FGLayoutProvider layoutProvider = (FGLayoutProvider)dialog.getSelectedObject();
        if (layoutProvider == null) {
            return;
        }
        leftController.changeLayout(layoutProvider);
        FgDisplay rightDisplay = (FgDisplay)displays.get(Duo.Side.RIGHT);
        FGController rightController = rightDisplay.getController();
        rightController.changeLayout(layoutProvider);
        this.fgProvider.stateChanged();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof FgComparisonContext;
    }
}

