/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.lang.ref.Cleaner;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.util.LazyCleaner;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LazyCleanerImpl
implements LazyCleaner {
    private static final Logger LOGGER = Logger.getLogger(LazyCleanerImpl.class.getName());
    private static final LazyCleanerImpl instance = new LazyCleanerImpl("PostgreSQL-JDBC-Cleaner", Duration.ofMillis(Long.getLong("pgjdbc.config.cleanup.thread.ttl", 30000L)));
    private final Cleaner cleaner = Cleaner.create();

    public LazyCleanerImpl(String threadName, Duration threadTtl) {
    }

    public static LazyCleanerImpl getInstance() {
        return instance;
    }

    @Override
    public <T extends Throwable> LazyCleaner.Cleanable<T> register(Object obj, LazyCleaner.CleaningAction<T> action) {
        assert (obj != action) : "object handle should not be the same as cleaning action, otherwise the object will never become phantom reachable, so the action will never trigger";
        CleanableWrapper<T> wrapper = new CleanableWrapper<T>(action);
        Cleaner.Cleanable nativeCleanable = this.cleaner.register(obj, wrapper::leakDetected);
        wrapper.setNativeCleanable(nativeCleanable);
        return wrapper;
    }

    public boolean isThreadRunning() {
        return false;
    }

    private static class CleanableWrapper<T extends Throwable>
    implements LazyCleaner.Cleanable<T> {
        private @Nullable Cleaner.Cleanable nativeCleanable;
        private volatile @Nullable LazyCleaner.CleaningAction<T> action;

        CleanableWrapper(LazyCleaner.CleaningAction<T> action) {
            this.action = action;
        }

        void setNativeCleanable(Cleaner.Cleanable nativeCleanable) {
            this.nativeCleanable = nativeCleanable;
        }

        private synchronized @Nullable LazyCleaner.CleaningAction<T> getCleaningAction() {
            LazyCleaner.CleaningAction<T> action = this.action;
            this.action = null;
            return action;
        }

        void leakDetected() {
            LazyCleaner.CleaningAction<T> cleaningAction = this.getCleaningAction();
            if (cleaningAction == null) {
                return;
            }
            try {
                cleaningAction.onClean(true);
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    LOGGER.log(Level.WARNING, "Unexpected interrupt while executing onClean", e);
                }
                LOGGER.log(Level.WARNING, "Unexpected exception while executing onClean", e);
            }
        }

        @Override
        public void clean() throws T {
            LazyCleaner.CleaningAction<T> cleaningAction = this.getCleaningAction();
            if (cleaningAction == null) {
                return;
            }
            Cleaner.Cleanable nativeCleanable = this.nativeCleanable;
            if (nativeCleanable != null) {
                this.nativeCleanable = null;
                nativeCleanable.clean();
            }
            cleaningAction.onClean(false);
        }
    }
}

