/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.DataImage;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class BitmapResource {
    private static final int BOTTOM_UP = 1;
    protected int size;
    private int width;
    private int planes;
    private int bitCount;
    private int compression;
    private int xPelsPerMeter;
    private int yPelsPerMeter;
    private int clrUsed;
    private int clrImportant;
    protected int sizeImage;
    protected int rawSizeImage = -1;
    private int imageDataOffset;
    protected int height;
    protected int rowOrder = 1;
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;

    public BitmapResource(MemBuffer buf) throws IOException {
        this.initialize(buf);
    }

    private void initialize(MemBuffer buf) throws IOException {
        try {
            this.size = buf.getInt(0);
            this.width = buf.getInt(4);
            this.height = buf.getInt(8);
            this.planes = buf.getShort(12);
            this.bitCount = buf.getShort(14);
            this.compression = buf.getInt(16);
            this.sizeImage = buf.getInt(20);
            this.xPelsPerMeter = buf.getInt(24);
            this.yPelsPerMeter = buf.getInt(28);
            this.clrUsed = buf.getInt(32);
            this.clrImportant = buf.getInt(36);
            this.imageDataOffset = this.size + this.getColorMapLength();
        }
        catch (MemoryAccessException e) {
            throw new IOException("Truncated header for bitmap at " + String.valueOf(buf.getAddress()));
        }
        if (this.bitCount < 0 || this.width < 0 || this.height < 0 || this.bitCount > 32 || this.width > 4096 || this.height > 4096) {
            throw new IOException("Invalid dimensions for bitmap at " + String.valueOf(buf.getAddress()));
        }
        if (this.clrUsed > (int)Math.pow(2.0, this.bitCount) || this.clrUsed > 65536 || this.clrUsed == 0 && this.bitCount > 32) {
            throw new IOException("Invalid colormap dimensions for bitmap at " + String.valueOf(buf.getAddress()));
        }
        int sz = this.width * this.height * this.bitCount / 16;
        if (sz < 0 || this.sizeImage < 0) {
            throw new IOException("Invalid size for bitmap at " + String.valueOf(buf.getAddress()));
        }
        try {
            BitmapDecompressResult decompress = this.decompress(buf, this.imageDataOffset, false, this.getImageDataSize());
            this.rawSizeImage = decompress.rawDataSize;
        }
        catch (MemoryAccessException e) {
            throw new IOException("Image data read error for bitmap at " + String.valueOf(buf.getAddress()));
        }
    }

    public int getMaskLength() {
        return 0;
    }

    public int getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getRawSizeImage() {
        return this.rawSizeImage;
    }

    public int getImageDataSize() {
        if (this.sizeImage == 0) {
            this.sizeImage = this.getComputedUncompressedImageDataSize();
        }
        return this.sizeImage;
    }

    protected int getComputedUncompressedImageDataSize() {
        return this.getBytesPerLine() * this.getHeight();
    }

    private int getBytesPerLine() {
        int lineLen = this.getWidth() * this.getBitCount();
        lineLen = this.getBitCount() == 1 ? (lineLen /= 8) : (this.getBitCount() == 4 ? (lineLen + 4) / 8 : (this.getBitCount() == 24 ? (lineLen /= 8) : (lineLen /= 8)));
        if (lineLen % 4 != 0) {
            lineLen += 4 - lineLen % 4;
        }
        return lineLen;
    }

    public int getXPelsPerMeter() {
        return this.xPelsPerMeter;
    }

    public int getYPelsPerMeter() {
        return this.yPelsPerMeter;
    }

    public int getClrUsed() {
        if (this.clrUsed == 0) {
            this.clrUsed = (int)Math.pow(2.0, this.bitCount);
        }
        return this.clrUsed;
    }

    public int getClrImportant() {
        return this.clrImportant;
    }

    public byte[] getPixelData(MemBuffer buf) {
        byte[] rawPixels = new byte[this.getImageDataSize()];
        if (buf.getBytes(rawPixels, this.size + this.getColorMapLength()) != rawPixels.length) {
            return new byte[0];
        }
        return rawPixels;
    }

    public int[] getRGBData(MemBuffer buf) {
        byte[] rawCmap = new byte[this.getColorMapLength()];
        if (buf.getBytes(rawCmap, this.size) != rawCmap.length) {
            return new int[0];
        }
        int[] cmap = new int[this.getClrUsed()];
        for (int i = 0; i < cmap.length; ++i) {
            cmap[i] = (rawCmap[i * 4 + 2] & 0xFF) << 16;
            int n = i;
            cmap[n] = cmap[n] + ((rawCmap[i * 4 + 1] & 0xFF) << 8);
            int n2 = i;
            cmap[n2] = cmap[n2] + (rawCmap[i * 4 + 0] & 0xFF);
        }
        return cmap;
    }

    public int[] getColorMap(MemBuffer buf) {
        return null;
    }

    public int getColorMapLength() {
        if (this.bitCount == 32 || this.bitCount == 24) {
            return 0;
        }
        return this.getClrUsed() * 4;
    }

    public DataImage getDataImage(MemBuffer buf) {
        if (this.bitCount == 1) {
            return this.getOnePlaneImage(buf);
        }
        if (this.bitCount == 4) {
            return this.getFourPlaneImage(buf);
        }
        if (this.bitCount == 8) {
            return this.getEightPlaneImage(buf);
        }
        if (this.bitCount == 24) {
            return this.get18PlaneImage(buf);
        }
        if (this.bitCount == 32) {
            return this.get32PlaneImage(buf);
        }
        return null;
    }

    protected DataImage get32PlaneImage(MemBuffer buf) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        int[] bOffs = new int[]{2, 1, 0, 3};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 3, 0);
        int w = this.getWidth();
        int h = this.getHeight();
        WritableRaster raster = Raster.createInterleavedRaster(0, w, h, w * 4, 4, bOffs, null);
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        byte[] dbuf = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.getPixelData(buf, dbuf);
        return new BitmapDataImage(image);
    }

    protected DataImage get18PlaneImage(MemBuffer buf) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8};
        int[] bOffs = new int[]{2, 1, 0};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        int w = this.getWidth();
        int h = this.getHeight();
        WritableRaster raster = Raster.createInterleavedRaster(0, w, h, w * 3, 3, bOffs, null);
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        byte[] dbuf = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.getPixelData(buf, dbuf);
        return new BitmapDataImage(image);
    }

    protected DataImage getEightPlaneImage(MemBuffer buf) {
        IndexColorModel model = new IndexColorModel(8, this.getClrUsed(), this.getRGBData(buf), 0, false, -1, 0);
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 13, model);
        byte[] dbuf = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.getPixelData(buf, dbuf);
        return new BitmapDataImage(image);
    }

    protected DataImage getFourPlaneImage(MemBuffer buf) {
        int[] colormapData = this.getRGBData(buf);
        IndexColorModel model = new IndexColorModel(4, this.getClrUsed(), colormapData, 0, false, -1, 0);
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 12, model);
        byte[] dbuf = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.getPixelData(buf, dbuf);
        return new BitmapDataImage(image);
    }

    protected DataImage getOnePlaneImage(MemBuffer buf) {
        int[] colormapData = this.getRGBData(buf);
        IndexColorModel model = new IndexColorModel(1, this.getClrUsed(), colormapData, 0, false, -1, 0);
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 12, model);
        byte[] dbuf = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.getPixelData(buf, dbuf);
        return new BitmapDataImage(image);
    }

    protected void getPixelData(MemBuffer buf, byte[] dbuf) {
        BitmapDecompressResult decompress;
        int bytesPerLine = this.getBytesPerLine();
        try {
            decompress = this.decompress(buf, this.imageDataOffset, true, this.getImageDataSize());
        }
        catch (MemoryAccessException e) {
            return;
        }
        byte[] imageData = decompress.decompressedImageData;
        int h = this.getHeight();
        if (this.compression != 0) {
            bytesPerLine = imageData.length / h;
        }
        if (imageData.length == 0) {
            return;
        }
        if (this.rowOrder == 1) {
            for (int i = 0; i < h; ++i) {
                int offset = i * bytesPerLine;
                int destIndex = (h - i - 1) * (dbuf.length / h);
                System.arraycopy(imageData, offset, dbuf, destIndex, dbuf.length / h);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BitmapDecompressResult decompress(MemBuffer buf, int offset, boolean returnDecompressedData, int maxCompressedDataLength) throws MemoryAccessException {
        block35: {
            rawDataSize = 0;
            decompressedDataSize = 0;
            decompressedData = null;
            h = this.getHeight();
            w = this.getWidth();
            maxBufferOffset = offset + maxCompressedDataLength;
            if (this.compression == 0) {
                decompressedDataSize = rawDataSize = this.getImageDataSize();
                if (returnDecompressedData == false) return new BitmapDecompressResult(rawDataSize, decompressedDataSize, decompressedData);
                decompressedData = new byte[rawDataSize];
                buf.getBytes(decompressedData, offset);
                return new BitmapDecompressResult(rawDataSize, decompressedDataSize, decompressedData);
            }
            if (this.compression != 2) {
                if (this.compression != 1) {
                    Msg.error((Object)this, (Object)("Unsupported bitmap resource compression type " + this.compression + " at " + String.valueOf(buf.getAddress())));
                    return new BitmapDecompressResult(rawDataSize, decompressedDataSize, decompressedData);
                }
                x = 0;
                y = 0;
                byteWidth = w;
                decompressedDataSize = byteWidth * h;
                if (returnDecompressedData) {
                    decompressedData = new byte[decompressedDataSize];
                }
            } else {
                block33: {
                    x = 0;
                    y = 0;
                    byteWidth = (w + 1) / 2;
                    decompressedDataSize = byteWidth * h;
                    if (returnDecompressedData) {
                        decompressedData = new byte[decompressedDataSize];
                    }
                    readOffset = offset;
                    try lbl-1000:
                    // 2 sources

                    {
                        block14: while (true) {
                            if (readOffset >= maxBufferOffset) {
                                throw new MemoryAccessException("Bitmap resource decompression exceeded memory constraint at " + String.valueOf(buf.getAddress()));
                            }
                            if ((val = buf.getByte(readOffset++)) == 0) {
                                if ((val = buf.getByte(readOffset++)) != 1) {
                                    switch (val) {
                                        case 0: {
                                            x = 0;
                                            ++y;
                                            continue block14;
                                        }
                                        case 1: {
                                            throw new AssertException();
                                        }
                                        case 2: {
                                            xdelta = buf.getByte(readOffset++) & 255;
                                            ydelta = buf.getByte(readOffset++) & 255;
                                            x += xdelta;
                                            y += ydelta;
                                            continue block14;
                                        }
                                    }
                                    numFollow = val & 255;
                                    if (decompressedData != null) {
                                        bytes = new byte[numFollow / 2];
                                        buf.getBytes(bytes, readOffset);
                                        System.arraycopy(bytes, 0, decompressedData, y * byteWidth + x / 2, bytes.length);
                                        x += numFollow;
                                    }
                                    readOffset += (numFollow + 1) / 2;
                                    readOffset += readOffset % 2;
                                    continue;
                                }
                                break;
                            }
                            run = val;
                            val = buf.getByte(readOffset++);
                            if (decompressedData == null) continue;
                            j = 0;
                            break block33;
                            break;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    }
                    rawDataSize = readOffset - offset;
                    return new BitmapDecompressResult(rawDataSize, decompressedDataSize, decompressedData);
                }
                while (true) {
                    if (j < run && x < w && y < h) ** break;
                    ** continue;
                    cval = decompressedData[y * byteWidth + x / 2];
                    cmask = 240 >> (x + 1) % 2 * 4;
                    mask = 240 >> j % 2 * 4;
                    nibble = (val & mask) >> (j + 1) % 2 * 4;
                    decompressedData[y * byteWidth + x / 2] = (byte)(cval & cmask | nibble << (x + 1) % 2 * 4);
                    ++x;
                    ++j;
                }
            }
            readOffset = offset;
            try lbl-1000:
            // 2 sources

            {
                block16: while (true) {
                    if (readOffset >= maxBufferOffset) {
                        throw new MemoryAccessException("Bitmap resource decompression exceeded memory constraint at " + String.valueOf(buf.getAddress()));
                    }
                    if ((val = buf.getByte(readOffset++)) == 0) {
                        if ((val = buf.getByte(readOffset++)) != 1) {
                            switch (val) {
                                case 0: {
                                    x = 0;
                                    ++y;
                                    continue block16;
                                }
                                case 1: {
                                    throw new AssertException();
                                }
                                case 2: {
                                    xdelta = buf.getByte(readOffset++) & 255;
                                    ydelta = buf.getByte(readOffset++) & 255;
                                    x += xdelta;
                                    y += ydelta;
                                    continue block16;
                                }
                            }
                            numFollow = val & 255;
                            if (decompressedData != null) {
                                bytes = new byte[numFollow];
                                buf.getBytes(bytes, readOffset);
                                System.arraycopy(bytes, 0, decompressedData, y * byteWidth + x, bytes.length);
                                x += numFollow;
                            }
                            readOffset += numFollow;
                            readOffset += readOffset % 2;
                            continue;
                        }
                        break;
                    }
                    run = val;
                    val = buf.getByte(readOffset++);
                    if (decompressedData == null) continue;
                    j = 0;
                    break block35;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            rawDataSize = readOffset - offset;
            return new BitmapDecompressResult(rawDataSize, decompressedDataSize, decompressedData);
        }
        while (true) {
            if (j < run && x < w && y < h) ** break;
            ** continue;
            decompressedData[y * byteWidth + x] = (byte)val;
            ++x;
            ++j;
        }
    }

    private static class BitmapDecompressResult {
        final int rawDataSize;
        final int decompressedDataSize;
        final byte[] decompressedImageData;

        BitmapDecompressResult(int rawDataSize, int decompressedDataSize, byte[] decompressedImageData) {
            this.rawDataSize = rawDataSize;
            this.decompressedDataSize = decompressedDataSize;
            this.decompressedImageData = decompressedImageData;
        }
    }

    private static class BitmapDataImage
    extends DataImage {
        private final BufferedImage image;

        BitmapDataImage(BufferedImage image) {
            this.image = image;
        }

        @Override
        public ImageIcon getImageIcon() {
            return ResourceManager.getImageIconFromImage((String)"Bitmap Data Image", (Image)this.image);
        }

        @Override
        public String getImageFileType() {
            return "bmp";
        }
    }
}

