/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.panel;

import ghidra.features.base.codecompare.panel.CodeComparisonView;
import ghidra.framework.options.SaveState;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CodeComparisonViewState {
    private static final String FUNCTION_COMPARISON_STATES = "CodeComparisonStates";
    private Map<Class<? extends CodeComparisonView>, SaveState> states = new HashMap<Class<? extends CodeComparisonView>, SaveState>();

    public SaveState getSaveState(Class<? extends CodeComparisonView> clazz) {
        return this.states.computeIfAbsent(clazz, this::createSaveState);
    }

    private SaveState createSaveState(Class<? extends CodeComparisonView> clazz) {
        return new SaveState();
    }

    public void writeConfigState(SaveState saveState) {
        Set<Map.Entry<Class<? extends CodeComparisonView>, SaveState>> entries = this.states.entrySet();
        SaveState classStates = new SaveState();
        for (Map.Entry<Class<? extends CodeComparisonView>, SaveState> entry : entries) {
            Class<? extends CodeComparisonView> clazz = entry.getKey();
            SaveState subState = entry.getValue();
            classStates.putSaveState(clazz.getName(), subState);
        }
        saveState.putSaveState(FUNCTION_COMPARISON_STATES, classStates);
    }

    public void readConfigState(SaveState saveState) {
        String[] names;
        SaveState classStates = saveState.getSaveState(FUNCTION_COMPARISON_STATES);
        if (classStates == null) {
            return;
        }
        for (String className : names = classStates.getNames()) {
            try {
                Class<?> clazz = Class.forName(className);
                SaveState classState = classStates.getSaveState(className);
                this.states.put(clazz, classState);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

