/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.codeexplorer.connectors.CodeLinkController;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.graph.GraphCycleFinder;
import org.freeplane.plugin.codeexplorer.map.ClassNode;
import org.freeplane.plugin.codeexplorer.map.CodeAttribute;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNodeLinks;
import org.freeplane.plugin.codeexplorer.task.CodeAttributeMatcher;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;

public abstract class CodeNode
extends NodeModel {
    protected final int groupIndex;

    static String formatClassCount(long classCount) {
        return " (" + classCount + (classCount == 1L ? " class)" : " classes)");
    }

    public static JavaClass findEnclosingNamedClass(JavaClass javaClass) {
        if (javaClass.isAnonymousClass() && javaClass.getEnclosingClass().isPresent()) {
            return CodeNode.findEnclosingNamedClass((JavaClass)javaClass.getEnclosingClass().get());
        }
        if (javaClass.isArray()) {
            return javaClass.getBaseComponentType();
        }
        return javaClass;
    }

    public static JavaClass findEnclosingTopLevelClass(JavaClass javaClass) {
        if (javaClass.isNestedClass() && javaClass.getEnclosingClass().isPresent()) {
            return CodeNode.findEnclosingTopLevelClass((JavaClass)javaClass.getEnclosingClass().get());
        }
        if (javaClass.isArray()) {
            return CodeNode.findEnclosingTopLevelClass(javaClass.getBaseComponentType());
        }
        return javaClass;
    }

    public static boolean hasValidTopLevelClass(JavaClass javaClass) {
        if (javaClass.isArray()) {
            return CodeNode.hasValidTopLevelClass(javaClass.getBaseComponentType());
        }
        if (javaClass.isTopLevelClass()) {
            return -1 == javaClass.getSimpleName().indexOf(45);
        }
        Optional extectedEnclosingClass = javaClass.getEnclosingClass();
        while (extectedEnclosingClass.isPresent()) {
            JavaClass enclosingClass = (JavaClass)extectedEnclosingClass.get();
            if (!CodeNode.classSourceLocationOf(enclosingClass).equals(CodeNode.classSourceLocationOf(javaClass))) {
                return false;
            }
            if (enclosingClass.isTopLevelClass()) {
                return true;
            }
            extectedEnclosingClass = ((JavaClass)extectedEnclosingClass.get()).getEnclosingClass();
        }
        return true;
    }

    public static boolean hasValidTopLevelClasses(Dependency dependency) {
        return CodeNode.hasValidTopLevelClass(dependency.getOriginClass()) && CodeNode.hasValidTopLevelClass(dependency.getTargetClass());
    }

    static String idWithGroupIndex(String idWithoutIndex, int groupIndex) {
        return idWithoutIndex + "[" + groupIndex + "]";
    }

    static JavaClass getTargetNodeClass(Dependency dependency) {
        return CodeNode.findEnclosingNamedClass(dependency.getTargetClass());
    }

    static boolean isNamed(JavaClass jc) {
        return !jc.isAnonymousClass() && !jc.isArray();
    }

    private boolean isTargetSourceKnown(Dependency dep) {
        return this.belongsToMap(dep.getTargetClass());
    }

    private boolean isOriginSourceKnown(Dependency dep) {
        return this.belongsToMap(dep.getOriginClass());
    }

    public boolean belongsToMap(JavaClass javaClass) {
        return this.getMap().isKnown(javaClass);
    }

    static boolean classesBelongToTheSamePackage(JavaClass first, JavaClass second) {
        return second.getPackage().equals(first.getPackage());
    }

    static boolean classesBelongToTheSamePackage(Dependency dependency) {
        return CodeNode.classesBelongToTheSamePackage(dependency.getOriginClass(), dependency.getTargetClass());
    }

    CodeNode(CodeMap map, int groupIndex) {
        super((MapModel)map);
        this.groupIndex = groupIndex;
    }

    void updateCodeAttributes(CodeAttributeMatcher codeAttributeMatcher) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)this);
        for (int row = attributes.getRowCount() - 1; row >= 0; --row) {
            if (!(attributes.getAttribute(row) instanceof CodeAttribute)) continue;
            attributes.getAttributes().remove(row);
            attributes.fireTableRowsDeleted((NodeModel)this, row, row);
        }
        if (!codeAttributeMatcher.isEmpty()) {
            this.getAnnotations().forEach(annotation -> {
                String annotationName = ClassNode.classNameWithNestedClasses(annotation.getRawType());
                annotation.getProperties().entrySet().stream().filter(attributeEntry -> codeAttributeMatcher.matches((JavaAnnotation<?>)annotation, (String)attributeEntry.getKey())).forEach(attributeEntry -> this.addCodeAttributes(attributes, "@" + annotationName, (String)attributeEntry.getKey(), attributeEntry.getValue()));
                if (annotation.getProperties().isEmpty() && codeAttributeMatcher.matches((HasName)annotation.getRawType())) {
                    this.addCodeAttributes(attributes, "@" + annotationName, "value", "");
                }
            });
            this.getInterfaces().forEach(javaInterface -> {
                JavaClass javaClass = javaInterface.toErasure();
                String interfaceName = ClassNode.classNameWithNestedClasses(javaClass);
                if (codeAttributeMatcher.matches((HasName)javaClass)) {
                    this.addCodeAttributes(attributes, "interface", "value", interfaceName);
                }
            });
        }
        this.getChildren().forEach(child -> ((CodeNode)((Object)child)).updateCodeAttributes(codeAttributeMatcher));
    }

    private void addCodeAttributes(NodeAttributeTableModel attributes, String annotationName, String key, Object values) {
        Stream<Object> valueStream = values.getClass().isArray() ? Stream.of((Object[])values) : Stream.of(values);
        valueStream.forEach(value -> attributes.addRowNoUndo((NodeModel)this, (Attribute)new CodeAttribute(key.equals("value") ? annotationName : annotationName + "." + key, value)));
    }

    Set<? extends JavaAnnotation<? extends HasName>> getAnnotations() {
        return Collections.emptySet();
    }

    Set<JavaType> getInterfaces() {
        return Collections.emptySet();
    }

    public CodeMap getMap() {
        return (CodeMap)super.getMap();
    }

    public CodeNode getParentNode() {
        return (CodeNode)super.getParentNode();
    }

    String getCodeElementName() {
        return this.getCodeElement().getName();
    }

    void setIdWithIndex(String idWithoutIndex) {
        this.setID(this.idWithOwnGroupIndex(idWithoutIndex));
    }

    String idWithOwnGroupIndex(String idWithoutIndex) {
        return CodeNode.idWithGroupIndex(idWithoutIndex, this.groupIndex);
    }

    String idWithGroupIndex(JavaClass javaClass) {
        JavaClass enclosingNamedClass = CodeNode.findEnclosingNamedClass(javaClass);
        return CodeNode.idWithGroupIndex(enclosingNamedClass.getName(), this.getMap().groupIndexOf(enclosingNamedClass));
    }

    boolean belongsToSameGroup(JavaClass javaClass) {
        return CodeNode.hasValidTopLevelClass(javaClass) && this.validClassBelongsToSameGroup(javaClass);
    }

    boolean validClassBelongsToSameGroup(JavaClass javaClass) {
        int anotherGroupIndex = this.projectIndexOf(javaClass);
        return anotherGroupIndex == this.groupIndex;
    }

    int projectIndexOf(JavaClass javaClass) {
        return this.getMap().groupIndexOf(javaClass);
    }

    boolean belongsToOtherGroup(JavaClass javaClass) {
        return CodeNode.hasValidTopLevelClass(javaClass) && !this.validClassBelongsToSameGroup(javaClass);
    }

    abstract HasName getCodeElement();

    abstract long getClassCount();

    abstract Stream<Dependency> getOutgoingDependencies();

    abstract Stream<Dependency> getIncomingDependencies();

    abstract String getUIIconName();

    Stream<Dependency> getIncomingAndOutgoingDependencies() {
        return Stream.concat(this.getIncomingDependencies(), this.getOutgoingDependencies());
    }

    public Stream<Dependency> getOutgoingDependenciesWithKnownTargets() {
        return this.getOutgoingDependencies().filter(this::isTargetSourceKnown);
    }

    public Stream<Dependency> getIncomingDependenciesWithKnownOrigins() {
        return this.getIncomingDependencies().filter(this::isOriginSourceKnown);
    }

    Stream<Dependency> getIncomingAndOutgoingDependenciesWithKnownTargets() {
        return Stream.concat(this.getIncomingDependenciesWithKnownOrigins(), this.getOutgoingDependenciesWithKnownTargets());
    }

    public Stream<Dependency> getOutgoingDependenciesWithKnownTargets(Filter filter) {
        Stream<Dependency> outgoingDependenciesWithKnownTargets = this.getOutgoingDependenciesWithKnownTargets();
        return filter == null ? outgoingDependenciesWithKnownTargets : outgoingDependenciesWithKnownTargets.filter(dep -> filter.accepts((NodeModel)this.getMap().getNodeByClass(dep.getOriginClass())));
    }

    public Stream<Dependency> getIncomingDependenciesWithKnownOrigins(Filter filter) {
        Stream<Dependency> incomingDependenciesWithKnownOrigins = this.getIncomingDependenciesWithKnownOrigins();
        return filter == null ? incomingDependenciesWithKnownOrigins : incomingDependenciesWithKnownOrigins.filter(dep -> filter.accepts((NodeModel)this.getMap().getNodeByClass(dep.getTargetClass())));
    }

    Stream<Dependency> getIncomingAndOutgoingDependenciesWithKnownTargets(Filter filter) {
        return Stream.concat(this.getIncomingDependenciesWithKnownOrigins(filter), this.getOutgoingDependenciesWithKnownTargets(filter));
    }

    protected abstract Stream<JavaClass> getClasses();

    protected Stream<JavaClass> getClasses(Filter filter) {
        Stream<JavaClass> classes = this.getClasses();
        return filter != null ? classes.filter(javaClass -> filter.accepts((NodeModel)this.getMap().getNodeByClass((JavaClass)javaClass))) : classes;
    }

    Stream<JavaClass> getInheriting() {
        return this.getClasses().flatMap(javaClass -> javaClass.getSubclasses().stream()).filter(this::belongsToMap);
    }

    Stream<JavaClass> getInherited() {
        return this.getClasses().flatMap(javaClass -> Stream.concat(javaClass.getRawInterfaces().stream(), javaClass.getRawSuperclass().map(Stream::of).orElse(Stream.empty()))).filter(this::belongsToMap);
    }

    public List<NamedIcon> getIcons() {
        UIIcon uiIcon = IconStoreFactory.ICON_STORE.getUIIcon(this.getUIIconName());
        return Collections.singletonList(uiIcon);
    }

    public Stream<CodeDependency> outgoingCodeDependenciesWithKnownTargets() {
        MemoizedCodeDependencies extension = this.getExtension(MemoizedCodeDependencies.class);
        if (extension != null) {
            return extension.outgoing();
        }
        if (this.getParentNode() == null || this.getParentNode().getChildCount() <= 40) {
            return this.collectOutgoingCodeDependenciesWithKnownTargets();
        }
        return this.memoizeCodeDependencies().outgoing();
    }

    private Stream<CodeDependency> collectOutgoingCodeDependenciesWithKnownTargets() {
        return ((Stream)this.getOutgoingDependenciesWithKnownTargets().parallel()).map(this.getMap()::toCodeDependency);
    }

    public Stream<CodeDependency> incomingCodeDependenciesWithKnownOrigins() {
        MemoizedCodeDependencies extension = this.getExtension(MemoizedCodeDependencies.class);
        if (extension != null) {
            return extension.incoming();
        }
        if (this.getParentNode() == null || this.getParentNode().getChildCount() <= 40) {
            return this.collectIncomingCodeDependenciesWithKnownOrigins();
        }
        return this.memoizeCodeDependencies().incoming();
    }

    MemoizedCodeDependencies memoizeCodeDependencies() {
        MemoizedCodeDependencies extension = new MemoizedCodeDependencies();
        this.addExtension(extension);
        return extension;
    }

    private Stream<CodeDependency> collectIncomingCodeDependenciesWithKnownOrigins() {
        return ((Stream)this.getIncomingDependenciesWithKnownOrigins().parallel()).map(this.getMap()::toCodeDependency);
    }

    public static Optional<String> classSourceLocationOf(JavaClass javaClass) {
        return javaClass.getSource().map(s -> {
            URI uri = s.getUri();
            String path = uri.getRawPath();
            String classLocation = path != null ? path : uri.getSchemeSpecificPart();
            String classSourceLocation = classLocation.substring(0, classLocation.length() - javaClass.getName().length() - ".class".length());
            return classSourceLocation;
        });
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        if (NodeLinks.class.equals(clazz)) {
            ModeController controller = Controller.getCurrentModeController();
            if (!controller.getModeName().equals("CodeExplorer")) {
                return null;
            }
            Configurable mapViewComponent = controller.getController().getMapViewManager().getMapViewConfiguration();
            if (mapViewComponent != null) {
                return (T)((Object)new CodeNodeLinks((CodeLinkController)controller.getExtension(LinkController.class), mapViewComponent, this));
            }
        }
        return (T)super.getExtension(clazz);
    }

    void setInitialFoldingState() {
        if (this.getParentNode().getChildCount() > 1 && this.getChildCount() > 0) {
            this.setFolded(true);
        }
    }

    Set<CodeNode> findCyclicDependencies() {
        GraphCycleFinder<CodeNode> cycleFinder = new GraphCycleFinder<CodeNode>();
        cycleFinder.addNode(this);
        cycleFinder.stopSearchHere();
        cycleFinder.exploreGraph(Collections.singleton(this), this::connectedTargetNodes, this::connectedOriginNodes);
        Set cycles = cycleFinder.findSimpleCycles();
        return cycles.stream().flatMap(edge -> ((CodeNode)((Object)((Object)edge.getKey()))).getOutgoingDependenciesWithKnownTargets().flatMap(dep -> this.classNodes((Map.Entry<CodeNode, CodeNode>)edge, dep.getOriginClass(), dep.getTargetClass()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<CodeNode> connectedOriginNodes(CodeNode node) {
        Stream<JavaClass> originClasses = node.getIncomingDependenciesWithKnownOrigins().map(Dependency::getOriginClass);
        return this.commonAncestorChildTowards(originClasses);
    }

    private Stream<CodeNode> connectedTargetNodes(CodeNode node) {
        Stream<JavaClass> targetClasses = node.getOutgoingDependenciesWithKnownTargets().map(Dependency::getTargetClass);
        return this.commonAncestorChildTowards(targetClasses);
    }

    private Stream<? extends CodeNode> classNodes(Map.Entry<CodeNode, CodeNode> edge, JavaClass originClass, JavaClass targetClass) {
        String targetId = this.idWithGroupIndex(targetClass);
        CodeNode targetClassNode = (CodeNode)this.getMap().getNodeForID(targetId);
        CodeNode targetNode = edge.getValue();
        if (targetNode == targetClassNode || targetClassNode.isDescendantOf(targetNode)) {
            String originId = this.idWithGroupIndex(originClass);
            CodeNode originNode = (CodeNode)this.getMap().getNodeForID(originId);
            return Stream.of(originNode, targetClassNode);
        }
        return Stream.empty();
    }

    private Stream<CodeNode> commonAncestorChildTowards(Stream<JavaClass> classes) {
        return classes.map(this::idWithGroupIndex).map(arg_0 -> ((CodeMap)this.getMap()).getNodeForID(arg_0)).map(CodeNode.class::cast).map(node -> (CodeNode)new NodeRelativePath((NodeModel)this, (NodeModel)node).endPathElement(1));
    }

    private class MemoizedCodeDependencies
    implements IExtension {
        DependencyJudge judge;
        CodeDependency[] incoming;
        CodeDependency[] outgoing;

        MemoizedCodeDependencies() {
            this.update();
        }

        private void update() {
            DependencyJudge currentJudge = CodeNode.this.getMap().getJudge();
            if (this.judge != currentJudge) {
                this.judge = currentJudge;
                this.incoming = (CodeDependency[])CodeNode.this.collectIncomingCodeDependenciesWithKnownOrigins().toArray(CodeDependency[]::new);
                this.outgoing = (CodeDependency[])CodeNode.this.collectOutgoingCodeDependenciesWithKnownTargets().toArray(CodeDependency[]::new);
            }
        }

        Stream<CodeDependency> incoming() {
            this.update();
            return (Stream)Stream.of(this.incoming).parallel();
        }

        Stream<CodeDependency> outgoing() {
            this.update();
            return (Stream)Stream.of(this.outgoing).parallel();
        }
    }
}

