/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractNode;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangPort;
import com.ericsson.otp.erlang.OtpErlangRef;
import com.ericsson.otp.erlang.OtpTransport;
import com.ericsson.otp.erlang.OtpTransportFactory;

public class OtpLocalNode
extends AbstractNode {
    private int serial = 0;
    private int pidCount = 1;
    private int portCount = 1;
    private int[] refId;
    protected int port;
    protected OtpTransport epmd;

    protected OtpLocalNode(String string) {
        super(string);
        this.init();
    }

    protected OtpLocalNode(String string, OtpTransportFactory otpTransportFactory) {
        super(string, otpTransportFactory);
        this.init();
    }

    protected OtpLocalNode(String string, String string2) {
        super(string, string2);
        this.init();
    }

    protected OtpLocalNode(String string, String string2, OtpTransportFactory otpTransportFactory) {
        super(string, string2, otpTransportFactory);
        this.init();
    }

    private void init() {
        this.serial = 0;
        this.pidCount = 1;
        this.portCount = 1;
        this.refId = new int[3];
        this.refId[0] = 1;
        this.refId[1] = 0;
        this.refId[2] = 0;
    }

    public int port() {
        return this.port;
    }

    protected void setEpmd(OtpTransport otpTransport) {
        this.epmd = otpTransport;
    }

    protected OtpTransport getEpmd() {
        return this.epmd;
    }

    public synchronized OtpErlangPid createPid() {
        OtpErlangPid otpErlangPid = new OtpErlangPid(this.node, this.pidCount, this.serial, this.creation());
        ++this.pidCount;
        if (this.pidCount > Short.MAX_VALUE) {
            this.pidCount = 0;
            ++this.serial;
            if (this.serial > 8191) {
                this.serial = 0;
            }
        }
        return otpErlangPid;
    }

    public synchronized OtpErlangPort createPort() {
        OtpErlangPort otpErlangPort = new OtpErlangPort(this.node, this.portCount, this.creation());
        ++this.portCount;
        if (this.portCount > 0xFFFFFFF) {
            this.portCount = 0;
        }
        return otpErlangPort;
    }

    public synchronized OtpErlangRef createRef() {
        OtpErlangRef otpErlangRef = new OtpErlangRef(this.node, this.refId, this.creation());
        this.refId[0] = this.refId[0] + 1;
        if (this.refId[0] > 262143) {
            this.refId[0] = 0;
            this.refId[1] = this.refId[1] + 1;
            if (this.refId[1] == 0) {
                this.refId[2] = this.refId[2] + 1;
            }
        }
        return otpErlangRef;
    }
}

