/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.cli.CLIContext;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.model.option.DataSourceAuthOptions;
import org.jkiss.dbeaver.model.cli.model.option.DataSourceOptions;
import org.jkiss.dbeaver.model.cli.model.option.InputFileOption;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.fs.DBFPath;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.DataSourceUtils;
import org.jkiss.dbeaver.utils.PropertySerializationUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class CLIUtils {
    private static final Log log = Log.getLog(CLIUtils.class);
    public static final int STRING_FORMAT_PADDING = 3;

    @Nullable
    public static String readValueFromFileOrSystemIn(@Nullable InputFileOption filesOptions) throws CLIException {
        String string;
        block11: {
            if (filesOptions == null) {
                return CLIUtils.tryReadFromSystemIn();
            }
            DBFPath inputFile = filesOptions.getInputFile();
            if (inputFile == null) {
                return CLIUtils.tryReadFromSystemIn();
            }
            DBFPath dBFPath = inputFile;
            try {
                Path path = inputFile.path();
                if (Files.notExists(path, new LinkOption[0])) {
                    throw new CLIException("Input file does not exist: " + String.valueOf(inputFile), 2);
                }
                string = Files.readString(path);
                if (dBFPath == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (dBFPath != null) {
                        try {
                            dBFPath.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CLIException("Error reading GQL from input file: " + String.valueOf(inputFile), e, 1);
                }
            }
            dBFPath.close();
        }
        return string;
    }

    @Nullable
    private static String tryReadFromSystemIn() {
        try {
            if (System.in.available() > 0) {
                return new String(System.in.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading from system in", (Throwable)e);
            return null;
        }
        return null;
    }

    @NotNull
    public static DBPProject findProject(@Nullable String projectIdOrName, @NotNull CLIContext context) throws CLIException {
        DBPProject project;
        DBPWorkspace workspace = (DBPWorkspace)context.getContextParameter(DBPWorkspace.class.getName());
        if (workspace == null) {
            workspace = DBWorkbench.getPlatform().getWorkspace();
        }
        if (CommonUtils.isEmpty((String)projectIdOrName)) {
            project = workspace.getActiveProject();
        } else {
            project = workspace.getProject(projectIdOrName);
            if (project == null) {
                project = workspace.getProjectById(projectIdOrName);
            }
        }
        if (project == null) {
            throw new CLIException("Can't find project '" + projectIdOrName + "'", 2);
        }
        return project;
    }

    @NotNull
    public static DBPDataSourceContainer findDataSource(@NotNull DBPProject project, @NotNull String existConnectionIdOrName) throws CLIException {
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        DBPDataSourceContainer container = registry.getDataSource(existConnectionIdOrName);
        if (container == null) {
            container = registry.findDataSourceByName(existConnectionIdOrName);
        }
        if (container == null) {
            throw new CLIException("Can't find connection '" + existConnectionIdOrName + "'", 2);
        }
        return container;
    }

    @NotNull
    public static DBPDataSourceContainer createTempDataSource(@NotNull DBPProject project, @NotNull String driverId, @NotNull DataSourceOptions dataSourceOptions, @NotNull DataSourceAuthOptions authOptions) throws CLIException {
        DBPDataSourceContainer tempDatasource = CLIUtils.createDataSource(project, driverId, dataSourceOptions, authOptions, true);
        CLIUtils.processDataSourceAuthOptions(tempDatasource, authOptions);
        return tempDatasource;
    }

    @NotNull
    public static DBPDataSourceContainer createDataSource(@NotNull DBPProject project, @NotNull String driverId, @NotNull DataSourceOptions dataSourceOptions, @NotNull DataSourceAuthOptions authOptions, boolean temporary) throws CLIException {
        DBPDriver driver = DBWorkbench.getPlatform().getDataSourceProviderRegistry().findDriver(driverId);
        if (driver == null) {
            throw new CLIException("Can't find driver '" + driverId + "'", 2);
        }
        DBPConnectionConfiguration connectionConfiguration = CLIUtils.updateConnectionConfiguration(dataSourceOptions, new DBPConnectionConfiguration());
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        DBPDataSourceContainer dataSource = registry.createDataSource(driver, connectionConfiguration);
        CLIUtils.updateDataSource(dataSourceOptions, authOptions, dataSource);
        dataSource.setTemporary(temporary);
        try {
            registry.addDataSource(dataSource);
        }
        catch (Exception e) {
            throw new CLIException("Error adding datasource: " + e.getMessage(), e, 1);
        }
        return dataSource;
    }

    public static void updateDataSource(@NotNull DataSourceOptions dataSourceOptions, @NotNull DataSourceAuthOptions authOptions, @NotNull DBPDataSourceContainer dataSource) throws CLIException {
        Object dsName = dataSourceOptions.getDatasourceName();
        if (CommonUtils.isEmpty((String)dsName)) {
            dsName = "Ext: " + dataSource.getDriver().getName();
            if (CommonUtils.isNotEmpty((String)dataSourceOptions.getDbName())) {
                dsName = (String)dsName + " - " + dataSourceOptions.getDbName();
            } else if (CommonUtils.isNotEmpty((String)dataSourceOptions.getServer())) {
                dsName = (String)dsName + " - " + dataSourceOptions.getServer();
            }
        }
        if (CommonUtils.isNotEmpty((String)dataSourceOptions.getDatasourceName())) {
            dataSource.setName((String)dsName);
        }
        if (CommonUtils.isNotEmpty((String)dataSourceOptions.getFolder())) {
            DBPDataSourceFolder folder = dataSource.getRegistry().getFolder(dataSourceOptions.getFolder());
            dataSource.setFolder(folder);
        }
        dataSource.setSavePassword(dataSourceOptions.isSavePassword());
        CLIUtils.processDataSourceAuthOptions(dataSource, authOptions);
    }

    @NotNull
    public static DBPConnectionConfiguration updateConnectionConfiguration(@NotNull DataSourceOptions dataSourceOptions, @NotNull DBPConnectionConfiguration connectionConfiguration) {
        if (CommonUtils.isNotEmpty((String)dataSourceOptions.getUrl())) {
            connectionConfiguration.setUrl(dataSourceOptions.getUrl());
        }
        if (CommonUtils.isNotEmpty((String)dataSourceOptions.getHost())) {
            connectionConfiguration.setHostName(dataSourceOptions.getHost());
        }
        if (dataSourceOptions.getPort() != null) {
            connectionConfiguration.setHostPort(dataSourceOptions.getPort().toString());
        }
        if (CommonUtils.isNotEmpty((String)dataSourceOptions.getServer())) {
            connectionConfiguration.setServerName(dataSourceOptions.getServer());
        }
        if (CommonUtils.isNotEmpty((String)dataSourceOptions.getDbName())) {
            connectionConfiguration.setDatabaseName(dataSourceOptions.getDbName());
        }
        if (!CommonUtils.isEmpty((String)dataSourceOptions.getAuthModel())) {
            connectionConfiguration.setAuthModelId(dataSourceOptions.getAuthModel());
        }
        return connectionConfiguration;
    }

    @NotNull
    public static Map<String, String> prepareKeyValueParams(@Nullable Map<String, String> parentParams, @NotNull List<String> cliParams) throws CLIException {
        LinkedHashMap<String, String> properties = parentParams == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(parentParams);
        for (String param : cliParams) {
            String[] paramParts = param.split("=", 2);
            if (paramParts.length == 2) {
                String paramName = paramParts[0].trim();
                String paramValue = paramParts[1].trim();
                if (!CommonUtils.isNotEmpty((String)paramName) || !CommonUtils.isNotEmpty((String)paramValue)) continue;
                properties.put(paramName, paramValue);
                continue;
            }
            throw new CLIException("Invalid param format: " + param, 2);
        }
        return properties;
    }

    public static void processDataSourceAuthOptions(@NotNull DBPDataSourceContainer dataSource, @NotNull DataSourceAuthOptions authOptions) throws CLIException {
        Map<String, String> authProperties;
        DBPConnectionConfiguration connectionConfiguration = dataSource.getConnectionConfiguration();
        if (CommonUtils.isNotEmpty((String)authOptions.getDbUser())) {
            connectionConfiguration.setUserName(authOptions.getDbUser());
        }
        if (CommonUtils.isNotEmpty((String)authOptions.getDbPassword())) {
            connectionConfiguration.setUserPassword(authOptions.getDbPassword());
        }
        if (!CommonUtils.isEmpty(authOptions.getConnectionParams())) {
            connectionConfiguration.setProperties(CLIUtils.prepareKeyValueParams(connectionConfiguration.getProperties(), authOptions.getConnectionParams()));
        }
        if (!CommonUtils.isEmpty(authOptions.getProviderParams())) {
            connectionConfiguration.setProviderProperties(CLIUtils.prepareKeyValueParams(connectionConfiguration.getProviderProperties(), authOptions.getProviderParams()));
        }
        if (!CommonUtils.isEmpty(authOptions.getAuthParams()) && !CommonUtils.isEmpty(authProperties = CLIUtils.prepareKeyValueParams(connectionConfiguration.getAuthProperties(), authOptions.getAuthParams()))) {
            DBAAuthCredentials credentialsInstance = connectionConfiguration.getAuthModel().loadCredentials(dataSource, connectionConfiguration);
            PropertySerializationUtils.updateCredentialsFromProperties((DBRProgressMonitor)new LoggingProgressMonitor(), (DBAAuthCredentials)credentialsInstance, authProperties);
            dataSource.getConnectionConfiguration().getAuthModel().provideCredentials(dataSource, dataSource.getConnectionConfiguration(), credentialsInstance);
        }
        if (authOptions.getNetworkHandlerOptions() != null && !CommonUtils.isEmpty(authOptions.getNetworkHandlerOptions().getHandlerParams())) {
            Map<String, String> handlerParams = CLIUtils.prepareKeyValueParams(new HashMap<String, String>(), authOptions.getNetworkHandlerOptions().getHandlerParams());
            try {
                DataSourceUtils.processNetworkHandlerProperties((DBPDataSourceContainer)dataSource, (boolean)authOptions.getNetworkHandlerOptions().isSavePassword(), handlerParams);
            }
            catch (Exception e) {
                throw new CLIException("Error processing network handler properties: " + e.getMessage(), e, 1);
            }
        }
    }

    public static String getPropertyHelpText(@NotNull DBPPropertyDescriptor property) {
        return CLIUtils.getPropertyHelpText(property, null);
    }

    @NotNull
    public static String getPropertyHelpText(@NotNull DBPPropertyDescriptor property, @Nullable String namePrefix) {
        IPropertyValueListProvider valueListProvider;
        Object[] possibleValues;
        String displayName = property.getDisplayName();
        String description = property.getDescription();
        StringBuilder helpText = new StringBuilder();
        helpText.append("  - ");
        if (CommonUtils.isNotEmpty((String)namePrefix) && !property.getId().startsWith(namePrefix)) {
            helpText.append(namePrefix);
        }
        helpText.append(property.getId());
        if (!CommonUtils.equalObjects((Object)displayName, (Object)description)) {
            helpText.append(" (").append(displayName).append(")");
        }
        if (CommonUtils.isNotEmpty((String)description)) {
            helpText.append(" = ").append(description);
        }
        if (property instanceof IPropertyValueListProvider && !ArrayUtils.isEmpty((Object[])(possibleValues = (valueListProvider = (IPropertyValueListProvider)property).getPossibleValues(null)))) {
            helpText.append(", possible values: ");
            for (int i = 0; i < possibleValues.length; ++i) {
                helpText.append(possibleValues[i]);
                if (i >= possibleValues.length - 1) continue;
                helpText.append(", ");
            }
        }
        helpText.append("\n");
        return helpText.toString();
    }

    @NotNull
    public static String formatAsTable(@NotNull List<Map<String, String>> data) {
        if (data.isEmpty()) {
            return "";
        }
        LinkedHashMap<String, Integer> columnWidths = new LinkedHashMap<String, Integer>();
        for (String string : data.getFirst().keySet()) {
            columnWidths.put(string, string.length());
        }
        for (Map map : data) {
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                columnWidths.put((String)entry.getKey(), Math.max((Integer)columnWidths.get(entry.getKey()), value == null ? 0 : value.length()));
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : columnWidths.entrySet()) {
            sb.append(String.format("%-" + ((Integer)entry.getValue() + 3) + "s", entry.getKey()));
        }
        sb.append("\n");
        for (Map<String, String> map : data) {
            for (Map.Entry entry : columnWidths.entrySet()) {
                sb.append(String.format("%-" + ((Integer)entry.getValue() + 3) + "s", CommonUtils.notNull((Object)map.get(entry.getKey()), (Object)"")));
            }
            sb.append("\n");
        }
        return sb.toString().trim();
    }
}

