/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookup;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public abstract class JDBCObjectLookupCache<OWNER extends DBSObject, OBJECT extends DBSObject>
extends JDBCObjectCache<OWNER, OBJECT>
implements JDBCObjectLookup<OWNER, OBJECT> {
    private static final Log log = Log.getLog(JDBCObjectLookupCache.class);
    private final Set<String> missingNames = new HashSet<String>();

    protected JDBCObjectLookupCache() {
    }

    @Override
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String name) throws DBException {
        DBSObject cachedObject = this.getCachedObject(name);
        if (cachedObject != null) {
            return (OBJECT)cachedObject;
        }
        if (this.isFullyCached() || this.missingNames.contains(name) || monitor == null) {
            return null;
        }
        OBJECT object = this.reloadObject(monitor, owner, null, name);
        if (object != null) {
            this.cacheObject((DBSObject)object);
        } else {
            this.missingNames.add(name);
        }
        return object;
    }

    public OBJECT refreshObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull OBJECT oldObject) throws DBException {
        String objectName = oldObject.getName();
        if (this.isFullyCached()) {
            OBJECT newObject = this.reloadObject(monitor, owner, oldObject, null);
            if (newObject != null) {
                this.deepCopyCachedObject(newObject, oldObject);
            } else {
                this.removeObject((DBSObject)oldObject, false);
            }
            return oldObject;
        }
        this.loadObjects(monitor, owner);
        return (OBJECT)this.getCachedObject(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    protected OBJECT reloadObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @Nullable OBJECT object, @Nullable String objectName) throws DBException {
        if (DBWorkbench.getPlatform().isUnitTestMode()) {
            JDBCObjectLookupCache.log.debug((Object)"[TEST] Skip lookup cache read in test mode");
            return object;
        }
        dataSource = owner.getDataSource();
        if (dataSource == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        try {
            session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, owner, (String)(object == null ? "Load object '" + objectName + "' from " + owner.getName() : "Reload object '" + String.valueOf(object) + "' from " + owner.getName()));
            try {
                block22: {
                    block20: {
                        block21: {
                            dbStat = this.prepareLookupStatement(session, (DBSObject)owner, (DBSObject)object, objectName);
                            dbStat.setFetchSize(1);
                            dbStat.executeStatement();
                            dbResult = dbStat.getResultSet();
                            if (dbResult == null) ** GOTO lbl32
                            if (!dbResult.next()) break block20;
                            var9_13 = this.fetchObject(session, owner, dbResult);
                            dbResult.close();
                            if (dbStat == null) break block21;
                            dbStat.close();
                        }
                        return var9_13;
                    }
                    try {
                        block23: {
                            dbResult.close();
                            break block23;
                            {
                                catch (Throwable var10_16) {
                                    dbResult.close();
                                    throw var10_16;
                                }
                            }
                        }
                        var9_14 = null;
                        if (dbStat == null) break block22;
                        dbStat.close();
                    }
                    catch (Throwable var8_11) {
                        if (dbStat != null) {
                            try {
                                dbStat.close();
                            }
                            catch (Throwable var9_15) {
                                var8_11.addSuppressed(var9_15);
                            }
                        }
                        throw var8_11;
                    }
                }
                return var9_14;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new DBDatabaseException((Throwable)ex, dataSource);
        }
    }

    @Override
    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OWNER owner) throws SQLException {
        return this.prepareLookupStatement(session, (DBSObject)owner, null, null);
    }

    public void setCache(@NotNull List<OBJECT> objects) {
        super.setCache(objects);
        this.missingNames.clear();
    }

    public void clearCache() {
        super.clearCache();
        this.missingNames.clear();
    }
}

