/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.registry.TaskConfiguratorDescriptor;
import org.jkiss.utils.CommonUtils;

public class TaskUIRegistry {
    public static final String TASK_EXTENSION_ID = "org.jkiss.dbeaver.task.ui";
    private static final Log log = Log.getLog(TaskUIRegistry.class);
    private static TaskUIRegistry instance = null;
    private final Map<DBTTaskType, TaskConfiguratorDescriptor> taskConfigurators = new LinkedHashMap<DBTTaskType, TaskConfiguratorDescriptor>();
    private final List<TaskConfiguratorDescriptor> taskHandlerConfigurators = new ArrayList<TaskConfiguratorDescriptor>();

    public static synchronized TaskUIRegistry getInstance() {
        if (instance == null) {
            instance = new TaskUIRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private TaskUIRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor(TASK_EXTENSION_ID)) {
            TaskConfiguratorDescriptor configDescriptor;
            if (!"configurator".equals(ext.getName())) continue;
            String typeId = ext.getAttribute("type");
            TaskTypeDescriptor taskType = TaskRegistry.getInstance().getTaskType(typeId);
            if (taskType == null) {
                if (!CommonUtils.isEmpty((String)ext.getAttribute("handler"))) {
                    configDescriptor = new TaskConfiguratorDescriptor(ext);
                    this.taskHandlerConfigurators.add(configDescriptor);
                    continue;
                }
                log.debug((Object)("Task type '" + typeId + "' not found. Skip configurator."));
                continue;
            }
            configDescriptor = new TaskConfiguratorDescriptor(taskType, ext);
            this.taskConfigurators.put((DBTTaskType)taskType, configDescriptor);
        }
    }

    public boolean supportsConfigurator(DBTTaskType taskType) {
        if (this.taskConfigurators.containsKey(taskType)) {
            return true;
        }
        Class handlerClass = taskType.getHandlerClass();
        if (handlerClass != null) {
            for (TaskConfiguratorDescriptor tcd : this.taskHandlerConfigurators) {
                if (!tcd.getTaskHandlerType().matchesType(handlerClass)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsConfiguratorPage(DBTTaskType type) {
        TaskConfiguratorDescriptor configuratorDescriptor = this.taskConfigurators.get(type);
        if (configuratorDescriptor != null) {
            return configuratorDescriptor.supportsPanel();
        }
        return false;
    }

    public DBTTaskConfigurator createConfigurator(DBTTaskType taskType) throws DBCException {
        TaskConfiguratorDescriptor configuratorDescriptor = this.taskConfigurators.get(taskType);
        if (configuratorDescriptor == null) {
            Class handlerClass = taskType.getHandlerClass();
            if (handlerClass != null) {
                for (TaskConfiguratorDescriptor tcd : this.taskHandlerConfigurators) {
                    if (!tcd.getTaskHandlerType().matchesType(handlerClass)) continue;
                    configuratorDescriptor = tcd;
                    break;
                }
            }
            if (configuratorDescriptor == null) {
                throw new DBCException("Task configurator not supported for " + taskType.getName());
            }
        }
        try {
            return configuratorDescriptor.createConfigurator();
        }
        catch (DBException e) {
            throw new DBCException("Task configurator create error", (Throwable)e);
        }
    }
}

