﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/groundstation/GroundStation_EXPORTS.h>

namespace Aws {
namespace GroundStation {
namespace Model {
enum class EphemerisErrorCode {
  NOT_SET,
  INTERNAL_ERROR,
  MISMATCHED_SATCAT_ID,
  OEM_VERSION_UNSUPPORTED,
  ORIGINATOR_MISSING,
  CREATION_DATE_MISSING,
  OBJECT_NAME_MISSING,
  OBJECT_ID_MISSING,
  REF_FRAME_UNSUPPORTED,
  REF_FRAME_EPOCH_UNSUPPORTED,
  TIME_SYSTEM_UNSUPPORTED,
  CENTER_BODY_UNSUPPORTED,
  INTERPOLATION_MISSING,
  INTERPOLATION_DEGREE_INVALID,
  AZ_EL_SEGMENT_LIST_MISSING,
  INSUFFICIENT_TIME_AZ_EL,
  START_TIME_IN_FUTURE,
  END_TIME_IN_PAST,
  EXPIRATION_TIME_TOO_EARLY,
  START_TIME_METADATA_TOO_EARLY,
  STOP_TIME_METADATA_TOO_LATE,
  AZ_EL_SEGMENT_END_TIME_BEFORE_START_TIME,
  AZ_EL_SEGMENT_TIMES_OVERLAP,
  AZ_EL_SEGMENTS_OUT_OF_ORDER,
  TIME_AZ_EL_ITEMS_OUT_OF_ORDER,
  MEAN_MOTION_INVALID,
  TIME_AZ_EL_AZ_RADIAN_RANGE_INVALID,
  TIME_AZ_EL_EL_RADIAN_RANGE_INVALID,
  TIME_AZ_EL_AZ_DEGREE_RANGE_INVALID,
  TIME_AZ_EL_EL_DEGREE_RANGE_INVALID,
  TIME_AZ_EL_ANGLE_UNITS_INVALID,
  INSUFFICIENT_KMS_PERMISSIONS,
  FILE_FORMAT_INVALID,
  AZ_EL_SEGMENT_REFERENCE_EPOCH_INVALID,
  AZ_EL_SEGMENT_START_TIME_INVALID,
  AZ_EL_SEGMENT_END_TIME_INVALID,
  AZ_EL_SEGMENT_VALID_TIME_RANGE_INVALID,
  AZ_EL_SEGMENT_END_TIME_TOO_LATE,
  AZ_EL_TOTAL_DURATION_EXCEEDED
};

namespace EphemerisErrorCodeMapper {
AWS_GROUNDSTATION_API EphemerisErrorCode GetEphemerisErrorCodeForName(const Aws::String& name);

AWS_GROUNDSTATION_API Aws::String GetNameForEphemerisErrorCode(EphemerisErrorCode value);
}  // namespace EphemerisErrorCodeMapper
}  // namespace Model
}  // namespace GroundStation
}  // namespace Aws
