// java wrapper for vtkWebGLObject object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWebGLObject.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWebGLObject_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWebGLObject",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebGLObject_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebGLObject_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebGLObject_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWebGLObject_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_GenerateBinaryData_14(JNIEnv* env, jobject obj)
{

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateBinaryData();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebGLObject_GetBinarySize_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBinarySize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebGLObject_GetNumberOfParts_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfParts();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_GetBinaryData_17(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkUnsignedCharArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBinaryData(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetLayer_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLayer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetId_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetId(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetWireframeMode_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWireframeMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetVisibility_111(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVisibility(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetTransformationMatrix_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransformationMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetIsWidget_113(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIsWidget(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetHasTransparency_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHasTransparency(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetInteractAtServer_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractAtServer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWebGLObject_SetType_116(JNIEnv* env, jobject obj,jint id0)
{
  WebGLObjectTypes   temp0;
  temp0 = static_cast<WebGLObjectTypes>(id0);

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetType(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebGLObject_isWireframeMode_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->isWireframeMode();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebGLObject_isVisible_118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->isVisible();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebGLObject_HasChanged_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasChanged();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebGLObject_isWidget_120(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->isWidget();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebGLObject_HasTransparency_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTransparency();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWebGLObject_InteractAtServer_122(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InteractAtServer();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWebGLObject_GetMD5_123(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMD5();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWebGLObject_GetId_124(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetId();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWebGLObject_GetLayer_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWebGLObject* op = static_cast<vtkWebGLObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayer();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkWebGLObject_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkWebGLObject::New());
}
