// java wrapper for vtkLightKit object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLightKit.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLightKit_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLightKit",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightKit_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightKit_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightKit_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightKit_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyLightIntensity_14(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyLightIntensity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyLightIntensity_15(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyLightIntensity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyToFillRatio_16(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyToFillRatio(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToFillRatioMinValue_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToFillRatioMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToFillRatioMaxValue_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToFillRatioMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToFillRatio_19(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToFillRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyToHeadRatio_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyToHeadRatio(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToHeadRatioMinValue_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToHeadRatioMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToHeadRatioMaxValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToHeadRatioMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToHeadRatio_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToHeadRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyToBackRatio_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyToBackRatio(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToBackRatioMinValue_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToBackRatioMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToBackRatioMaxValue_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToBackRatioMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyToBackRatio_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyToBackRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyLightWarmth_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyLightWarmth(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyLightWarmth_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyLightWarmth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetFillLightWarmth_120(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFillLightWarmth(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetFillLightWarmth_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFillLightWarmth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetHeadLightWarmth_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHeadLightWarmth(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetHeadLightWarmth_123(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeadLightWarmth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetBackLightWarmth_124(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackLightWarmth(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetBackLightWarmth_125(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackLightWarmth();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightKit_GetKeyLightColor_126(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyLightColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightKit_GetFillLightColor_127(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFillLightColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightKit_GetHeadLightColor_128(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeadLightColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightKit_GetBackLightColor_129(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackLightColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_MaintainLuminanceOn_130(JNIEnv* env, jobject obj)
{

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->MaintainLuminanceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_MaintainLuminanceOff_131(JNIEnv* env, jobject obj)
{

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->MaintainLuminanceOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightKit_GetMaintainLuminance_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaintainLuminance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetMaintainLuminance_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaintainLuminance(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyLightAngle_134(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyLightAngle(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyLightAngle_135(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyLightAngle(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyLightElevation_136(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyLightElevation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetKeyLightAzimuth_137(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKeyLightAzimuth(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightKit_GetKeyLightAngle_138(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyLightAngle();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyLightElevation_139(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyLightElevation();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetKeyLightAzimuth_140(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKeyLightAzimuth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetFillLightAngle_141(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFillLightAngle(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetFillLightAngle_142(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFillLightAngle(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetFillLightElevation_143(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFillLightElevation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetFillLightAzimuth_144(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFillLightAzimuth(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightKit_GetFillLightAngle_145(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFillLightAngle();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetFillLightElevation_146(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFillLightElevation();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetFillLightAzimuth_147(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFillLightAzimuth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetBackLightAngle_148(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackLightAngle(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetBackLightAngle_149(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackLightAngle(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetBackLightElevation_150(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackLightElevation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_SetBackLightAzimuth_151(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackLightAzimuth(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightKit_GetBackLightAngle_152(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackLightAngle();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetBackLightElevation_153(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackLightElevation();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightKit_GetBackLightAzimuth_154(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackLightAzimuth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_AddLightsToRenderer_155(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLightsToRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_RemoveLightsFromRenderer_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveLightsFromRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_DeepCopy_157(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLightKit * temp0;
  temp0 = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_Modified_158(JNIEnv* env, jobject obj)
{

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightKit_Update_159(JNIEnv* env, jobject obj)
{

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLightKit_GetStringFromType_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStringFromType(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLightKit_GetStringFromSubType_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStringFromSubType(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLightKit_GetShortStringFromSubType_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShortStringFromSubType(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightKit_GetSubType_163(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  vtkLightKit::LightKitType   temp0;
  int   temp1;
  vtkLightKit::LightKitSubType   temp20;
  temp0 = static_cast<vtkLightKit::LightKitType>(id0);
  temp1 = id1;

  vtkLightKit* op = static_cast<vtkLightKit*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSubType(temp0,temp1);
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLightKit_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLightKit::New());
}
