// java wrapper for vtkLight object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLight.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLight_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLight",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLight_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLight_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLight_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLight_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLight_ShallowClone_14(JNIEnv* env, jobject obj)
{
  vtkLight * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ShallowClone();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_Render_15(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkRenderer * temp0;
  int   temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetAmbientColor_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbientColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetAmbientColor_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbientColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLight_GetAmbientColor_18(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbientColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetDiffuseColor_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDiffuseColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetDiffuseColor_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDiffuseColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLight_GetDiffuseColor_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuseColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetSpecularColor_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecularColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetSpecularColor_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecularColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLight_GetSpecularColor_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetColor_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetColor_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetPosition_117(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetPosition_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLight_GetPosition_119(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetFocalPoint_120(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetFocalPoint_121(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLight_GetFocalPoint_122(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetIntensity_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntensity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLight_GetIntensity_124(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntensity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetSwitch_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSwitch(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLight_GetSwitch_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSwitch();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SwitchOn_127(JNIEnv* env, jobject obj)
{

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SwitchOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SwitchOff_128(JNIEnv* env, jobject obj)
{

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SwitchOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetPositional_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPositional(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLight_GetPositional_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPositional();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_PositionalOn_131(JNIEnv* env, jobject obj)
{

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->PositionalOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_PositionalOff_132(JNIEnv* env, jobject obj)
{

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->PositionalOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetExponent_133(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponent(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLight_GetExponentMinValue_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLight_GetExponentMaxValue_135(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLight_GetExponent_136(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetConeAngle_137(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConeAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLight_GetConeAngle_138(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetAttenuationValues_139(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttenuationValues(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetAttenuationValues_140(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttenuationValues(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLight_GetAttenuationValues_141(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttenuationValues();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetTransformMatrix_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransformMatrix(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLight_GetTransformMatrix_143(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransformMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_GetTransformedPosition_144(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTransformedPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLight_GetTransformedPosition_145(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransformedPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_GetTransformedFocalPoint_146(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTransformedFocalPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLight_GetTransformedFocalPoint_147(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransformedFocalPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_TransformPoint_148(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_TransformVector_149(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformVector(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetDirectionAngle_150(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionAngle(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetDirectionAngle_151(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectionAngle(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_DeepCopy_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLight * temp0;
  temp0 = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetLightType_153(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLightType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLight_GetLightType_154(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLightType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetLightTypeToHeadlight_155(JNIEnv* env, jobject obj)
{

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLightTypeToHeadlight();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetLightTypeToSceneLight_156(JNIEnv* env, jobject obj)
{

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLightTypeToSceneLight();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetLightTypeToCameraLight_157(JNIEnv* env, jobject obj)
{

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLightTypeToCameraLight();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLight_LightTypeIsHeadlight_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->LightTypeIsHeadlight();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLight_LightTypeIsSceneLight_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->LightTypeIsSceneLight();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLight_LightTypeIsCameraLight_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->LightTypeIsCameraLight();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetShadowAttenuation_161(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShadowAttenuation(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkLight_GetShadowAttenuation_162(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShadowAttenuation();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLight_GetInformation_163(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLight_SetInformation_164(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLight* op = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInformation(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLight_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLight::New());
}
