// java wrapper for vtkTableToGraph object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTableToGraph.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkGraphAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTableToGraph_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTableToGraph",dType)) { return me; }
  if ((res= vtkGraphAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTableToGraph_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTableToGraph_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTableToGraph_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTableToGraph_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_AddLinkVertex_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1,jint id2)
{
  char * temp0;
  char * temp1;
  int   temp2;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLinkVertex(temp0,temp1,temp2);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_ClearLinkVertices_15(JNIEnv* env, jobject obj)
{

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearLinkVertices();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_AddLinkEdge_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLinkEdge(temp0,temp1);
  delete[] temp0;
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_ClearLinkEdges_17(JNIEnv* env, jobject obj)
{

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearLinkEdges();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTableToGraph_GetLinkGraph_18(JNIEnv* env, jobject obj)
{
  vtkMutableDirectedGraph * temp20;

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinkGraph();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_SetLinkGraph_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMutableDirectedGraph * temp0;
  temp0 = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLinkGraph(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_LinkColumnPath_110(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkStringArray * temp0;
  vtkStringArray * temp1;
  vtkBitArray * temp2;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->LinkColumnPath(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_SetDirected_111(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirected(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTableToGraph_GetDirected_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirected();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_DirectedOn_113(JNIEnv* env, jobject obj)
{

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->DirectedOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_DirectedOff_114(JNIEnv* env, jobject obj)
{

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->DirectedOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTableToGraph_GetMTime_115(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTableToGraph_SetVertexTableConnection_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTableToGraph* op = static_cast<vtkTableToGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexTableConnection(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTableToGraph_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTableToGraph::New());
}
