// java wrapper for vtkDelimitedTextReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDelimitedTextReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkTableAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDelimitedTextReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDelimitedTextReader",dType)) { return me; }
  if ((res= vtkTableAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelimitedTextReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelimitedTextReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelimitedTextReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelimitedTextReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetFileName_14(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetFileName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetInputString_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputString(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetInputString_17(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetInputString_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputString(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelimitedTextReader_GetInputStringLength_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputStringLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetReadFromInputString_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadFromInputString(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelimitedTextReader_GetReadFromInputString_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadFromInputString();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_ReadFromInputStringOn_112(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFromInputStringOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_ReadFromInputStringOff_113(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadFromInputStringOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetUnicodeCharacterSet_114(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnicodeCharacterSet();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetUnicodeCharacterSet_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnicodeCharacterSet(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetUTF8RecordDelimiters_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUTF8RecordDelimiters(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetUTF8RecordDelimiters_117(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUTF8RecordDelimiters();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetFieldDelimiterCharacters_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldDelimiterCharacters(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetFieldDelimiterCharacters_119(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDelimiterCharacters();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetUTF8FieldDelimiters_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUTF8FieldDelimiters(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetUTF8FieldDelimiters_121(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUTF8FieldDelimiters();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jchar  JNICALL Java_vtk_vtkDelimitedTextReader_GetStringDelimiter_122(JNIEnv* env, jobject obj)
{
  char   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStringDelimiter();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetStringDelimiter_123(JNIEnv* env, jobject obj,jchar id0)
{
  char   temp0;
  temp0 = static_cast<char>(0xff & id0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStringDelimiter(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetUTF8StringDelimiters_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUTF8StringDelimiters(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetUTF8StringDelimiters_125(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUTF8StringDelimiters();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetUseStringDelimiter_126(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseStringDelimiter(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetUseStringDelimiter_127(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseStringDelimiter();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_UseStringDelimiterOn_128(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseStringDelimiterOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_UseStringDelimiterOff_129(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseStringDelimiterOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetHaveHeaders_130(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHaveHeaders();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetHaveHeaders_131(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHaveHeaders(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetMergeConsecutiveDelimiters_132(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMergeConsecutiveDelimiters(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetMergeConsecutiveDelimiters_133(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMergeConsecutiveDelimiters();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_MergeConsecutiveDelimitersOn_134(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergeConsecutiveDelimitersOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_MergeConsecutiveDelimitersOff_135(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MergeConsecutiveDelimitersOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelimitedTextReader_GetMaxRecords_136(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxRecords();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetMaxRecords_137(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxRecords(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelimitedTextReader_GetSkippedRecords_138(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSkippedRecords();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetSkippedRecords_139(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSkippedRecords(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetDetectNumericColumns_140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDetectNumericColumns(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetDetectNumericColumns_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDetectNumericColumns();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_DetectNumericColumnsOn_142(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DetectNumericColumnsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_DetectNumericColumnsOff_143(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DetectNumericColumnsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetForceDouble_144(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceDouble(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetForceDouble_145(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceDouble();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_ForceDoubleOn_146(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceDoubleOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_ForceDoubleOff_147(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceDoubleOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetTrimWhitespacePriorToNumericConversion_148(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTrimWhitespacePriorToNumericConversion(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetTrimWhitespacePriorToNumericConversion_149(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTrimWhitespacePriorToNumericConversion();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_TrimWhitespacePriorToNumericConversionOn_150(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->TrimWhitespacePriorToNumericConversionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_TrimWhitespacePriorToNumericConversionOff_151(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->TrimWhitespacePriorToNumericConversionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetDefaultIntegerValue_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultIntegerValue(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelimitedTextReader_GetDefaultIntegerValue_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultIntegerValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetDefaultDoubleValue_154(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultDoubleValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDelimitedTextReader_GetDefaultDoubleValue_155(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultDoubleValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetPedigreeIdArrayName_156(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPedigreeIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetPedigreeIdArrayName_157(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPedigreeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetGeneratePedigreeIds_158(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGeneratePedigreeIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetGeneratePedigreeIds_159(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGeneratePedigreeIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_GeneratePedigreeIdsOn_160(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GeneratePedigreeIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_GeneratePedigreeIdsOff_161(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GeneratePedigreeIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetOutputPedigreeIds_162(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPedigreeIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetOutputPedigreeIds_163(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPedigreeIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_OutputPedigreeIdsOn_164(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutputPedigreeIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_OutputPedigreeIdsOff_165(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutputPedigreeIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetAddTabFieldDelimiter_166(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAddTabFieldDelimiter(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDelimitedTextReader_GetAddTabFieldDelimiter_167(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAddTabFieldDelimiter();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_AddTabFieldDelimiterOn_168(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddTabFieldDelimiterOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_AddTabFieldDelimiterOff_169(JNIEnv* env, jobject obj)
{

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddTabFieldDelimiterOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetLastError_170(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastError();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetReplacementCharacter_171(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReplacementCharacter(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDelimitedTextReader_GetReplacementCharacter_172(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReplacementCharacter();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetPreview_173(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPreview();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetPreviewNumberOfLines_174(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPreviewNumberOfLines(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDelimitedTextReader_GetPreviewNumberOfLines_175(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPreviewNumberOfLines();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDelimitedTextReader_GetCommentCharacters_176(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCommentCharacters();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDelimitedTextReader_SetCommentCharacters_177(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkDelimitedTextReader* op = static_cast<vtkDelimitedTextReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCommentCharacters(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDelimitedTextReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDelimitedTextReader::New());
}
