// java wrapper for vtkGeneralTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGeneralTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGeneralTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGeneralTransform",dType)) { return me; }
  if ((res= vtkAbstractTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Identity_14(JNIEnv* env, jobject obj)
{

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Identity();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Inverse_15(JNIEnv* env, jobject obj)
{

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Inverse();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Translate_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Translate_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Translate_18(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_RotateWXYZ_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_RotateWXYZ_110(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_RotateWXYZ_111(JNIEnv* env, jobject obj,jdouble id0,jfloatArray id1)
{
  double   temp0;
  float temp1[3];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_RotateX_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateX(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_RotateY_113(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateY(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_RotateZ_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateZ(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Scale_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Scale_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Scale_117(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Concatenate_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Concatenate_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Concatenate_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_PreMultiply_121(JNIEnv* env, jobject obj)
{

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreMultiply();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_PostMultiply_122(JNIEnv* env, jobject obj)
{

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->PostMultiply();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralTransform_GetNumberOfConcatenatedTransforms_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfConcatenatedTransforms();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralTransform_GetConcatenatedTransform_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAbstractTransform * temp20;
  temp0 = id0;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConcatenatedTransform(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_SetInput_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralTransform_GetInput_126(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralTransform_GetInverseFlag_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverseFlag();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Push_128(JNIEnv* env, jobject obj)
{

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Push();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_Pop_129(JNIEnv* env, jobject obj)
{

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Pop();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_InternalTransformPoint_130(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralTransform_InternalTransformPoint_131(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralTransform_CircuitCheck_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CircuitCheck(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralTransform_MakeTransform_133(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralTransform_GetMTime_134(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGeneralTransform* op = static_cast<vtkGeneralTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGeneralTransform_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGeneralTransform::New());
}
