// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkSobelGradientMagnitudePass2FS.h"

const char *vtkSobelGradientMagnitudePass2FS =
"//VTK::System::Dec\n"
"\n"
"\n"
"// Fragment shader used by the second pass of the Sobel filter render pass.\n"
"\n"
"in vec2 tcoordVC;\n"
"\n"
"uniform sampler2D gx1;\n"
"uniform sampler2D gy1;\n"
"uniform float stepSize; // 1/H\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"void main(void)\n"
"{\n"
"  vec2 offset=vec2(0.0,stepSize);\n"
"\n"
"  // Gx\n"
"\n"
"  vec4 tx1=texture2D(gx1,tcoordVC-offset);\n"
"  vec4 tx2=texture2D(gx1,tcoordVC);\n"
"  vec4 tx3=texture2D(gx1,tcoordVC+offset);\n"
"\n"
"  // if clamped textures, rescale values from [0,1] to [-1,1]\n"
"  tx1=tx1*2.0-1.0;\n"
"  tx2=tx2*2.0-1.0;\n"
"  tx3=tx3*2.0-1.0;\n"
"\n"
"  vec4 gx=(tx1+2.0*tx2+tx3)/4.0;\n"
"\n"
"  // Gy\n"
"\n"
"  vec4 ty1=texture2D(gy1,tcoordVC-offset);\n"
"  vec4 ty3=texture2D(gy1,tcoordVC+offset);\n"
"\n"
"  vec4 gy=ty3-ty1;\n"
"\n"
"  // the maximum gradient magnitude is sqrt(2.0) when for example gx=1 and\n"
"  // gy=1\n"
"//  gl_FragData[0]=sqrt((gx*gx+gy*gy)/2.0);\n"
"  gl_FragData[0].rgb=sqrt((gx.rgb*gx.rgb+gy.rgb*gy.rgb)/2.0);\n"
"  gl_FragData[0].a=1.0; // arbitrary choice.\n"
"}\n"
"";
