// python wrapper for vtkOSPRayLightNode
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOSPRayLightNode.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOSPRayLightNode(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOSPRayLightNode_ClassNew(); }


static PyObject *
PyvtkOSPRayLightNode_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOSPRayLightNode::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayLightNode *op = static_cast<vtkOSPRayLightNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOSPRayLightNode::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOSPRayLightNode *tempr = vtkOSPRayLightNode::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayLightNode *op = static_cast<vtkOSPRayLightNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOSPRayLightNode *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOSPRayLightNode::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOSPRayLightNode::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayLightNode *op = static_cast<vtkOSPRayLightNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOSPRayLightNode::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayLightNode *op = static_cast<vtkOSPRayLightNode *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Render(temp0);
    }
    else
    {
      op->vtkOSPRayLightNode::Render(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_SetLightScale(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetLightScale");

  double temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkOSPRayLightNode::SetLightScale(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_GetLightScale(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetLightScale");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    double tempr = vtkOSPRayLightNode::GetLightScale();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_IS_AMBIENT(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IS_AMBIENT");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayLightNode::IS_AMBIENT();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_SetIsAmbient(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetIsAmbient");

  int temp0;
  vtkLight *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkLight"))
  {
    vtkOSPRayLightNode::SetIsAmbient(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_GetIsAmbient(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetIsAmbient");

  vtkLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkLight"))
  {
    int tempr = vtkOSPRayLightNode::GetIsAmbient(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_RADIUS(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RADIUS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkOSPRayLightNode::RADIUS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_SetRadius(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRadius");

  double temp0;
  vtkLight *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkLight"))
  {
    vtkOSPRayLightNode::SetRadius(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayLightNode_GetRadius(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRadius");

  vtkLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkLight"))
  {
    double tempr = vtkOSPRayLightNode::GetRadius(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkOSPRayLightNode_Methods[] = {
  {"IsTypeOf", PyvtkOSPRayLightNode_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOSPRayLightNode_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOSPRayLightNode_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOSPRayLightNode\nC++: static vtkOSPRayLightNode *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOSPRayLightNode_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOSPRayLightNode\nC++: vtkOSPRayLightNode *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOSPRayLightNode_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOSPRayLightNode_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Render", PyvtkOSPRayLightNode_Render, METH_VARARGS,
   "Render(self, prepass:bool) -> None\nC++: void Render(bool prepass) override;\n\nMake ospray calls to render me.\n"},
  {"SetLightScale", PyvtkOSPRayLightNode_SetLightScale, METH_VARARGS,
   "SetLightScale(s:float) -> None\nC++: static void SetLightScale(double s)\n\nA global multiplier to all ospray lights. default is 1.0\n"},
  {"GetLightScale", PyvtkOSPRayLightNode_GetLightScale, METH_VARARGS,
   "GetLightScale() -> float\nC++: static double GetLightScale()\n\n"},
  {"IS_AMBIENT", PyvtkOSPRayLightNode_IS_AMBIENT, METH_VARARGS,
   "IS_AMBIENT() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *IS_AMBIENT()\n\nWhen present on light, the light acts as an ambient source. An\nAmbientLight is one that has no specific position in space and\nfor which only the ambient color term affects the result.\\ingroup\nInformationKeys\n"},
  {"SetIsAmbient", PyvtkOSPRayLightNode_SetIsAmbient, METH_VARARGS,
   "SetIsAmbient(__a:int, __b:vtkLight) -> None\nC++: static void SetIsAmbient(int, vtkLight *)\n\nConvenience method to set/get IS_AMBIENT on a vtkLight.\n"},
  {"GetIsAmbient", PyvtkOSPRayLightNode_GetIsAmbient, METH_VARARGS,
   "GetIsAmbient(__a:vtkLight) -> int\nC++: static int GetIsAmbient(vtkLight *)\n\n"},
  {"RADIUS", PyvtkOSPRayLightNode_RADIUS, METH_VARARGS,
   "RADIUS() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *RADIUS()\n\nThe radius setting, when > 0.0, produces soft shadows in the path\ntracer.\\ingroup InformationKeys\n"},
  {"SetRadius", PyvtkOSPRayLightNode_SetRadius, METH_VARARGS,
   "SetRadius(__a:float, __b:vtkLight) -> None\nC++: static void SetRadius(double, vtkLight *)\n\nConvenience method to set/get RADIUS on a vtkLight.\n"},
  {"GetRadius", PyvtkOSPRayLightNode_GetRadius, METH_VARARGS,
   "GetRadius(__a:vtkLight) -> float\nC++: static double GetRadius(vtkLight *)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOSPRayLightNode_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("light_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOSPRayLightNode_GetLightScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOSPRayLightNode_SetLightScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOSPRayLightNode_SetLightScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLightScale/SetLightScale\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOSPRayLightNode_Doc =
  "vtkOSPRayLightNode - links vtkLights to OSPRay\n\n"
  "Superclass: vtkLightNode\n\n"
  "Translates vtkLight state into OSPRay rendering calls\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOSPRayLightNode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingRayTracing.vtkOSPRayLightNode", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOSPRayLightNode_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOSPRayLightNode_StaticNew()
{
  return vtkOSPRayLightNode::New();
}

PyObject *PyvtkOSPRayLightNode_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOSPRayLightNode_Type, PyvtkOSPRayLightNode_Methods,
    "vtkOSPRayLightNode",
 &PyvtkOSPRayLightNode_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkLightNode");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOSPRayLightNode_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOSPRayLightNode(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOSPRayLightNode_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOSPRayLightNode", o) != 0)
  {
    Py_DECREF(o);
  }

}

