// python wrapper for vtkOSPRayActorNode
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOSPRayActorNode.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOSPRayActorNode(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOSPRayActorNode_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOSPRayActorNode_ScalingMode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingRayTracing.vtkOSPRayActorNode.ScalingMode", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkOSPRayActorNode_ScalingMode_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkOSPRayActorNode_ScalingMode_Type, static_cast<int>(val));
}


static PyObject *
PyvtkOSPRayActorNode_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOSPRayActorNode::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayActorNode *op = static_cast<vtkOSPRayActorNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOSPRayActorNode::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOSPRayActorNode *tempr = vtkOSPRayActorNode::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayActorNode *op = static_cast<vtkOSPRayActorNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOSPRayActorNode *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOSPRayActorNode::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOSPRayActorNode::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayActorNode *op = static_cast<vtkOSPRayActorNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOSPRayActorNode::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayActorNode *op = static_cast<vtkOSPRayActorNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkOSPRayActorNode::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_ENABLE_SCALING(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ENABLE_SCALING");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkOSPRayActorNode::ENABLE_SCALING();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_SetEnableScaling(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetEnableScaling");

  int temp0;
  vtkActor *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkActor"))
  {
    vtkOSPRayActorNode::SetEnableScaling(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_GetEnableScaling(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetEnableScaling");

  vtkActor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkActor"))
  {
    int tempr = vtkOSPRayActorNode::GetEnableScaling(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_SCALE_ARRAY_NAME(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SCALE_ARRAY_NAME");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationStringKey *tempr = vtkOSPRayActorNode::SCALE_ARRAY_NAME();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_SetScaleArrayName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetScaleArrayName");

  const char *temp0 = nullptr;
  vtkActor *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkActor"))
  {
    vtkOSPRayActorNode::SetScaleArrayName(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_SCALE_FUNCTION(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SCALE_FUNCTION");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationObjectBaseKey *tempr = vtkOSPRayActorNode::SCALE_FUNCTION();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_SetScaleFunction(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetScaleFunction");

  vtkPiecewiseFunction *temp0 = nullptr;
  vtkActor *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPiecewiseFunction") &&
      ap.GetVTKObject(temp1, "vtkActor"))
  {
    vtkOSPRayActorNode::SetScaleFunction(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_LUMINOSITY(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "LUMINOSITY");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkOSPRayActorNode::LUMINOSITY();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_SetLuminosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetLuminosity");

  double temp0;
  vtkProperty *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkProperty"))
  {
    vtkOSPRayActorNode::SetLuminosity(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayActorNode_GetLuminosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetLuminosity");

  vtkProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkProperty"))
  {
    double tempr = vtkOSPRayActorNode::GetLuminosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkOSPRayActorNode_Methods[] = {
  {"IsTypeOf", PyvtkOSPRayActorNode_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOSPRayActorNode_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOSPRayActorNode_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOSPRayActorNode\nC++: static vtkOSPRayActorNode *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOSPRayActorNode_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOSPRayActorNode\nC++: vtkOSPRayActorNode *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOSPRayActorNode_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOSPRayActorNode_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetMTime", PyvtkOSPRayActorNode_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nOverridden to take into account my renderables time, including\nmapper and data into mapper inclusive of composite input\n"},
  {"ENABLE_SCALING", PyvtkOSPRayActorNode_ENABLE_SCALING, METH_VARARGS,
   "ENABLE_SCALING() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *ENABLE_SCALING()\n\nA key to set the ScalingMode. The default is ALL_APPROXIMATE.\nALL_EXACT means use vtkActor.PointSize/LineWidth for all radii.\nALL_APPROXIMATE sets all radii to approximate GL's pixel sizes\nvia a function of PointSize/LineWidth and object bounding box.\nEACH_MAPPED means map every value from SCALE_ARRAY_NAME through\nthe SCALE_FUNCTION lookup table to set each radius independently.\nEACH_EXACT means use the SCALE_ARRAY_NAME to set each radius\ndirectly.\n"},
  {"SetEnableScaling", PyvtkOSPRayActorNode_SetEnableScaling, METH_VARARGS,
   "SetEnableScaling(value:int, __b:vtkActor) -> None\nC++: static void SetEnableScaling(int value, vtkActor *)\n\nConvenience method to set enable_scaling on my renderable.\n"},
  {"GetEnableScaling", PyvtkOSPRayActorNode_GetEnableScaling, METH_VARARGS,
   "GetEnableScaling(__a:vtkActor) -> int\nC++: static int GetEnableScaling(vtkActor *)\n\n"},
  {"SCALE_ARRAY_NAME", PyvtkOSPRayActorNode_SCALE_ARRAY_NAME, METH_VARARGS,
   "SCALE_ARRAY_NAME() -> vtkInformationStringKey\nC++: static vtkInformationStringKey *SCALE_ARRAY_NAME()\n\nName of a point aligned, single component wide, double valued\narray that, when added to the mapper, will be used to scale each\nelement in the sphere and cylinder representations individually.\nWhen not supplied the radius is constant across all elements and\nis a function of the Mapper's PointSize and LineWidth.\n"},
  {"SetScaleArrayName", PyvtkOSPRayActorNode_SetScaleArrayName, METH_VARARGS,
   "SetScaleArrayName(scaleArrayName:str, __b:vtkActor) -> None\nC++: static void SetScaleArrayName(const char *scaleArrayName,\n    vtkActor *)\n\nConvenience method to set a scale_array_name on my renderable.\n"},
  {"SCALE_FUNCTION", PyvtkOSPRayActorNode_SCALE_FUNCTION, METH_VARARGS,
   "SCALE_FUNCTION() -> vtkInformationObjectBaseKey\nC++: static vtkInformationObjectBaseKey *SCALE_FUNCTION()\n\nA piecewise function for values from the scale array that alters\nthe resulting radii arbitrarily\n"},
  {"SetScaleFunction", PyvtkOSPRayActorNode_SetScaleFunction, METH_VARARGS,
   "SetScaleFunction(scaleFunction:vtkPiecewiseFunction, __b:vtkActor)\n     -> None\nC++: static void SetScaleFunction(\n    vtkPiecewiseFunction *scaleFunction, vtkActor *)\n\nConvenience method to set a scale_function on my renderable.\n"},
  {"LUMINOSITY", PyvtkOSPRayActorNode_LUMINOSITY, METH_VARARGS,
   "LUMINOSITY() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *LUMINOSITY()\n\nIndicates that the actor acts as a light emitting object.\n"},
  {"SetLuminosity", PyvtkOSPRayActorNode_SetLuminosity, METH_VARARGS,
   "SetLuminosity(value:float, __b:vtkProperty) -> None\nC++: static void SetLuminosity(double value, vtkProperty *)\n\nConvenience method to set luminosity on my renderable.\n"},
  {"GetLuminosity", PyvtkOSPRayActorNode_GetLuminosity, METH_VARARGS,
   "GetLuminosity(__a:vtkProperty) -> float\nC++: static double GetLuminosity(vtkProperty *)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOSPRayActorNode_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOSPRayActorNode_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOSPRayActorNode_Doc =
  "vtkOSPRayActorNode - links vtkActor and vtkMapper to OSPRay\n\n"
  "Superclass: vtkActorNode\n\n"
  "Translates vtkActor/Mapper state into OSPRay rendering calls\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOSPRayActorNode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingRayTracing.vtkOSPRayActorNode", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOSPRayActorNode_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOSPRayActorNode_StaticNew()
{
  return vtkOSPRayActorNode::New();
}

PyObject *PyvtkOSPRayActorNode_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOSPRayActorNode_Type, PyvtkOSPRayActorNode_Methods,
    "vtkOSPRayActorNode",
 &PyvtkOSPRayActorNode_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkActorNode");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkOSPRayActorNode_ScalingMode_Type);
  PyVTKEnum_Add(&PyvtkOSPRayActorNode_ScalingMode_Type, "vtkOSPRayActorNode.ScalingMode");

  o = (PyObject *)&PyvtkOSPRayActorNode_ScalingMode_Type;
  if (PyDict_SetItemString(d, "ScalingMode", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 4; c++)
  {
    typedef vtkOSPRayActorNode::ScalingMode cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[4] = {
        { "ALL_EXACT", vtkOSPRayActorNode::ALL_EXACT },
        { "ALL_APPROXIMATE", vtkOSPRayActorNode::ALL_APPROXIMATE },
        { "EACH_MAPPED", vtkOSPRayActorNode::EACH_MAPPED },
        { "EACH_EXACT", vtkOSPRayActorNode::EACH_EXACT },
      };

    o = PyvtkOSPRayActorNode_ScalingMode_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOSPRayActorNode_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOSPRayActorNode(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOSPRayActorNode_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOSPRayActorNode", o) != 0)
  {
    Py_DECREF(o);
  }

}

