//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/volumeFieldSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdVolumeFieldSchemaTokens,
    HD_VOLUME_FIELD_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdAssetPathDataSourceHandle
HdVolumeFieldSchema::GetFilePath() const
{
    return _GetTypedDataSource<HdAssetPathDataSource>(
        HdVolumeFieldSchemaTokens->filePath);
}

HdTokenDataSourceHandle
HdVolumeFieldSchema::GetFieldName() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdVolumeFieldSchemaTokens->fieldName);
}

HdIntDataSourceHandle
HdVolumeFieldSchema::GetFieldIndex() const
{
    return _GetTypedDataSource<HdIntDataSource>(
        HdVolumeFieldSchemaTokens->fieldIndex);
}

HdTokenDataSourceHandle
HdVolumeFieldSchema::GetFieldDataType() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdVolumeFieldSchemaTokens->fieldDataType);
}

HdTokenDataSourceHandle
HdVolumeFieldSchema::GetVectorDataRoleHint() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdVolumeFieldSchemaTokens->vectorDataRoleHint);
}

/*static*/
HdContainerDataSourceHandle
HdVolumeFieldSchema::BuildRetained(
        const HdAssetPathDataSourceHandle &filePath,
        const HdTokenDataSourceHandle &fieldName,
        const HdIntDataSourceHandle &fieldIndex,
        const HdTokenDataSourceHandle &fieldDataType,
        const HdTokenDataSourceHandle &vectorDataRoleHint
)
{
    TfToken _names[5];
    HdDataSourceBaseHandle _values[5];

    size_t _count = 0;

    if (filePath) {
        _names[_count] = HdVolumeFieldSchemaTokens->filePath;
        _values[_count++] = filePath;
    }

    if (fieldName) {
        _names[_count] = HdVolumeFieldSchemaTokens->fieldName;
        _values[_count++] = fieldName;
    }

    if (fieldIndex) {
        _names[_count] = HdVolumeFieldSchemaTokens->fieldIndex;
        _values[_count++] = fieldIndex;
    }

    if (fieldDataType) {
        _names[_count] = HdVolumeFieldSchemaTokens->fieldDataType;
        _values[_count++] = fieldDataType;
    }

    if (vectorDataRoleHint) {
        _names[_count] = HdVolumeFieldSchemaTokens->vectorDataRoleHint;
        _values[_count++] = vectorDataRoleHint;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdVolumeFieldSchema::Builder &
HdVolumeFieldSchema::Builder::SetFilePath(
    const HdAssetPathDataSourceHandle &filePath)
{
    _filePath = filePath;
    return *this;
}

HdVolumeFieldSchema::Builder &
HdVolumeFieldSchema::Builder::SetFieldName(
    const HdTokenDataSourceHandle &fieldName)
{
    _fieldName = fieldName;
    return *this;
}

HdVolumeFieldSchema::Builder &
HdVolumeFieldSchema::Builder::SetFieldIndex(
    const HdIntDataSourceHandle &fieldIndex)
{
    _fieldIndex = fieldIndex;
    return *this;
}

HdVolumeFieldSchema::Builder &
HdVolumeFieldSchema::Builder::SetFieldDataType(
    const HdTokenDataSourceHandle &fieldDataType)
{
    _fieldDataType = fieldDataType;
    return *this;
}

HdVolumeFieldSchema::Builder &
HdVolumeFieldSchema::Builder::SetVectorDataRoleHint(
    const HdTokenDataSourceHandle &vectorDataRoleHint)
{
    _vectorDataRoleHint = vectorDataRoleHint;
    return *this;
}

HdContainerDataSourceHandle
HdVolumeFieldSchema::Builder::Build()
{
    return HdVolumeFieldSchema::BuildRetained(
        _filePath,
        _fieldName,
        _fieldIndex,
        _fieldDataType,
        _vectorDataRoleHint
    );
}

/*static*/
HdVolumeFieldSchema
HdVolumeFieldSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdVolumeFieldSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdVolumeFieldSchemaTokens->volumeField))
        : nullptr);
}

/*static*/
const TfToken &
HdVolumeFieldSchema::GetSchemaToken()
{
    return HdVolumeFieldSchemaTokens->volumeField;
}

/*static*/
const HdDataSourceLocator &
HdVolumeFieldSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE