//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/primvarSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/base/vt/typeHeaders.h"
#include "pxr/base/vt/visitValue.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdPrimvarSchemaTokens,
    HD_PRIMVAR_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

bool
HdPrimvarSchema::IsIndexed() const
{
    if (_container) {
        return (_container->Get(HdPrimvarSchemaTokens->
                    indexedPrimvarValue) && 
                _container->Get(HdPrimvarSchemaTokens->indices));
    }
    return false;
}

namespace {

template<typename T>
VtValue 
_ComputeFlattened(VtArray<T> const &array, VtIntArray const &indices) {
    if (indices.empty()) {
        return VtValue(array);
    }

    VtArray<T> result = VtArray<T>(indices.size());

    bool invalidIndices = false;
    for (size_t i = 0; i < indices.size(); ++i) {
        int index = indices[i];
        if (index >= 0 && (size_t)index < array.size()) {
            result[i] = array[index];
        } else {
            result[i] = T();
            invalidIndices = true;
        }
    }
    if (invalidIndices) {
        TF_WARN("Invalid primvar indices");
    }

    return VtValue(result);
}


struct _ComputeFlattenedValue
{
    _ComputeFlattenedValue(VtIntArray const &indices)
    : _indices(indices) {}

    template <typename T>
    VtValue operator()(VtArray<T> const &array) {
        return _ComputeFlattened<T>(array, _indices);
    }

    VtValue operator()(VtValue const &value) {
        TF_WARN("Unsupported indexed primvar type");
        return value;
    }

    VtIntArray _indices;
};

class _HdDataSourceFlattenedPrimvarValue : public HdSampledDataSource
{
public:
    HD_DECLARE_DATASOURCE(_HdDataSourceFlattenedPrimvarValue);

    _HdDataSourceFlattenedPrimvarValue(
        HdSampledDataSourceHandle indexedValue,
        HdIntArrayDataSourceHandle indices)
    : _indexedValue(std::move(indexedValue))
    , _indices(std::move(indices))
    {
    }

    VtValue GetValue(Time shutterOffset) override
    {
        const VtValue indexedValue = _indexedValue->GetValue(shutterOffset);
        const VtIntArray indices = _indices->GetTypedValue(shutterOffset);
        return VtVisitValue(indexedValue, _ComputeFlattenedValue(indices));
    }

    bool GetContributingSampleTimesForInterval(
        const Time startTime, const Time endTime,
        std::vector<Time> * const outSampleTimes) override
    {
        HdSampledDataSourceHandle const ds[] = {
            _indexedValue, _indices };
        return HdGetMergedContributingSampleTimesForInterval(
            std::size(ds), ds,
            startTime, endTime, outSampleTimes);
    }

private:
    HdSampledDataSourceHandle const _indexedValue;
    HdIntArrayDataSourceHandle const _indices;
};

}

HdSampledDataSourceHandle
HdPrimvarSchema::GetPrimvarValue() const
{
    // overriden definition from primvarSchemaGetValue.template.cpp
    if (_container) {
        if (HdSampledDataSourceHandle sds =
                _GetTypedDataSource<HdSampledDataSource>(
                    HdPrimvarSchemaTokens->primvarValue)) {
            return sds;
        } else {
            HdSampledDataSourceHandle ivds =
                _GetTypedDataSource<HdSampledDataSource>(
                    HdPrimvarSchemaTokens->indexedPrimvarValue);

            HdTypedSampledDataSource<VtIntArray>::Handle ids = 
                _GetTypedDataSource<HdTypedSampledDataSource<VtIntArray>>(
                    HdPrimvarSchemaTokens->indices);

            if (ivds && ids) {
                return _HdDataSourceFlattenedPrimvarValue::New(ivds, ids);
            }
        }
    }
    return nullptr;
}

HdSampledDataSourceHandle
HdPrimvarSchema::GetIndexedPrimvarValue() const
{
    // overriden definition from primvarSchemaGetIndexedValue.template.cpp
    if (IsIndexed()) {
        return _GetTypedDataSource<HdSampledDataSource>(
                HdPrimvarSchemaTokens->indexedPrimvarValue);
    } else {
        return _GetTypedDataSource<HdSampledDataSource>(
                HdPrimvarSchemaTokens->primvarValue);
    }
}

HdSampledDataSourceHandle
HdPrimvarSchema::GetFlattenedPrimvarValue() const
{
    if (!_container) {
        return nullptr;
    }

    if (HdSampledDataSourceHandle sds =
        _GetTypedDataSource<HdSampledDataSource>(
            HdPrimvarSchemaTokens->primvarValue)) {
        // Non-indexed case.
        return sds;
    } else {
        // Indexed case, we need to flatten.

        HdSampledDataSourceHandle ivds =
            _GetTypedDataSource<HdSampledDataSource>(
                HdPrimvarSchemaTokens->indexedPrimvarValue);
        if (!ivds) {
            return nullptr;
        }

        HdTypedSampledDataSource<VtIntArray>::Handle ids = 
            _GetTypedDataSource<HdTypedSampledDataSource<VtIntArray>>(
                HdPrimvarSchemaTokens->indices);
        if (!ids) {
            return nullptr;
        }

        return _HdDataSourceFlattenedPrimvarValue::New(ivds, ids);
    }
}

// --(END CUSTOM CODE: Schema Methods)--

HdIntArrayDataSourceHandle
HdPrimvarSchema::GetIndices() const
{
    return _GetTypedDataSource<HdIntArrayDataSource>(
        HdPrimvarSchemaTokens->indices);
}

HdTokenDataSourceHandle
HdPrimvarSchema::GetInterpolation() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrimvarSchemaTokens->interpolation);
}

HdTokenDataSourceHandle
HdPrimvarSchema::GetRole() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdPrimvarSchemaTokens->role);
}

HdIntDataSourceHandle
HdPrimvarSchema::GetElementSize() const
{
    return _GetTypedDataSource<HdIntDataSource>(
        HdPrimvarSchemaTokens->elementSize);
}

/*static*/
HdContainerDataSourceHandle
HdPrimvarSchema::BuildRetained(
        const HdSampledDataSourceHandle &primvarValue,
        const HdSampledDataSourceHandle &indexedPrimvarValue,
        const HdIntArrayDataSourceHandle &indices,
        const HdTokenDataSourceHandle &interpolation,
        const HdTokenDataSourceHandle &role,
        const HdIntDataSourceHandle &elementSize
)
{
    TfToken _names[6];
    HdDataSourceBaseHandle _values[6];

    size_t _count = 0;

    if (primvarValue) {
        _names[_count] = HdPrimvarSchemaTokens->primvarValue;
        _values[_count++] = primvarValue;
    }

    if (indexedPrimvarValue) {
        _names[_count] = HdPrimvarSchemaTokens->indexedPrimvarValue;
        _values[_count++] = indexedPrimvarValue;
    }

    if (indices) {
        _names[_count] = HdPrimvarSchemaTokens->indices;
        _values[_count++] = indices;
    }

    if (interpolation) {
        _names[_count] = HdPrimvarSchemaTokens->interpolation;
        _values[_count++] = interpolation;
    }

    if (role) {
        _names[_count] = HdPrimvarSchemaTokens->role;
        _values[_count++] = role;
    }

    if (elementSize) {
        _names[_count] = HdPrimvarSchemaTokens->elementSize;
        _values[_count++] = elementSize;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdPrimvarSchema::Builder &
HdPrimvarSchema::Builder::SetPrimvarValue(
    const HdSampledDataSourceHandle &primvarValue)
{
    _primvarValue = primvarValue;
    return *this;
}

HdPrimvarSchema::Builder &
HdPrimvarSchema::Builder::SetIndexedPrimvarValue(
    const HdSampledDataSourceHandle &indexedPrimvarValue)
{
    _indexedPrimvarValue = indexedPrimvarValue;
    return *this;
}

HdPrimvarSchema::Builder &
HdPrimvarSchema::Builder::SetIndices(
    const HdIntArrayDataSourceHandle &indices)
{
    _indices = indices;
    return *this;
}

HdPrimvarSchema::Builder &
HdPrimvarSchema::Builder::SetInterpolation(
    const HdTokenDataSourceHandle &interpolation)
{
    _interpolation = interpolation;
    return *this;
}

HdPrimvarSchema::Builder &
HdPrimvarSchema::Builder::SetRole(
    const HdTokenDataSourceHandle &role)
{
    _role = role;
    return *this;
}

HdPrimvarSchema::Builder &
HdPrimvarSchema::Builder::SetElementSize(
    const HdIntDataSourceHandle &elementSize)
{
    _elementSize = elementSize;
    return *this;
}

HdContainerDataSourceHandle
HdPrimvarSchema::Builder::Build()
{
    return HdPrimvarSchema::BuildRetained(
        _primvarValue,
        _indexedPrimvarValue,
        _indices,
        _interpolation,
        _role,
        _elementSize
    );
}

/*static*/
HdTokenDataSourceHandle
HdPrimvarSchema::BuildInterpolationDataSource(
    const TfToken &interpolation)
{

    if (interpolation == HdPrimvarSchemaTokens->constant) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(interpolation);
        return ds;
    }
    if (interpolation == HdPrimvarSchemaTokens->uniform) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(interpolation);
        return ds;
    }
    if (interpolation == HdPrimvarSchemaTokens->varying) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(interpolation);
        return ds;
    }
    if (interpolation == HdPrimvarSchemaTokens->vertex) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(interpolation);
        return ds;
    }
    if (interpolation == HdPrimvarSchemaTokens->faceVarying) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(interpolation);
        return ds;
    }
    if (interpolation == HdPrimvarSchemaTokens->instance) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(interpolation);
        return ds;
    }
    // fallback for unknown token
    return HdRetainedTypedSampledDataSource<TfToken>::New(interpolation);
}

/*static*/
HdTokenDataSourceHandle
HdPrimvarSchema::BuildRoleDataSource(
    const TfToken &role)
{

    if (role == HdPrimvarSchemaTokens->point) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(role);
        return ds;
    }
    if (role == HdPrimvarSchemaTokens->normal) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(role);
        return ds;
    }
    if (role == HdPrimvarSchemaTokens->vector) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(role);
        return ds;
    }
    if (role == HdPrimvarSchemaTokens->color) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(role);
        return ds;
    }
    if (role == HdPrimvarSchemaTokens->pointIndex) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(role);
        return ds;
    }
    if (role == HdPrimvarSchemaTokens->edgeIndex) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(role);
        return ds;
    }
    if (role == HdPrimvarSchemaTokens->faceIndex) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(role);
        return ds;
    }
    if (role == HdPrimvarSchemaTokens->textureCoordinate) {
        static const HdRetainedTypedSampledDataSource<TfToken>::Handle ds =
            HdRetainedTypedSampledDataSource<TfToken>::New(role);
        return ds;
    }
    // fallback for unknown token
    return HdRetainedTypedSampledDataSource<TfToken>::New(role);
} 

PXR_NAMESPACE_CLOSE_SCOPE