//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/extComputationOutputSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdExtComputationOutputSchemaTokens,
    HD_EXT_COMPUTATION_OUTPUT_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTupleTypeDataSourceHandle
HdExtComputationOutputSchema::GetValueType() const
{
    return _GetTypedDataSource<HdTupleTypeDataSource>(
        HdExtComputationOutputSchemaTokens->valueType);
}

/*static*/
HdContainerDataSourceHandle
HdExtComputationOutputSchema::BuildRetained(
        const HdTupleTypeDataSourceHandle &valueType
)
{
    TfToken _names[1];
    HdDataSourceBaseHandle _values[1];

    size_t _count = 0;

    if (valueType) {
        _names[_count] = HdExtComputationOutputSchemaTokens->valueType;
        _values[_count++] = valueType;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdExtComputationOutputSchema::Builder &
HdExtComputationOutputSchema::Builder::SetValueType(
    const HdTupleTypeDataSourceHandle &valueType)
{
    _valueType = valueType;
    return *this;
}

HdContainerDataSourceHandle
HdExtComputationOutputSchema::Builder::Build()
{
    return HdExtComputationOutputSchema::BuildRetained(
        _valueType
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE