// python wrapper for ttkMergeTreeAutoencoder
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMergeTreeAutoencoder.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMergeTreeAutoencoder(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMergeTreeAutoencoder_ClassNew(); }


static PyObject *
PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInputArrayToProcess(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInputArrayToProcess(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s4(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s5(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  int temp0;
  vtkInformation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkInformation"))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInputArrayToProcess(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s6(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputArrayToProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  int temp0;
  int temp1;
  int temp2;
  const char *temp3 = nullptr;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInputArrayToProcess(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTreeAutoencoder_SetInputArrayToProcess_Methods[] = {
  {"SetInputArrayToProcess", PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s2, METH_VARARGS,
   "@zi"},
  {"SetInputArrayToProcess", PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s3, METH_VARARGS,
   "@iiiiz"},
  {"SetInputArrayToProcess", PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s4, METH_VARARGS,
   "@iiiii"},
  {"SetInputArrayToProcess", PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s5, METH_VARARGS,
   "@iV *vtkInformation"},
  {"SetInputArrayToProcess", PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s6, METH_VARARGS,
   "@iiizz"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyttkMergeTreeAutoencoder_SetInputArrayToProcess(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyttkMergeTreeAutoencoder_SetInputArrayToProcess_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyttkMergeTreeAutoencoder_SetInputArrayToProcess_s1(self, args);
    case 2:
    case 5:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetInputArrayToProcess");
  return nullptr;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetDoCompute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDoCompute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDoCompute(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetDoCompute(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetDoCompute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDoCompute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDoCompute() :
      op->ttkMergeTreeAutoencoder::GetDoCompute());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetNormalizedWasserstein(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizedWasserstein");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNormalizedWasserstein(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetNormalizedWasserstein(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNormalizedWasserstein(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNormalizedWasserstein");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNormalizedWasserstein() :
      op->ttkMergeTreeAutoencoder::GetNormalizedWasserstein());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetNumberOfEncoderLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfEncoderLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfEncoderLayers(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetNumberOfEncoderLayers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNumberOfEncoderLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfEncoderLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfEncoderLayers() :
      op->ttkMergeTreeAutoencoder::GetNumberOfEncoderLayers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetScaleLayerAfterLatent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScaleLayerAfterLatent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScaleLayerAfterLatent(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetScaleLayerAfterLatent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetScaleLayerAfterLatent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScaleLayerAfterLatent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetScaleLayerAfterLatent() :
      op->ttkMergeTreeAutoencoder::GetScaleLayerAfterLatent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetInputNumberOfAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputNumberOfAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInputNumberOfAxes(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInputNumberOfAxes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetInputNumberOfAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputNumberOfAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetInputNumberOfAxes() :
      op->ttkMergeTreeAutoencoder::GetInputNumberOfAxes());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetInputOriginPrimeSizePercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputOriginPrimeSizePercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInputOriginPrimeSizePercent(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInputOriginPrimeSizePercent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetInputOriginPrimeSizePercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputOriginPrimeSizePercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetInputOriginPrimeSizePercent() :
      op->ttkMergeTreeAutoencoder::GetInputOriginPrimeSizePercent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetNumberOfAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfAxes(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetNumberOfAxes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNumberOfAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfAxes() :
      op->ttkMergeTreeAutoencoder::GetNumberOfAxes());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetLatentSpaceOriginPrimeSizePercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLatentSpaceOriginPrimeSizePercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLatentSpaceOriginPrimeSizePercent(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetLatentSpaceOriginPrimeSizePercent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetLatentSpaceOriginPrimeSizePercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLatentSpaceOriginPrimeSizePercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLatentSpaceOriginPrimeSizePercent() :
      op->ttkMergeTreeAutoencoder::GetLatentSpaceOriginPrimeSizePercent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetNumberOfProjectionSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfProjectionSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfProjectionSteps(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetNumberOfProjectionSteps(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNumberOfProjectionSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfProjectionSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfProjectionSteps() :
      op->ttkMergeTreeAutoencoder::GetNumberOfProjectionSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetBarycenterSizeLimitPercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBarycenterSizeLimitPercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBarycenterSizeLimitPercent(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetBarycenterSizeLimitPercent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetBarycenterSizeLimitPercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBarycenterSizeLimitPercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBarycenterSizeLimitPercent() :
      op->ttkMergeTreeAutoencoder::GetBarycenterSizeLimitPercent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetMinIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinIteration(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetMinIteration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetMinIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetMinIteration() :
      op->ttkMergeTreeAutoencoder::GetMinIteration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetMaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxIteration(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetMaxIteration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetMaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetMaxIteration() :
      op->ttkMergeTreeAutoencoder::GetMaxIteration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetIterationGap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIterationGap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIterationGap(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetIterationGap(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetIterationGap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIterationGap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetIterationGap() :
      op->ttkMergeTreeAutoencoder::GetIterationGap());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetBatchSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBatchSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBatchSize(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetBatchSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetBatchSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBatchSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBatchSize() :
      op->ttkMergeTreeAutoencoder::GetBatchSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetOptimizer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOptimizer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOptimizer(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetOptimizer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetOptimizer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOptimizer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOptimizer() :
      op->ttkMergeTreeAutoencoder::GetOptimizer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetGradientStepSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGradientStepSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGradientStepSize(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetGradientStepSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetGradientStepSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGradientStepSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetGradientStepSize() :
      op->ttkMergeTreeAutoencoder::GetGradientStepSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetBeta1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBeta1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBeta1(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetBeta1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetBeta1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBeta1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBeta1() :
      op->ttkMergeTreeAutoencoder::GetBeta1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetBeta2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBeta2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBeta2(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetBeta2(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetBeta2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBeta2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBeta2() :
      op->ttkMergeTreeAutoencoder::GetBeta2());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetReconstructionLossWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReconstructionLossWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReconstructionLossWeight(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetReconstructionLossWeight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetReconstructionLossWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReconstructionLossWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetReconstructionLossWeight() :
      op->ttkMergeTreeAutoencoder::GetReconstructionLossWeight());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetTrackingLossWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTrackingLossWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTrackingLossWeight(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetTrackingLossWeight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetTrackingLossWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTrackingLossWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTrackingLossWeight() :
      op->ttkMergeTreeAutoencoder::GetTrackingLossWeight());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetMetricLossWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMetricLossWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMetricLossWeight(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetMetricLossWeight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetMetricLossWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMetricLossWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMetricLossWeight() :
      op->ttkMergeTreeAutoencoder::GetMetricLossWeight());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetClusteringLossWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClusteringLossWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetClusteringLossWeight(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetClusteringLossWeight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetClusteringLossWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClusteringLossWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetClusteringLossWeight() :
      op->ttkMergeTreeAutoencoder::GetClusteringLossWeight());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetCustomLossSpace(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomLossSpace");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCustomLossSpace(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetCustomLossSpace(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetCustomLossSpace(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomLossSpace");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCustomLossSpace() :
      op->ttkMergeTreeAutoencoder::GetCustomLossSpace());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetCustomLossActivate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomLossActivate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCustomLossActivate(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetCustomLossActivate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetCustomLossActivate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomLossActivate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCustomLossActivate() :
      op->ttkMergeTreeAutoencoder::GetCustomLossActivate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetNormalizeMetricLoss(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizeMetricLoss");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNormalizeMetricLoss(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetNormalizeMetricLoss(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNormalizeMetricLoss(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNormalizeMetricLoss");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNormalizeMetricLoss() :
      op->ttkMergeTreeAutoencoder::GetNormalizeMetricLoss());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetClusteringLossTemperature(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClusteringLossTemperature");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetClusteringLossTemperature(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetClusteringLossTemperature(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetClusteringLossTemperature(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClusteringLossTemperature");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetClusteringLossTemperature() :
      op->ttkMergeTreeAutoencoder::GetClusteringLossTemperature());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetCustomLossDynamicWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomLossDynamicWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCustomLossDynamicWeight(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetCustomLossDynamicWeight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetCustomLossDynamicWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomLossDynamicWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCustomLossDynamicWeight() :
      op->ttkMergeTreeAutoencoder::GetCustomLossDynamicWeight());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetNumberOfInit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfInit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfInit(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetNumberOfInit(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNumberOfInit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfInit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfInit() :
      op->ttkMergeTreeAutoencoder::GetNumberOfInit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetEuclideanVectorsInit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEuclideanVectorsInit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEuclideanVectorsInit(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetEuclideanVectorsInit(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetEuclideanVectorsInit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEuclideanVectorsInit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEuclideanVectorsInit() :
      op->ttkMergeTreeAutoencoder::GetEuclideanVectorsInit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetInitOriginPrimeStructByCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInitOriginPrimeStructByCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInitOriginPrimeStructByCopy(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetInitOriginPrimeStructByCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetInitOriginPrimeStructByCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInitOriginPrimeStructByCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetInitOriginPrimeStructByCopy() :
      op->ttkMergeTreeAutoencoder::GetInitOriginPrimeStructByCopy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetTrackingLossDecoding(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTrackingLossDecoding");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTrackingLossDecoding(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetTrackingLossDecoding(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetTrackingLossDecoding(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTrackingLossDecoding");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTrackingLossDecoding() :
      op->ttkMergeTreeAutoencoder::GetTrackingLossDecoding());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetTrackingLossInitRandomness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTrackingLossInitRandomness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTrackingLossInitRandomness(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetTrackingLossInitRandomness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetTrackingLossInitRandomness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTrackingLossInitRandomness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTrackingLossInitRandomness() :
      op->ttkMergeTreeAutoencoder::GetTrackingLossInitRandomness());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetDeterministic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeterministic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeterministic(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetDeterministic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetDeterministic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeterministic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDeterministic() :
      op->ttkMergeTreeAutoencoder::GetDeterministic());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetActivate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivate(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetActivate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetActivate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActivate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetActivate() :
      op->ttkMergeTreeAutoencoder::GetActivate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetActivationFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivationFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivationFunction(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetActivationFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetActivationFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActivationFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetActivationFunction() :
      op->ttkMergeTreeAutoencoder::GetActivationFunction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetFullSymmetricAE(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFullSymmetricAE");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFullSymmetricAE(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetFullSymmetricAE(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetFullSymmetricAE(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullSymmetricAE");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFullSymmetricAE() :
      op->ttkMergeTreeAutoencoder::GetFullSymmetricAE());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetActivateOutputInit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActivateOutputInit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActivateOutputInit(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetActivateOutputInit(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetActivateOutputInit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActivateOutputInit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetActivateOutputInit() :
      op->ttkMergeTreeAutoencoder::GetActivateOutputInit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetJoinSplitMixtureCoefficient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetJoinSplitMixtureCoefficient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetJoinSplitMixtureCoefficient(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetJoinSplitMixtureCoefficient(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetJoinSplitMixtureCoefficient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetJoinSplitMixtureCoefficient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetJoinSplitMixtureCoefficient() :
      op->ttkMergeTreeAutoencoder::GetJoinSplitMixtureCoefficient());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon1UseFarthestSaddle(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetEpsilon1UseFarthestSaddle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEpsilon1UseFarthestSaddle() :
      op->ttkMergeTreeAutoencoder::GetEpsilon1UseFarthestSaddle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetEpsilonTree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilonTree1(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetEpsilonTree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetEpsilonTree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilonTree1() :
      op->ttkMergeTreeAutoencoder::GetEpsilonTree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetEpsilon2Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon2Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetEpsilon2Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetEpsilon2Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilon2Tree1() :
      op->ttkMergeTreeAutoencoder::GetEpsilon2Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetEpsilon3Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon3Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetEpsilon3Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetEpsilon3Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilon3Tree1() :
      op->ttkMergeTreeAutoencoder::GetEpsilon3Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPersistenceThreshold(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetPersistenceThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPersistenceThreshold() :
      op->ttkMergeTreeAutoencoder::GetPersistenceThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetDeleteMultiPersPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeleteMultiPersPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetDeleteMultiPersPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetDeleteMultiPersPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDeleteMultiPersPairs() :
      op->ttkMergeTreeAutoencoder::GetDeleteMultiPersPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetNodePerTask(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNodePerTask");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNodePerTask(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetNodePerTask(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNodePerTask(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNodePerTask");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNodePerTask() :
      op->ttkMergeTreeAutoencoder::GetNodePerTask());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SetCreateOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCreateOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCreateOutput(temp0);
    }
    else
    {
      op->ttkMergeTreeAutoencoder::SetCreateOutput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetCreateOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCreateOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCreateOutput() :
      op->ttkMergeTreeAutoencoder::GetCreateOutput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMergeTreeAutoencoder::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMergeTreeAutoencoder::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMergeTreeAutoencoder *tempr = ttkMergeTreeAutoencoder::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMergeTreeAutoencoder *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMergeTreeAutoencoder::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMergeTreeAutoencoder::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeAutoencoder_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeAutoencoder *op = static_cast<ttkMergeTreeAutoencoder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMergeTreeAutoencoder::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTreeAutoencoder_Methods[] = {
  {"SetInputArrayToProcess", PyttkMergeTreeAutoencoder_SetInputArrayToProcess, METH_VARARGS,
   "SetInputArrayToProcess(self, name:str) -> None\nC++: void SetInputArrayToProcess(const char *name)\nSetInputArrayToProcess(self, name:str, fieldAssociation:int)\n    -> None\nC++: void SetInputArrayToProcess(const char *name,\n    int fieldAssociation)\nSetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldAssociation:int, name:str) -> None\nC++: virtual void SetInputArrayToProcess(int idx, int port,\n    int connection, int fieldAssociation, const char *name)\nSetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldAssociation:int, fieldAttributeType:int) -> None\nC++: virtual void SetInputArrayToProcess(int idx, int port,\n    int connection, int fieldAssociation, int fieldAttributeType)\nSetInputArrayToProcess(self, idx:int, info:vtkInformation) -> None\nC++: virtual void SetInputArrayToProcess(int idx,\n    vtkInformation *info)\nSetInputArrayToProcess(self, idx:int, port:int, connection:int,\n    fieldAssociation:str, attributeTypeorName:str) -> None\nC++: virtual void SetInputArrayToProcess(int idx, int port,\n    int connection, const char *fieldAssociation,\n    const char *attributeTypeorName)\n\n"},
  {"SetDoCompute", PyttkMergeTreeAutoencoder_SetDoCompute, METH_VARARGS,
   "SetDoCompute(self, doCompute:bool) -> None\nC++: void SetDoCompute(bool doCompute)\n\n"},
  {"GetDoCompute", PyttkMergeTreeAutoencoder_GetDoCompute, METH_VARARGS,
   "GetDoCompute(self) -> bool\nC++: bool GetDoCompute()\n\n"},
  {"SetNormalizedWasserstein", PyttkMergeTreeAutoencoder_SetNormalizedWasserstein, METH_VARARGS,
   "SetNormalizedWasserstein(self, nW:bool) -> None\nC++: void SetNormalizedWasserstein(bool nW)\n\n"},
  {"GetNormalizedWasserstein", PyttkMergeTreeAutoencoder_GetNormalizedWasserstein, METH_VARARGS,
   "GetNormalizedWasserstein(self) -> bool\nC++: bool GetNormalizedWasserstein()\n\n"},
  {"SetNumberOfEncoderLayers", PyttkMergeTreeAutoencoder_SetNumberOfEncoderLayers, METH_VARARGS,
   "SetNumberOfEncoderLayers(self, numberOfEncoderLayers:int) -> None\nC++: void SetNumberOfEncoderLayers(\n    unsigned int numberOfEncoderLayers)\n\n"},
  {"GetNumberOfEncoderLayers", PyttkMergeTreeAutoencoder_GetNumberOfEncoderLayers, METH_VARARGS,
   "GetNumberOfEncoderLayers(self) -> int\nC++: unsigned int GetNumberOfEncoderLayers()\n\n"},
  {"SetScaleLayerAfterLatent", PyttkMergeTreeAutoencoder_SetScaleLayerAfterLatent, METH_VARARGS,
   "SetScaleLayerAfterLatent(self, scaleLayerAfterLatent:int) -> None\nC++: void SetScaleLayerAfterLatent(\n    unsigned int scaleLayerAfterLatent)\n\n"},
  {"GetScaleLayerAfterLatent", PyttkMergeTreeAutoencoder_GetScaleLayerAfterLatent, METH_VARARGS,
   "GetScaleLayerAfterLatent(self) -> int\nC++: unsigned int GetScaleLayerAfterLatent()\n\n"},
  {"SetInputNumberOfAxes", PyttkMergeTreeAutoencoder_SetInputNumberOfAxes, METH_VARARGS,
   "SetInputNumberOfAxes(self, numberOfAxes:int) -> None\nC++: void SetInputNumberOfAxes(unsigned int numberOfAxes)\n\n"},
  {"GetInputNumberOfAxes", PyttkMergeTreeAutoencoder_GetInputNumberOfAxes, METH_VARARGS,
   "GetInputNumberOfAxes(self) -> int\nC++: unsigned int GetInputNumberOfAxes()\n\n"},
  {"SetInputOriginPrimeSizePercent", PyttkMergeTreeAutoencoder_SetInputOriginPrimeSizePercent, METH_VARARGS,
   "SetInputOriginPrimeSizePercent(self, originSize:float) -> None\nC++: void SetInputOriginPrimeSizePercent(double originSize)\n\n"},
  {"GetInputOriginPrimeSizePercent", PyttkMergeTreeAutoencoder_GetInputOriginPrimeSizePercent, METH_VARARGS,
   "GetInputOriginPrimeSizePercent(self) -> float\nC++: double GetInputOriginPrimeSizePercent()\n\n"},
  {"SetNumberOfAxes", PyttkMergeTreeAutoencoder_SetNumberOfAxes, METH_VARARGS,
   "SetNumberOfAxes(self, numberOfAxes:int) -> None\nC++: void SetNumberOfAxes(unsigned int numberOfAxes)\n\n"},
  {"GetNumberOfAxes", PyttkMergeTreeAutoencoder_GetNumberOfAxes, METH_VARARGS,
   "GetNumberOfAxes(self) -> int\nC++: unsigned int GetNumberOfAxes()\n\n"},
  {"SetLatentSpaceOriginPrimeSizePercent", PyttkMergeTreeAutoencoder_SetLatentSpaceOriginPrimeSizePercent, METH_VARARGS,
   "SetLatentSpaceOriginPrimeSizePercent(self, originSize:float)\n    -> None\nC++: void SetLatentSpaceOriginPrimeSizePercent(double originSize)\n\n"},
  {"GetLatentSpaceOriginPrimeSizePercent", PyttkMergeTreeAutoencoder_GetLatentSpaceOriginPrimeSizePercent, METH_VARARGS,
   "GetLatentSpaceOriginPrimeSizePercent(self) -> float\nC++: double GetLatentSpaceOriginPrimeSizePercent()\n\n"},
  {"SetNumberOfProjectionSteps", PyttkMergeTreeAutoencoder_SetNumberOfProjectionSteps, METH_VARARGS,
   "SetNumberOfProjectionSteps(self, noSteps:int) -> None\nC++: void SetNumberOfProjectionSteps(unsigned int noSteps)\n\n"},
  {"GetNumberOfProjectionSteps", PyttkMergeTreeAutoencoder_GetNumberOfProjectionSteps, METH_VARARGS,
   "GetNumberOfProjectionSteps(self) -> int\nC++: unsigned int GetNumberOfProjectionSteps()\n\n"},
  {"SetBarycenterSizeLimitPercent", PyttkMergeTreeAutoencoder_SetBarycenterSizeLimitPercent, METH_VARARGS,
   "SetBarycenterSizeLimitPercent(self, percent:float) -> None\nC++: void SetBarycenterSizeLimitPercent(double percent)\n\n"},
  {"GetBarycenterSizeLimitPercent", PyttkMergeTreeAutoencoder_GetBarycenterSizeLimitPercent, METH_VARARGS,
   "GetBarycenterSizeLimitPercent(self) -> float\nC++: double GetBarycenterSizeLimitPercent()\n\n"},
  {"SetMinIteration", PyttkMergeTreeAutoencoder_SetMinIteration, METH_VARARGS,
   "SetMinIteration(self, minIteration:int) -> None\nC++: void SetMinIteration(unsigned int minIteration)\n\n"},
  {"GetMinIteration", PyttkMergeTreeAutoencoder_GetMinIteration, METH_VARARGS,
   "GetMinIteration(self) -> int\nC++: unsigned int GetMinIteration()\n\n"},
  {"SetMaxIteration", PyttkMergeTreeAutoencoder_SetMaxIteration, METH_VARARGS,
   "SetMaxIteration(self, maxIteration:int) -> None\nC++: void SetMaxIteration(unsigned int maxIteration)\n\n"},
  {"GetMaxIteration", PyttkMergeTreeAutoencoder_GetMaxIteration, METH_VARARGS,
   "GetMaxIteration(self) -> int\nC++: unsigned int GetMaxIteration()\n\n"},
  {"SetIterationGap", PyttkMergeTreeAutoencoder_SetIterationGap, METH_VARARGS,
   "SetIterationGap(self, iterationGap:int) -> None\nC++: void SetIterationGap(unsigned int iterationGap)\n\n"},
  {"GetIterationGap", PyttkMergeTreeAutoencoder_GetIterationGap, METH_VARARGS,
   "GetIterationGap(self) -> float\nC++: double GetIterationGap()\n\n"},
  {"SetBatchSize", PyttkMergeTreeAutoencoder_SetBatchSize, METH_VARARGS,
   "SetBatchSize(self, bs:float) -> None\nC++: void SetBatchSize(double bs)\n\n"},
  {"GetBatchSize", PyttkMergeTreeAutoencoder_GetBatchSize, METH_VARARGS,
   "GetBatchSize(self) -> float\nC++: double GetBatchSize()\n\n"},
  {"SetOptimizer", PyttkMergeTreeAutoencoder_SetOptimizer, METH_VARARGS,
   "SetOptimizer(self, optimizer:int) -> None\nC++: void SetOptimizer(int optimizer)\n\n"},
  {"GetOptimizer", PyttkMergeTreeAutoencoder_GetOptimizer, METH_VARARGS,
   "GetOptimizer(self) -> int\nC++: int GetOptimizer()\n\n"},
  {"SetGradientStepSize", PyttkMergeTreeAutoencoder_SetGradientStepSize, METH_VARARGS,
   "SetGradientStepSize(self, lr:float) -> None\nC++: void SetGradientStepSize(double lr)\n\n"},
  {"GetGradientStepSize", PyttkMergeTreeAutoencoder_GetGradientStepSize, METH_VARARGS,
   "GetGradientStepSize(self) -> float\nC++: double GetGradientStepSize()\n\n"},
  {"SetBeta1", PyttkMergeTreeAutoencoder_SetBeta1, METH_VARARGS,
   "SetBeta1(self, beta:float) -> None\nC++: void SetBeta1(double beta)\n\n"},
  {"GetBeta1", PyttkMergeTreeAutoencoder_GetBeta1, METH_VARARGS,
   "GetBeta1(self) -> float\nC++: double GetBeta1()\n\n"},
  {"SetBeta2", PyttkMergeTreeAutoencoder_SetBeta2, METH_VARARGS,
   "SetBeta2(self, beta:float) -> None\nC++: void SetBeta2(double beta)\n\n"},
  {"GetBeta2", PyttkMergeTreeAutoencoder_GetBeta2, METH_VARARGS,
   "GetBeta2(self) -> float\nC++: double GetBeta2()\n\n"},
  {"SetReconstructionLossWeight", PyttkMergeTreeAutoencoder_SetReconstructionLossWeight, METH_VARARGS,
   "SetReconstructionLossWeight(self, reconstructionLossWeight:float)\n    -> None\nC++: void SetReconstructionLossWeight(\n    double reconstructionLossWeight)\n\n"},
  {"GetReconstructionLossWeight", PyttkMergeTreeAutoencoder_GetReconstructionLossWeight, METH_VARARGS,
   "GetReconstructionLossWeight(self) -> float\nC++: double GetReconstructionLossWeight()\n\n"},
  {"SetTrackingLossWeight", PyttkMergeTreeAutoencoder_SetTrackingLossWeight, METH_VARARGS,
   "SetTrackingLossWeight(self, trackingLossWeight:float) -> None\nC++: void SetTrackingLossWeight(double trackingLossWeight)\n\n"},
  {"GetTrackingLossWeight", PyttkMergeTreeAutoencoder_GetTrackingLossWeight, METH_VARARGS,
   "GetTrackingLossWeight(self) -> float\nC++: double GetTrackingLossWeight()\n\n"},
  {"SetMetricLossWeight", PyttkMergeTreeAutoencoder_SetMetricLossWeight, METH_VARARGS,
   "SetMetricLossWeight(self, metricLossWeight:float) -> None\nC++: void SetMetricLossWeight(double metricLossWeight)\n\n"},
  {"GetMetricLossWeight", PyttkMergeTreeAutoencoder_GetMetricLossWeight, METH_VARARGS,
   "GetMetricLossWeight(self) -> float\nC++: double GetMetricLossWeight()\n\n"},
  {"SetClusteringLossWeight", PyttkMergeTreeAutoencoder_SetClusteringLossWeight, METH_VARARGS,
   "SetClusteringLossWeight(self, clusteringLossWeight:float) -> None\nC++: void SetClusteringLossWeight(double clusteringLossWeight)\n\n"},
  {"GetClusteringLossWeight", PyttkMergeTreeAutoencoder_GetClusteringLossWeight, METH_VARARGS,
   "GetClusteringLossWeight(self) -> float\nC++: double GetClusteringLossWeight()\n\n"},
  {"SetCustomLossSpace", PyttkMergeTreeAutoencoder_SetCustomLossSpace, METH_VARARGS,
   "SetCustomLossSpace(self, customLossSpace:bool) -> None\nC++: void SetCustomLossSpace(bool customLossSpace)\n\n"},
  {"GetCustomLossSpace", PyttkMergeTreeAutoencoder_GetCustomLossSpace, METH_VARARGS,
   "GetCustomLossSpace(self) -> bool\nC++: bool GetCustomLossSpace()\n\n"},
  {"SetCustomLossActivate", PyttkMergeTreeAutoencoder_SetCustomLossActivate, METH_VARARGS,
   "SetCustomLossActivate(self, customLossActivate:bool) -> None\nC++: void SetCustomLossActivate(bool customLossActivate)\n\n"},
  {"GetCustomLossActivate", PyttkMergeTreeAutoencoder_GetCustomLossActivate, METH_VARARGS,
   "GetCustomLossActivate(self) -> bool\nC++: bool GetCustomLossActivate()\n\n"},
  {"SetNormalizeMetricLoss", PyttkMergeTreeAutoencoder_SetNormalizeMetricLoss, METH_VARARGS,
   "SetNormalizeMetricLoss(self, normalizeMetricLoss:bool) -> None\nC++: void SetNormalizeMetricLoss(bool normalizeMetricLoss)\n\n"},
  {"GetNormalizeMetricLoss", PyttkMergeTreeAutoencoder_GetNormalizeMetricLoss, METH_VARARGS,
   "GetNormalizeMetricLoss(self) -> bool\nC++: bool GetNormalizeMetricLoss()\n\n"},
  {"SetClusteringLossTemperature", PyttkMergeTreeAutoencoder_SetClusteringLossTemperature, METH_VARARGS,
   "SetClusteringLossTemperature(self,\n    clusteringLossTemperature:float) -> None\nC++: void SetClusteringLossTemperature(\n    double clusteringLossTemperature)\n\n"},
  {"GetClusteringLossTemperature", PyttkMergeTreeAutoencoder_GetClusteringLossTemperature, METH_VARARGS,
   "GetClusteringLossTemperature(self) -> float\nC++: double GetClusteringLossTemperature()\n\n"},
  {"SetCustomLossDynamicWeight", PyttkMergeTreeAutoencoder_SetCustomLossDynamicWeight, METH_VARARGS,
   "SetCustomLossDynamicWeight(self, customLossDynamicWeight:bool)\n    -> None\nC++: void SetCustomLossDynamicWeight(bool customLossDynamicWeight)\n\n"},
  {"GetCustomLossDynamicWeight", PyttkMergeTreeAutoencoder_GetCustomLossDynamicWeight, METH_VARARGS,
   "GetCustomLossDynamicWeight(self) -> bool\nC++: bool GetCustomLossDynamicWeight()\n\n"},
  {"SetNumberOfInit", PyttkMergeTreeAutoencoder_SetNumberOfInit, METH_VARARGS,
   "SetNumberOfInit(self, noInit:int) -> None\nC++: void SetNumberOfInit(unsigned int noInit)\n\n"},
  {"GetNumberOfInit", PyttkMergeTreeAutoencoder_GetNumberOfInit, METH_VARARGS,
   "GetNumberOfInit(self) -> int\nC++: unsigned int GetNumberOfInit()\n\n"},
  {"SetEuclideanVectorsInit", PyttkMergeTreeAutoencoder_SetEuclideanVectorsInit, METH_VARARGS,
   "SetEuclideanVectorsInit(self, euclideanVectorsInit:bool) -> None\nC++: void SetEuclideanVectorsInit(bool euclideanVectorsInit)\n\n"},
  {"GetEuclideanVectorsInit", PyttkMergeTreeAutoencoder_GetEuclideanVectorsInit, METH_VARARGS,
   "GetEuclideanVectorsInit(self) -> bool\nC++: bool GetEuclideanVectorsInit()\n\n"},
  {"SetInitOriginPrimeStructByCopy", PyttkMergeTreeAutoencoder_SetInitOriginPrimeStructByCopy, METH_VARARGS,
   "SetInitOriginPrimeStructByCopy(self,\n    initOriginPrimeStructByCopy:bool) -> None\nC++: void SetInitOriginPrimeStructByCopy(\n    bool initOriginPrimeStructByCopy)\n\n"},
  {"GetInitOriginPrimeStructByCopy", PyttkMergeTreeAutoencoder_GetInitOriginPrimeStructByCopy, METH_VARARGS,
   "GetInitOriginPrimeStructByCopy(self) -> bool\nC++: bool GetInitOriginPrimeStructByCopy()\n\n"},
  {"SetTrackingLossDecoding", PyttkMergeTreeAutoencoder_SetTrackingLossDecoding, METH_VARARGS,
   "SetTrackingLossDecoding(self, trackingLossDecoding:float) -> None\nC++: void SetTrackingLossDecoding(double trackingLossDecoding)\n\n"},
  {"GetTrackingLossDecoding", PyttkMergeTreeAutoencoder_GetTrackingLossDecoding, METH_VARARGS,
   "GetTrackingLossDecoding(self) -> float\nC++: double GetTrackingLossDecoding()\n\n"},
  {"SetTrackingLossInitRandomness", PyttkMergeTreeAutoencoder_SetTrackingLossInitRandomness, METH_VARARGS,
   "SetTrackingLossInitRandomness(self,\n    trackingLossInitRandomness:float) -> None\nC++: void SetTrackingLossInitRandomness(\n    double trackingLossInitRandomness)\n\n"},
  {"GetTrackingLossInitRandomness", PyttkMergeTreeAutoencoder_GetTrackingLossInitRandomness, METH_VARARGS,
   "GetTrackingLossInitRandomness(self) -> float\nC++: double GetTrackingLossInitRandomness()\n\n"},
  {"SetDeterministic", PyttkMergeTreeAutoencoder_SetDeterministic, METH_VARARGS,
   "SetDeterministic(self, deterministic:bool) -> None\nC++: void SetDeterministic(bool deterministic)\n\n"},
  {"GetDeterministic", PyttkMergeTreeAutoencoder_GetDeterministic, METH_VARARGS,
   "GetDeterministic(self) -> bool\nC++: bool GetDeterministic()\n\n"},
  {"SetActivate", PyttkMergeTreeAutoencoder_SetActivate, METH_VARARGS,
   "SetActivate(self, activate:bool) -> None\nC++: void SetActivate(bool activate)\n\n"},
  {"GetActivate", PyttkMergeTreeAutoencoder_GetActivate, METH_VARARGS,
   "GetActivate(self) -> bool\nC++: bool GetActivate()\n\n"},
  {"SetActivationFunction", PyttkMergeTreeAutoencoder_SetActivationFunction, METH_VARARGS,
   "SetActivationFunction(self, activationFunction:int) -> None\nC++: void SetActivationFunction(unsigned int activationFunction)\n\n"},
  {"GetActivationFunction", PyttkMergeTreeAutoencoder_GetActivationFunction, METH_VARARGS,
   "GetActivationFunction(self) -> int\nC++: unsigned int GetActivationFunction()\n\n"},
  {"SetFullSymmetricAE", PyttkMergeTreeAutoencoder_SetFullSymmetricAE, METH_VARARGS,
   "SetFullSymmetricAE(self, fullSymmetricAE:bool) -> None\nC++: void SetFullSymmetricAE(bool fullSymmetricAE)\n\n"},
  {"GetFullSymmetricAE", PyttkMergeTreeAutoencoder_GetFullSymmetricAE, METH_VARARGS,
   "GetFullSymmetricAE(self) -> bool\nC++: bool GetFullSymmetricAE()\n\n"},
  {"SetActivateOutputInit", PyttkMergeTreeAutoencoder_SetActivateOutputInit, METH_VARARGS,
   "SetActivateOutputInit(self, activateOutputInit:bool) -> None\nC++: void SetActivateOutputInit(bool activateOutputInit)\n\n"},
  {"GetActivateOutputInit", PyttkMergeTreeAutoencoder_GetActivateOutputInit, METH_VARARGS,
   "GetActivateOutputInit(self) -> bool\nC++: bool GetActivateOutputInit()\n\n"},
  {"SetJoinSplitMixtureCoefficient", PyttkMergeTreeAutoencoder_SetJoinSplitMixtureCoefficient, METH_VARARGS,
   "SetJoinSplitMixtureCoefficient(self,\n    joinSplitMixtureCoefficient:float) -> None\nC++: void SetJoinSplitMixtureCoefficient(\n    double joinSplitMixtureCoefficient)\n\n"},
  {"GetJoinSplitMixtureCoefficient", PyttkMergeTreeAutoencoder_GetJoinSplitMixtureCoefficient, METH_VARARGS,
   "GetJoinSplitMixtureCoefficient(self) -> float\nC++: double GetJoinSplitMixtureCoefficient()\n\n"},
  {"SetEpsilon1UseFarthestSaddle", PyttkMergeTreeAutoencoder_SetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "SetEpsilon1UseFarthestSaddle(self, epsilon1UseFarthestSaddle:bool)\n     -> None\nC++: void SetEpsilon1UseFarthestSaddle(\n    bool epsilon1UseFarthestSaddle)\n\n"},
  {"GetEpsilon1UseFarthestSaddle", PyttkMergeTreeAutoencoder_GetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "GetEpsilon1UseFarthestSaddle(self) -> bool\nC++: bool GetEpsilon1UseFarthestSaddle()\n\n"},
  {"SetEpsilonTree1", PyttkMergeTreeAutoencoder_SetEpsilonTree1, METH_VARARGS,
   "SetEpsilonTree1(self, epsilonTree1:float) -> None\nC++: void SetEpsilonTree1(double epsilonTree1)\n\n"},
  {"GetEpsilonTree1", PyttkMergeTreeAutoencoder_GetEpsilonTree1, METH_VARARGS,
   "GetEpsilonTree1(self) -> float\nC++: double GetEpsilonTree1()\n\n"},
  {"SetEpsilon2Tree1", PyttkMergeTreeAutoencoder_SetEpsilon2Tree1, METH_VARARGS,
   "SetEpsilon2Tree1(self, epsilon2Tree1:float) -> None\nC++: void SetEpsilon2Tree1(double epsilon2Tree1)\n\n"},
  {"GetEpsilon2Tree1", PyttkMergeTreeAutoencoder_GetEpsilon2Tree1, METH_VARARGS,
   "GetEpsilon2Tree1(self) -> float\nC++: double GetEpsilon2Tree1()\n\n"},
  {"SetEpsilon3Tree1", PyttkMergeTreeAutoencoder_SetEpsilon3Tree1, METH_VARARGS,
   "SetEpsilon3Tree1(self, epsilon3Tree1:float) -> None\nC++: void SetEpsilon3Tree1(double epsilon3Tree1)\n\n"},
  {"GetEpsilon3Tree1", PyttkMergeTreeAutoencoder_GetEpsilon3Tree1, METH_VARARGS,
   "GetEpsilon3Tree1(self) -> float\nC++: double GetEpsilon3Tree1()\n\n"},
  {"SetPersistenceThreshold", PyttkMergeTreeAutoencoder_SetPersistenceThreshold, METH_VARARGS,
   "SetPersistenceThreshold(self, persistenceThreshold:float) -> None\nC++: void SetPersistenceThreshold(double persistenceThreshold)\n\n"},
  {"GetPersistenceThreshold", PyttkMergeTreeAutoencoder_GetPersistenceThreshold, METH_VARARGS,
   "GetPersistenceThreshold(self) -> float\nC++: double GetPersistenceThreshold()\n\n"},
  {"SetDeleteMultiPersPairs", PyttkMergeTreeAutoencoder_SetDeleteMultiPersPairs, METH_VARARGS,
   "SetDeleteMultiPersPairs(self, delMultiPersPairs:bool) -> None\nC++: void SetDeleteMultiPersPairs(bool delMultiPersPairs)\n\n"},
  {"GetDeleteMultiPersPairs", PyttkMergeTreeAutoencoder_GetDeleteMultiPersPairs, METH_VARARGS,
   "GetDeleteMultiPersPairs(self) -> bool\nC++: bool GetDeleteMultiPersPairs()\n\n"},
  {"SetNodePerTask", PyttkMergeTreeAutoencoder_SetNodePerTask, METH_VARARGS,
   "SetNodePerTask(self, nodePerTask:int) -> None\nC++: void SetNodePerTask(int nodePerTask)\n\n"},
  {"GetNodePerTask", PyttkMergeTreeAutoencoder_GetNodePerTask, METH_VARARGS,
   "GetNodePerTask(self) -> int\nC++: int GetNodePerTask()\n\n"},
  {"SetCreateOutput", PyttkMergeTreeAutoencoder_SetCreateOutput, METH_VARARGS,
   "SetCreateOutput(self, createOutput:bool) -> None\nC++: void SetCreateOutput(bool createOutput)\n\n"},
  {"GetCreateOutput", PyttkMergeTreeAutoencoder_GetCreateOutput, METH_VARARGS,
   "GetCreateOutput(self) -> bool\nC++: bool GetCreateOutput()\n\n"},
  {"IsTypeOf", PyttkMergeTreeAutoencoder_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMergeTreeAutoencoder_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMergeTreeAutoencoder_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMergeTreeAutoencoder\nC++: static ttkMergeTreeAutoencoder *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMergeTreeAutoencoder_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMergeTreeAutoencoder\nC++: ttkMergeTreeAutoencoder *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMergeTreeAutoencoder_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMergeTreeAutoencoder_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMergeTreeAutoencoder_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("input_array_to_process"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetInputArrayToProcess(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetInputArrayToProcess(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputArrayToProcess\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("do_compute"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetDoCompute(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetDoCompute(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetDoCompute(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDoCompute/SetDoCompute\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normalized_wasserstein"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetNormalizedWasserstein(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetNormalizedWasserstein(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetNormalizedWasserstein(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNormalizedWasserstein/SetNormalizedWasserstein\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scale_layer_after_latent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetScaleLayerAfterLatent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetScaleLayerAfterLatent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetScaleLayerAfterLatent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetScaleLayerAfterLatent/SetScaleLayerAfterLatent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_number_of_axes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetInputNumberOfAxes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetInputNumberOfAxes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetInputNumberOfAxes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInputNumberOfAxes/SetInputNumberOfAxes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_origin_prime_size_percent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetInputOriginPrimeSizePercent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetInputOriginPrimeSizePercent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetInputOriginPrimeSizePercent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInputOriginPrimeSizePercent/SetInputOriginPrimeSizePercent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("latent_space_origin_prime_size_percent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetLatentSpaceOriginPrimeSizePercent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetLatentSpaceOriginPrimeSizePercent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetLatentSpaceOriginPrimeSizePercent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLatentSpaceOriginPrimeSizePercent/SetLatentSpaceOriginPrimeSizePercent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("barycenter_size_limit_percent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetBarycenterSizeLimitPercent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetBarycenterSizeLimitPercent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetBarycenterSizeLimitPercent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBarycenterSizeLimitPercent/SetBarycenterSizeLimitPercent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("min_iteration"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetMinIteration(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetMinIteration(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetMinIteration(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinIteration/SetMinIteration\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_iteration"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetMaxIteration(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetMaxIteration(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetMaxIteration(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxIteration/SetMaxIteration\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("iteration_gap"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetIterationGap(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetIterationGap(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetIterationGap\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("batch_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetBatchSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetBatchSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetBatchSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBatchSize/SetBatchSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("optimizer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetOptimizer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetOptimizer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetOptimizer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOptimizer/SetOptimizer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gradient_step_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetGradientStepSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetGradientStepSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetGradientStepSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGradientStepSize/SetGradientStepSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("beta1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetBeta1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetBeta1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetBeta1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBeta1/SetBeta1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("beta2"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetBeta2(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetBeta2(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetBeta2(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBeta2/SetBeta2\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reconstruction_loss_weight"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetReconstructionLossWeight(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetReconstructionLossWeight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetReconstructionLossWeight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReconstructionLossWeight/SetReconstructionLossWeight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tracking_loss_weight"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetTrackingLossWeight(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetTrackingLossWeight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetTrackingLossWeight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTrackingLossWeight/SetTrackingLossWeight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("metric_loss_weight"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetMetricLossWeight(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetMetricLossWeight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetMetricLossWeight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMetricLossWeight/SetMetricLossWeight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("clustering_loss_weight"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetClusteringLossWeight(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetClusteringLossWeight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetClusteringLossWeight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetClusteringLossWeight/SetClusteringLossWeight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_loss_space"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetCustomLossSpace(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetCustomLossSpace(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetCustomLossSpace(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCustomLossSpace/SetCustomLossSpace\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_loss_activate"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetCustomLossActivate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetCustomLossActivate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetCustomLossActivate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCustomLossActivate/SetCustomLossActivate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normalize_metric_loss"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetNormalizeMetricLoss(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetNormalizeMetricLoss(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetNormalizeMetricLoss(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNormalizeMetricLoss/SetNormalizeMetricLoss\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("clustering_loss_temperature"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetClusteringLossTemperature(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetClusteringLossTemperature(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetClusteringLossTemperature(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetClusteringLossTemperature/SetClusteringLossTemperature\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_loss_dynamic_weight"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetCustomLossDynamicWeight(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetCustomLossDynamicWeight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetCustomLossDynamicWeight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCustomLossDynamicWeight/SetCustomLossDynamicWeight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_init"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetNumberOfInit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetNumberOfInit(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetNumberOfInit(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfInit/SetNumberOfInit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("euclidean_vectors_init"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetEuclideanVectorsInit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetEuclideanVectorsInit(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetEuclideanVectorsInit(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEuclideanVectorsInit/SetEuclideanVectorsInit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("init_origin_prime_struct_by_copy"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetInitOriginPrimeStructByCopy(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetInitOriginPrimeStructByCopy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetInitOriginPrimeStructByCopy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInitOriginPrimeStructByCopy/SetInitOriginPrimeStructByCopy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tracking_loss_decoding"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetTrackingLossDecoding(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetTrackingLossDecoding(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetTrackingLossDecoding(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTrackingLossDecoding/SetTrackingLossDecoding\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tracking_loss_init_randomness"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetTrackingLossInitRandomness(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetTrackingLossInitRandomness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetTrackingLossInitRandomness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTrackingLossInitRandomness/SetTrackingLossInitRandomness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("deterministic"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetDeterministic(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetDeterministic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetDeterministic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDeterministic/SetDeterministic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("activate"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetActivate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetActivate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetActivate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActivate/SetActivate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("activation_function"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetActivationFunction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetActivationFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetActivationFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActivationFunction/SetActivationFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_symmetric_ae"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetFullSymmetricAE(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetFullSymmetricAE(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetFullSymmetricAE(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFullSymmetricAE/SetFullSymmetricAE\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("activate_output_init"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetActivateOutputInit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetActivateOutputInit(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetActivateOutputInit(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActivateOutputInit/SetActivateOutputInit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("join_split_mixture_coefficient"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetJoinSplitMixtureCoefficient(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetJoinSplitMixtureCoefficient(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetJoinSplitMixtureCoefficient(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetJoinSplitMixtureCoefficient/SetJoinSplitMixtureCoefficient\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon1_use_farthest_saddle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetEpsilon1UseFarthestSaddle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetEpsilon1UseFarthestSaddle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetEpsilon1UseFarthestSaddle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon1UseFarthestSaddle/SetEpsilon1UseFarthestSaddle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetEpsilonTree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetEpsilonTree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetEpsilonTree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilonTree1/SetEpsilonTree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon2_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetEpsilon2Tree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetEpsilon2Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetEpsilon2Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon2Tree1/SetEpsilon2Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon3_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetEpsilon3Tree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetEpsilon3Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetEpsilon3Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon3Tree1/SetEpsilon3Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("persistence_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetPersistenceThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetPersistenceThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetPersistenceThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPersistenceThreshold/SetPersistenceThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delete_multi_pers_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetDeleteMultiPersPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetDeleteMultiPersPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetDeleteMultiPersPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDeleteMultiPersPairs/SetDeleteMultiPersPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("node_per_task"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetNodePerTask(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetNodePerTask(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetNodePerTask(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNodePerTask/SetNodePerTask\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("create_output"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetCreateOutput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetCreateOutput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetCreateOutput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCreateOutput/SetCreateOutput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_array_to_process"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetInputArrayToProcess(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetInputArrayToProcess(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputArrayToProcess\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("iteration_gap"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetIterationGap(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIterationGap\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_encoder_layers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetNumberOfEncoderLayers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetNumberOfEncoderLayers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetNumberOfEncoderLayers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfEncoderLayers/SetNumberOfEncoderLayers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_axes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetNumberOfAxes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetNumberOfAxes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetNumberOfAxes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfAxes/SetNumberOfAxes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_projection_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeAutoencoder_GetNumberOfProjectionSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeAutoencoder_SetNumberOfProjectionSteps(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeAutoencoder_SetNumberOfProjectionSteps(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfProjectionSteps/SetNumberOfProjectionSteps\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMergeTreeAutoencoder_Doc =
  "ttkMergeTreeAutoencoder - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Mathieu Pont <mathieu.pont@lip6.fr>\\date 2023.\n\n"
  "TTK VTK-filter that wraps the ttk::MergeTreeAutoencoder module.\n\n"
  "This VTK filter uses the ttk::MergeTreeAutoencoder module to compute\n"
  "an auto-encoder of merge trees or persistence diagrams.\n\n"
  "\\param Input vtkMultiBlockDataSet Input trees\n"
  "\\param Input (optional) vtkMultiBlockDataSet Input trees. If input\n"
  "    are merge\n"
  "trees, then this input can be used to process join and split trees\n"
  "together. Pass as input either join or split trees in the first input\n"
  "and the other type of trees in the second input. If input are\n"
  "persistence diagrams, then this has no effect to use this input.\n"
  "\\param Input (optional) vtkTable Info (such as clustering assigment)\n"
  "\\param Output vtkMultiBlockDataSet Origins\n"
  "\\param Output vtkMultiBlockDataSet Bases Axes\n"
  "\\param Output vtkMultiBlockDataSet Coefficients\n"
  "\\param Output vtkMultiBlockDataSet Processed Input Trees\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(),\n"
  "GetOutputDataObject()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication:\n\n"
  "\"Wasserstein Auto-Encoders of Merge Trees (and Persistence Diagrams)\"\n\n"
  "Mathieu Pont,  Julien Tierny.\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2023\n\n"
  "\\sa ttk::MergeTreeAutoencoder\n"
  "\\sa ttkAlgorithm\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeWAE/\">Me\n"
  "  rge tree Wasserstein Auto-Encoder example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramWAE/\"\n"
  "  >Persistence Diagram Wasserstein Auto-Encoder example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTreeAutoencoder_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTreeAutoencoder.ttkMergeTreeAutoencoder", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMergeTreeAutoencoder_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMergeTreeAutoencoder_StaticNew()
{
  return ttkMergeTreeAutoencoder::New();
}

PyObject *PyttkMergeTreeAutoencoder_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMergeTreeAutoencoder_Type, PyttkMergeTreeAutoencoder_Methods,
    "ttkMergeTreeAutoencoder",
 &PyttkMergeTreeAutoencoder_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMergeTreeAutoencoder_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMergeTreeAutoencoder(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMergeTreeAutoencoder_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMergeTreeAutoencoder", o) != 0)
  {
    Py_DECREF(o);
  }

}

