const char sysprof_parse_lua[] =
"-- Parser of LuaJIT's sysprof binary stream.\n"
"-- The format spec can be found in <src/lj_sysprof.h>.\n"
"\n"
"local symtab = require \"utils.symtab\"\n"
"local vmdef = require \"jit.vmdef\"\n"
"\n"
"local string_format = string.format\n"
"\n"
"local LJP_MAGIC = \"ljp\"\n"
"local LJP_CURRENT_VERSION = 2\n"
"\n"
"local M = {}\n"
"\n"
"local VMST = {\n"
"  INTERP = 0,\n"
"  LFUNC  = 1,\n"
"  FFUNC  = 2,\n"
"  CFUNC  = 3,\n"
"  GC     = 4,\n"
"  EXIT   = 5,\n"
"  RECORD = 6,\n"
"  OPT    = 7,\n"
"  ASM    = 8,\n"
"  TRACE  = 9,\n"
"  SYMTAB = 10,\n"
"}\n"
"\n"
"\n"
"local FRAME = {\n"
"  LFUNC  = 1,\n"
"  CFUNC  = 2,\n"
"  FFUNC  = 3,\n"
"  BOTTOM = 0x80\n"
"}\n"
"\n"
"\n"
"local STREAM_END = 0x80\n"
"local SYMTAB_LFUNC_EVENT = 10\n"
"local SYMTAB_CFUNC_EVENT = 11\n"
"local SYMTAB_TRACE_EVENT = 12\n"
"\n"
"local function new_event()\n"
"  return {\n"
"    lua = {\n"
"      vmstate = 0,\n"
"      callchain = {},\n"
"      trace = {\n"
"        traceno = nil,\n"
"        addr = 0,\n"
"        line = 0,\n"
"      }\n"
"    },\n"
"    host = {\n"
"      callchain = {}\n"
"    }\n"
"  }\n"
"end\n"
"\n"
"local function parse_lfunc(reader, symbols)\n"
"  local addr = reader:read_uleb128()\n"
"  local line = reader:read_uleb128()\n"
"  local loc = symtab.loc({ addr = addr, line = line })\n"
"  loc.type = FRAME.LFUNC\n"
"  return symtab.demangle(symbols, loc)\n"
"end\n"
"\n"
"local function parse_ffunc(reader, _)\n"
"  local ffid = reader:read_uleb128()\n"
"  return vmdef.ffnames[ffid]\n"
"end\n"
"\n"
"local function parse_cfunc(reader, symbols)\n"
"  local addr = reader:read_uleb128()\n"
"  local loc = symtab.loc({ addr = addr })\n"
"  loc.type = FRAME.CFUNC\n"
"  return symtab.demangle(symbols, loc)\n"
"end\n"
"\n"
"local frame_parsers = {\n"
"  [FRAME.LFUNC] = parse_lfunc,\n"
"  [FRAME.FFUNC] = parse_ffunc,\n"
"  [FRAME.CFUNC] = parse_cfunc\n"
"}\n"
"\n"
"local function parse_lua_callchain(reader, event, symbols)\n"
"  while true do\n"
"    local frame_header = reader:read_octet()\n"
"    if frame_header == FRAME.BOTTOM then\n"
"      break\n"
"    end\n"
"    local name = frame_parsers[frame_header](reader, symbols)\n"
"    table.insert(event.lua.callchain, 1, {name = name, type = frame_header})\n"
"  end\n"
"end\n"
"\n"
"--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--\n"
"\n"
"local function parse_host_callchain(reader, event, symbols)\n"
"  local addr = reader:read_uleb128()\n"
"\n"
"  while addr ~= 0 do\n"
"    local loc = symtab.loc({ addr = addr })\n"
"    table.insert(event.host.callchain, 1, symtab.demangle(symbols, loc))\n"
"    addr = reader:read_uleb128()\n"
"  end\n"
"end\n"
"\n"
"--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--\n"
"\n"
"local function parse_trace_callchain(reader, event, symbols)\n"
"  local loc = {}\n"
"  loc.traceno = reader:read_uleb128()\n"
"  loc.addr = reader:read_uleb128()\n"
"  loc.line = reader:read_uleb128()\n"
"\n"
"  local name_lua = symtab.demangle(symbols, {\n"
"    addr = loc.addr,\n"
"    traceno = loc.traceno,\n"
"  })\n"
"  event.lua.trace = loc\n"
"  event.lua.trace.name = name_lua\n"
"end\n"
"\n"
"--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--\n"
"\n"
"local function parse_host_only(reader, event, symbols)\n"
"  parse_host_callchain(reader, event, symbols)\n"
"end\n"
"\n"
"local function parse_lua_host(reader, event, symbols)\n"
"  parse_lua_callchain(reader, event, symbols)\n"
"  parse_host_callchain(reader, event, symbols)\n"
"end\n"
"\n"
"local function parse_trace(reader, event, symbols)\n"
"  parse_trace_callchain(reader, event, symbols)\n"
"  -- parse_lua_callchain(reader, event)\n"
"end\n"
"\n"
"local function parse_symtab(reader, symbols, vmstate)\n"
"  if vmstate == SYMTAB_LFUNC_EVENT then\n"
"    symtab.parse_sym_lfunc(reader, symbols)\n"
"  elseif vmstate == SYMTAB_CFUNC_EVENT then\n"
"    symtab.parse_sym_cfunc(reader, symbols)\n"
"  elseif vmstate == SYMTAB_TRACE_EVENT then\n"
"    symtab.parse_sym_trace(reader, symbols)\n"
"  else\n"
"    error(\"Unknown symtab event\")\n"
"  end\n"
"end\n"
"\n"
"local event_parsers = {\n"
"  [VMST.INTERP] = parse_host_only,\n"
"  [VMST.LFUNC]  = parse_lua_host,\n"
"  [VMST.FFUNC]  = parse_lua_host,\n"
"  [VMST.CFUNC]  = parse_lua_host,\n"
"  [VMST.GC]     = parse_host_only,\n"
"  [VMST.EXIT]   = parse_host_only,\n"
"  [VMST.RECORD] = parse_host_only,\n"
"  [VMST.OPT]    = parse_host_only,\n"
"  [VMST.ASM]    = parse_host_only,\n"
"  [VMST.TRACE]  = parse_trace,\n"
"}\n"
"\n"
"local function insert_lua_callchain(chain, lua)\n"
"  local ins_cnt = 0\n"
"  local name_lua\n"
"  for _, fr in ipairs(lua.callchain) do\n"
"    ins_cnt = ins_cnt + 1\n"
"    if fr.type == FRAME.CFUNC then\n"
"      -- C function encountered, the next chunk\n"
"      -- of frames is located on the C stack.\n"
"      break\n"
"    end\n"
"    name_lua = fr.name\n"
"\n"
"    if fr.type == FRAME.LFUNC\n"
"      and lua.trace.traceno ~= nil\n"
"      and lua.trace.addr == fr.addr\n"
"      and lua.trace.line == fr.line\n"
"    then\n"
"      name_lua = lua.trace.name\n"
"    end\n"
"\n"
"    table.insert(chain, name_lua)\n"
"  end\n"
"  table.remove(lua.callchain, ins_cnt)\n"
"end\n"
"\n"
"local function merge(event)\n"
"  local callchain = {}\n"
"\n"
"  for _, name_host in ipairs(event.host.callchain) do\n"
"    table.insert(callchain, name_host)\n"
"    if string.match(name_host, '^lua_cpcall') ~= nil then\n"
"      -- Any C function is present on both the C and the Lua\n"
"      -- stacks. It is more convenient to get its info from the\n"
"      -- host stack, since it has information about child frames.\n"
"      table.remove(event.lua.callchain)\n"
"    end\n"
"\n"
"    if string.match(name_host, '^lua_p\?call') ~= nil then\n"
"      insert_lua_callchain(callchain, event.lua)\n"
"    end\n"
"\n"
"  end\n"
"  return table.concat(callchain, ';') .. ';'\n"
"end\n"
"\n"
"local function parse_event(reader, events, symbols)\n"
"  local event = new_event()\n"
"\n"
"  local vmstate = reader:read_octet()\n"
"  if vmstate == STREAM_END then\n"
"    -- TODO: samples & overruns\n"
"    return false\n"
"  elseif SYMTAB_LFUNC_EVENT <= vmstate and vmstate <= SYMTAB_TRACE_EVENT then\n"
"    parse_symtab(reader, symbols, vmstate)\n"
"    return true\n"
"  end\n"
"\n"
"  assert(0 <= vmstate and vmstate <= 9, \"Vmstate \"..vmstate..\" is not valid\")\n"
"  event.lua.vmstate = vmstate\n"
"\n"
"  event_parsers[vmstate](reader, event, symbols)\n"
"  local callchain = merge(event)\n"
"  events[callchain] = (events[callchain] or 0) + 1\n"
"  return true\n"
"end\n"
"\n"
"function M.parse(reader, symbols)\n"
"  local events = {}\n"
"\n"
"  local magic = reader:read_octets(3)\n"
"  local version = reader:read_octets(1)\n"
"  -- Dummy-consume reserved bytes.\n"
"  local _ = reader:read_octets(3)\n"
"\n"
"  if magic ~= LJP_MAGIC then\n"
"    error(\"Bad sysprof event format prologue: \" .. tostring(magic))\n"
"  end\n"
"\n"
"  if string.byte(version) ~= LJP_CURRENT_VERSION then\n"
"    error(string_format(\n"
"      \"Sysprof event format version mismatch:\"..\n"
"      \" the tool expects %d, but your data is %d\",\n"
"      LJP_CURRENT_VERSION,\n"
"      string.byte(version)\n"
"    ))\n"
"  end\n"
"\n"
"  while parse_event(reader, events, symbols) do\n"
"    -- Empty body.\n"
"  end\n"
"\n"
"  return events\n"
"end\n"
"\n"
"return M\n"
""
;
