const char clock_lua[] =
"-- clock.lua -- internal file\n"
"local clock = {}\n"
"local ffi = require('ffi')\n"
"\n"
"ffi.cdef[[\n"
"    double clock_realtime(void);\n"
"    double clock_monotonic(void);\n"
"    double clock_process(void);\n"
"    double clock_thread(void);\n"
"    int64_t clock_realtime64(void);\n"
"    int64_t clock_monotonic64(void);\n"
"    int64_t clock_process64(void);\n"
"    int64_t clock_thread64(void);\n"
"]]\n"
"\n"
"local C = ffi.C\n"
"\n"
"clock.realtime = C.clock_realtime\n"
"clock.monotonic = C.clock_monotonic\n"
"clock.proc = C.clock_process\n"
"clock.thread = C.clock_thread\n"
"\n"
"clock.realtime64 = C.clock_realtime64\n"
"clock.monotonic64 = C.clock_monotonic64\n"
"clock.proc64 = C.clock_process64\n"
"clock.thread64 = C.clock_thread64\n"
"\n"
"clock.time = clock.realtime\n"
"clock.time64 = clock.realtime64\n"
"\n"
"clock.bench = function(fun, ...)\n"
"    local overhead = clock.proc()\n"
"    overhead = clock.proc() - overhead\n"
"    local start_time = clock.proc()\n"
"    local res = {0, fun(...)}\n"
"    res[1] = clock.proc() - start_time - overhead\n"
"    return res\n"
"end\n"
"\n"
"return clock\n"
""
;
