/* animatedList.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from animatedList.vala, do not modify */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>
#include <stdlib.h>

#define ANIMATED_LIST_SCROLL_ANIMATION_DURATION 500
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM,
	ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP
} AnimatedListDirection;

#define TYPE_ANIMATED_LIST_DIRECTION (animated_list_direction_get_type ())

#define TYPE_ANIMATION_DATA (animation_data_get_type ())
typedef struct _AnimationData AnimationData;

#define TYPE_ANIMATED_LIST_ITEM (animated_list_item_get_type ())
#define ANIMATED_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATED_LIST_ITEM, AnimatedListItem))
#define ANIMATED_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATED_LIST_ITEM, AnimatedListItemClass))
#define IS_ANIMATED_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATED_LIST_ITEM))
#define IS_ANIMATED_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATED_LIST_ITEM))
#define ANIMATED_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATED_LIST_ITEM, AnimatedListItemClass))

typedef struct _AnimatedListItem AnimatedListItem;
typedef struct _AnimatedListItemClass AnimatedListItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_WIDGET_HEIGHTS (widget_heights_get_type ())
typedef struct _WidgetHeights WidgetHeights;

#define TYPE_WIDGET_ALLOC (widget_alloc_get_type ())
typedef struct _WidgetAlloc WidgetAlloc;

#define TYPE_ANIMATED_LIST (animated_list_get_type ())
#define ANIMATED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATED_LIST, AnimatedList))
#define ANIMATED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATED_LIST, AnimatedListClass))
#define IS_ANIMATED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATED_LIST))
#define IS_ANIMATED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATED_LIST))
#define ANIMATED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATED_LIST, AnimatedListClass))

typedef struct _AnimatedList AnimatedList;
typedef struct _AnimatedListClass AnimatedListClass;
typedef struct _AnimatedListPrivate AnimatedListPrivate;
typedef enum  {
	ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_NONE,
	ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE,
	ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE_WITH
} AnimatedListItemRevealAnimationType;

#define ANIMATED_LIST_ITEM_TYPE_REVEAL_ANIMATION_TYPE (animated_list_item_reveal_animation_type_get_type ())
typedef enum  {
	ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_NONE,
	ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_LEFT,
	ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_RIGHT
} AnimatedListItemChildAnimationType;

#define ANIMATED_LIST_ITEM_TYPE_CHILD_ANIMATION_TYPE (animated_list_item_child_animation_type_get_type ())
enum  {
	ANIMATED_LIST_0_PROPERTY,
	ANIMATED_LIST_HADJUSTMENT_PROPERTY,
	ANIMATED_LIST_HSCROLL_POLICY_PROPERTY,
	ANIMATED_LIST_VADJUSTMENT_PROPERTY,
	ANIMATED_LIST_VSCROLL_POLICY_PROPERTY,
	ANIMATED_LIST_N_CHILDREN_PROPERTY,
	ANIMATED_LIST_CHILDREN_PROPERTY,
	ANIMATED_LIST_VISIBLE_CHILDREN_PROPERTY,
	ANIMATED_LIST_TRANSITION_CHILDREN_PROPERTY,
	ANIMATED_LIST_USE_CARD_ANIMATION_PROPERTY,
	ANIMATED_LIST_DIRECTION_PROPERTY,
	ANIMATED_LIST_SCROLL_TO_APPEND_PROPERTY,
	ANIMATED_LIST_ANIMATION_REVEAL_TYPE_PROPERTY,
	ANIMATED_LIST_ANIMATION_CHILD_TYPE_PROPERTY,
	ANIMATED_LIST_NUM_PROPERTIES
};
static GParamSpec* animated_list_properties[ANIMATED_LIST_NUM_PROPERTIES];
#define _animation_data_free0(var) ((var == NULL) ? NULL : (var = (animation_data_free (var), NULL)))
#define _gsk_transform_unref0(var) ((var == NULL) ? NULL : (var = (gsk_transform_unref (var), NULL)))
typedef struct _AnimatedListPrependData AnimatedListPrependData;
typedef struct _AnimatedListAppendData AnimatedListAppendData;
typedef struct _AnimatedListRemoveData AnimatedListRemoveData;

struct _AnimationData {
	GtkAdjustment* vadj;
	AnimatedListItem* item;
};

struct _WidgetHeights {
	gint min_height;
	gint nat_height;
};

struct _WidgetAlloc {
	gfloat y;
	gint height;
};

struct _AnimatedList {
	GtkWidget parent_instance;
	AnimatedListPrivate * priv;
};

struct _AnimatedListClass {
	GtkWidgetClass parent_class;
};

struct _AnimatedListPrivate {
	GtkAdjustment* _hadjustment;
	GtkScrollablePolicy _hscroll_policy;
	GtkAdjustment* _vadjustment;
	GtkScrollablePolicy _vscroll_policy;
	guint _n_children;
	GList* _children;
	GList* _visible_children;
	gboolean _transition_children;
	gboolean _use_card_animation;
	AnimatedListDirection _direction;
	gboolean _scroll_to_append;
	AnimatedListItemRevealAnimationType _animation_reveal_type;
	AnimatedListItemChildAnimationType _animation_child_type;
	AdwCallbackAnimationTarget* scroll_btm_target;
	AdwTimedAnimation* scroll_btm_anim;
	AnimationData* scroll_btm_anim_data;
	AdwCallbackAnimationTarget* scroll_top_target;
	AdwTimedAnimation* scroll_top_anim;
	AnimationData* scroll_top_anim_data;
	AdwCallbackAnimationTarget* scroll_comp_target;
	AdwTimedAnimation* scroll_comp_anim;
	AnimationData* scroll_comp_anim_data;
	gboolean set_initial_scroll_value;
	gfloat fade_distance;
	GtkSettings* settings;
	guint scroll_to_source_id;
};

struct _AnimatedListPrependData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AnimatedList* self;
	GtkWidget* widget;
	AnimatedListItem* result;
	gboolean _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	AnimatedListItem* item;
	AnimatedListItem* _tmp3_;
	AnimatedListItem* _tmp4_;
	AnimatedListItem* _tmp5_;
	GList* _tmp6_;
	AnimatedListItem* _tmp7_;
	AnimatedListItem* _tmp8_;
	guint _tmp9_;
	gboolean _tmp10_;
	AnimatedListDirection _tmp11_;
	GtkAdjustment* _tmp12_;
	GtkAdjustment* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	GtkAdjustment* _tmp16_;
	GtkAdjustment* _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	GtkAdjustment* _tmp20_;
	GtkAdjustment* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	AnimatedListItem* _tmp24_;
	AnimatedListDirection _tmp25_;
	AnimatedListItem* _tmp26_;
	AnimatedListItem* _tmp27_;
	gboolean _tmp28_;
};

struct _AnimatedListAppendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AnimatedList* self;
	GtkWidget* widget;
	AnimatedListItem* result;
	gboolean _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	AnimatedListItem* item;
	AnimatedListItem* _tmp3_;
	AnimatedListItem* _tmp4_;
	AnimatedListItem* _tmp5_;
	GList* _tmp6_;
	AnimatedListItem* _tmp7_;
	AnimatedListItem* _tmp8_;
	guint _tmp9_;
	gboolean _tmp10_;
	AnimatedListDirection _tmp11_;
	GtkAdjustment* _tmp12_;
	GtkAdjustment* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	GtkAdjustment* _tmp16_;
	GtkAdjustment* _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	GtkAdjustment* _tmp20_;
	GtkAdjustment* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	AnimatedListItem* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	AnimatedListDirection _tmp27_;
	AnimatedListItem* _tmp28_;
	gboolean _tmp29_;
	AnimatedListDirection _tmp30_;
	AnimatedListItem* _tmp31_;
	AnimatedListItem* _tmp32_;
	AnimatedListItem* _tmp33_;
	gboolean _tmp34_;
};

struct _AnimatedListRemoveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AnimatedList* self;
	GtkWidget* widget;
	gboolean transition;
	gboolean result;
	AnimatedListItem* item;
	AnimatedListItem* _tmp0_;
	AnimatedListItem* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _result_;
	AnimatedListItem* _tmp4_;
	AnimatedListItem* _tmp5_;
	GList* _tmp6_;
	AnimatedListItem* _tmp7_;
	guint _tmp8_;
};

static gint AnimatedList_private_offset;
static gpointer animated_list_parent_class = NULL;
static GtkScrollableInterface * animated_list_gtk_scrollable_parent_iface = NULL;

VALA_EXTERN GType animated_list_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType animation_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType animated_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatedListItem, g_object_unref)
VALA_EXTERN AnimationData* animation_data_dup (const AnimationData* self);
VALA_EXTERN void animation_data_free (AnimationData* self);
VALA_EXTERN void animation_data_copy (const AnimationData* self,
                          AnimationData* dest);
VALA_EXTERN void animation_data_destroy (AnimationData* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (AnimationData, animation_data_destroy)
VALA_EXTERN GType widget_heights_get_type (void) G_GNUC_CONST ;
VALA_EXTERN WidgetHeights* widget_heights_dup (const WidgetHeights* self);
VALA_EXTERN void widget_heights_free (WidgetHeights* self);
VALA_EXTERN GType widget_alloc_get_type (void) G_GNUC_CONST ;
VALA_EXTERN WidgetAlloc* widget_alloc_dup (const WidgetAlloc* self);
VALA_EXTERN void widget_alloc_free (WidgetAlloc* self);
VALA_EXTERN GType animated_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatedList, g_object_unref)
VALA_EXTERN GType animated_list_item_reveal_animation_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType animated_list_item_child_animation_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AnimatedList* animated_list_new (void);
VALA_EXTERN AnimatedList* animated_list_construct (GType object_type);
static void animated_list_real_dispose (GObject* base);
VALA_EXTERN GList* animated_list_get_children (AnimatedList* self);
VALA_EXTERN void animated_list_set_transition_children (AnimatedList* self,
                                            gboolean value);
VALA_EXTERN void animated_list_remove (AnimatedList* self,
                           GtkWidget* widget,
                           gboolean transition,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
VALA_EXTERN gboolean animated_list_remove_finish (AnimatedList* self,
                                      GAsyncResult* _res_);
static gboolean animated_list_real_get_border (GtkScrollable* base,
                                        GtkBorder* border);
static GtkSizeRequestMode animated_list_real_get_request_mode (GtkWidget* base);
static void animated_list_real_compute_expand_internal (GtkWidget* base,
                                                 gboolean* hexpand_p,
                                                 gboolean* vexpand_p);
static gfloat animated_list_get_fade_distance (AnimatedList* self,
                                        gint height);
VALA_EXTERN AnimatedListDirection animated_list_get_direction (AnimatedList* self);
static void animated_list_compute_height (AnimatedList* self,
                                   gint width,
                                   gint height,
                                   gint* total_height,
                                   WidgetAlloc** child_heights,
                                   gint* child_heights_length1);
VALA_EXTERN guint animated_list_get_n_children (AnimatedList* self);
static gboolean animated_list_should_card_animate (AnimatedList* self);
static void animated_list_real_size_allocate (GtkWidget* base,
                                       gint width,
                                       gint height,
                                       gint baseline);
VALA_EXTERN GList* animated_list_get_visible_children (AnimatedList* self);
static void animated_list_set_visible_children (AnimatedList* self,
                                         GList* value);
static void animated_list_real_measure (GtkWidget* base,
                                 GtkOrientation orientation,
                                 gint for_size,
                                 gint* minimum,
                                 gint* natural,
                                 gint* minimum_baseline,
                                 gint* natural_baseline);
static void animated_list_real_snapshot (GtkWidget* base,
                                  GtkSnapshot* snapshot);
static GtkAdjustment* animated_list_clone_adjustment (AnimatedList* self,
                                               GtkAdjustment* original);
static void animated_list_scroll_bottom_value_cb (AnimatedList* self,
                                           gdouble value);
static void animated_list_play_scroll_bottom_anim (AnimatedList* self,
                                            AnimatedListItem* item);
VALA_EXTERN gint animated_list_item_get_animation_duration (AnimatedListItem* self);
VALA_EXTERN AdwEasing animated_list_item_get_animation_easing (AnimatedListItem* self);
static void animated_list_scroll_top_value_cb (AnimatedList* self,
                                        gdouble value);
static void animated_list_play_scroll_top_anim (AnimatedList* self,
                                         AnimatedListItem* item);
static void animated_list_scroll_comp_value_cb (AnimatedList* self,
                                         gdouble value);
static void animated_list_play_scroll_comp_anim (AnimatedList* self,
                                          AnimatedListItem* item);
static AnimatedListItem* animated_list_get_list_item (AnimatedList* self,
                                               GtkWidget* widget);
VALA_EXTERN AnimatedListItem* animated_list_item_new (void);
VALA_EXTERN AnimatedListItem* animated_list_item_construct (GType object_type);
VALA_EXTERN void animated_list_item_set_child (AnimatedListItem* self,
                                   GtkWidget* value);
VALA_EXTERN AnimatedListItemRevealAnimationType animated_list_get_animation_reveal_type (AnimatedList* self);
VALA_EXTERN void animated_list_item_set_animation_reveal_type (AnimatedListItem* self,
                                                   AnimatedListItemRevealAnimationType value);
VALA_EXTERN AnimatedListItemChildAnimationType animated_list_get_animation_child_type (AnimatedList* self);
VALA_EXTERN void animated_list_item_set_animation_child_type (AnimatedListItem* self,
                                                  AnimatedListItemChildAnimationType value);
static void animated_list_prepend_data_free (gpointer _data);
VALA_EXTERN void animated_list_prepend (AnimatedList* self,
                            GtkWidget* widget,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
VALA_EXTERN AnimatedListItem* animated_list_prepend_finish (AnimatedList* self,
                                                GAsyncResult* _res_);
static gboolean animated_list_prepend_co (AnimatedListPrependData* _data_);
static void animated_list_set_children (AnimatedList* self,
                                 GList* value);
static void animated_list_set_n_children (AnimatedList* self,
                                   guint value);
VALA_EXTERN void animated_list_item_added (AnimatedListItem* self,
                               gboolean transition,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void animated_list_item_added_finish (AnimatedListItem* self,
                                      GAsyncResult* _res_);
VALA_EXTERN gboolean animated_list_get_transition_children (AnimatedList* self);
static void animated_list_prepend_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_);
static void animated_list_append_data_free (gpointer _data);
VALA_EXTERN void animated_list_append (AnimatedList* self,
                           GtkWidget* widget,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
VALA_EXTERN AnimatedListItem* animated_list_append_finish (AnimatedList* self,
                                               GAsyncResult* _res_);
static gboolean animated_list_append_co (AnimatedListAppendData* _data_);
VALA_EXTERN gboolean animated_list_get_scroll_to_append (AnimatedList* self);
static void animated_list_append_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
static AnimatedListItem* animated_list_try_get_ancestor (AnimatedList* self,
                                                  GtkWidget* widget);
static void animated_list_remove_data_free (gpointer _data);
static gboolean animated_list_remove_co (AnimatedListRemoveData* _data_);
VALA_EXTERN void animated_list_item_removed (AnimatedListItem* self,
                                 gboolean transition,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN gboolean animated_list_item_removed_finish (AnimatedListItem* self,
                                            GAsyncResult* _res_);
static void animated_list_remove_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN gboolean animated_list_move_to_beginning (AnimatedList* self,
                                          GtkWidget* widget,
                                          gboolean scroll_to);
VALA_EXTERN void animated_list_scroll_to_top (AnimatedList* self);
static void __lambda10_ (AnimatedList* self);
VALA_EXTERN AnimatedListItem* animated_list_get_first_item (AnimatedList* self);
static void ___lambda10__gsource_once_func (gpointer self);
VALA_EXTERN gboolean animated_list_is_empty (AnimatedList* self);
VALA_EXTERN AnimatedListItem* animated_list_get_last_item (AnimatedList* self);
VALA_EXTERN gboolean animated_list_get_use_card_animation (AnimatedList* self);
VALA_EXTERN void animated_list_set_use_card_animation (AnimatedList* self,
                                           gboolean value);
VALA_EXTERN void animated_list_set_direction (AnimatedList* self,
                                  AnimatedListDirection value);
VALA_EXTERN void animated_list_set_scroll_to_append (AnimatedList* self,
                                         gboolean value);
VALA_EXTERN void animated_list_set_animation_reveal_type (AnimatedList* self,
                                              AnimatedListItemRevealAnimationType value);
VALA_EXTERN void animated_list_set_animation_child_type (AnimatedList* self,
                                             AnimatedListItemChildAnimationType value);
static GObject * animated_list_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _animated_list___lambda11_ (AnimatedList* self);
static void ___lambda12_ (AnimatedList* self);
static void ____lambda12__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                 gpointer self);
static void __animated_list___lambda11__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void _animated_list___lambda13_ (AnimatedList* self);
static void __lambda14_ (AnimatedList* self);
static void ___lambda14__gsource_once_func (gpointer self);
static void __animated_list___lambda13__gtk_widget_map (GtkWidget* _sender,
                                                 gpointer self);
static void _animated_list_scroll_bottom_value_cb_adw_animation_target_func (gdouble value,
                                                                      gpointer self);
static void _animated_list_scroll_top_value_cb_adw_animation_target_func (gdouble value,
                                                                   gpointer self);
static void _animated_list_scroll_comp_value_cb_adw_animation_target_func (gdouble value,
                                                                    gpointer self);
static void animated_list_finalize (GObject * obj);
static GType animated_list_get_type_once (void);
static void _vala_animated_list_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_animated_list_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

 G_GNUC_NO_INLINE static GType
animated_list_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM, "ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM", "top-to-bottom"}, {ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP, "ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP", "bottom-to-top"}, {0, NULL, NULL}};
	GType animated_list_direction_type_id;
	animated_list_direction_type_id = g_enum_register_static ("AnimatedListDirection", values);
	return animated_list_direction_type_id;
}

GType
animated_list_direction_get_type (void)
{
	static gsize animated_list_direction_type_id__once = 0;
	if (g_once_init_enter (&animated_list_direction_type_id__once)) {
		GType animated_list_direction_type_id;
		animated_list_direction_type_id = animated_list_direction_get_type_once ();
		g_once_init_leave (&animated_list_direction_type_id__once, animated_list_direction_type_id);
	}
	return animated_list_direction_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
animation_data_copy (const AnimationData* self,
                     AnimationData* dest)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	AnimatedListItem* _tmp2_;
	_tmp0_ = (*self).vadj;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).vadj);
	(*dest).vadj = _tmp1_;
	_tmp2_ = (*self).item;
	(*dest).item = _tmp2_;
}

void
animation_data_destroy (AnimationData* self)
{
	_g_object_unref0 ((*self).vadj);
}

AnimationData*
animation_data_dup (const AnimationData* self)
{
	AnimationData* dup;
	dup = g_new0 (AnimationData, 1);
	animation_data_copy (self, dup);
	return dup;
}

void
animation_data_free (AnimationData* self)
{
	animation_data_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
animation_data_get_type_once (void)
{
	GType animation_data_type_id;
	animation_data_type_id = g_boxed_type_register_static ("AnimationData", (GBoxedCopyFunc) animation_data_dup, (GBoxedFreeFunc) animation_data_free);
	return animation_data_type_id;
}

GType
animation_data_get_type (void)
{
	static gsize animation_data_type_id__once = 0;
	if (g_once_init_enter (&animation_data_type_id__once)) {
		GType animation_data_type_id;
		animation_data_type_id = animation_data_get_type_once ();
		g_once_init_leave (&animation_data_type_id__once, animation_data_type_id);
	}
	return animation_data_type_id__once;
}

WidgetHeights*
widget_heights_dup (const WidgetHeights* self)
{
	WidgetHeights* dup;
	dup = g_new0 (WidgetHeights, 1);
	memcpy (dup, self, sizeof (WidgetHeights));
	return dup;
}

void
widget_heights_free (WidgetHeights* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
widget_heights_get_type_once (void)
{
	GType widget_heights_type_id;
	widget_heights_type_id = g_boxed_type_register_static ("WidgetHeights", (GBoxedCopyFunc) widget_heights_dup, (GBoxedFreeFunc) widget_heights_free);
	return widget_heights_type_id;
}

GType
widget_heights_get_type (void)
{
	static gsize widget_heights_type_id__once = 0;
	if (g_once_init_enter (&widget_heights_type_id__once)) {
		GType widget_heights_type_id;
		widget_heights_type_id = widget_heights_get_type_once ();
		g_once_init_leave (&widget_heights_type_id__once, widget_heights_type_id);
	}
	return widget_heights_type_id__once;
}

WidgetAlloc*
widget_alloc_dup (const WidgetAlloc* self)
{
	WidgetAlloc* dup;
	dup = g_new0 (WidgetAlloc, 1);
	memcpy (dup, self, sizeof (WidgetAlloc));
	return dup;
}

void
widget_alloc_free (WidgetAlloc* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
widget_alloc_get_type_once (void)
{
	GType widget_alloc_type_id;
	widget_alloc_type_id = g_boxed_type_register_static ("WidgetAlloc", (GBoxedCopyFunc) widget_alloc_dup, (GBoxedFreeFunc) widget_alloc_free);
	return widget_alloc_type_id;
}

GType
widget_alloc_get_type (void)
{
	static gsize widget_alloc_type_id__once = 0;
	if (g_once_init_enter (&widget_alloc_type_id__once)) {
		GType widget_alloc_type_id;
		widget_alloc_type_id = widget_alloc_get_type_once ();
		g_once_init_leave (&widget_alloc_type_id__once, widget_alloc_type_id);
	}
	return widget_alloc_type_id__once;
}

static inline gpointer
animated_list_get_instance_private (AnimatedList* self)
{
	return G_STRUCT_MEMBER_P (self, AnimatedList_private_offset);
}

AnimatedList*
animated_list_construct (GType object_type)
{
	AnimatedList * self = NULL;
	self = (AnimatedList*) g_object_new (object_type, "css-name", "animatedlist", "accessible-role", GTK_ACCESSIBLE_ROLE_LIST, "transition-children", TRUE, "use-card-animation", TRUE, "direction", ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM, "scroll-to-append", FALSE, NULL);
	return self;
}

AnimatedList*
animated_list_new (void)
{
	return animated_list_construct (TYPE_ANIMATED_LIST);
}

static void
animated_list_real_dispose (GObject* base)
{
	AnimatedList * self;
	GList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	_tmp0_ = self->priv->_children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			AnimatedListItem* _tmp1_;
			AnimatedListItem* child = NULL;
			_tmp1_ = _g_object_ref0 ((AnimatedListItem*) child_it->data);
			child = _tmp1_;
			{
				AnimatedListItem* _tmp2_;
				animated_list_set_transition_children (self, FALSE);
				_tmp2_ = child;
				animated_list_remove (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE, NULL, NULL);
				_g_object_unref0 (child);
			}
		}
	}
	G_OBJECT_CLASS (animated_list_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), G_TYPE_OBJECT, GObject));
}

static gboolean
animated_list_real_get_border (GtkScrollable* base,
                               GtkBorder* border)
{
	AnimatedList * self;
	GtkBorder _vala_border = {0};
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	memset (&_vala_border, 0, sizeof (GtkBorder));
	result = FALSE;
	if (border) {
		*border = _vala_border;
	}
	return result;
}

static GtkSizeRequestMode
animated_list_real_get_request_mode (GtkWidget* base)
{
	AnimatedList * self;
	GList* _tmp0_;
	GtkSizeRequestMode result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	_tmp0_ = self->priv->_children;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp0_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			AnimatedListItem* item = NULL;
			item = (AnimatedListItem*) item_it->data;
			{
				AnimatedListItem* _tmp1_;
				_tmp1_ = item;
				if (gtk_widget_get_request_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget)) != GTK_SIZE_REQUEST_CONSTANT_SIZE) {
					result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
					return result;
				}
			}
		}
	}
	result = GTK_SIZE_REQUEST_CONSTANT_SIZE;
	return result;
}

static void
animated_list_real_compute_expand_internal (GtkWidget* base,
                                            gboolean* hexpand_p,
                                            gboolean* vexpand_p)
{
	AnimatedList * self;
	gboolean _vala_hexpand_p = FALSE;
	gboolean _vala_vexpand_p = FALSE;
	GList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	_vala_hexpand_p = FALSE;
	_vala_vexpand_p = FALSE;
	_tmp0_ = self->priv->_children;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp0_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			AnimatedListItem* item = NULL;
			item = (AnimatedListItem*) item_it->data;
			{
				AnimatedListItem* _tmp1_;
				AnimatedListItem* _tmp2_;
				_tmp1_ = item;
				_vala_hexpand_p = _vala_hexpand_p | gtk_widget_compute_expand (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), GTK_ORIENTATION_HORIZONTAL);
				_tmp2_ = item;
				_vala_vexpand_p = _vala_vexpand_p | gtk_widget_compute_expand (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), GTK_ORIENTATION_VERTICAL);
			}
		}
	}
	if (hexpand_p) {
		*hexpand_p = _vala_hexpand_p;
	}
	if (vexpand_p) {
		*vexpand_p = _vala_vexpand_p;
	}
}

static gfloat
animated_list_get_fade_distance (AnimatedList* self,
                                 gint height)
{
	AnimatedListDirection _tmp0_;
	gfloat result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), 0.0F);
	_tmp0_ = self->priv->_direction;
	switch (_tmp0_) {
		case ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM:
		{
			result = height - self->priv->fade_distance;
			return result;
		}
		case ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP:
		{
			result = self->priv->fade_distance;
			return result;
		}
		default:
		break;
	}
	result = (gfloat) 0;
	return result;
}

static void
animated_list_compute_height (AnimatedList* self,
                              gint width,
                              gint height,
                              gint* total_height,
                              WidgetAlloc** child_heights,
                              gint* child_heights_length1)
{
	gint _vala_total_height = 0;
	WidgetAlloc* _vala_child_heights = NULL;
	gint _vala_child_heights_length1 = 0;
	guint _tmp0_;
	WidgetAlloc* _tmp1_;
	gint num_vexpand_children = 0;
	WidgetHeights measured_height = {0};
	WidgetHeights* heights = NULL;
	guint _tmp2_;
	WidgetHeights* _tmp3_;
	gint heights_length1;
	gint _heights_size_;
	gint total_min = 0;
	gint total_nat = 0;
	gint i = 0;
	GList* _tmp4_;
	gboolean allocate_nat = FALSE;
	gint extra_height = 0;
	WidgetHeights _tmp20_;
	gint y = 0;
	GList* _tmp22_;
	static const gfloat LIMIT = 0.2f;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	_vala_total_height = 0;
	_tmp0_ = self->priv->_n_children;
	_tmp1_ = g_new0 (WidgetAlloc, _tmp0_);
	_vala_child_heights = (g_free (_vala_child_heights), NULL);
	_vala_child_heights = _tmp1_;
	_vala_child_heights_length1 = _tmp0_;
	self->priv->fade_distance = (gfloat) 0;
	num_vexpand_children = 0;
	memset (&measured_height, 0, sizeof (WidgetHeights));
	_tmp2_ = self->priv->_n_children;
	_tmp3_ = g_new0 (WidgetHeights, _tmp2_);
	heights = _tmp3_;
	heights_length1 = _tmp2_;
	_heights_size_ = heights_length1;
	total_min = 0;
	total_nat = 0;
	i = 0;
	_tmp4_ = self->priv->_children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp4_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			AnimatedListItem* _tmp5_;
			AnimatedListItem* child = NULL;
			_tmp5_ = _g_object_ref0 ((AnimatedListItem*) child_it->data);
			child = _tmp5_;
			{
				AnimatedListItem* _tmp6_;
				gint nat_width = 0;
				AnimatedListItem* _tmp7_;
				gint _tmp8_ = 0;
				gint min_height = 0;
				gint nat_height = 0;
				AnimatedListItem* _tmp9_;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint min = 0;
				gint nat = 0;
				AnimatedListItem* _tmp12_;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				WidgetHeights* _tmp15_;
				gint _tmp15__length1;
				WidgetHeights _tmp16_ = {0};
				AnimatedListItem* _tmp17_;
				gint _tmp19_;
				_tmp6_ = child;
				if (!gtk_widget_should_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget))) {
					_g_object_unref0 (child);
					continue;
				}
				_tmp7_ = child;
				gtk_widget_measure (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), GTK_ORIENTATION_HORIZONTAL, -1, NULL, &_tmp8_, NULL, NULL);
				nat_width = _tmp8_;
				_tmp9_ = child;
				gtk_widget_measure (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), GTK_ORIENTATION_VERTICAL, nat_width, &_tmp10_, &_tmp11_, NULL, NULL);
				min_height = _tmp10_;
				nat_height = _tmp11_;
				self->priv->fade_distance = MAX (self->priv->fade_distance, (gfloat) MIN (min_height, nat_height));
				_tmp12_ = child;
				gtk_widget_measure (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), GTK_ORIENTATION_VERTICAL, width, &_tmp13_, &_tmp14_, NULL, NULL);
				min = _tmp13_;
				nat = _tmp14_;
				_tmp15_ = heights;
				_tmp15__length1 = heights_length1;
				memset (&_tmp16_, 0, sizeof (WidgetHeights));
				_tmp16_.min_height = min;
				_tmp16_.nat_height = nat;
				_tmp15_[i] = _tmp16_;
				total_min += min;
				total_nat += nat;
				_tmp17_ = child;
				if (gtk_widget_compute_expand (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), GTK_ORIENTATION_VERTICAL)) {
					gint _tmp18_;
					_tmp18_ = num_vexpand_children;
					num_vexpand_children = _tmp18_ + 1;
				}
				_tmp19_ = i;
				i = _tmp19_ + 1;
				_g_object_unref0 (child);
			}
		}
	}
	allocate_nat = FALSE;
	extra_height = 0;
	_tmp20_ = measured_height;
	if (height >= _tmp20_.nat_height) {
		WidgetHeights _tmp21_;
		allocate_nat = TRUE;
		_tmp21_ = measured_height;
		extra_height = height - _tmp21_.nat_height;
	} else {
		g_warn_if_reached ();
	}
	y = 0;
	i = 0;
	_tmp22_ = self->priv->_children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp22_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			AnimatedListItem* _tmp23_;
			AnimatedListItem* child = NULL;
			_tmp23_ = _g_object_ref0 ((AnimatedListItem*) child_it->data);
			child = _tmp23_;
			{
				WidgetHeights computed_height = {0};
				WidgetHeights* _tmp24_;
				gint _tmp24__length1;
				WidgetHeights _tmp25_;
				WidgetAlloc child_allocation = {0};
				WidgetHeights _tmp26_;
				WidgetAlloc _tmp27_ = {0};
				AnimatedListItem* _tmp29_;
				WidgetAlloc* _tmp30_;
				gint _tmp30__length1;
				WidgetAlloc _tmp31_;
				WidgetAlloc _tmp32_;
				WidgetAlloc _tmp33_;
				gint _tmp34_;
				_tmp24_ = heights;
				_tmp24__length1 = heights_length1;
				_tmp25_ = _tmp24_[i];
				computed_height = _tmp25_;
				_tmp26_ = computed_height;
				memset (&_tmp27_, 0, sizeof (WidgetAlloc));
				_tmp27_.y = (gfloat) 0;
				_tmp27_.height = _tmp26_.min_height;
				child_allocation = _tmp27_;
				if (allocate_nat) {
					WidgetHeights _tmp28_;
					_tmp28_ = computed_height;
					child_allocation.height = _tmp28_.nat_height;
				}
				_tmp29_ = child;
				if (gtk_widget_compute_expand (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget), GTK_ORIENTATION_VERTICAL)) {
					child_allocation.height = child_allocation.height + (extra_height / num_vexpand_children);
				}
				child_allocation.y = (gfloat) y;
				_tmp30_ = _vala_child_heights;
				_tmp30__length1 = _vala_child_heights_length1;
				_tmp31_ = child_allocation;
				_tmp30_[i] = _tmp31_;
				_tmp32_ = child_allocation;
				_vala_total_height = _vala_total_height + _tmp32_.height;
				_tmp33_ = child_allocation;
				y += _tmp33_.height;
				_tmp34_ = i;
				i = _tmp34_ + 1;
				_g_object_unref0 (child);
			}
		}
	}
	if (self->priv->fade_distance == ((gfloat) 0)) {
		self->priv->fade_distance = height * LIMIT;
	} else {
		self->priv->fade_distance = MIN (self->priv->fade_distance, height * LIMIT);
	}
	if (animated_list_should_card_animate (self)) {
		GtkAdjustment* _tmp37_;
		GtkAdjustment* _tmp38_;
		_tmp37_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
		_tmp38_ = _tmp37_;
		_tmp36_ = _tmp38_ != NULL;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		_tmp35_ = _vala_total_height > height;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_vala_total_height = _vala_total_height + ((gint) self->priv->fade_distance);
	}
	heights = (g_free (heights), NULL);
	if (total_height) {
		*total_height = _vala_total_height;
	}
	if (child_heights) {
		*child_heights = _vala_child_heights;
	} else {
		_vala_child_heights = (g_free (_vala_child_heights), NULL);
	}
	if (child_heights_length1) {
		*child_heights_length1 = _vala_child_heights_length1;
	}
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static gpointer
_gsk_transform_ref0 (gpointer self)
{
	return self ? gsk_transform_ref (self) : NULL;
}

static void
animated_list_real_size_allocate (GtkWidget* base,
                                  gint width,
                                  gint height,
                                  gint baseline)
{
	AnimatedList * self;
	GList* _tmp4_;
	gint total_height = 0;
	WidgetAlloc* heights = NULL;
	gint heights_length1 = 0;
	gint _heights_size_ = 0;
	gint _tmp5_ = 0;
	WidgetAlloc* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gboolean is_reversed = FALSE;
	AnimatedListDirection _tmp8_;
	gboolean has_scroll = FALSE;
	gfloat scroll_y = 0.0F;
	GtkAdjustment* _tmp9_;
	GtkAdjustment* _tmp10_;
	guint index = 0U;
	GList* _tmp17_;
	GtkAdjustment* _tmp47_;
	GtkAdjustment* _tmp48_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		_tmp0_ = self->priv->_visible_children;
		if (!(!vala_g_list_is_empty (_tmp0_))) {
			break;
		}
		_tmp1_ = self->priv->_visible_children;
		_tmp2_ = self->priv->_visible_children;
		_tmp3_ = g_list_nth (_tmp2_, (guint) 0);
		animated_list_set_visible_children (self, g_list_delete_link (_tmp1_, _tmp3_));
	}
	_tmp4_ = self->priv->_visible_children;
	g_warn_if_fail (vala_g_list_is_empty (_tmp4_));
	animated_list_compute_height (self, width, height, &_tmp5_, &_tmp6_, &_tmp7_);
	total_height = _tmp5_;
	heights = (g_free (heights), NULL);
	heights = _tmp6_;
	heights_length1 = _tmp7_;
	_heights_size_ = heights_length1;
	_tmp8_ = self->priv->_direction;
	is_reversed = _tmp8_ == ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP;
	has_scroll = total_height > height;
	scroll_y = 0.0f;
	_tmp9_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		GtkAdjustment* _tmp11_;
		GtkAdjustment* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp11_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_adjustment_get_value (_tmp12_);
		_tmp14_ = _tmp13_;
		scroll_y = (gfloat) _tmp14_;
		if (has_scroll) {
			_tmp15_ = self->priv->set_initial_scroll_value;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			AnimatedListDirection _tmp16_;
			if (gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget))) {
				self->priv->set_initial_scroll_value = FALSE;
			}
			_tmp16_ = self->priv->_direction;
			switch (_tmp16_) {
				case ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM:
				{
					scroll_y = (gfloat) 0;
					break;
				}
				case ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP:
				{
					scroll_y = (gfloat) (total_height - height);
					break;
				}
				default:
				break;
			}
		}
	}
	total_height = MAX (height, total_height);
	index = (guint) 0;
	_tmp17_ = self->priv->_children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp17_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			AnimatedListItem* _tmp18_;
			AnimatedListItem* child = NULL;
			_tmp18_ = _g_object_ref0 ((AnimatedListItem*) child_it->data);
			child = _tmp18_;
			{
				AnimatedListItem* _tmp19_;
				WidgetAlloc child_allocation = {0};
				WidgetAlloc* _tmp21_;
				gint _tmp21__length1;
				WidgetAlloc _tmp22_;
				gint child_height = 0;
				WidgetAlloc _tmp23_;
				gfloat scale = 0.0F;
				gfloat x = 0.0F;
				gfloat y = 0.0F;
				WidgetAlloc _tmp24_;
				gfloat opacity = 0.0F;
				gboolean skip_child = FALSE;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_ = FALSE;
				GskTransform* transform = NULL;
				GskTransform* _tmp37_;
				graphene_point_t _tmp38_ = {0};
				graphene_point_t _tmp39_;
				GskTransform* _tmp40_;
				GskTransform* _tmp41_;
				AnimatedListItem* _tmp42_;
				GskTransform* _tmp43_;
				GskTransform* _tmp44_;
				AnimatedListItem* _tmp45_;
				guint _tmp46_;
				_tmp19_ = child;
				if (!gtk_widget_should_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget))) {
					guint _tmp20_;
					_tmp20_ = index;
					index = _tmp20_ + 1;
					_g_object_unref0 (child);
					continue;
				}
				_tmp21_ = heights;
				_tmp21__length1 = heights_length1;
				_tmp22_ = _tmp21_[index];
				child_allocation = _tmp22_;
				_tmp23_ = child_allocation;
				child_height = _tmp23_.height;
				scale = 1.0f;
				x = (gfloat) 0;
				_tmp24_ = child_allocation;
				y = _tmp24_.y - scroll_y;
				if (is_reversed) {
					WidgetAlloc _tmp25_;
					_tmp25_ = child_allocation;
					y = ((total_height - child_height) - _tmp25_.y) - scroll_y;
				}
				opacity = 1.0f;
				skip_child = TRUE;
				if (y < ((gfloat) height)) {
					_tmp26_ = (child_height + y) > ((gfloat) 0);
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					gboolean _tmp27_ = FALSE;
					skip_child = FALSE;
					if (animated_list_should_card_animate (self)) {
						_tmp27_ = has_scroll;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						gfloat item_center = 0.0F;
						gfloat local_fade_distance = 0.0F;
						gboolean _tmp29_ = FALSE;
						gboolean _tmp30_ = FALSE;
						item_center = y + (child_height * 0.5f);
						if (child_height > height) {
							gint _tmp28_ = 0;
							if (is_reversed) {
								_tmp28_ = child_height;
							} else {
								_tmp28_ = 0;
							}
							item_center = y + _tmp28_;
						}
						local_fade_distance = animated_list_get_fade_distance (self, height);
						if (!is_reversed) {
							_tmp30_ = item_center > local_fade_distance;
						} else {
							_tmp30_ = FALSE;
						}
						if (_tmp30_) {
							_tmp29_ = TRUE;
						} else {
							gboolean _tmp31_ = FALSE;
							if (is_reversed) {
								_tmp31_ = item_center < local_fade_distance;
							} else {
								_tmp31_ = FALSE;
							}
							_tmp29_ = _tmp31_;
						}
						if (_tmp29_) {
							gfloat dist = 0.0F;
							gfloat radius = 0.0F;
							dist = fabsf (item_center - local_fade_distance);
							radius = self->priv->fade_distance;
							if (dist < radius) {
								gfloat angle = 0.0F;
								gfloat new_y = 0.0F;
								gint _tmp32_ = 0;
								angle = atanf (dist / radius);
								new_y = sinf (angle) * radius;
								scale = 1.0f - ((new_y / height) * 2);
								x = (width - (width * scale)) * 0.5f;
								if (is_reversed) {
									_tmp32_ = 1;
								} else {
									_tmp32_ = -1;
								}
								y += (gfloat) ((dist * sin ((gdouble) angle)) * _tmp32_);
								opacity = 1.0f - ((dist / radius) * 2);
								skip_child |= ((gdouble) opacity) <= 0.1;
							} else {
								skip_child = TRUE;
							}
						}
					}
				}
				if (!skip_child) {
					_tmp34_ = y < ((gfloat) height);
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					_tmp33_ = (child_height + y) > ((gfloat) 0);
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					GList* _tmp35_;
					AnimatedListItem* _tmp36_;
					_tmp35_ = self->priv->_visible_children;
					_tmp36_ = child;
					animated_list_set_visible_children (self, g_list_prepend (_tmp35_, _tmp36_));
				}
				_tmp37_ = gsk_transform_new ();
				memset (&_tmp38_, 0, sizeof (graphene_point_t));
				_tmp39_ = *graphene_point_init (&_tmp38_, x, y);
				_tmp40_ = gsk_transform_translate (_tmp37_, &_tmp39_);
				_tmp41_ = gsk_transform_scale (_tmp40_, scale, scale);
				transform = _tmp41_;
				_tmp42_ = child;
				_tmp43_ = transform;
				_tmp44_ = _gsk_transform_ref0 (_tmp43_);
				gtk_widget_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget), width, child_height, baseline, _tmp44_);
				_tmp45_ = child;
				gtk_widget_set_opacity (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget), (gdouble) opacity);
				_tmp46_ = index;
				index = _tmp46_ + 1;
				_gsk_transform_unref0 (transform);
				_g_object_unref0 (child);
			}
		}
	}
	_tmp47_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp48_ = _tmp47_;
	if (_tmp48_ != NULL) {
		GtkAdjustment* _tmp49_;
		GtkAdjustment* _tmp50_;
		_tmp49_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
		_tmp50_ = _tmp49_;
		gtk_adjustment_configure (_tmp50_, (gdouble) scroll_y, (gdouble) 0, (gdouble) total_height, height * 0.1, height * 0.9, (gdouble) height);
	}
	heights = (g_free (heights), NULL);
}

static void
animated_list_real_measure (GtkWidget* base,
                            GtkOrientation orientation,
                            gint for_size,
                            gint* minimum,
                            gint* natural,
                            gint* minimum_baseline,
                            gint* natural_baseline)
{
	AnimatedList * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	gint min = 0;
	gint nat = 0;
	gint largest_min = 0;
	gint largest_nat = 0;
	GList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	_vala_minimum = 0;
	_vala_natural = 0;
	_vala_minimum_baseline = -1;
	_vala_natural_baseline = -1;
	min = 0;
	nat = 0;
	largest_min = 0;
	largest_nat = 0;
	_tmp0_ = self->priv->_children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			AnimatedListItem* _tmp1_;
			AnimatedListItem* child = NULL;
			_tmp1_ = _g_object_ref0 ((AnimatedListItem*) child_it->data);
			child = _tmp1_;
			{
				AnimatedListItem* _tmp2_;
				gint child_min = 0;
				gint child_nat = 0;
				AnimatedListItem* _tmp3_;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp2_ = child;
				if (!gtk_widget_should_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget))) {
					_g_object_unref0 (child);
					continue;
				}
				_tmp3_ = child;
				gtk_widget_measure (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), orientation, for_size, &_tmp4_, &_tmp5_, NULL, NULL);
				child_min = _tmp4_;
				child_nat = _tmp5_;
				min += child_min;
				nat += child_nat;
				largest_min = MAX (largest_min, child_min);
				largest_nat = MAX (largest_min, child_nat);
				_g_object_unref0 (child);
			}
		}
	}
	switch (orientation) {
		case GTK_ORIENTATION_HORIZONTAL:
		{
			_vala_minimum = largest_min;
			_vala_natural = largest_nat;
			break;
		}
		case GTK_ORIENTATION_VERTICAL:
		{
			_vala_minimum = min;
			_vala_natural = nat;
			break;
		}
		default:
		break;
	}
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static void
animated_list_real_snapshot (GtkWidget* base,
                             GtkSnapshot* snapshot)
{
	AnimatedList * self;
	GList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (snapshot, gtk_snapshot_get_type ()));
	_tmp0_ = self->priv->_visible_children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			AnimatedListItem* child = NULL;
			child = (AnimatedListItem*) child_it->data;
			{
				AnimatedListItem* _tmp1_;
				AnimatedListItem* _tmp2_;
				_tmp1_ = child;
				if (!gtk_widget_should_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget))) {
					continue;
				}
				_tmp2_ = child;
				gtk_widget_snapshot_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), snapshot);
			}
		}
	}
}

static GtkAdjustment*
animated_list_clone_adjustment (AnimatedList* self,
                                GtkAdjustment* original)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (original, gtk_adjustment_get_type ()), NULL);
	_tmp0_ = gtk_adjustment_new (gtk_adjustment_get_value (original), gtk_adjustment_get_lower (original), gtk_adjustment_get_upper (original), gtk_adjustment_get_step_increment (original), gtk_adjustment_get_page_increment (original), gtk_adjustment_get_page_size (original));
	if (_tmp0_) {
		g_object_set_data ((GObject *) _tmp0_, "vala-creation-function", "AnimatedList.clone_adjustment");
	}
	g_object_ref_sink (_tmp0_);
	result = _tmp0_;
	return result;
}

static void
animated_list_scroll_bottom_value_cb (AnimatedList* self,
                                      gdouble value)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	AnimationData* _tmp2_;
	GtkAdjustment* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	AnimationData* _tmp6_;
	GtkAdjustment* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	AnimationData* _tmp10_;
	AnimatedListItem* _tmp11_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	_tmp0_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->scroll_btm_anim_data;
	_tmp3_ = (*_tmp2_).vadj;
	_tmp4_ = gtk_adjustment_get_upper (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->scroll_btm_anim_data;
	_tmp7_ = (*_tmp6_).vadj;
	_tmp8_ = gtk_adjustment_get_page_size (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->scroll_btm_anim_data;
	_tmp11_ = (*_tmp10_).item;
	gtk_adjustment_set_value (_tmp1_, (_tmp5_ - _tmp9_) + gtk_widget_get_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget)));
}

static gpointer
_animation_data_dup0 (gpointer self)
{
	return self ? animation_data_dup (self) : NULL;
}

static void
animated_list_play_scroll_bottom_anim (AnimatedList* self,
                                       AnimatedListItem* item)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	AnimationData _tmp3_ = {0};
	AnimationData _tmp4_;
	AnimationData* _tmp5_;
	AdwTimedAnimation* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	AdwTimedAnimation* _tmp9_;
	AdwEasing _tmp10_;
	AdwEasing _tmp11_;
	AdwTimedAnimation* _tmp12_;
	AdwTimedAnimation* _tmp13_;
	AdwTimedAnimation* _tmp14_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (item));
	_tmp0_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp1_ = _tmp0_;
	_tmp2_ = animated_list_clone_adjustment (self, _tmp1_);
	memset (&_tmp3_, 0, sizeof (AnimationData));
	_tmp3_.item = item;
	_g_object_unref0 (_tmp3_.vadj);
	_tmp3_.vadj = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _animation_data_dup0 (&_tmp4_);
	_animation_data_free0 (self->priv->scroll_btm_anim_data);
	self->priv->scroll_btm_anim_data = _tmp5_;
	animation_data_destroy (&_tmp4_);
	_tmp6_ = self->priv->scroll_top_anim;
	_tmp7_ = animated_list_item_get_animation_duration (item);
	_tmp8_ = _tmp7_;
	adw_timed_animation_set_duration (_tmp6_, (guint) _tmp8_);
	_tmp9_ = self->priv->scroll_top_anim;
	_tmp10_ = animated_list_item_get_animation_easing (item);
	_tmp11_ = _tmp10_;
	adw_timed_animation_set_easing (_tmp9_, _tmp11_);
	_tmp12_ = self->priv->scroll_btm_anim;
	adw_timed_animation_set_value_from (_tmp12_, 0.0);
	_tmp13_ = self->priv->scroll_btm_anim;
	adw_timed_animation_set_value_to (_tmp13_, 1.0);
	_tmp14_ = self->priv->scroll_btm_anim;
	adw_animation_play (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, adw_animation_get_type (), AdwAnimation));
}

static void
animated_list_scroll_top_value_cb (AnimatedList* self,
                                   gdouble value)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	AnimationData* _tmp2_;
	GtkAdjustment* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	_tmp0_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->scroll_top_anim_data;
	_tmp3_ = (*_tmp2_).vadj;
	_tmp4_ = gtk_adjustment_get_value (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_adjustment_set_value (_tmp1_, adw_lerp (_tmp5_, (gdouble) 0, value));
}

static void
animated_list_play_scroll_top_anim (AnimatedList* self,
                                    AnimatedListItem* item)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	AnimationData _tmp3_ = {0};
	AnimationData _tmp4_;
	AnimationData* _tmp5_;
	AdwTimedAnimation* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	AdwTimedAnimation* _tmp9_;
	AdwEasing _tmp10_;
	AdwEasing _tmp11_;
	AdwTimedAnimation* _tmp12_;
	AdwTimedAnimation* _tmp13_;
	AdwTimedAnimation* _tmp14_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (item));
	_tmp0_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp1_ = _tmp0_;
	_tmp2_ = animated_list_clone_adjustment (self, _tmp1_);
	memset (&_tmp3_, 0, sizeof (AnimationData));
	_tmp3_.item = item;
	_g_object_unref0 (_tmp3_.vadj);
	_tmp3_.vadj = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _animation_data_dup0 (&_tmp4_);
	_animation_data_free0 (self->priv->scroll_top_anim_data);
	self->priv->scroll_top_anim_data = _tmp5_;
	animation_data_destroy (&_tmp4_);
	_tmp6_ = self->priv->scroll_top_anim;
	_tmp7_ = animated_list_item_get_animation_duration (item);
	_tmp8_ = _tmp7_;
	adw_timed_animation_set_duration (_tmp6_, (guint) _tmp8_);
	_tmp9_ = self->priv->scroll_top_anim;
	_tmp10_ = animated_list_item_get_animation_easing (item);
	_tmp11_ = _tmp10_;
	adw_timed_animation_set_easing (_tmp9_, _tmp11_);
	_tmp12_ = self->priv->scroll_top_anim;
	adw_timed_animation_set_value_from (_tmp12_, 0.0);
	_tmp13_ = self->priv->scroll_top_anim;
	adw_timed_animation_set_value_to (_tmp13_, 1.0);
	_tmp14_ = self->priv->scroll_top_anim;
	adw_animation_play (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, adw_animation_get_type (), AdwAnimation));
}

static void
animated_list_scroll_comp_value_cb (AnimatedList* self,
                                    gdouble value)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	AnimationData* _tmp2_;
	GtkAdjustment* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	AnimationData* _tmp6_;
	AnimatedListItem* _tmp7_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	_tmp0_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->scroll_comp_anim_data;
	_tmp3_ = (*_tmp2_).vadj;
	_tmp4_ = gtk_adjustment_get_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->scroll_comp_anim_data;
	_tmp7_ = (*_tmp6_).item;
	gtk_adjustment_set_value (_tmp1_, _tmp5_ + gtk_widget_get_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget)));
}

static void
animated_list_play_scroll_comp_anim (AnimatedList* self,
                                     AnimatedListItem* item)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	AnimationData _tmp3_ = {0};
	AnimationData _tmp4_;
	AnimationData* _tmp5_;
	AdwTimedAnimation* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	AdwTimedAnimation* _tmp9_;
	AdwTimedAnimation* _tmp10_;
	AdwTimedAnimation* _tmp11_;
	AdwTimedAnimation* _tmp12_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (item));
	_tmp0_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp1_ = _tmp0_;
	_tmp2_ = animated_list_clone_adjustment (self, _tmp1_);
	memset (&_tmp3_, 0, sizeof (AnimationData));
	_tmp3_.item = item;
	_g_object_unref0 (_tmp3_.vadj);
	_tmp3_.vadj = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _animation_data_dup0 (&_tmp4_);
	_animation_data_free0 (self->priv->scroll_comp_anim_data);
	self->priv->scroll_comp_anim_data = _tmp5_;
	animation_data_destroy (&_tmp4_);
	_tmp6_ = self->priv->scroll_comp_anim;
	_tmp7_ = animated_list_item_get_animation_duration (item);
	_tmp8_ = _tmp7_;
	adw_timed_animation_set_duration (_tmp6_, (guint) _tmp8_);
	_tmp9_ = self->priv->scroll_comp_anim;
	adw_timed_animation_set_easing (_tmp9_, ADW_LINEAR);
	_tmp10_ = self->priv->scroll_comp_anim;
	adw_timed_animation_set_value_from (_tmp10_, 0.0);
	_tmp11_ = self->priv->scroll_comp_anim;
	adw_timed_animation_set_value_to (_tmp11_, 1.0);
	_tmp12_ = self->priv->scroll_comp_anim;
	adw_animation_play (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, adw_animation_get_type (), AdwAnimation));
}

static AnimatedListItem*
animated_list_get_list_item (AnimatedList* self,
                             GtkWidget* widget)
{
	AnimatedListItem* item = NULL;
	AnimatedListItem* result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), NULL);
	if (IS_ANIMATED_LIST_ITEM (widget)) {
		AnimatedListItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (IS_ANIMATED_LIST_ITEM (widget) ? ((AnimatedListItem*) widget) : NULL);
		_g_object_unref0 (item);
		item = _tmp0_;
	} else {
		AnimatedListItem* _tmp1_;
		AnimatedListItem* _tmp2_;
		AnimatedListItem* _tmp3_;
		AnimatedListItemRevealAnimationType _tmp4_;
		AnimatedListItem* _tmp5_;
		AnimatedListItemChildAnimationType _tmp6_;
		AnimatedListItem* _tmp7_;
		_tmp1_ = animated_list_item_new ();
		if (_tmp1_) {
			g_object_set_data ((GObject *) _tmp1_, "vala-creation-function", "AnimatedList.get_list_item");
		}
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (item);
		item = _tmp1_;
		_tmp2_ = item;
		animated_list_item_set_child (_tmp2_, widget);
		_tmp3_ = item;
		_tmp4_ = self->priv->_animation_reveal_type;
		animated_list_item_set_animation_reveal_type (_tmp3_, _tmp4_);
		_tmp5_ = item;
		_tmp6_ = self->priv->_animation_child_type;
		animated_list_item_set_animation_child_type (_tmp5_, _tmp6_);
		gtk_widget_unparent (widget);
		_tmp7_ = item;
		gtk_widget_set_parent (widget, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	}
	result = item;
	return result;
}

static void
animated_list_prepend_data_free (gpointer _data)
{
	AnimatedListPrependData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->widget);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AnimatedListPrependData, _data_);
}

void
animated_list_prepend (AnimatedList* self,
                       GtkWidget* widget,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	AnimatedListPrependData* _data_;
	AnimatedList* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	_data_ = g_slice_new0 (AnimatedListPrependData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, animated_list_prepend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data_->widget);
	_data_->widget = _tmp1_;
	animated_list_prepend_co (_data_);
}

AnimatedListItem*
animated_list_prepend_finish (AnimatedList* self,
                              GAsyncResult* _res_)
{
	AnimatedListItem* result;
	AnimatedListPrependData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Inserts a widget last into the list depending on direction:
     * TOP_TO_BOTTOM: Bottom
     * BOTTOM_TO_TOP: Top
     */
static void
animated_list_prepend_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_)
{
	AnimatedListPrependData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	animated_list_prepend_co (_data_);
}

static gboolean
animated_list_prepend_co (AnimatedListPrependData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->widget == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = gtk_widget_get_parent (_data_->widget);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp0_ = _data_->_tmp2_ != NULL;
	}
	if (_data_->_tmp0_) {
		g_warn_if_reached ();
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = animated_list_get_list_item (_data_->self, _data_->widget);
	_data_->item = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->item;
	gtk_widget_unparent (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gtk_widget_get_type (), GtkWidget));
	_data_->_tmp5_ = _data_->item;
	gtk_widget_insert_before (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget), NULL);
	_data_->_tmp6_ = _data_->self->priv->_children;
	_data_->_tmp7_ = _data_->item;
	_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
	animated_list_set_children (_data_->self, g_list_append (_data_->_tmp6_, _data_->_tmp8_));
	_data_->_tmp9_ = _data_->self->priv->_n_children;
	animated_list_set_n_children (_data_->self, _data_->_tmp9_ + 1);
	_data_->_tmp11_ = _data_->self->priv->_direction;
	if (_data_->_tmp11_ == ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM) {
		_data_->_tmp12_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_scrollable_get_type (), GtkScrollable));
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = gtk_adjustment_get_value (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_scrollable_get_type (), GtkScrollable));
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = gtk_adjustment_get_upper (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_scrollable_get_type (), GtkScrollable));
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = gtk_adjustment_get_page_size (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp10_ = _data_->_tmp15_ == (_data_->_tmp19_ - _data_->_tmp23_);
	} else {
		_data_->_tmp10_ = FALSE;
	}
	if (_data_->_tmp10_) {
		_data_->_tmp24_ = _data_->item;
		animated_list_play_scroll_bottom_anim (_data_->self, _data_->_tmp24_);
	} else {
		_data_->_tmp25_ = _data_->self->priv->_direction;
		if (_data_->_tmp25_ == ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP) {
			_data_->_tmp26_ = _data_->item;
			animated_list_play_scroll_comp_anim (_data_->self, _data_->_tmp26_);
		}
	}
	_data_->_tmp27_ = _data_->item;
	_data_->_tmp28_ = _data_->self->priv->_transition_children;
	_data_->_state_ = 1;
	animated_list_item_added (_data_->_tmp27_, _data_->_tmp28_, animated_list_prepend_ready, _data_);
	return FALSE;
	_state_1:
	animated_list_item_added_finish (_data_->_tmp27_, _data_->_res_);
	_data_->result = _data_->item;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
animated_list_append_data_free (gpointer _data)
{
	AnimatedListAppendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->widget);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AnimatedListAppendData, _data_);
}

void
animated_list_append (AnimatedList* self,
                      GtkWidget* widget,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	AnimatedListAppendData* _data_;
	AnimatedList* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	_data_ = g_slice_new0 (AnimatedListAppendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, animated_list_append_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data_->widget);
	_data_->widget = _tmp1_;
	animated_list_append_co (_data_);
}

AnimatedListItem*
animated_list_append_finish (AnimatedList* self,
                             GAsyncResult* _res_)
{
	AnimatedListItem* result;
	AnimatedListAppendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Inserts a widget first into the list depending on direction:
     * TOP_TO_BOTTOM: Top
     * BOTTOM_TO_TOP: Bottom
     */
static void
animated_list_append_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	AnimatedListAppendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	animated_list_append_co (_data_);
}

static gboolean
animated_list_append_co (AnimatedListAppendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->widget == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = gtk_widget_get_parent (_data_->widget);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp0_ = _data_->_tmp2_ != NULL;
	}
	if (_data_->_tmp0_) {
		g_warn_if_reached ();
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = animated_list_get_list_item (_data_->self, _data_->widget);
	_data_->item = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->item;
	gtk_widget_unparent (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gtk_widget_get_type (), GtkWidget));
	_data_->_tmp5_ = _data_->item;
	gtk_widget_insert_after (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget), NULL);
	_data_->_tmp6_ = _data_->self->priv->_children;
	_data_->_tmp7_ = _data_->item;
	_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
	animated_list_set_children (_data_->self, g_list_prepend (_data_->_tmp6_, _data_->_tmp8_));
	_data_->_tmp9_ = _data_->self->priv->_n_children;
	animated_list_set_n_children (_data_->self, _data_->_tmp9_ + 1);
	_data_->_tmp11_ = _data_->self->priv->_direction;
	if (_data_->_tmp11_ == ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP) {
		_data_->_tmp12_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_scrollable_get_type (), GtkScrollable));
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = gtk_adjustment_get_value (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_scrollable_get_type (), GtkScrollable));
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = gtk_adjustment_get_upper (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_scrollable_get_type (), GtkScrollable));
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = gtk_adjustment_get_page_size (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp10_ = _data_->_tmp15_ == (_data_->_tmp19_ - _data_->_tmp23_);
	} else {
		_data_->_tmp10_ = FALSE;
	}
	if (_data_->_tmp10_) {
		_data_->_tmp24_ = _data_->item;
		animated_list_play_scroll_bottom_anim (_data_->self, _data_->_tmp24_);
	} else {
		_data_->_tmp26_ = _data_->self->priv->_scroll_to_append;
		if (!_data_->_tmp26_) {
			_data_->_tmp27_ = _data_->self->priv->_direction;
			_data_->_tmp25_ = _data_->_tmp27_ == ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM;
		} else {
			_data_->_tmp25_ = FALSE;
		}
		if (_data_->_tmp25_) {
			_data_->_tmp28_ = _data_->item;
			animated_list_play_scroll_comp_anim (_data_->self, _data_->_tmp28_);
		} else {
			_data_->_tmp29_ = _data_->self->priv->_scroll_to_append;
			if (_data_->_tmp29_) {
				_data_->_tmp30_ = _data_->self->priv->_direction;
				switch (_data_->_tmp30_) {
					case ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM:
					{
						_data_->_tmp31_ = _data_->item;
						animated_list_play_scroll_top_anim (_data_->self, _data_->_tmp31_);
						break;
					}
					case ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP:
					{
						_data_->_tmp32_ = _data_->item;
						animated_list_play_scroll_bottom_anim (_data_->self, _data_->_tmp32_);
						break;
					}
					default:
					break;
				}
			}
		}
	}
	_data_->_tmp33_ = _data_->item;
	_data_->_tmp34_ = _data_->self->priv->_transition_children;
	_data_->_state_ = 1;
	animated_list_item_added (_data_->_tmp33_, _data_->_tmp34_, animated_list_append_ready, _data_);
	return FALSE;
	_state_1:
	animated_list_item_added_finish (_data_->_tmp33_, _data_->_res_);
	_data_->result = _data_->item;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static AnimatedListItem*
animated_list_try_get_ancestor (AnimatedList* self,
                                GtkWidget* widget)
{
	AnimatedListItem* item = NULL;
	AnimatedListItem* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	AnimatedListItem* result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), NULL);
	if (IS_ANIMATED_LIST_ITEM (widget)) {
		AnimatedListItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (IS_ANIMATED_LIST_ITEM (widget) ? ((AnimatedListItem*) widget) : NULL);
		_g_object_unref0 (item);
		item = _tmp0_;
	} else {
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp1_ = gtk_widget_get_parent (widget);
		_tmp2_ = _tmp1_;
		if (IS_ANIMATED_LIST_ITEM (_tmp2_)) {
			GtkWidget* _tmp3_;
			GtkWidget* _tmp4_;
			AnimatedListItem* _tmp5_;
			_tmp3_ = gtk_widget_get_parent (widget);
			_tmp4_ = _tmp3_;
			_tmp5_ = _g_object_ref0 (IS_ANIMATED_LIST_ITEM (_tmp4_) ? ((AnimatedListItem*) _tmp4_) : NULL);
			_g_object_unref0 (item);
			item = _tmp5_;
		} else {
			GtkWidget* ancestor = NULL;
			GtkWidget* _tmp6_;
			GtkWidget* _tmp7_;
			GtkWidget* _tmp10_;
			AnimatedListItem* _tmp11_;
			_tmp6_ = gtk_widget_get_ancestor (widget, TYPE_ANIMATED_LIST_ITEM);
			ancestor = _tmp6_;
			_tmp7_ = ancestor;
			if (!IS_ANIMATED_LIST_ITEM (_tmp7_)) {
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (widget, G_TYPE_OBJECT, GObject)));
				_tmp9_ = g_type_name (TYPE_ANIMATED_LIST_ITEM);
				g_warning ("animatedList.vala:623: Widget %p of type  \"%s\" is not an ancestor of" \
" %s!", widget, _tmp8_, _tmp9_);
				result = NULL;
				_g_object_unref0 (item);
				return result;
			}
			_tmp10_ = ancestor;
			_tmp11_ = _g_object_ref0 (IS_ANIMATED_LIST_ITEM (_tmp10_) ? ((AnimatedListItem*) _tmp10_) : NULL);
			_g_object_unref0 (item);
			item = _tmp11_;
		}
	}
	_tmp12_ = item;
	_tmp13_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = _tmp13_;
	if (_tmp14_ != G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget)) {
		g_warn_if_reached ();
		result = NULL;
		_g_object_unref0 (item);
		return result;
	}
	result = item;
	return result;
}

static void
animated_list_remove_data_free (gpointer _data)
{
	AnimatedListRemoveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->widget);
	_g_object_unref0 (_data_->self);
	g_slice_free (AnimatedListRemoveData, _data_);
}

void
animated_list_remove (AnimatedList* self,
                      GtkWidget* widget,
                      gboolean transition,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	AnimatedListRemoveData* _data_;
	AnimatedList* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	_data_ = g_slice_new0 (AnimatedListRemoveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, animated_list_remove_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data_->widget);
	_data_->widget = _tmp1_;
	_data_->transition = transition;
	animated_list_remove_co (_data_);
}

gboolean
animated_list_remove_finish (AnimatedList* self,
                             GAsyncResult* _res_)
{
	gboolean result;
	AnimatedListRemoveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
animated_list_remove_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	AnimatedListRemoveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	animated_list_remove_co (_data_);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
animated_list_remove_co (AnimatedListRemoveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->widget == NULL) {
		g_warn_if_reached ();
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = animated_list_try_get_ancestor (_data_->self, _data_->widget);
	_data_->item = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->item;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		_g_object_unref0 (_data_->item);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->_transition_children;
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = _data_->transition;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	_data_->_tmp4_ = _data_->item;
	_data_->_state_ = 1;
	animated_list_item_removed (_data_->_tmp4_, _data_->_tmp2_, animated_list_remove_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_result_ = animated_list_item_removed_finish (_data_->_tmp4_, _data_->_res_);
	_data_->_tmp5_ = _data_->item;
	gtk_widget_unparent (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, gtk_widget_get_type (), GtkWidget));
	_data_->_tmp6_ = _data_->self->priv->_children;
	_data_->_tmp7_ = _data_->item;
	animated_list_set_children (_data_->self, vala_g_list_remove_full (_data_->_tmp6_, _data_->_tmp7_, _g_object_unref0_));
	_data_->_tmp8_ = _data_->self->priv->_n_children;
	animated_list_set_n_children (_data_->self, _data_->_tmp8_ - 1);
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget));
	_data_->result = _data_->_result_;
	_g_object_unref0 (_data_->item);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
animated_list_move_to_beginning (AnimatedList* self,
                                 GtkWidget* widget,
                                 gboolean scroll_to)
{
	AnimatedListItem* item = NULL;
	AnimatedListItem* _tmp0_;
	AnimatedListItem* _tmp1_;
	AnimatedListItem* _tmp2_;
	GList* _tmp3_;
	AnimatedListItem* _tmp4_;
	GList* _tmp5_;
	AnimatedListItem* _tmp6_;
	AnimatedListItem* _tmp7_;
	gboolean result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), FALSE);
	if (widget == NULL) {
		g_warn_if_reached ();
		result = FALSE;
		return result;
	}
	_tmp0_ = animated_list_try_get_ancestor (self, widget);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ == NULL) {
		g_warn_if_reached ();
		result = FALSE;
		_g_object_unref0 (item);
		return result;
	}
	_tmp2_ = item;
	gtk_widget_insert_after (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), NULL);
	_tmp3_ = self->priv->_children;
	_tmp4_ = item;
	animated_list_set_children (self, vala_g_list_remove_full (_tmp3_, _tmp4_, _g_object_unref0_));
	_tmp5_ = self->priv->_children;
	_tmp6_ = item;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	animated_list_set_children (self, g_list_prepend (_tmp5_, _tmp7_));
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (scroll_to) {
		animated_list_scroll_to_top (self);
	}
	result = TRUE;
	_g_object_unref0 (item);
	return result;
}

static void
__lambda10_ (AnimatedList* self)
{
	AnimatedListItem* item = NULL;
	AnimatedListItem* _tmp0_;
	AnimatedListItem* _tmp1_;
	AnimatedListDirection _tmp2_;
	self->priv->scroll_to_source_id = (guint) 0;
	_tmp0_ = animated_list_get_first_item (self);
	item = _tmp0_;
	_tmp1_ = item;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->_direction;
	switch (_tmp2_) {
		case ANIMATED_LIST_DIRECTION_TOP_TO_BOTTOM:
		{
			AnimatedListItem* _tmp3_;
			_tmp3_ = item;
			animated_list_play_scroll_top_anim (self, _tmp3_);
			break;
		}
		case ANIMATED_LIST_DIRECTION_BOTTOM_TO_TOP:
		{
			AnimatedListItem* _tmp4_;
			_tmp4_ = item;
			animated_list_play_scroll_bottom_anim (self, _tmp4_);
			break;
		}
		default:
		break;
	}
}

static void
___lambda10__gsource_once_func (gpointer self)
{
	__lambda10_ ((AnimatedList*) self);
}

void
animated_list_scroll_to_top (AnimatedList* self)
{
	g_return_if_fail (IS_ANIMATED_LIST (self));
	if (self->priv->scroll_to_source_id > ((guint) 0)) {
		g_source_remove (self->priv->scroll_to_source_id);
	}
	self->priv->scroll_to_source_id = g_idle_add_once (___lambda10__gsource_once_func, self);
}

gboolean
animated_list_is_empty (AnimatedList* self)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), FALSE);
	_tmp0_ = self->priv->_children;
	result = vala_g_list_is_empty (_tmp0_);
	return result;
}

AnimatedListItem*
animated_list_get_first_item (AnimatedList* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	AnimatedListItem* result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), NULL);
	_tmp0_ = self->priv->_children;
	if (vala_g_list_is_empty (_tmp0_)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_children;
	_tmp2_ = g_list_first (_tmp1_);
	_tmp3_ = _tmp2_->data;
	result = (AnimatedListItem*) _tmp3_;
	return result;
}

AnimatedListItem*
animated_list_get_last_item (AnimatedList* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	AnimatedListItem* result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), NULL);
	_tmp0_ = self->priv->_children;
	if (vala_g_list_is_empty (_tmp0_)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_children;
	_tmp2_ = g_list_last (_tmp1_);
	_tmp3_ = _tmp2_->data;
	result = (AnimatedListItem*) _tmp3_;
	return result;
}

static gboolean
animated_list_should_card_animate (AnimatedList* self)
{
	gboolean value = FALSE;
	gboolean _tmp0_;
	GtkSettings* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), FALSE);
	_tmp0_ = self->priv->_use_card_animation;
	value = _tmp0_;
	_tmp1_ = self->priv->settings;
	if (_tmp1_ != NULL) {
		GtkSettings* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->settings;
		g_object_get (_tmp2_, "gtk-enable-animations", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		value &= _tmp4_;
	}
	result = value;
	return result;
}

static GtkAdjustment*
animated_list_real_get_hadjustment (GtkScrollable* base)
{
	GtkAdjustment* result;
	AnimatedList* self;
	GtkAdjustment* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	_tmp0_ = self->priv->_hadjustment;
	result = _tmp0_;
	return result;
}

static void
animated_list_real_set_hadjustment (GtkScrollable* base,
                                    GtkAdjustment* value)
{
	AnimatedList* self;
	GtkAdjustment* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	old_value = animated_list_real_get_hadjustment (base);
	if (old_value != value) {
		GtkAdjustment* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_hadjustment);
		self->priv->_hadjustment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_HADJUSTMENT_PROPERTY]);
	}
}

static GtkScrollablePolicy
animated_list_real_get_hscroll_policy (GtkScrollable* base)
{
	GtkScrollablePolicy result;
	AnimatedList* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	result = self->priv->_hscroll_policy;
	return result;
}

static void
animated_list_real_set_hscroll_policy (GtkScrollable* base,
                                       GtkScrollablePolicy value)
{
	AnimatedList* self;
	GtkScrollablePolicy old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	old_value = animated_list_real_get_hscroll_policy (base);
	if (old_value != value) {
		self->priv->_hscroll_policy = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_HSCROLL_POLICY_PROPERTY]);
	}
}

static GtkAdjustment*
animated_list_real_get_vadjustment (GtkScrollable* base)
{
	GtkAdjustment* result;
	AnimatedList* self;
	GtkAdjustment* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	_tmp0_ = self->priv->_vadjustment;
	result = _tmp0_;
	return result;
}

static void
animated_list_real_set_vadjustment (GtkScrollable* base,
                                    GtkAdjustment* value)
{
	AnimatedList* self;
	GtkAdjustment* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	old_value = animated_list_real_get_vadjustment (base);
	if (old_value != value) {
		GtkAdjustment* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_vadjustment);
		self->priv->_vadjustment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_VADJUSTMENT_PROPERTY]);
	}
}

static GtkScrollablePolicy
animated_list_real_get_vscroll_policy (GtkScrollable* base)
{
	GtkScrollablePolicy result;
	AnimatedList* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	result = self->priv->_vscroll_policy;
	return result;
}

static void
animated_list_real_set_vscroll_policy (GtkScrollable* base,
                                       GtkScrollablePolicy value)
{
	AnimatedList* self;
	GtkScrollablePolicy old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST, AnimatedList);
	old_value = animated_list_real_get_vscroll_policy (base);
	if (old_value != value) {
		self->priv->_vscroll_policy = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_VSCROLL_POLICY_PROPERTY]);
	}
}

guint
animated_list_get_n_children (AnimatedList* self)
{
	guint result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), 0U);
	result = self->priv->_n_children;
	return result;
}

static void
animated_list_set_n_children (AnimatedList* self,
                              guint value)
{
	guint old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_n_children (self);
	if (old_value != value) {
		self->priv->_n_children = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_N_CHILDREN_PROPERTY]);
	}
}

GList*
animated_list_get_children (AnimatedList* self)
{
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), NULL);
	_tmp0_ = self->priv->_children;
	result = _tmp0_;
	return result;
}

static void
animated_list_set_children (AnimatedList* self,
                            GList* value)
{
	GList* old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_children (self);
	if (old_value != value) {
		self->priv->_children = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_CHILDREN_PROPERTY]);
	}
}

GList*
animated_list_get_visible_children (AnimatedList* self)
{
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), NULL);
	_tmp0_ = self->priv->_visible_children;
	result = _tmp0_;
	return result;
}

static void
animated_list_set_visible_children (AnimatedList* self,
                                    GList* value)
{
	GList* old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_visible_children (self);
	if (old_value != value) {
		self->priv->_visible_children = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_VISIBLE_CHILDREN_PROPERTY]);
	}
}

gboolean
animated_list_get_transition_children (AnimatedList* self)
{
	gboolean result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), FALSE);
	result = self->priv->_transition_children;
	return result;
}

void
animated_list_set_transition_children (AnimatedList* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_transition_children (self);
	if (old_value != value) {
		self->priv->_transition_children = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_TRANSITION_CHILDREN_PROPERTY]);
	}
}

gboolean
animated_list_get_use_card_animation (AnimatedList* self)
{
	gboolean result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), FALSE);
	result = self->priv->_use_card_animation;
	return result;
}

void
animated_list_set_use_card_animation (AnimatedList* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_use_card_animation (self);
	if (old_value != value) {
		self->priv->_use_card_animation = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_USE_CARD_ANIMATION_PROPERTY]);
	}
}

AnimatedListDirection
animated_list_get_direction (AnimatedList* self)
{
	AnimatedListDirection result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), 0);
	result = self->priv->_direction;
	return result;
}

void
animated_list_set_direction (AnimatedList* self,
                             AnimatedListDirection value)
{
	AnimatedListDirection old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_direction (self);
	if (old_value != value) {
		self->priv->_direction = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_DIRECTION_PROPERTY]);
	}
}

gboolean
animated_list_get_scroll_to_append (AnimatedList* self)
{
	gboolean result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), FALSE);
	result = self->priv->_scroll_to_append;
	return result;
}

void
animated_list_set_scroll_to_append (AnimatedList* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_scroll_to_append (self);
	if (old_value != value) {
		self->priv->_scroll_to_append = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_SCROLL_TO_APPEND_PROPERTY]);
	}
}

AnimatedListItemRevealAnimationType
animated_list_get_animation_reveal_type (AnimatedList* self)
{
	AnimatedListItemRevealAnimationType result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), 0);
	result = self->priv->_animation_reveal_type;
	return result;
}

void
animated_list_set_animation_reveal_type (AnimatedList* self,
                                         AnimatedListItemRevealAnimationType value)
{
	AnimatedListItemRevealAnimationType old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_animation_reveal_type (self);
	if (old_value != value) {
		self->priv->_animation_reveal_type = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_ANIMATION_REVEAL_TYPE_PROPERTY]);
	}
}

AnimatedListItemChildAnimationType
animated_list_get_animation_child_type (AnimatedList* self)
{
	AnimatedListItemChildAnimationType result;
	g_return_val_if_fail (IS_ANIMATED_LIST (self), 0);
	result = self->priv->_animation_child_type;
	return result;
}

void
animated_list_set_animation_child_type (AnimatedList* self,
                                        AnimatedListItemChildAnimationType value)
{
	AnimatedListItemChildAnimationType old_value;
	g_return_if_fail (IS_ANIMATED_LIST (self));
	old_value = animated_list_get_animation_child_type (self);
	if (old_value != value) {
		self->priv->_animation_child_type = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_properties[ANIMATED_LIST_ANIMATION_CHILD_TYPE_PROPERTY]);
	}
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda12_ (AnimatedList* self)
{
	gtk_widget_queue_allocate (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
____lambda12__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                            gpointer self)
{
	___lambda12_ ((AnimatedList*) self);
}

static void
_animated_list___lambda11_ (AnimatedList* self)
{
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	_tmp0_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		_tmp2_ = gtk_scrollable_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable));
		_tmp3_ = _tmp2_;
		g_signal_connect_object (_tmp3_, "value-changed", (GCallback) ____lambda12__gtk_adjustment_value_changed, self, 0);
	}
}

static void
__animated_list___lambda11__g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	_animated_list___lambda11_ ((AnimatedList*) self);
}

static void
__lambda14_ (AnimatedList* self)
{
	self->priv->set_initial_scroll_value = TRUE;
	gtk_widget_queue_allocate (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
___lambda14__gsource_once_func (gpointer self)
{
	__lambda14_ ((AnimatedList*) self);
}

static void
_animated_list___lambda13_ (AnimatedList* self)
{
	g_idle_add_once (___lambda14__gsource_once_func, self);
}

static void
__animated_list___lambda13__gtk_widget_map (GtkWidget* _sender,
                                            gpointer self)
{
	_animated_list___lambda13_ ((AnimatedList*) self);
}

static void
_animated_list_scroll_bottom_value_cb_adw_animation_target_func (gdouble value,
                                                                 gpointer self)
{
	animated_list_scroll_bottom_value_cb ((AnimatedList*) self, value);
}

static void
_animated_list_scroll_top_value_cb_adw_animation_target_func (gdouble value,
                                                              gpointer self)
{
	animated_list_scroll_top_value_cb ((AnimatedList*) self, value);
}

static void
_animated_list_scroll_comp_value_cb_adw_animation_target_func (gdouble value,
                                                               gpointer self)
{
	animated_list_scroll_comp_value_cb ((AnimatedList*) self, value);
}

static GObject *
animated_list_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AnimatedList * self;
	GList* _tmp0_;
	GList* _tmp1_;
	AdwCallbackAnimationTarget* _tmp2_;
	AdwCallbackAnimationTarget* _tmp3_;
	AdwAnimationTarget* _tmp4_;
	AdwTimedAnimation* _tmp5_;
	AdwTimedAnimation* _tmp6_;
	AdwCallbackAnimationTarget* _tmp7_;
	AdwCallbackAnimationTarget* _tmp8_;
	AdwAnimationTarget* _tmp9_;
	AdwTimedAnimation* _tmp10_;
	AdwTimedAnimation* _tmp11_;
	AdwCallbackAnimationTarget* _tmp12_;
	AdwCallbackAnimationTarget* _tmp13_;
	AdwAnimationTarget* _tmp14_;
	AdwTimedAnimation* _tmp15_;
	AdwTimedAnimation* _tmp16_;
	parent_class = G_OBJECT_CLASS (animated_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATED_LIST, AnimatedList);
	gtk_scrollable_set_hadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable), NULL);
	_tmp0_ = NULL;
	animated_list_set_children (self, _tmp0_);
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (_g_list_free__g_object_unref0_ (_tmp0_), NULL));
	_tmp1_ = NULL;
	animated_list_set_visible_children (self, _tmp1_);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (g_list_free (_tmp1_), NULL));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::vadjustment", (GCallback) __animated_list___lambda11__g_object_notify, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "map", (GCallback) __animated_list___lambda13__gtk_widget_map, self, 0);
	gtk_widget_set_overflow (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_OVERFLOW_HIDDEN);
	_tmp2_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_animated_list_scroll_bottom_value_cb_adw_animation_target_func, g_object_ref (self), g_object_unref);
	if (_tmp2_) {
		g_object_set_data ((GObject *) _tmp2_, "vala-creation-function", "");
	}
	_g_object_unref0 (self->priv->scroll_btm_target);
	self->priv->scroll_btm_target = _tmp2_;
	_tmp3_ = self->priv->scroll_btm_target;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, adw_animation_target_get_type (), AdwAnimationTarget));
	_tmp5_ = (AdwTimedAnimation*) adw_timed_animation_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 0.0, 1.0, (guint) ANIMATED_LIST_SCROLL_ANIMATION_DURATION, _tmp4_);
	if (_tmp5_) {
		g_object_set_data ((GObject *) _tmp5_, "vala-creation-function", "");
	}
	_g_object_unref0 (self->priv->scroll_btm_anim);
	self->priv->scroll_btm_anim = _tmp5_;
	_tmp6_ = self->priv->scroll_btm_anim;
	adw_timed_animation_set_easing (_tmp6_, ADW_EASE_OUT_QUINT);
	_tmp7_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_animated_list_scroll_top_value_cb_adw_animation_target_func, g_object_ref (self), g_object_unref);
	if (_tmp7_) {
		g_object_set_data ((GObject *) _tmp7_, "vala-creation-function", "");
	}
	_g_object_unref0 (self->priv->scroll_top_target);
	self->priv->scroll_top_target = _tmp7_;
	_tmp8_ = self->priv->scroll_top_target;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, adw_animation_target_get_type (), AdwAnimationTarget));
	_tmp10_ = (AdwTimedAnimation*) adw_timed_animation_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 0.0, 1.0, (guint) ANIMATED_LIST_SCROLL_ANIMATION_DURATION, _tmp9_);
	if (_tmp10_) {
		g_object_set_data ((GObject *) _tmp10_, "vala-creation-function", "");
	}
	_g_object_unref0 (self->priv->scroll_top_anim);
	self->priv->scroll_top_anim = _tmp10_;
	_tmp11_ = self->priv->scroll_top_anim;
	adw_timed_animation_set_easing (_tmp11_, ADW_EASE_OUT_QUINT);
	_tmp12_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_animated_list_scroll_comp_value_cb_adw_animation_target_func, g_object_ref (self), g_object_unref);
	if (_tmp12_) {
		g_object_set_data ((GObject *) _tmp12_, "vala-creation-function", "");
	}
	_g_object_unref0 (self->priv->scroll_comp_target);
	self->priv->scroll_comp_target = _tmp12_;
	_tmp13_ = self->priv->scroll_comp_target;
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, adw_animation_target_get_type (), AdwAnimationTarget));
	_tmp15_ = (AdwTimedAnimation*) adw_timed_animation_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 0.0, 1.0, (guint) ANIMATED_LIST_SCROLL_ANIMATION_DURATION, _tmp14_);
	if (_tmp15_) {
		g_object_set_data ((GObject *) _tmp15_, "vala-creation-function", "");
	}
	_g_object_unref0 (self->priv->scroll_comp_anim);
	self->priv->scroll_comp_anim = _tmp15_;
	_tmp16_ = self->priv->scroll_comp_anim;
	adw_timed_animation_set_easing (_tmp16_, ADW_EASE_OUT_QUINT);
	return obj;
}

static void
animated_list_class_init (AnimatedListClass * klass,
                          gpointer klass_data)
{
	animated_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AnimatedList_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) animated_list_real_dispose;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget*)) animated_list_real_get_request_mode;
	((GtkWidgetClass *) klass)->compute_expand = (void (*) (GtkWidget*, gboolean*, gboolean*)) animated_list_real_compute_expand_internal;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) animated_list_real_size_allocate;
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) animated_list_real_measure;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) animated_list_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_animated_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_animated_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = animated_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = animated_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_HADJUSTMENT_PROPERTY, animated_list_properties[ANIMATED_LIST_HADJUSTMENT_PROPERTY] = g_param_spec_object ("hadjustment", "hadjustment", "hadjustment", gtk_adjustment_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_HSCROLL_POLICY_PROPERTY, animated_list_properties[ANIMATED_LIST_HSCROLL_POLICY_PROPERTY] = g_param_spec_enum ("hscroll-policy", "hscroll-policy", "hscroll-policy", gtk_scrollable_policy_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_VADJUSTMENT_PROPERTY, animated_list_properties[ANIMATED_LIST_VADJUSTMENT_PROPERTY] = g_param_spec_object ("vadjustment", "vadjustment", "vadjustment", gtk_adjustment_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_VSCROLL_POLICY_PROPERTY, animated_list_properties[ANIMATED_LIST_VSCROLL_POLICY_PROPERTY] = g_param_spec_enum ("vscroll-policy", "vscroll-policy", "vscroll-policy", gtk_scrollable_policy_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_N_CHILDREN_PROPERTY, animated_list_properties[ANIMATED_LIST_N_CHILDREN_PROPERTY] = g_param_spec_uint ("n-children", "n-children", "n-children", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_CHILDREN_PROPERTY, animated_list_properties[ANIMATED_LIST_CHILDREN_PROPERTY] = g_param_spec_pointer ("children", "children", "children", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_VISIBLE_CHILDREN_PROPERTY, animated_list_properties[ANIMATED_LIST_VISIBLE_CHILDREN_PROPERTY] = g_param_spec_pointer ("visible-children", "visible-children", "visible-children", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Indicates if new / removed children should display an expand and shrink
	     * animation.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_TRANSITION_CHILDREN_PROPERTY, animated_list_properties[ANIMATED_LIST_TRANSITION_CHILDREN_PROPERTY] = g_param_spec_boolean ("transition-children", "transition-children", "transition-children", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/** Whether or not the list should display its items in a stack or not */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_USE_CARD_ANIMATION_PROPERTY, animated_list_properties[ANIMATED_LIST_USE_CARD_ANIMATION_PROPERTY] = g_param_spec_boolean ("use-card-animation", "use-card-animation", "use-card-animation", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/** The direction that the items should flow in */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_DIRECTION_PROPERTY, animated_list_properties[ANIMATED_LIST_DIRECTION_PROPERTY] = g_param_spec_enum ("direction", "direction", "direction", TYPE_ANIMATED_LIST_DIRECTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/** Scroll to the latest item added to the list */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_SCROLL_TO_APPEND_PROPERTY, animated_list_properties[ANIMATED_LIST_SCROLL_TO_APPEND_PROPERTY] = g_param_spec_boolean ("scroll-to-append", "scroll-to-append", "scroll-to-append", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/** The default item reveal animation type */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ANIMATION_REVEAL_TYPE_PROPERTY, animated_list_properties[ANIMATED_LIST_ANIMATION_REVEAL_TYPE_PROPERTY] = g_param_spec_enum ("animation-reveal-type", "animation-reveal-type", "animation-reveal-type", ANIMATED_LIST_ITEM_TYPE_REVEAL_ANIMATION_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/** The default item animation type */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ANIMATION_CHILD_TYPE_PROPERTY, animated_list_properties[ANIMATED_LIST_ANIMATION_CHILD_TYPE_PROPERTY] = g_param_spec_enum ("animation-child-type", "animation-child-type", "animation-child-type", ANIMATED_LIST_ITEM_TYPE_CHILD_ANIMATION_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
animated_list_gtk_scrollable_interface_init (GtkScrollableInterface * iface,
                                             gpointer iface_data)
{
	animated_list_gtk_scrollable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_border = (gboolean (*) (GtkScrollable*, GtkBorder*)) animated_list_real_get_border;
}

static void
animated_list_instance_init (AnimatedList * self,
                             gpointer klass)
{
	GtkSettings* _tmp0_;
	self->priv = animated_list_get_instance_private (self);
	self->priv->scroll_btm_anim_data = NULL;
	self->priv->scroll_top_anim_data = NULL;
	self->priv->scroll_comp_anim_data = NULL;
	self->priv->set_initial_scroll_value = FALSE;
	self->priv->fade_distance = 0.0f;
	_tmp0_ = gtk_settings_get_default ();
	self->priv->settings = _tmp0_;
	self->priv->scroll_to_source_id = (guint) 0;
}

static void
animated_list_finalize (GObject * obj)
{
	AnimatedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATED_LIST, AnimatedList);
	_g_object_unref0 (self->priv->_hadjustment);
	_g_object_unref0 (self->priv->_vadjustment);
	_g_object_unref0 (self->priv->scroll_btm_target);
	_g_object_unref0 (self->priv->scroll_btm_anim);
	_animation_data_free0 (self->priv->scroll_btm_anim_data);
	_g_object_unref0 (self->priv->scroll_top_target);
	_g_object_unref0 (self->priv->scroll_top_anim);
	_animation_data_free0 (self->priv->scroll_top_anim_data);
	_g_object_unref0 (self->priv->scroll_comp_target);
	_g_object_unref0 (self->priv->scroll_comp_anim);
	_animation_data_free0 (self->priv->scroll_comp_anim_data);
	G_OBJECT_CLASS (animated_list_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
animated_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AnimatedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animated_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnimatedList), 0, (GInstanceInitFunc) animated_list_instance_init, NULL };
	static const GInterfaceInfo gtk_scrollable_info = { (GInterfaceInitFunc) animated_list_gtk_scrollable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType animated_list_type_id;
	animated_list_type_id = g_type_register_static (gtk_widget_get_type (), "AnimatedList", &g_define_type_info, 0);
	g_type_add_interface_static (animated_list_type_id, gtk_scrollable_get_type (), &gtk_scrollable_info);
	AnimatedList_private_offset = g_type_add_instance_private (animated_list_type_id, sizeof (AnimatedListPrivate));
	return animated_list_type_id;
}

GType
animated_list_get_type (void)
{
	static gsize animated_list_type_id__once = 0;
	if (g_once_init_enter (&animated_list_type_id__once)) {
		GType animated_list_type_id;
		animated_list_type_id = animated_list_get_type_once ();
		g_once_init_leave (&animated_list_type_id__once, animated_list_type_id);
	}
	return animated_list_type_id__once;
}

static void
_vala_animated_list_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	AnimatedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATED_LIST, AnimatedList);
	switch (property_id) {
		case ANIMATED_LIST_HADJUSTMENT_PROPERTY:
		g_value_set_object (value, animated_list_real_get_hadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable)));
		break;
		case ANIMATED_LIST_HSCROLL_POLICY_PROPERTY:
		g_value_set_enum (value, animated_list_real_get_hscroll_policy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable)));
		break;
		case ANIMATED_LIST_VADJUSTMENT_PROPERTY:
		g_value_set_object (value, animated_list_real_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable)));
		break;
		case ANIMATED_LIST_VSCROLL_POLICY_PROPERTY:
		g_value_set_enum (value, animated_list_real_get_vscroll_policy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable)));
		break;
		case ANIMATED_LIST_N_CHILDREN_PROPERTY:
		g_value_set_uint (value, animated_list_get_n_children (self));
		break;
		case ANIMATED_LIST_CHILDREN_PROPERTY:
		g_value_set_pointer (value, animated_list_get_children (self));
		break;
		case ANIMATED_LIST_VISIBLE_CHILDREN_PROPERTY:
		g_value_set_pointer (value, animated_list_get_visible_children (self));
		break;
		case ANIMATED_LIST_TRANSITION_CHILDREN_PROPERTY:
		g_value_set_boolean (value, animated_list_get_transition_children (self));
		break;
		case ANIMATED_LIST_USE_CARD_ANIMATION_PROPERTY:
		g_value_set_boolean (value, animated_list_get_use_card_animation (self));
		break;
		case ANIMATED_LIST_DIRECTION_PROPERTY:
		g_value_set_enum (value, animated_list_get_direction (self));
		break;
		case ANIMATED_LIST_SCROLL_TO_APPEND_PROPERTY:
		g_value_set_boolean (value, animated_list_get_scroll_to_append (self));
		break;
		case ANIMATED_LIST_ANIMATION_REVEAL_TYPE_PROPERTY:
		g_value_set_enum (value, animated_list_get_animation_reveal_type (self));
		break;
		case ANIMATED_LIST_ANIMATION_CHILD_TYPE_PROPERTY:
		g_value_set_enum (value, animated_list_get_animation_child_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_animated_list_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	AnimatedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATED_LIST, AnimatedList);
	switch (property_id) {
		case ANIMATED_LIST_HADJUSTMENT_PROPERTY:
		animated_list_real_set_hadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable), g_value_get_object (value));
		break;
		case ANIMATED_LIST_HSCROLL_POLICY_PROPERTY:
		animated_list_real_set_hscroll_policy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable), g_value_get_enum (value));
		break;
		case ANIMATED_LIST_VADJUSTMENT_PROPERTY:
		animated_list_real_set_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable), g_value_get_object (value));
		break;
		case ANIMATED_LIST_VSCROLL_POLICY_PROPERTY:
		animated_list_real_set_vscroll_policy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrollable_get_type (), GtkScrollable), g_value_get_enum (value));
		break;
		case ANIMATED_LIST_N_CHILDREN_PROPERTY:
		animated_list_set_n_children (self, g_value_get_uint (value));
		break;
		case ANIMATED_LIST_CHILDREN_PROPERTY:
		animated_list_set_children (self, g_value_get_pointer (value));
		break;
		case ANIMATED_LIST_VISIBLE_CHILDREN_PROPERTY:
		animated_list_set_visible_children (self, g_value_get_pointer (value));
		break;
		case ANIMATED_LIST_TRANSITION_CHILDREN_PROPERTY:
		animated_list_set_transition_children (self, g_value_get_boolean (value));
		break;
		case ANIMATED_LIST_USE_CARD_ANIMATION_PROPERTY:
		animated_list_set_use_card_animation (self, g_value_get_boolean (value));
		break;
		case ANIMATED_LIST_DIRECTION_PROPERTY:
		animated_list_set_direction (self, g_value_get_enum (value));
		break;
		case ANIMATED_LIST_SCROLL_TO_APPEND_PROPERTY:
		animated_list_set_scroll_to_append (self, g_value_get_boolean (value));
		break;
		case ANIMATED_LIST_ANIMATION_REVEAL_TYPE_PROPERTY:
		animated_list_set_animation_reveal_type (self, g_value_get_enum (value));
		break;
		case ANIMATED_LIST_ANIMATION_CHILD_TYPE_PROPERTY:
		animated_list_set_animation_child_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

