/* server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_lsa.h"
#include <util/debug.h>

NTSTATUS dcerpc_server_lsarpc_init(TALLOC_CTX *);

/* lsarpc - dcerpc server boilerplate generated by pidl */


static NTSTATUS lsarpc__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_LSARPC_BIND
	return DCESRV_INTERFACE_LSARPC_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void lsarpc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_LSARPC_UNBIND
	DCESRV_INTERFACE_LSARPC_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS lsarpc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_lsarpc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_lsarpc.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_lsarpc.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_lsarpc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS lsarpc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct lsa_Close *r2 = (struct lsa_Close *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Close, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_Close(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Close will reply async\n"));
		}
		break;
	}
	case 1: {
		struct lsa_Delete *r2 = (struct lsa_Delete *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Delete, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_Delete(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Delete will reply async\n"));
		}
		break;
	}
	case 2: {
		struct lsa_EnumPrivs *r2 = (struct lsa_EnumPrivs *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumPrivs, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_EnumPrivs(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumPrivs will reply async\n"));
		}
		break;
	}
	case 3: {
		struct lsa_QuerySecurity *r2 = (struct lsa_QuerySecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QuerySecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_QuerySecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QuerySecurity will reply async\n"));
		}
		break;
	}
	case 4: {
		struct lsa_SetSecObj *r2 = (struct lsa_SetSecObj *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetSecObj, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetSecObj(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetSecObj will reply async\n"));
		}
		break;
	}
	case 5: {
		struct lsa_ChangePassword *r2 = (struct lsa_ChangePassword *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_ChangePassword, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_ChangePassword(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_ChangePassword will reply async\n"));
		}
		break;
	}
	case 6: {
		struct lsa_OpenPolicy *r2 = (struct lsa_OpenPolicy *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenPolicy, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_OpenPolicy(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenPolicy will reply async\n"));
		}
		break;
	}
	case 7: {
		struct lsa_QueryInfoPolicy *r2 = (struct lsa_QueryInfoPolicy *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryInfoPolicy, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_QueryInfoPolicy(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryInfoPolicy will reply async\n"));
		}
		break;
	}
	case 8: {
		struct lsa_SetInfoPolicy *r2 = (struct lsa_SetInfoPolicy *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetInfoPolicy, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetInfoPolicy(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetInfoPolicy will reply async\n"));
		}
		break;
	}
	case 9: {
		struct lsa_ClearAuditLog *r2 = (struct lsa_ClearAuditLog *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_ClearAuditLog, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_ClearAuditLog(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_ClearAuditLog will reply async\n"));
		}
		break;
	}
	case 10: {
		struct lsa_CreateAccount *r2 = (struct lsa_CreateAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CreateAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateAccount will reply async\n"));
		}
		break;
	}
	case 11: {
		struct lsa_EnumAccounts *r2 = (struct lsa_EnumAccounts *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumAccounts, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_EnumAccounts(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumAccounts will reply async\n"));
		}
		break;
	}
	case 12: {
		struct lsa_CreateTrustedDomain *r2 = (struct lsa_CreateTrustedDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateTrustedDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CreateTrustedDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateTrustedDomain will reply async\n"));
		}
		break;
	}
	case 13: {
		struct lsa_EnumTrustDom *r2 = (struct lsa_EnumTrustDom *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumTrustDom, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_EnumTrustDom(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumTrustDom will reply async\n"));
		}
		break;
	}
	case 14: {
		struct lsa_LookupNames *r2 = (struct lsa_LookupNames *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupNames, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupNames(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupNames will reply async\n"));
		}
		break;
	}
	case 15: {
		struct lsa_LookupSids *r2 = (struct lsa_LookupSids *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupSids, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupSids(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupSids will reply async\n"));
		}
		break;
	}
	case 16: {
		struct lsa_CreateSecret *r2 = (struct lsa_CreateSecret *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateSecret, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CreateSecret(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateSecret will reply async\n"));
		}
		break;
	}
	case 17: {
		struct lsa_OpenAccount *r2 = (struct lsa_OpenAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_OpenAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenAccount will reply async\n"));
		}
		break;
	}
	case 18: {
		struct lsa_EnumPrivsAccount *r2 = (struct lsa_EnumPrivsAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumPrivsAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_EnumPrivsAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumPrivsAccount will reply async\n"));
		}
		break;
	}
	case 19: {
		struct lsa_AddPrivilegesToAccount *r2 = (struct lsa_AddPrivilegesToAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_AddPrivilegesToAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_AddPrivilegesToAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_AddPrivilegesToAccount will reply async\n"));
		}
		break;
	}
	case 20: {
		struct lsa_RemovePrivilegesFromAccount *r2 = (struct lsa_RemovePrivilegesFromAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_RemovePrivilegesFromAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_RemovePrivilegesFromAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_RemovePrivilegesFromAccount will reply async\n"));
		}
		break;
	}
	case 21: {
		struct lsa_GetQuotasForAccount *r2 = (struct lsa_GetQuotasForAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_GetQuotasForAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_GetQuotasForAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_GetQuotasForAccount will reply async\n"));
		}
		break;
	}
	case 22: {
		struct lsa_SetQuotasForAccount *r2 = (struct lsa_SetQuotasForAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetQuotasForAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetQuotasForAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetQuotasForAccount will reply async\n"));
		}
		break;
	}
	case 23: {
		struct lsa_GetSystemAccessAccount *r2 = (struct lsa_GetSystemAccessAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_GetSystemAccessAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_GetSystemAccessAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_GetSystemAccessAccount will reply async\n"));
		}
		break;
	}
	case 24: {
		struct lsa_SetSystemAccessAccount *r2 = (struct lsa_SetSystemAccessAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetSystemAccessAccount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetSystemAccessAccount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetSystemAccessAccount will reply async\n"));
		}
		break;
	}
	case 25: {
		struct lsa_OpenTrustedDomain *r2 = (struct lsa_OpenTrustedDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenTrustedDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_OpenTrustedDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenTrustedDomain will reply async\n"));
		}
		break;
	}
	case 26: {
		struct lsa_QueryTrustedDomainInfo *r2 = (struct lsa_QueryTrustedDomainInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryTrustedDomainInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_QueryTrustedDomainInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryTrustedDomainInfo will reply async\n"));
		}
		break;
	}
	case 27: {
		struct lsa_SetInformationTrustedDomain *r2 = (struct lsa_SetInformationTrustedDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetInformationTrustedDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetInformationTrustedDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetInformationTrustedDomain will reply async\n"));
		}
		break;
	}
	case 28: {
		struct lsa_OpenSecret *r2 = (struct lsa_OpenSecret *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenSecret, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_OpenSecret(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenSecret will reply async\n"));
		}
		break;
	}
	case 29: {
		struct lsa_SetSecret *r2 = (struct lsa_SetSecret *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetSecret, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetSecret(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetSecret will reply async\n"));
		}
		break;
	}
	case 30: {
		struct lsa_QuerySecret *r2 = (struct lsa_QuerySecret *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QuerySecret, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_QuerySecret(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QuerySecret will reply async\n"));
		}
		break;
	}
	case 31: {
		struct lsa_LookupPrivValue *r2 = (struct lsa_LookupPrivValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupPrivValue, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupPrivValue(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupPrivValue will reply async\n"));
		}
		break;
	}
	case 32: {
		struct lsa_LookupPrivName *r2 = (struct lsa_LookupPrivName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupPrivName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupPrivName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupPrivName will reply async\n"));
		}
		break;
	}
	case 33: {
		struct lsa_LookupPrivDisplayName *r2 = (struct lsa_LookupPrivDisplayName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupPrivDisplayName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupPrivDisplayName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupPrivDisplayName will reply async\n"));
		}
		break;
	}
	case 34: {
		struct lsa_DeleteObject *r2 = (struct lsa_DeleteObject *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_DeleteObject, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_DeleteObject(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_DeleteObject will reply async\n"));
		}
		break;
	}
	case 35: {
		struct lsa_EnumAccountsWithUserRight *r2 = (struct lsa_EnumAccountsWithUserRight *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumAccountsWithUserRight, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_EnumAccountsWithUserRight(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumAccountsWithUserRight will reply async\n"));
		}
		break;
	}
	case 36: {
		struct lsa_EnumAccountRights *r2 = (struct lsa_EnumAccountRights *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumAccountRights, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_EnumAccountRights(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumAccountRights will reply async\n"));
		}
		break;
	}
	case 37: {
		struct lsa_AddAccountRights *r2 = (struct lsa_AddAccountRights *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_AddAccountRights, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_AddAccountRights(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_AddAccountRights will reply async\n"));
		}
		break;
	}
	case 38: {
		struct lsa_RemoveAccountRights *r2 = (struct lsa_RemoveAccountRights *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_RemoveAccountRights, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_RemoveAccountRights(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_RemoveAccountRights will reply async\n"));
		}
		break;
	}
	case 39: {
		struct lsa_QueryTrustedDomainInfoBySid *r2 = (struct lsa_QueryTrustedDomainInfoBySid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryTrustedDomainInfoBySid, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_QueryTrustedDomainInfoBySid(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryTrustedDomainInfoBySid will reply async\n"));
		}
		break;
	}
	case 40: {
		struct lsa_SetTrustedDomainInfo *r2 = (struct lsa_SetTrustedDomainInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetTrustedDomainInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetTrustedDomainInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetTrustedDomainInfo will reply async\n"));
		}
		break;
	}
	case 41: {
		struct lsa_DeleteTrustedDomain *r2 = (struct lsa_DeleteTrustedDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_DeleteTrustedDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_DeleteTrustedDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_DeleteTrustedDomain will reply async\n"));
		}
		break;
	}
	case 42: {
		struct lsa_StorePrivateData *r2 = (struct lsa_StorePrivateData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_StorePrivateData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_StorePrivateData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_StorePrivateData will reply async\n"));
		}
		break;
	}
	case 43: {
		struct lsa_RetrievePrivateData *r2 = (struct lsa_RetrievePrivateData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_RetrievePrivateData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_RetrievePrivateData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_RetrievePrivateData will reply async\n"));
		}
		break;
	}
	case 44: {
		struct lsa_OpenPolicy2 *r2 = (struct lsa_OpenPolicy2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenPolicy2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_OpenPolicy2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenPolicy2 will reply async\n"));
		}
		break;
	}
	case 45: {
		struct lsa_GetUserName *r2 = (struct lsa_GetUserName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_GetUserName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_GetUserName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_GetUserName will reply async\n"));
		}
		break;
	}
	case 46: {
		struct lsa_QueryInfoPolicy2 *r2 = (struct lsa_QueryInfoPolicy2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryInfoPolicy2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_QueryInfoPolicy2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryInfoPolicy2 will reply async\n"));
		}
		break;
	}
	case 47: {
		struct lsa_SetInfoPolicy2 *r2 = (struct lsa_SetInfoPolicy2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetInfoPolicy2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetInfoPolicy2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetInfoPolicy2 will reply async\n"));
		}
		break;
	}
	case 48: {
		struct lsa_QueryTrustedDomainInfoByName *r2 = (struct lsa_QueryTrustedDomainInfoByName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryTrustedDomainInfoByName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_QueryTrustedDomainInfoByName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryTrustedDomainInfoByName will reply async\n"));
		}
		break;
	}
	case 49: {
		struct lsa_SetTrustedDomainInfoByName *r2 = (struct lsa_SetTrustedDomainInfoByName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetTrustedDomainInfoByName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetTrustedDomainInfoByName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetTrustedDomainInfoByName will reply async\n"));
		}
		break;
	}
	case 50: {
		struct lsa_EnumTrustedDomainsEx *r2 = (struct lsa_EnumTrustedDomainsEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumTrustedDomainsEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_EnumTrustedDomainsEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumTrustedDomainsEx will reply async\n"));
		}
		break;
	}
	case 51: {
		struct lsa_CreateTrustedDomainEx *r2 = (struct lsa_CreateTrustedDomainEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateTrustedDomainEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CreateTrustedDomainEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateTrustedDomainEx will reply async\n"));
		}
		break;
	}
	case 52: {
		struct lsa_CloseTrustedDomainEx *r2 = (struct lsa_CloseTrustedDomainEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CloseTrustedDomainEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CloseTrustedDomainEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CloseTrustedDomainEx will reply async\n"));
		}
		break;
	}
	case 53: {
		struct lsa_QueryDomainInformationPolicy *r2 = (struct lsa_QueryDomainInformationPolicy *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryDomainInformationPolicy, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_QueryDomainInformationPolicy(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryDomainInformationPolicy will reply async\n"));
		}
		break;
	}
	case 54: {
		struct lsa_SetDomainInformationPolicy *r2 = (struct lsa_SetDomainInformationPolicy *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetDomainInformationPolicy, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_SetDomainInformationPolicy(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetDomainInformationPolicy will reply async\n"));
		}
		break;
	}
	case 55: {
		struct lsa_OpenTrustedDomainByName *r2 = (struct lsa_OpenTrustedDomainByName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenTrustedDomainByName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_OpenTrustedDomainByName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenTrustedDomainByName will reply async\n"));
		}
		break;
	}
	case 56: {
		struct lsa_TestCall *r2 = (struct lsa_TestCall *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_TestCall, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_TestCall(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_TestCall will reply async\n"));
		}
		break;
	}
	case 57: {
		struct lsa_LookupSids2 *r2 = (struct lsa_LookupSids2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupSids2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupSids2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupSids2 will reply async\n"));
		}
		break;
	}
	case 58: {
		struct lsa_LookupNames2 *r2 = (struct lsa_LookupNames2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupNames2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupNames2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupNames2 will reply async\n"));
		}
		break;
	}
	case 59: {
		struct lsa_CreateTrustedDomainEx2 *r2 = (struct lsa_CreateTrustedDomainEx2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateTrustedDomainEx2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CreateTrustedDomainEx2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateTrustedDomainEx2 will reply async\n"));
		}
		break;
	}
	case 60: {
		struct lsa_CREDRWRITE *r2 = (struct lsa_CREDRWRITE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRWRITE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRWRITE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRWRITE will reply async\n"));
		}
		break;
	}
	case 61: {
		struct lsa_CREDRREAD *r2 = (struct lsa_CREDRREAD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRREAD, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRREAD(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRREAD will reply async\n"));
		}
		break;
	}
	case 62: {
		struct lsa_CREDRENUMERATE *r2 = (struct lsa_CREDRENUMERATE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRENUMERATE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRENUMERATE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRENUMERATE will reply async\n"));
		}
		break;
	}
	case 63: {
		struct lsa_CREDRWRITEDOMAINCREDENTIALS *r2 = (struct lsa_CREDRWRITEDOMAINCREDENTIALS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRWRITEDOMAINCREDENTIALS(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRWRITEDOMAINCREDENTIALS will reply async\n"));
		}
		break;
	}
	case 64: {
		struct lsa_CREDRREADDOMAINCREDENTIALS *r2 = (struct lsa_CREDRREADDOMAINCREDENTIALS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRREADDOMAINCREDENTIALS(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRREADDOMAINCREDENTIALS will reply async\n"));
		}
		break;
	}
	case 65: {
		struct lsa_CREDRDELETE *r2 = (struct lsa_CREDRDELETE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRDELETE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRDELETE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRDELETE will reply async\n"));
		}
		break;
	}
	case 66: {
		struct lsa_CREDRGETTARGETINFO *r2 = (struct lsa_CREDRGETTARGETINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRGETTARGETINFO, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRGETTARGETINFO(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRGETTARGETINFO will reply async\n"));
		}
		break;
	}
	case 67: {
		struct lsa_CREDRPROFILELOADED *r2 = (struct lsa_CREDRPROFILELOADED *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRPROFILELOADED, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRPROFILELOADED(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRPROFILELOADED will reply async\n"));
		}
		break;
	}
	case 68: {
		struct lsa_LookupNames3 *r2 = (struct lsa_LookupNames3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupNames3, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupNames3(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupNames3 will reply async\n"));
		}
		break;
	}
	case 69: {
		struct lsa_CREDRGETSESSIONTYPES *r2 = (struct lsa_CREDRGETSESSIONTYPES *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRGETSESSIONTYPES, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRGETSESSIONTYPES(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRGETSESSIONTYPES will reply async\n"));
		}
		break;
	}
	case 70: {
		struct lsa_LSARREGISTERAUDITEVENT *r2 = (struct lsa_LSARREGISTERAUDITEVENT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARREGISTERAUDITEVENT, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LSARREGISTERAUDITEVENT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARREGISTERAUDITEVENT will reply async\n"));
		}
		break;
	}
	case 71: {
		struct lsa_LSARGENAUDITEVENT *r2 = (struct lsa_LSARGENAUDITEVENT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARGENAUDITEVENT, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LSARGENAUDITEVENT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARGENAUDITEVENT will reply async\n"));
		}
		break;
	}
	case 72: {
		struct lsa_LSARUNREGISTERAUDITEVENT *r2 = (struct lsa_LSARUNREGISTERAUDITEVENT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LSARUNREGISTERAUDITEVENT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARUNREGISTERAUDITEVENT will reply async\n"));
		}
		break;
	}
	case 73: {
		struct lsa_lsaRQueryForestTrustInformation *r2 = (struct lsa_lsaRQueryForestTrustInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_lsaRQueryForestTrustInformation, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_lsaRQueryForestTrustInformation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_lsaRQueryForestTrustInformation will reply async\n"));
		}
		break;
	}
	case 74: {
		struct lsa_lsaRSetForestTrustInformation *r2 = (struct lsa_lsaRSetForestTrustInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_lsaRSetForestTrustInformation, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_lsaRSetForestTrustInformation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_lsaRSetForestTrustInformation will reply async\n"));
		}
		break;
	}
	case 75: {
		struct lsa_CREDRRENAME *r2 = (struct lsa_CREDRRENAME *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRRENAME, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CREDRRENAME(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRRENAME will reply async\n"));
		}
		break;
	}
	case 76: {
		struct lsa_LookupSids3 *r2 = (struct lsa_LookupSids3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupSids3, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupSids3(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupSids3 will reply async\n"));
		}
		break;
	}
	case 77: {
		struct lsa_LookupNames4 *r2 = (struct lsa_LookupNames4 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupNames4, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LookupNames4(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupNames4 will reply async\n"));
		}
		break;
	}
	case 78: {
		struct lsa_LSAROPENPOLICYSCE *r2 = (struct lsa_LSAROPENPOLICYSCE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSAROPENPOLICYSCE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LSAROPENPOLICYSCE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSAROPENPOLICYSCE will reply async\n"));
		}
		break;
	}
	case 79: {
		struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r2 = (struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARADTREGISTERSECURITYEVENTSOURCE will reply async\n"));
		}
		break;
	}
	case 80: {
		struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r2 = (struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE will reply async\n"));
		}
		break;
	}
	case 81: {
		struct lsa_LSARADTREPORTSECURITYEVENT *r2 = (struct lsa_LSARADTREPORTSECURITYEVENT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_LSARADTREPORTSECURITYEVENT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARADTREPORTSECURITYEVENT will reply async\n"));
		}
		break;
	}
	case 82: {
		struct lsa_Opnum82NotUsedOnWire *r2 = (struct lsa_Opnum82NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum82NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum82NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum82NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 83: {
		struct lsa_Opnum83NotUsedOnWire *r2 = (struct lsa_Opnum83NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum83NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum83NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum83NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 84: {
		struct lsa_Opnum84NotUsedOnWire *r2 = (struct lsa_Opnum84NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum84NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum84NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum84NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 85: {
		struct lsa_Opnum85NotUsedOnWire *r2 = (struct lsa_Opnum85NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum85NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum85NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum85NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 86: {
		struct lsa_Opnum86NotUsedOnWire *r2 = (struct lsa_Opnum86NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum86NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum86NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum86NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 87: {
		struct lsa_Opnum87NotUsedOnWire *r2 = (struct lsa_Opnum87NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum87NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum87NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum87NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 88: {
		struct lsa_Opnum88NotUsedOnWire *r2 = (struct lsa_Opnum88NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum88NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum88NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum88NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 89: {
		struct lsa_Opnum89NotUsedOnWire *r2 = (struct lsa_Opnum89NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum89NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum89NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum89NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 90: {
		struct lsa_Opnum90NotUsedOnWire *r2 = (struct lsa_Opnum90NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum90NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum90NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum90NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 91: {
		struct lsa_Opnum91NotUsedOnWire *r2 = (struct lsa_Opnum91NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum91NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum91NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum91NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 92: {
		struct lsa_Opnum92NotUsedOnWire *r2 = (struct lsa_Opnum92NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum92NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum92NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum92NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 93: {
		struct lsa_Opnum93NotUsedOnWire *r2 = (struct lsa_Opnum93NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum93NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum93NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum93NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 94: {
		struct lsa_Opnum94NotUsedOnWire *r2 = (struct lsa_Opnum94NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum94NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum94NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum94NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 95: {
		struct lsa_Opnum95NotUsedOnWire *r2 = (struct lsa_Opnum95NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum95NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum95NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum95NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 96: {
		struct lsa_Opnum96NotUsedOnWire *r2 = (struct lsa_Opnum96NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum96NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum96NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum96NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 97: {
		struct lsa_Opnum97NotUsedOnWire *r2 = (struct lsa_Opnum97NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum97NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum97NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum97NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 98: {
		struct lsa_Opnum98NotUsedOnWire *r2 = (struct lsa_Opnum98NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum98NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum98NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum98NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 99: {
		struct lsa_Opnum99NotUsedOnWire *r2 = (struct lsa_Opnum99NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum99NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum99NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum99NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 100: {
		struct lsa_Opnum100NotUsedOnWire *r2 = (struct lsa_Opnum100NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum100NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum100NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum100NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 101: {
		struct lsa_Opnum101NotUsedOnWire *r2 = (struct lsa_Opnum101NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum101NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum101NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum101NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 102: {
		struct lsa_Opnum102NotUsedOnWire *r2 = (struct lsa_Opnum102NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum102NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum102NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum102NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 103: {
		struct lsa_Opnum103NotUsedOnWire *r2 = (struct lsa_Opnum103NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum103NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum103NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum103NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 104: {
		struct lsa_Opnum104NotUsedOnWire *r2 = (struct lsa_Opnum104NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum104NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum104NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum104NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 105: {
		struct lsa_Opnum105NotUsedOnWire *r2 = (struct lsa_Opnum105NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum105NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum105NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum105NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 106: {
		struct lsa_Opnum106NotUsedOnWire *r2 = (struct lsa_Opnum106NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum106NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum106NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum106NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 107: {
		struct lsa_Opnum107NotUsedOnWire *r2 = (struct lsa_Opnum107NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum107NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum107NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum107NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 108: {
		struct lsa_Opnum108NotUsedOnWire *r2 = (struct lsa_Opnum108NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum108NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum108NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum108NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 109: {
		struct lsa_Opnum109NotUsedOnWire *r2 = (struct lsa_Opnum109NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum109NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum109NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum109NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 110: {
		struct lsa_Opnum110NotUsedOnWire *r2 = (struct lsa_Opnum110NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum110NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum110NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum110NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 111: {
		struct lsa_Opnum111NotUsedOnWire *r2 = (struct lsa_Opnum111NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum111NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum111NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum111NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 112: {
		struct lsa_Opnum112NotUsedOnWire *r2 = (struct lsa_Opnum112NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum112NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum112NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum112NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 113: {
		struct lsa_Opnum113NotUsedOnWire *r2 = (struct lsa_Opnum113NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum113NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum113NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum113NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 114: {
		struct lsa_Opnum114NotUsedOnWire *r2 = (struct lsa_Opnum114NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum114NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum114NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum114NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 115: {
		struct lsa_Opnum115NotUsedOnWire *r2 = (struct lsa_Opnum115NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum115NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum115NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum115NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 116: {
		struct lsa_Opnum116NotUsedOnWire *r2 = (struct lsa_Opnum116NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum116NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum116NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum116NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 117: {
		struct lsa_Opnum117NotUsedOnWire *r2 = (struct lsa_Opnum117NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum117NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum117NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum117NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 118: {
		struct lsa_Opnum118NotUsedOnWire *r2 = (struct lsa_Opnum118NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum118NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum118NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum118NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 119: {
		struct lsa_Opnum119NotUsedOnWire *r2 = (struct lsa_Opnum119NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum119NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum119NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum119NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 120: {
		struct lsa_Opnum120NotUsedOnWire *r2 = (struct lsa_Opnum120NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum120NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum120NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum120NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 121: {
		struct lsa_Opnum121NotUsedOnWire *r2 = (struct lsa_Opnum121NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum121NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum121NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum121NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 122: {
		struct lsa_Opnum122NotUsedOnWire *r2 = (struct lsa_Opnum122NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum122NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum122NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum122NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 123: {
		struct lsa_Opnum123NotUsedOnWire *r2 = (struct lsa_Opnum123NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum123NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum123NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum123NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 124: {
		struct lsa_Opnum124NotUsedOnWire *r2 = (struct lsa_Opnum124NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum124NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum124NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum124NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 125: {
		struct lsa_Opnum125NotUsedOnWire *r2 = (struct lsa_Opnum125NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum125NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum125NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum125NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 126: {
		struct lsa_Opnum126NotUsedOnWire *r2 = (struct lsa_Opnum126NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum126NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum126NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum126NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 127: {
		struct lsa_Opnum127NotUsedOnWire *r2 = (struct lsa_Opnum127NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum127NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum127NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum127NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 128: {
		struct lsa_Opnum128NotUsedOnWire *r2 = (struct lsa_Opnum128NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum128NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum128NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum128NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 129: {
		struct lsa_CreateTrustedDomainEx3 *r2 = (struct lsa_CreateTrustedDomainEx3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateTrustedDomainEx3, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_CreateTrustedDomainEx3(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateTrustedDomainEx3 will reply async\n"));
		}
		break;
	}
	case 130: {
		struct lsa_OpenPolicy3 *r2 = (struct lsa_OpenPolicy3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenPolicy3, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_OpenPolicy3(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenPolicy3 will reply async\n"));
		}
		break;
	}
	case 131: {
		struct lsa_Opnum131NotUsedOnWire *r2 = (struct lsa_Opnum131NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum131NotUsedOnWire, NDR_IN, r2);
		}
		dcesrv_lsa_Opnum131NotUsedOnWire(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum131NotUsedOnWire will reply async\n"));
		}
		break;
	}
	case 132: {
		struct lsa_lsaRQueryForestTrustInformation2 *r2 = (struct lsa_lsaRQueryForestTrustInformation2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_lsaRQueryForestTrustInformation2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_lsaRQueryForestTrustInformation2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_lsaRQueryForestTrustInformation2 will reply async\n"));
		}
		break;
	}
	case 133: {
		struct lsa_lsaRSetForestTrustInformation2 *r2 = (struct lsa_lsaRSetForestTrustInformation2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_lsaRSetForestTrustInformation2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_lsa_lsaRSetForestTrustInformation2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_lsaRSetForestTrustInformation2 will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS lsarpc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct lsa_Close *r2 = (struct lsa_Close *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Close replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Close, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Close\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct lsa_Delete *r2 = (struct lsa_Delete *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Delete replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Delete, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Delete\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct lsa_EnumPrivs *r2 = (struct lsa_EnumPrivs *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumPrivs replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumPrivs, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_EnumPrivs\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct lsa_QuerySecurity *r2 = (struct lsa_QuerySecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QuerySecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QuerySecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_QuerySecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct lsa_SetSecObj *r2 = (struct lsa_SetSecObj *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetSecObj replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetSecObj, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetSecObj\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct lsa_ChangePassword *r2 = (struct lsa_ChangePassword *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_ChangePassword replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_ChangePassword, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_ChangePassword\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct lsa_OpenPolicy *r2 = (struct lsa_OpenPolicy *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenPolicy replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenPolicy, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_OpenPolicy\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct lsa_QueryInfoPolicy *r2 = (struct lsa_QueryInfoPolicy *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryInfoPolicy replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryInfoPolicy, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_QueryInfoPolicy\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct lsa_SetInfoPolicy *r2 = (struct lsa_SetInfoPolicy *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetInfoPolicy replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetInfoPolicy, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetInfoPolicy\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct lsa_ClearAuditLog *r2 = (struct lsa_ClearAuditLog *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_ClearAuditLog replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_ClearAuditLog, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_ClearAuditLog\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct lsa_CreateAccount *r2 = (struct lsa_CreateAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CreateAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct lsa_EnumAccounts *r2 = (struct lsa_EnumAccounts *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumAccounts replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumAccounts, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_EnumAccounts\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct lsa_CreateTrustedDomain *r2 = (struct lsa_CreateTrustedDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateTrustedDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateTrustedDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CreateTrustedDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct lsa_EnumTrustDom *r2 = (struct lsa_EnumTrustDom *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumTrustDom replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumTrustDom, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_EnumTrustDom\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct lsa_LookupNames *r2 = (struct lsa_LookupNames *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupNames replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupNames, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupNames\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct lsa_LookupSids *r2 = (struct lsa_LookupSids *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupSids replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupSids, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupSids\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct lsa_CreateSecret *r2 = (struct lsa_CreateSecret *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateSecret replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateSecret, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CreateSecret\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct lsa_OpenAccount *r2 = (struct lsa_OpenAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_OpenAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct lsa_EnumPrivsAccount *r2 = (struct lsa_EnumPrivsAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumPrivsAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumPrivsAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_EnumPrivsAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct lsa_AddPrivilegesToAccount *r2 = (struct lsa_AddPrivilegesToAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_AddPrivilegesToAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_AddPrivilegesToAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_AddPrivilegesToAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct lsa_RemovePrivilegesFromAccount *r2 = (struct lsa_RemovePrivilegesFromAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_RemovePrivilegesFromAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_RemovePrivilegesFromAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_RemovePrivilegesFromAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct lsa_GetQuotasForAccount *r2 = (struct lsa_GetQuotasForAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_GetQuotasForAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_GetQuotasForAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_GetQuotasForAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct lsa_SetQuotasForAccount *r2 = (struct lsa_SetQuotasForAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetQuotasForAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetQuotasForAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetQuotasForAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct lsa_GetSystemAccessAccount *r2 = (struct lsa_GetSystemAccessAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_GetSystemAccessAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_GetSystemAccessAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_GetSystemAccessAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct lsa_SetSystemAccessAccount *r2 = (struct lsa_SetSystemAccessAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetSystemAccessAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetSystemAccessAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetSystemAccessAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct lsa_OpenTrustedDomain *r2 = (struct lsa_OpenTrustedDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenTrustedDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenTrustedDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_OpenTrustedDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct lsa_QueryTrustedDomainInfo *r2 = (struct lsa_QueryTrustedDomainInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryTrustedDomainInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryTrustedDomainInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_QueryTrustedDomainInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct lsa_SetInformationTrustedDomain *r2 = (struct lsa_SetInformationTrustedDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetInformationTrustedDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetInformationTrustedDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetInformationTrustedDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct lsa_OpenSecret *r2 = (struct lsa_OpenSecret *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenSecret replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenSecret, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_OpenSecret\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct lsa_SetSecret *r2 = (struct lsa_SetSecret *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetSecret replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetSecret, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetSecret\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct lsa_QuerySecret *r2 = (struct lsa_QuerySecret *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QuerySecret replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QuerySecret, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_QuerySecret\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 31: {
		struct lsa_LookupPrivValue *r2 = (struct lsa_LookupPrivValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupPrivValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupPrivValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupPrivValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 32: {
		struct lsa_LookupPrivName *r2 = (struct lsa_LookupPrivName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupPrivName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupPrivName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupPrivName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 33: {
		struct lsa_LookupPrivDisplayName *r2 = (struct lsa_LookupPrivDisplayName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupPrivDisplayName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupPrivDisplayName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupPrivDisplayName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 34: {
		struct lsa_DeleteObject *r2 = (struct lsa_DeleteObject *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_DeleteObject replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_DeleteObject, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_DeleteObject\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 35: {
		struct lsa_EnumAccountsWithUserRight *r2 = (struct lsa_EnumAccountsWithUserRight *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumAccountsWithUserRight replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumAccountsWithUserRight, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_EnumAccountsWithUserRight\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 36: {
		struct lsa_EnumAccountRights *r2 = (struct lsa_EnumAccountRights *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumAccountRights replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumAccountRights, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_EnumAccountRights\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 37: {
		struct lsa_AddAccountRights *r2 = (struct lsa_AddAccountRights *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_AddAccountRights replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_AddAccountRights, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_AddAccountRights\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 38: {
		struct lsa_RemoveAccountRights *r2 = (struct lsa_RemoveAccountRights *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_RemoveAccountRights replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_RemoveAccountRights, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_RemoveAccountRights\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 39: {
		struct lsa_QueryTrustedDomainInfoBySid *r2 = (struct lsa_QueryTrustedDomainInfoBySid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryTrustedDomainInfoBySid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryTrustedDomainInfoBySid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_QueryTrustedDomainInfoBySid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 40: {
		struct lsa_SetTrustedDomainInfo *r2 = (struct lsa_SetTrustedDomainInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetTrustedDomainInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetTrustedDomainInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetTrustedDomainInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 41: {
		struct lsa_DeleteTrustedDomain *r2 = (struct lsa_DeleteTrustedDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_DeleteTrustedDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_DeleteTrustedDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_DeleteTrustedDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 42: {
		struct lsa_StorePrivateData *r2 = (struct lsa_StorePrivateData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_StorePrivateData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_StorePrivateData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_StorePrivateData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 43: {
		struct lsa_RetrievePrivateData *r2 = (struct lsa_RetrievePrivateData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_RetrievePrivateData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_RetrievePrivateData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_RetrievePrivateData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 44: {
		struct lsa_OpenPolicy2 *r2 = (struct lsa_OpenPolicy2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenPolicy2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenPolicy2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_OpenPolicy2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 45: {
		struct lsa_GetUserName *r2 = (struct lsa_GetUserName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_GetUserName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_GetUserName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_GetUserName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 46: {
		struct lsa_QueryInfoPolicy2 *r2 = (struct lsa_QueryInfoPolicy2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryInfoPolicy2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryInfoPolicy2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_QueryInfoPolicy2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 47: {
		struct lsa_SetInfoPolicy2 *r2 = (struct lsa_SetInfoPolicy2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetInfoPolicy2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetInfoPolicy2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetInfoPolicy2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 48: {
		struct lsa_QueryTrustedDomainInfoByName *r2 = (struct lsa_QueryTrustedDomainInfoByName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryTrustedDomainInfoByName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryTrustedDomainInfoByName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_QueryTrustedDomainInfoByName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 49: {
		struct lsa_SetTrustedDomainInfoByName *r2 = (struct lsa_SetTrustedDomainInfoByName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetTrustedDomainInfoByName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetTrustedDomainInfoByName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetTrustedDomainInfoByName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 50: {
		struct lsa_EnumTrustedDomainsEx *r2 = (struct lsa_EnumTrustedDomainsEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_EnumTrustedDomainsEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_EnumTrustedDomainsEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_EnumTrustedDomainsEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 51: {
		struct lsa_CreateTrustedDomainEx *r2 = (struct lsa_CreateTrustedDomainEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateTrustedDomainEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateTrustedDomainEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CreateTrustedDomainEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 52: {
		struct lsa_CloseTrustedDomainEx *r2 = (struct lsa_CloseTrustedDomainEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CloseTrustedDomainEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CloseTrustedDomainEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CloseTrustedDomainEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 53: {
		struct lsa_QueryDomainInformationPolicy *r2 = (struct lsa_QueryDomainInformationPolicy *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_QueryDomainInformationPolicy replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_QueryDomainInformationPolicy, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_QueryDomainInformationPolicy\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 54: {
		struct lsa_SetDomainInformationPolicy *r2 = (struct lsa_SetDomainInformationPolicy *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_SetDomainInformationPolicy replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_SetDomainInformationPolicy, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_SetDomainInformationPolicy\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 55: {
		struct lsa_OpenTrustedDomainByName *r2 = (struct lsa_OpenTrustedDomainByName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenTrustedDomainByName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenTrustedDomainByName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_OpenTrustedDomainByName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 56: {
		struct lsa_TestCall *r2 = (struct lsa_TestCall *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_TestCall replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_TestCall, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_TestCall\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 57: {
		struct lsa_LookupSids2 *r2 = (struct lsa_LookupSids2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupSids2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupSids2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupSids2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 58: {
		struct lsa_LookupNames2 *r2 = (struct lsa_LookupNames2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupNames2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupNames2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupNames2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 59: {
		struct lsa_CreateTrustedDomainEx2 *r2 = (struct lsa_CreateTrustedDomainEx2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateTrustedDomainEx2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateTrustedDomainEx2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CreateTrustedDomainEx2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 60: {
		struct lsa_CREDRWRITE *r2 = (struct lsa_CREDRWRITE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRWRITE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRWRITE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRWRITE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 61: {
		struct lsa_CREDRREAD *r2 = (struct lsa_CREDRREAD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRREAD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRREAD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRREAD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 62: {
		struct lsa_CREDRENUMERATE *r2 = (struct lsa_CREDRENUMERATE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRENUMERATE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRENUMERATE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRENUMERATE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 63: {
		struct lsa_CREDRWRITEDOMAINCREDENTIALS *r2 = (struct lsa_CREDRWRITEDOMAINCREDENTIALS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRWRITEDOMAINCREDENTIALS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRWRITEDOMAINCREDENTIALS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 64: {
		struct lsa_CREDRREADDOMAINCREDENTIALS *r2 = (struct lsa_CREDRREADDOMAINCREDENTIALS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRREADDOMAINCREDENTIALS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRREADDOMAINCREDENTIALS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 65: {
		struct lsa_CREDRDELETE *r2 = (struct lsa_CREDRDELETE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRDELETE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRDELETE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRDELETE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 66: {
		struct lsa_CREDRGETTARGETINFO *r2 = (struct lsa_CREDRGETTARGETINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRGETTARGETINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRGETTARGETINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRGETTARGETINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 67: {
		struct lsa_CREDRPROFILELOADED *r2 = (struct lsa_CREDRPROFILELOADED *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRPROFILELOADED replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRPROFILELOADED, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRPROFILELOADED\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 68: {
		struct lsa_LookupNames3 *r2 = (struct lsa_LookupNames3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupNames3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupNames3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupNames3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 69: {
		struct lsa_CREDRGETSESSIONTYPES *r2 = (struct lsa_CREDRGETSESSIONTYPES *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRGETSESSIONTYPES replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRGETSESSIONTYPES, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRGETSESSIONTYPES\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 70: {
		struct lsa_LSARREGISTERAUDITEVENT *r2 = (struct lsa_LSARREGISTERAUDITEVENT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARREGISTERAUDITEVENT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARREGISTERAUDITEVENT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LSARREGISTERAUDITEVENT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 71: {
		struct lsa_LSARGENAUDITEVENT *r2 = (struct lsa_LSARGENAUDITEVENT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARGENAUDITEVENT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARGENAUDITEVENT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LSARGENAUDITEVENT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 72: {
		struct lsa_LSARUNREGISTERAUDITEVENT *r2 = (struct lsa_LSARUNREGISTERAUDITEVENT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARUNREGISTERAUDITEVENT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LSARUNREGISTERAUDITEVENT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 73: {
		struct lsa_lsaRQueryForestTrustInformation *r2 = (struct lsa_lsaRQueryForestTrustInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_lsaRQueryForestTrustInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_lsaRQueryForestTrustInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_lsaRQueryForestTrustInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 74: {
		struct lsa_lsaRSetForestTrustInformation *r2 = (struct lsa_lsaRSetForestTrustInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_lsaRSetForestTrustInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_lsaRSetForestTrustInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_lsaRSetForestTrustInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 75: {
		struct lsa_CREDRRENAME *r2 = (struct lsa_CREDRRENAME *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CREDRRENAME replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CREDRRENAME, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CREDRRENAME\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 76: {
		struct lsa_LookupSids3 *r2 = (struct lsa_LookupSids3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupSids3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupSids3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupSids3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 77: {
		struct lsa_LookupNames4 *r2 = (struct lsa_LookupNames4 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LookupNames4 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LookupNames4, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LookupNames4\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 78: {
		struct lsa_LSAROPENPOLICYSCE *r2 = (struct lsa_LSAROPENPOLICYSCE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSAROPENPOLICYSCE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSAROPENPOLICYSCE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LSAROPENPOLICYSCE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 79: {
		struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r2 = (struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARADTREGISTERSECURITYEVENTSOURCE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LSARADTREGISTERSECURITYEVENTSOURCE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 80: {
		struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r2 = (struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 81: {
		struct lsa_LSARADTREPORTSECURITYEVENT *r2 = (struct lsa_LSARADTREPORTSECURITYEVENT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_LSARADTREPORTSECURITYEVENT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_LSARADTREPORTSECURITYEVENT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 82: {
		struct lsa_Opnum82NotUsedOnWire *r2 = (struct lsa_Opnum82NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum82NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum82NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum82NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 83: {
		struct lsa_Opnum83NotUsedOnWire *r2 = (struct lsa_Opnum83NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum83NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum83NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum83NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 84: {
		struct lsa_Opnum84NotUsedOnWire *r2 = (struct lsa_Opnum84NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum84NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum84NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum84NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 85: {
		struct lsa_Opnum85NotUsedOnWire *r2 = (struct lsa_Opnum85NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum85NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum85NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum85NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 86: {
		struct lsa_Opnum86NotUsedOnWire *r2 = (struct lsa_Opnum86NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum86NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum86NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum86NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 87: {
		struct lsa_Opnum87NotUsedOnWire *r2 = (struct lsa_Opnum87NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum87NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum87NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum87NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 88: {
		struct lsa_Opnum88NotUsedOnWire *r2 = (struct lsa_Opnum88NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum88NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum88NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum88NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 89: {
		struct lsa_Opnum89NotUsedOnWire *r2 = (struct lsa_Opnum89NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum89NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum89NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum89NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 90: {
		struct lsa_Opnum90NotUsedOnWire *r2 = (struct lsa_Opnum90NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum90NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum90NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum90NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 91: {
		struct lsa_Opnum91NotUsedOnWire *r2 = (struct lsa_Opnum91NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum91NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum91NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum91NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 92: {
		struct lsa_Opnum92NotUsedOnWire *r2 = (struct lsa_Opnum92NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum92NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum92NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum92NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 93: {
		struct lsa_Opnum93NotUsedOnWire *r2 = (struct lsa_Opnum93NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum93NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum93NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum93NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 94: {
		struct lsa_Opnum94NotUsedOnWire *r2 = (struct lsa_Opnum94NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum94NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum94NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum94NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 95: {
		struct lsa_Opnum95NotUsedOnWire *r2 = (struct lsa_Opnum95NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum95NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum95NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum95NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 96: {
		struct lsa_Opnum96NotUsedOnWire *r2 = (struct lsa_Opnum96NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum96NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum96NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum96NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 97: {
		struct lsa_Opnum97NotUsedOnWire *r2 = (struct lsa_Opnum97NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum97NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum97NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum97NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 98: {
		struct lsa_Opnum98NotUsedOnWire *r2 = (struct lsa_Opnum98NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum98NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum98NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum98NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 99: {
		struct lsa_Opnum99NotUsedOnWire *r2 = (struct lsa_Opnum99NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum99NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum99NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum99NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 100: {
		struct lsa_Opnum100NotUsedOnWire *r2 = (struct lsa_Opnum100NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum100NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum100NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum100NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 101: {
		struct lsa_Opnum101NotUsedOnWire *r2 = (struct lsa_Opnum101NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum101NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum101NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum101NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 102: {
		struct lsa_Opnum102NotUsedOnWire *r2 = (struct lsa_Opnum102NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum102NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum102NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum102NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 103: {
		struct lsa_Opnum103NotUsedOnWire *r2 = (struct lsa_Opnum103NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum103NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum103NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum103NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 104: {
		struct lsa_Opnum104NotUsedOnWire *r2 = (struct lsa_Opnum104NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum104NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum104NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum104NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 105: {
		struct lsa_Opnum105NotUsedOnWire *r2 = (struct lsa_Opnum105NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum105NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum105NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum105NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 106: {
		struct lsa_Opnum106NotUsedOnWire *r2 = (struct lsa_Opnum106NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum106NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum106NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum106NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 107: {
		struct lsa_Opnum107NotUsedOnWire *r2 = (struct lsa_Opnum107NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum107NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum107NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum107NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 108: {
		struct lsa_Opnum108NotUsedOnWire *r2 = (struct lsa_Opnum108NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum108NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum108NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum108NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 109: {
		struct lsa_Opnum109NotUsedOnWire *r2 = (struct lsa_Opnum109NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum109NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum109NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum109NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 110: {
		struct lsa_Opnum110NotUsedOnWire *r2 = (struct lsa_Opnum110NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum110NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum110NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum110NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 111: {
		struct lsa_Opnum111NotUsedOnWire *r2 = (struct lsa_Opnum111NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum111NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum111NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum111NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 112: {
		struct lsa_Opnum112NotUsedOnWire *r2 = (struct lsa_Opnum112NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum112NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum112NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum112NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 113: {
		struct lsa_Opnum113NotUsedOnWire *r2 = (struct lsa_Opnum113NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum113NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum113NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum113NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 114: {
		struct lsa_Opnum114NotUsedOnWire *r2 = (struct lsa_Opnum114NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum114NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum114NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum114NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 115: {
		struct lsa_Opnum115NotUsedOnWire *r2 = (struct lsa_Opnum115NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum115NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum115NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum115NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 116: {
		struct lsa_Opnum116NotUsedOnWire *r2 = (struct lsa_Opnum116NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum116NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum116NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum116NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 117: {
		struct lsa_Opnum117NotUsedOnWire *r2 = (struct lsa_Opnum117NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum117NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum117NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum117NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 118: {
		struct lsa_Opnum118NotUsedOnWire *r2 = (struct lsa_Opnum118NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum118NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum118NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum118NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 119: {
		struct lsa_Opnum119NotUsedOnWire *r2 = (struct lsa_Opnum119NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum119NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum119NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum119NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 120: {
		struct lsa_Opnum120NotUsedOnWire *r2 = (struct lsa_Opnum120NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum120NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum120NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum120NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 121: {
		struct lsa_Opnum121NotUsedOnWire *r2 = (struct lsa_Opnum121NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum121NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum121NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum121NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 122: {
		struct lsa_Opnum122NotUsedOnWire *r2 = (struct lsa_Opnum122NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum122NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum122NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum122NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 123: {
		struct lsa_Opnum123NotUsedOnWire *r2 = (struct lsa_Opnum123NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum123NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum123NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum123NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 124: {
		struct lsa_Opnum124NotUsedOnWire *r2 = (struct lsa_Opnum124NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum124NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum124NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum124NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 125: {
		struct lsa_Opnum125NotUsedOnWire *r2 = (struct lsa_Opnum125NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum125NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum125NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum125NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 126: {
		struct lsa_Opnum126NotUsedOnWire *r2 = (struct lsa_Opnum126NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum126NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum126NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum126NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 127: {
		struct lsa_Opnum127NotUsedOnWire *r2 = (struct lsa_Opnum127NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum127NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum127NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum127NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 128: {
		struct lsa_Opnum128NotUsedOnWire *r2 = (struct lsa_Opnum128NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum128NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum128NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum128NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 129: {
		struct lsa_CreateTrustedDomainEx3 *r2 = (struct lsa_CreateTrustedDomainEx3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_CreateTrustedDomainEx3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_CreateTrustedDomainEx3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_CreateTrustedDomainEx3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 130: {
		struct lsa_OpenPolicy3 *r2 = (struct lsa_OpenPolicy3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_OpenPolicy3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_OpenPolicy3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_OpenPolicy3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 131: {
		struct lsa_Opnum131NotUsedOnWire *r2 = (struct lsa_Opnum131NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_Opnum131NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_Opnum131NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_Opnum131NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 132: {
		struct lsa_lsaRQueryForestTrustInformation2 *r2 = (struct lsa_lsaRQueryForestTrustInformation2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_lsaRQueryForestTrustInformation2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_lsaRQueryForestTrustInformation2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_lsaRQueryForestTrustInformation2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 133: {
		struct lsa_lsaRSetForestTrustInformation2 *r2 = (struct lsa_lsaRSetForestTrustInformation2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function lsa_lsaRSetForestTrustInformation2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(lsa_lsaRSetForestTrustInformation2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in lsa_lsaRSetForestTrustInformation2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS lsarpc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_lsarpc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface dcesrv_lsarpc_interface = {
	.name		    = "lsarpc",
	.syntax_id          = {{0x12345778,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0x89,0xab}},0.0},
	.bind		    = lsarpc__op_bind,
	.unbind		    = lsarpc__op_unbind,
	.ndr_pull	    = lsarpc__op_ndr_pull,
	.dispatch	    = lsarpc__op_dispatch,
	.reply		    = lsarpc__op_reply,
	.ndr_push	    = lsarpc__op_ndr_push,
	.local		    = NULL,
#ifdef DCESRV_INTERFACE_LSARPC_FLAGS
	.flags              = DCESRV_INTERFACE_LSARPC_FLAGS
#else
	.flags              = 0
#endif
};


static NTSTATUS lsarpc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;
#ifdef DCESRV_INTERFACE_LSARPC_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint =
		DCESRV_INTERFACE_LSARPC_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_lsarpc.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_lsarpc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx,
						name,
						ncacn_np_secondary_endpoint,
						&dcesrv_lsarpc_interface,
						NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("lsarpc_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS lsarpc__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool lsarpc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_lsarpc_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_lsarpc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_lsarpc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool lsarpc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_lsarpc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_lsarpc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_lsarpc_init(TALLOC_CTX *ctx)
{
	NTSTATUS ret;
	static const struct dcesrv_endpoint_server ep_server = {
	    /* fill in our name */
	    .name = "lsarpc",

	    /* Initialization flag */
	    .initialized = false,

	    /* fill in all the operations */
#ifdef DCESRV_INTERFACE_LSARPC_INIT_SERVER
	    .init_server = DCESRV_INTERFACE_LSARPC_INIT_SERVER,
#else
	    .init_server = lsarpc__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_LSARPC_SHUTDOWN_SERVER
	    .shutdown_server = DCESRV_INTERFACE_LSARPC_SHUTDOWN_SERVER,
#else
	    .shutdown_server = lsarpc__op_shutdown_server,
#endif
	    .interface_by_uuid = lsarpc__op_interface_by_uuid,
	    .interface_by_name = lsarpc__op_interface_by_name
	};
	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'lsarpc' endpoint server!\n"));
		return ret;
	}

	return ret;
}

