
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_tpm20_rsakey_blob.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject TPMT_RSA_SCHEME_Type;
static PyTypeObject TPMS_RSA_PARMS_Type;
static PyTypeObject TPM2B_PUBLIC_KEY_RSA_Type;
static PyTypeObject TPM2B_DIGEST_Type;
static PyTypeObject TPM2B_PUBLIC_Type;
static PyTypeObject TPM20_RSAKEY_BLOB_Type;

static PyTypeObject *BaseObject_Type;

static PyObject *py_TPMT_RSA_SCHEME_get_scheme(PyObject *obj, void *closure)
{
	struct TPMT_RSA_SCHEME *object = pytalloc_get_ptr(obj);
	PyObject *py_scheme;
	py_scheme = PyLong_FromLong((uint16_t)(object->scheme));
	return py_scheme;
}

static int py_TPMT_RSA_SCHEME_set_scheme(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPMT_RSA_SCHEME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->scheme");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->scheme));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->scheme = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPMT_RSA_SCHEME_get_hash_algorithm(PyObject *obj, void *closure)
{
	struct TPMT_RSA_SCHEME *object = pytalloc_get_ptr(obj);
	PyObject *py_hash_algorithm;
	py_hash_algorithm = PyLong_FromLong((uint16_t)(object->hash_algorithm));
	return py_hash_algorithm;
}

static int py_TPMT_RSA_SCHEME_set_hash_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPMT_RSA_SCHEME *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hash_algorithm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->hash_algorithm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->hash_algorithm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_TPMT_RSA_SCHEME_getsetters[] = {
	{
		.name = discard_const_p(char, "scheme"),
		.get = py_TPMT_RSA_SCHEME_get_scheme,
		.set = py_TPMT_RSA_SCHEME_set_scheme,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "hash_algorithm"),
		.get = py_TPMT_RSA_SCHEME_get_hash_algorithm,
		.set = py_TPMT_RSA_SCHEME_set_hash_algorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_TPMT_RSA_SCHEME_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct TPMT_RSA_SCHEME, type);
}


static PyTypeObject TPMT_RSA_SCHEME_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "tpm20_rsakey_blob.TPMT_RSA_SCHEME",
	.tp_getset = py_TPMT_RSA_SCHEME_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_TPMT_RSA_SCHEME_new,
};


static PyObject *py_TPMS_RSA_PARMS_get_symmetric_algorithm(PyObject *obj, void *closure)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(obj);
	PyObject *py_symmetric_algorithm;
	py_symmetric_algorithm = PyLong_FromLong((uint16_t)(object->symmetric_algorithm));
	return py_symmetric_algorithm;
}

static int py_TPMS_RSA_PARMS_set_symmetric_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->symmetric_algorithm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->symmetric_algorithm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->symmetric_algorithm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPMS_RSA_PARMS_get_scheme(PyObject *obj, void *closure)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(obj);
	PyObject *py_scheme;
	py_scheme = pytalloc_reference_ex(&TPMT_RSA_SCHEME_Type, pytalloc_get_mem_ctx(obj), &object->scheme);
	return py_scheme;
}

static int py_TPMS_RSA_PARMS_set_scheme(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->scheme");
		return -1;
	}
	PY_CHECK_TYPE(&TPMT_RSA_SCHEME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->scheme = *(struct TPMT_RSA_SCHEME *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_TPMS_RSA_PARMS_get_keyBits(PyObject *obj, void *closure)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(obj);
	PyObject *py_keyBits;
	py_keyBits = PyLong_FromLong((uint16_t)(object->keyBits));
	return py_keyBits;
}

static int py_TPMS_RSA_PARMS_set_keyBits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->keyBits");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->keyBits));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->keyBits = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPMS_RSA_PARMS_get_exponent(PyObject *obj, void *closure)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(obj);
	PyObject *py_exponent;
	py_exponent = PyList_New(TPM_RSA_EXPONENT_SIZE);
	if (py_exponent == NULL) {
		return NULL;
	}
	{
		int exponent_cntr_0;
		for (exponent_cntr_0 = 0; exponent_cntr_0 < (TPM_RSA_EXPONENT_SIZE); exponent_cntr_0++) {
			PyObject *py_exponent_0;
			py_exponent_0 = PyLong_FromLong((uint16_t)((object->exponent)[exponent_cntr_0]));
			PyList_SetItem(py_exponent, exponent_cntr_0, py_exponent_0);
		}
	}
	return py_exponent;
}

static int py_TPMS_RSA_PARMS_set_exponent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->exponent");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int exponent_cntr_0;
		object->exponent = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->exponent, PyList_GET_SIZE(value));
		if (!object->exponent) { return -1; }
		talloc_set_name_const(object->exponent, "ARRAY: object->exponent");
		for (exponent_cntr_0 = 0; exponent_cntr_0 < PyList_GET_SIZE(value); exponent_cntr_0++) {
			if (PyList_GET_ITEM(value, exponent_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->exponent)[exponent_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->exponent)[exponent_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, exponent_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, exponent_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->exponent)[exponent_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_TPMS_RSA_PARMS_getsetters[] = {
	{
		.name = discard_const_p(char, "symmetric_algorithm"),
		.get = py_TPMS_RSA_PARMS_get_symmetric_algorithm,
		.set = py_TPMS_RSA_PARMS_set_symmetric_algorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "scheme"),
		.get = py_TPMS_RSA_PARMS_get_scheme,
		.set = py_TPMS_RSA_PARMS_set_scheme,
		.doc = discard_const_p(char, "PIDL-generated element of base type TPMT_RSA_SCHEME")
	},
	{
		.name = discard_const_p(char, "keyBits"),
		.get = py_TPMS_RSA_PARMS_get_keyBits,
		.set = py_TPMS_RSA_PARMS_set_keyBits,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "exponent"),
		.get = py_TPMS_RSA_PARMS_get_exponent,
		.set = py_TPMS_RSA_PARMS_set_exponent,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_TPMS_RSA_PARMS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct TPMS_RSA_PARMS, type);
}

static PyObject *py_TPMS_RSA_PARMS_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_TPMS_RSA_PARMS);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_TPMS_RSA_PARMS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPMS_RSA_PARMS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPMS_RSA_PARMS);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_TPMS_RSA_PARMS_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPMS_RSA_PARMS *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPMS_RSA_PARMS, "TPMS_RSA_PARMS", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPMS_RSA_PARMS, "TPMS_RSA_PARMS", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_TPMS_RSA_PARMS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_TPMS_RSA_PARMS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPMS_RSA_PARMS_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPMS_RSA_PARMS_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject TPMS_RSA_PARMS_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "tpm20_rsakey_blob.TPMS_RSA_PARMS",
	.tp_getset = py_TPMS_RSA_PARMS_getsetters,
	.tp_methods = py_TPMS_RSA_PARMS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_TPMS_RSA_PARMS_new,
};


static PyObject *py_TPM2B_PUBLIC_KEY_RSA_get_size(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC_KEY_RSA *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_TPM2B_PUBLIC_KEY_RSA_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC_KEY_RSA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM2B_PUBLIC_KEY_RSA_get_buffer(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC_KEY_RSA *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	py_buffer = PyList_New(object->size);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_0;
		for (buffer_cntr_0 = 0; buffer_cntr_0 < (object->size); buffer_cntr_0++) {
			PyObject *py_buffer_0;
			py_buffer_0 = PyLong_FromLong((uint16_t)((object->buffer)[buffer_cntr_0]));
			PyList_SetItem(py_buffer, buffer_cntr_0, py_buffer_0);
		}
	}
	return py_buffer;
}

static int py_TPM2B_PUBLIC_KEY_RSA_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC_KEY_RSA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buffer");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int buffer_cntr_0;
		object->buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffer, PyList_GET_SIZE(value));
		if (!object->buffer) { return -1; }
		talloc_set_name_const(object->buffer, "ARRAY: object->buffer");
		for (buffer_cntr_0 = 0; buffer_cntr_0 < PyList_GET_SIZE(value); buffer_cntr_0++) {
			if (PyList_GET_ITEM(value, buffer_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->buffer)[buffer_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->buffer)[buffer_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->buffer)[buffer_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_TPM2B_PUBLIC_KEY_RSA_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_TPM2B_PUBLIC_KEY_RSA_get_size,
		.set = py_TPM2B_PUBLIC_KEY_RSA_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "buffer"),
		.get = py_TPM2B_PUBLIC_KEY_RSA_get_buffer,
		.set = py_TPM2B_PUBLIC_KEY_RSA_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_TPM2B_PUBLIC_KEY_RSA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct TPM2B_PUBLIC_KEY_RSA, type);
}

static PyObject *py_TPM2B_PUBLIC_KEY_RSA_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct TPM2B_PUBLIC_KEY_RSA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_TPM2B_PUBLIC_KEY_RSA);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_TPM2B_PUBLIC_KEY_RSA_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPM2B_PUBLIC_KEY_RSA *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPM2B_PUBLIC_KEY_RSA);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPM2B_PUBLIC_KEY_RSA);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_TPM2B_PUBLIC_KEY_RSA_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPM2B_PUBLIC_KEY_RSA *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPM2B_PUBLIC_KEY_RSA, "TPM2B_PUBLIC_KEY_RSA", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPM2B_PUBLIC_KEY_RSA, "TPM2B_PUBLIC_KEY_RSA", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_TPM2B_PUBLIC_KEY_RSA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_TPM2B_PUBLIC_KEY_RSA_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPM2B_PUBLIC_KEY_RSA_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPM2B_PUBLIC_KEY_RSA_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject TPM2B_PUBLIC_KEY_RSA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "tpm20_rsakey_blob.TPM2B_PUBLIC_KEY_RSA",
	.tp_getset = py_TPM2B_PUBLIC_KEY_RSA_getsetters,
	.tp_methods = py_TPM2B_PUBLIC_KEY_RSA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_TPM2B_PUBLIC_KEY_RSA_new,
};


static PyObject *py_TPM2B_DIGEST_get_size(PyObject *obj, void *closure)
{
	struct TPM2B_DIGEST *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_TPM2B_DIGEST_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_DIGEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM2B_DIGEST_get_buffer(PyObject *obj, void *closure)
{
	struct TPM2B_DIGEST *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	py_buffer = PyList_New(object->size);
	if (py_buffer == NULL) {
		return NULL;
	}
	{
		int buffer_cntr_0;
		for (buffer_cntr_0 = 0; buffer_cntr_0 < (object->size); buffer_cntr_0++) {
			PyObject *py_buffer_0;
			py_buffer_0 = PyLong_FromLong((uint16_t)((object->buffer)[buffer_cntr_0]));
			PyList_SetItem(py_buffer, buffer_cntr_0, py_buffer_0);
		}
	}
	return py_buffer;
}

static int py_TPM2B_DIGEST_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_DIGEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buffer");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int buffer_cntr_0;
		object->buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffer, PyList_GET_SIZE(value));
		if (!object->buffer) { return -1; }
		talloc_set_name_const(object->buffer, "ARRAY: object->buffer");
		for (buffer_cntr_0 = 0; buffer_cntr_0 < PyList_GET_SIZE(value); buffer_cntr_0++) {
			if (PyList_GET_ITEM(value, buffer_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->buffer)[buffer_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->buffer)[buffer_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->buffer)[buffer_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_TPM2B_DIGEST_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_TPM2B_DIGEST_get_size,
		.set = py_TPM2B_DIGEST_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "buffer"),
		.get = py_TPM2B_DIGEST_get_buffer,
		.set = py_TPM2B_DIGEST_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_TPM2B_DIGEST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct TPM2B_DIGEST, type);
}

static PyObject *py_TPM2B_DIGEST_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct TPM2B_DIGEST *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_TPM2B_DIGEST);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_TPM2B_DIGEST_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPM2B_DIGEST *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPM2B_DIGEST);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPM2B_DIGEST);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_TPM2B_DIGEST_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPM2B_DIGEST *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPM2B_DIGEST, "TPM2B_DIGEST", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPM2B_DIGEST, "TPM2B_DIGEST", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_TPM2B_DIGEST_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_TPM2B_DIGEST_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPM2B_DIGEST_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPM2B_DIGEST_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject TPM2B_DIGEST_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "tpm20_rsakey_blob.TPM2B_DIGEST",
	.tp_getset = py_TPM2B_DIGEST_getsetters,
	.tp_methods = py_TPM2B_DIGEST_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_TPM2B_DIGEST_new,
};


static PyObject *py_TPM2B_PUBLIC_get_size(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_TPM2B_PUBLIC_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM2B_PUBLIC_get_type(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_TPM2B_PUBLIC_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM2B_PUBLIC_get_hash_algorithm(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(obj);
	PyObject *py_hash_algorithm;
	py_hash_algorithm = PyLong_FromLong((uint16_t)(object->hash_algorithm));
	return py_hash_algorithm;
}

static int py_TPM2B_PUBLIC_set_hash_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hash_algorithm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->hash_algorithm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->hash_algorithm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM2B_PUBLIC_get_attributes(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->attributes));
	return py_attributes;
}

static int py_TPM2B_PUBLIC_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM2B_PUBLIC_get_auth_policy(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_policy;
	py_auth_policy = pytalloc_reference_ex(&TPM2B_DIGEST_Type, pytalloc_get_mem_ctx(obj), &object->auth_policy);
	return py_auth_policy;
}

static int py_TPM2B_PUBLIC_set_auth_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_policy");
		return -1;
	}
	PY_CHECK_TYPE(&TPM2B_DIGEST_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->auth_policy = *(struct TPM2B_DIGEST *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_TPM2B_PUBLIC_get_rsa_detail(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(obj);
	PyObject *py_rsa_detail;
	py_rsa_detail = pytalloc_reference_ex(&TPMS_RSA_PARMS_Type, pytalloc_get_mem_ctx(obj), &object->rsa_detail);
	return py_rsa_detail;
}

static int py_TPM2B_PUBLIC_set_rsa_detail(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rsa_detail");
		return -1;
	}
	PY_CHECK_TYPE(&TPMS_RSA_PARMS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->rsa_detail = *(struct TPMS_RSA_PARMS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_TPM2B_PUBLIC_get_rsa(PyObject *obj, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(obj);
	PyObject *py_rsa;
	py_rsa = pytalloc_reference_ex(&TPM2B_PUBLIC_KEY_RSA_Type, pytalloc_get_mem_ctx(obj), &object->rsa);
	return py_rsa;
}

static int py_TPM2B_PUBLIC_set_rsa(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rsa");
		return -1;
	}
	PY_CHECK_TYPE(&TPM2B_PUBLIC_KEY_RSA_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->rsa = *(struct TPM2B_PUBLIC_KEY_RSA *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_TPM2B_PUBLIC_getsetters[] = {
	{
		.name = discard_const_p(char, "size"),
		.get = py_TPM2B_PUBLIC_get_size,
		.set = py_TPM2B_PUBLIC_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_TPM2B_PUBLIC_get_type,
		.set = py_TPM2B_PUBLIC_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "hash_algorithm"),
		.get = py_TPM2B_PUBLIC_get_hash_algorithm,
		.set = py_TPM2B_PUBLIC_set_hash_algorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_TPM2B_PUBLIC_get_attributes,
		.set = py_TPM2B_PUBLIC_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "auth_policy"),
		.get = py_TPM2B_PUBLIC_get_auth_policy,
		.set = py_TPM2B_PUBLIC_set_auth_policy,
		.doc = discard_const_p(char, "PIDL-generated element of base type TPM2B_DIGEST")
	},
	{
		.name = discard_const_p(char, "rsa_detail"),
		.get = py_TPM2B_PUBLIC_get_rsa_detail,
		.set = py_TPM2B_PUBLIC_set_rsa_detail,
		.doc = discard_const_p(char, "PIDL-generated element of base type TPMS_RSA_PARMS")
	},
	{
		.name = discard_const_p(char, "rsa"),
		.get = py_TPM2B_PUBLIC_get_rsa,
		.set = py_TPM2B_PUBLIC_set_rsa,
		.doc = discard_const_p(char, "PIDL-generated element of base type TPM2B_PUBLIC_KEY_RSA")
	},
	{ .name = NULL }
};

static PyObject *py_TPM2B_PUBLIC_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct TPM2B_PUBLIC, type);
}

static PyObject *py_TPM2B_PUBLIC_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_TPM2B_PUBLIC);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_TPM2B_PUBLIC_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPM2B_PUBLIC);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPM2B_PUBLIC);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_TPM2B_PUBLIC_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPM2B_PUBLIC *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPM2B_PUBLIC, "TPM2B_PUBLIC", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPM2B_PUBLIC, "TPM2B_PUBLIC", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_TPM2B_PUBLIC_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_TPM2B_PUBLIC_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPM2B_PUBLIC_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPM2B_PUBLIC_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject TPM2B_PUBLIC_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "tpm20_rsakey_blob.TPM2B_PUBLIC",
	.tp_getset = py_TPM2B_PUBLIC_getsetters,
	.tp_methods = py_TPM2B_PUBLIC_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_TPM2B_PUBLIC_new,
};


static PyObject *py_TPM20_RSAKEY_BLOB_get_magic(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyLong_FromUnsignedLongLong((uint32_t)(object->magic));
	return py_magic;
}

static int py_TPM20_RSAKEY_BLOB_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->magic");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_header_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_header_length;
	py_header_length = PyLong_FromUnsignedLongLong((uint32_t)(object->header_length));
	return py_header_length;
}

static int py_TPM20_RSAKEY_BLOB_set_header_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->header_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->header_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->header_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_type(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromUnsignedLongLong((uint32_t)(object->type));
	return py_type;
}

static int py_TPM20_RSAKEY_BLOB_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_flags(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_TPM20_RSAKEY_BLOB_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_public_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_public_length;
	py_public_length = PyLong_FromUnsignedLongLong((uint32_t)(object->public_length));
	return py_public_length;
}

static int py_TPM20_RSAKEY_BLOB_set_public_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->public_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->public_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->public_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_private_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_private_length;
	py_private_length = PyLong_FromUnsignedLongLong((uint32_t)(object->private_length));
	return py_private_length;
}

static int py_TPM20_RSAKEY_BLOB_set_private_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->private_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->private_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->private_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_migration_public_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_migration_public_length;
	py_migration_public_length = PyLong_FromUnsignedLongLong((uint32_t)(object->migration_public_length));
	return py_migration_public_length;
}

static int py_TPM20_RSAKEY_BLOB_set_migration_public_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->migration_public_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->migration_public_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->migration_public_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_migration_private_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_migration_private_length;
	py_migration_private_length = PyLong_FromUnsignedLongLong((uint32_t)(object->migration_private_length));
	return py_migration_private_length;
}

static int py_TPM20_RSAKEY_BLOB_set_migration_private_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->migration_private_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->migration_private_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->migration_private_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_policy_digest_list_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_policy_digest_list_length;
	py_policy_digest_list_length = PyLong_FromUnsignedLongLong((uint32_t)(object->policy_digest_list_length));
	return py_policy_digest_list_length;
}

static int py_TPM20_RSAKEY_BLOB_set_policy_digest_list_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->policy_digest_list_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->policy_digest_list_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->policy_digest_list_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_pcr_binding_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_pcr_binding_length;
	py_pcr_binding_length = PyLong_FromUnsignedLongLong((uint32_t)(object->pcr_binding_length));
	return py_pcr_binding_length;
}

static int py_TPM20_RSAKEY_BLOB_set_pcr_binding_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pcr_binding_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pcr_binding_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pcr_binding_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_pcr_digest_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_pcr_digest_length;
	py_pcr_digest_length = PyLong_FromUnsignedLongLong((uint32_t)(object->pcr_digest_length));
	return py_pcr_digest_length;
}

static int py_TPM20_RSAKEY_BLOB_set_pcr_digest_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pcr_digest_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pcr_digest_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pcr_digest_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_encrypted_secret_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_encrypted_secret_length;
	py_encrypted_secret_length = PyLong_FromUnsignedLongLong((uint32_t)(object->encrypted_secret_length));
	return py_encrypted_secret_length;
}

static int py_TPM20_RSAKEY_BLOB_set_encrypted_secret_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->encrypted_secret_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->encrypted_secret_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->encrypted_secret_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_tpm12_hostage_blob_length(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_tpm12_hostage_blob_length;
	py_tpm12_hostage_blob_length = PyLong_FromUnsignedLongLong((uint32_t)(object->tpm12_hostage_blob_length));
	return py_tpm12_hostage_blob_length;
}

static int py_TPM20_RSAKEY_BLOB_set_tpm12_hostage_blob_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tpm12_hostage_blob_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tpm12_hostage_blob_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tpm12_hostage_blob_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_pcr_alg_id(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_pcr_alg_id;
	py_pcr_alg_id = PyLong_FromLong((uint16_t)(object->pcr_alg_id));
	return py_pcr_alg_id;
}

static int py_TPM20_RSAKEY_BLOB_set_pcr_alg_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pcr_alg_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pcr_alg_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pcr_alg_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_public_key(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_public_key;
	py_public_key = pytalloc_reference_ex(&TPM2B_PUBLIC_Type, pytalloc_get_mem_ctx(obj), &object->public_key);
	return py_public_key;
}

static int py_TPM20_RSAKEY_BLOB_set_public_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->public_key");
		return -1;
	}
	PY_CHECK_TYPE(&TPM2B_PUBLIC_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->public_key = *(struct TPM2B_PUBLIC *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_TPM20_RSAKEY_BLOB_get_remaining(PyObject *obj, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_remaining;
	py_remaining = PyBytes_FromStringAndSize((char *)(object->remaining).data, (object->remaining).length);
	return py_remaining;
}

static int py_TPM20_RSAKEY_BLOB_set_remaining(PyObject *py_obj, PyObject *value, void *closure)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remaining");
		return -1;
	}
	object->remaining = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_TPM20_RSAKEY_BLOB_getsetters[] = {
	{
		.name = discard_const_p(char, "magic"),
		.get = py_TPM20_RSAKEY_BLOB_get_magic,
		.set = py_TPM20_RSAKEY_BLOB_set_magic,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "header_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_header_length,
		.set = py_TPM20_RSAKEY_BLOB_set_header_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_TPM20_RSAKEY_BLOB_get_type,
		.set = py_TPM20_RSAKEY_BLOB_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_TPM20_RSAKEY_BLOB_get_flags,
		.set = py_TPM20_RSAKEY_BLOB_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "public_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_public_length,
		.set = py_TPM20_RSAKEY_BLOB_set_public_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "private_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_private_length,
		.set = py_TPM20_RSAKEY_BLOB_set_private_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "migration_public_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_migration_public_length,
		.set = py_TPM20_RSAKEY_BLOB_set_migration_public_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "migration_private_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_migration_private_length,
		.set = py_TPM20_RSAKEY_BLOB_set_migration_private_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "policy_digest_list_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_policy_digest_list_length,
		.set = py_TPM20_RSAKEY_BLOB_set_policy_digest_list_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pcr_binding_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_pcr_binding_length,
		.set = py_TPM20_RSAKEY_BLOB_set_pcr_binding_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pcr_digest_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_pcr_digest_length,
		.set = py_TPM20_RSAKEY_BLOB_set_pcr_digest_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "encrypted_secret_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_encrypted_secret_length,
		.set = py_TPM20_RSAKEY_BLOB_set_encrypted_secret_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "tpm12_hostage_blob_length"),
		.get = py_TPM20_RSAKEY_BLOB_get_tpm12_hostage_blob_length,
		.set = py_TPM20_RSAKEY_BLOB_set_tpm12_hostage_blob_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pcr_alg_id"),
		.get = py_TPM20_RSAKEY_BLOB_get_pcr_alg_id,
		.set = py_TPM20_RSAKEY_BLOB_set_pcr_alg_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "public_key"),
		.get = py_TPM20_RSAKEY_BLOB_get_public_key,
		.set = py_TPM20_RSAKEY_BLOB_set_public_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type TPM2B_PUBLIC")
	},
	{
		.name = discard_const_p(char, "remaining"),
		.get = py_TPM20_RSAKEY_BLOB_get_remaining,
		.set = py_TPM20_RSAKEY_BLOB_set_remaining,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_TPM20_RSAKEY_BLOB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct TPM20_RSAKEY_BLOB, type);
}

static PyObject *py_TPM20_RSAKEY_BLOB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_TPM20_RSAKEY_BLOB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_TPM20_RSAKEY_BLOB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPM20_RSAKEY_BLOB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_TPM20_RSAKEY_BLOB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_TPM20_RSAKEY_BLOB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct TPM20_RSAKEY_BLOB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPM20_RSAKEY_BLOB, "TPM20_RSAKEY_BLOB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_TPM20_RSAKEY_BLOB, "TPM20_RSAKEY_BLOB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_TPM20_RSAKEY_BLOB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_TPM20_RSAKEY_BLOB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPM20_RSAKEY_BLOB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_TPM20_RSAKEY_BLOB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject TPM20_RSAKEY_BLOB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "tpm20_rsakey_blob.TPM20_RSAKEY_BLOB",
	.tp_getset = py_TPM20_RSAKEY_BLOB_getsetters,
	.tp_methods = py_TPM20_RSAKEY_BLOB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_TPM20_RSAKEY_BLOB_new,
};

static PyMethodDef tpm20_rsakey_blob_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "tpm20_rsakey_blob",
	.m_doc = "tpm20_rsakey_blob DCE/RPC",
	.m_size = -1,
	.m_methods = tpm20_rsakey_blob_methods,
};
MODULE_INIT_FUNC(tpm20_rsakey_blob)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	TPMT_RSA_SCHEME_Type.tp_base = BaseObject_Type;
	TPMT_RSA_SCHEME_Type.tp_basicsize = pytalloc_BaseObject_size();

	TPMS_RSA_PARMS_Type.tp_base = BaseObject_Type;
	TPMS_RSA_PARMS_Type.tp_basicsize = pytalloc_BaseObject_size();

	TPM2B_PUBLIC_KEY_RSA_Type.tp_base = BaseObject_Type;
	TPM2B_PUBLIC_KEY_RSA_Type.tp_basicsize = pytalloc_BaseObject_size();

	TPM2B_DIGEST_Type.tp_base = BaseObject_Type;
	TPM2B_DIGEST_Type.tp_basicsize = pytalloc_BaseObject_size();

	TPM2B_PUBLIC_Type.tp_base = BaseObject_Type;
	TPM2B_PUBLIC_Type.tp_basicsize = pytalloc_BaseObject_size();

	TPM20_RSAKEY_BLOB_Type.tp_base = BaseObject_Type;
	TPM20_RSAKEY_BLOB_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&TPMT_RSA_SCHEME_Type) < 0)
		goto out;
	if (PyType_Ready(&TPMS_RSA_PARMS_Type) < 0)
		goto out;
	if (PyType_Ready(&TPM2B_PUBLIC_KEY_RSA_Type) < 0)
		goto out;
	if (PyType_Ready(&TPM2B_DIGEST_Type) < 0)
		goto out;
	if (PyType_Ready(&TPM2B_PUBLIC_Type) < 0)
		goto out;
	if (PyType_Ready(&TPM20_RSAKEY_BLOB_Type) < 0)
		goto out;
#ifdef PY_TPMT_RSA_SCHEME_PATCH
	PY_TPMT_RSA_SCHEME_PATCH(&TPMT_RSA_SCHEME_Type);
#endif
#ifdef PY_TPMS_RSA_PARMS_PATCH
	PY_TPMS_RSA_PARMS_PATCH(&TPMS_RSA_PARMS_Type);
#endif
#ifdef PY_TPM2B_PUBLIC_KEY_RSA_PATCH
	PY_TPM2B_PUBLIC_KEY_RSA_PATCH(&TPM2B_PUBLIC_KEY_RSA_Type);
#endif
#ifdef PY_TPM2B_DIGEST_PATCH
	PY_TPM2B_DIGEST_PATCH(&TPM2B_DIGEST_Type);
#endif
#ifdef PY_TPM2B_PUBLIC_PATCH
	PY_TPM2B_PUBLIC_PATCH(&TPM2B_PUBLIC_Type);
#endif
#ifdef PY_TPM20_RSAKEY_BLOB_PATCH
	PY_TPM20_RSAKEY_BLOB_PATCH(&TPM20_RSAKEY_BLOB_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "TPM20_MAGIC", PyLong_FromUnsignedLongLong(0x4D504350));
	PyModule_AddObject(m, "PCP_TYPE_TPM_12", PyLong_FromUnsignedLongLong(0x00000001));
	PyModule_AddObject(m, "PCP_TYPE_TPM_20", PyLong_FromUnsignedLongLong(0x00000002));
	PyModule_AddObject(m, "TPM_ALG_RSA", PyLong_FromUnsignedLongLong(0x0001));
	PyModule_AddObject(m, "TPM_ALG_NULL", PyLong_FromUnsignedLongLong(0x0010));
	PyModule_AddObject(m, "TPM_ALG_SHA256", PyLong_FromUnsignedLongLong(0x000B));
	PyModule_AddObject(m, "TPM_ALG_RSASSA", PyLong_FromUnsignedLongLong(0x0014));
	PyModule_AddObject(m, "TPM_RSA_EXPONENT_SIZE", PyLong_FromLong((uint16_t)(sizeof(uint32_t))));
	Py_INCREF((PyObject *)(void *)&TPMT_RSA_SCHEME_Type);
	PyModule_AddObject(m, "TPMT_RSA_SCHEME", (PyObject *)(void *)&TPMT_RSA_SCHEME_Type);
	Py_INCREF((PyObject *)(void *)&TPMS_RSA_PARMS_Type);
	PyModule_AddObject(m, "TPMS_RSA_PARMS", (PyObject *)(void *)&TPMS_RSA_PARMS_Type);
	Py_INCREF((PyObject *)(void *)&TPM2B_PUBLIC_KEY_RSA_Type);
	PyModule_AddObject(m, "TPM2B_PUBLIC_KEY_RSA", (PyObject *)(void *)&TPM2B_PUBLIC_KEY_RSA_Type);
	Py_INCREF((PyObject *)(void *)&TPM2B_DIGEST_Type);
	PyModule_AddObject(m, "TPM2B_DIGEST", (PyObject *)(void *)&TPM2B_DIGEST_Type);
	Py_INCREF((PyObject *)(void *)&TPM2B_PUBLIC_Type);
	PyModule_AddObject(m, "TPM2B_PUBLIC", (PyObject *)(void *)&TPM2B_PUBLIC_Type);
	Py_INCREF((PyObject *)(void *)&TPM20_RSAKEY_BLOB_Type);
	PyModule_AddObject(m, "TPM20_RSAKEY_BLOB", (PyObject *)(void *)&TPM20_RSAKEY_BLOB_Type);
#ifdef PY_MOD_TPM20_RSAKEY_BLOB_PATCH
	PY_MOD_TPM20_RSAKEY_BLOB_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	return m;

}
