// ui/gfx/mojom/ca_layer_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/ca_layer_params.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace gfx::mojom {
class CALayerParamsDataView;

class CALayerContentDataView;


}  // gfx::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::CALayerParamsDataView> {
  using Data = ::gfx::mojom::internal::CALayerParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::CALayerContentDataView> {
  using Data = ::gfx::mojom::internal::CALayerContent_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class CALayerParamsDataView {
 public:
  CALayerParamsDataView() = default;

  CALayerParamsDataView(
      internal::CALayerParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_empty() const {
    return data_->is_empty;
  }
  inline void GetContentDataView(
      CALayerContentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = !data_->content.is_null() ? &data_->content : nullptr;
    return mojo::internal::Deserialize<::gfx::mojom::CALayerContentDataView>(
        pointer, output, message_);
  }
  inline void GetPixelSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelSize(UserType* output) {
    
    auto* pointer = data_->pixel_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float scale_factor() const {
    return data_->scale_factor;
  }
 private:
  internal::CALayerParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CALayerContentDataView {
 public:
  using Tag = internal::CALayerContent_Data::CALayerContent_Tag;

  CALayerContentDataView() = default;

  CALayerContentDataView(
      internal::CALayerContent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_ca_context_id() const { return data_->tag == Tag::kCaContextId; }
  uint32_t ca_context_id() const {
    CHECK(is_ca_context_id());
    return data_->data.f_ca_context_id;
  }
  bool is_io_surface_mach_port() const { return data_->tag == Tag::kIoSurfaceMachPort; }
  mojo::PlatformHandle TakeIoSurfaceMachPort() {
    CHECK(is_io_surface_mach_port());
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->data.f_io_surface_mach_port, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::CALayerContent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gfx::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::CALayerParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::CALayerParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::CALayerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->is_empty = Traits::is_empty(input);
    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<decltype(fragment->content)>
        content_fragment(fragment.message());
    content_fragment.Claim(&fragment->content);
    mojo::internal::Serialize<::gfx::mojom::CALayerContentDataView>(
        in_content, content_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in CALayerParams struct");
    decltype(Traits::pixel_size(input)) in_pixel_size = Traits::pixel_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pixel_size)::BaseType> pixel_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_pixel_size, pixel_size_fragment);
    fragment->pixel_size.Set(
        pixel_size_fragment.is_null() ? nullptr : pixel_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pixel_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_size in CALayerParams struct");
    fragment->scale_factor = Traits::scale_factor(input);
  }

  static bool Deserialize(::gfx::mojom::internal::CALayerParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::CALayerParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::CALayerContentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gfx::mojom::CALayerContentDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gfx::mojom::internal::CALayerContent_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::gfx::mojom::CALayerContentDataView::Tag::kCaContextId: {
        decltype(Traits::ca_context_id(input))
            in_ca_context_id = Traits::ca_context_id(input);
        fragment->data.f_ca_context_id = in_ca_context_id;
        break;
      }
      case ::gfx::mojom::CALayerContentDataView::Tag::kIoSurfaceMachPort: {
        decltype(Traits::io_surface_mach_port(input))
            in_io_surface_mach_port = Traits::io_surface_mach_port(input);
        mojo::internal::Serialize<mojo::PlatformHandle>(
            in_io_surface_mach_port, &fragment->data.f_io_surface_mach_port, &fragment.message());
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            !mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_io_surface_mach_port),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
            "invalid io_surface_mach_port in CALayerContent union");
        break;
      }
    }
  }

  static bool Deserialize(::gfx::mojom::internal::CALayerContent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::CALayerContentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void CALayerParamsDataView::GetContentDataView(
    CALayerContentDataView* output) {
  auto pointer = &data_->content;
  *output = CALayerContentDataView(pointer, message_);
}
inline void CALayerParamsDataView::GetPixelSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->pixel_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}




}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_SHARED_H_