// ui/events/mojom/event.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/events/mojom/event.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/events/mojom/event.mojom-params-data.h"
#include "ui/events/mojom/event.mojom-shared-message-ids.h"

#include "ui/events/mojom/event.mojom-import-headers.h"
#include "ui/events/mojom/event.mojom-test-utils.h"
#include "ui/events/mojom/event_mojom_traits.h"


namespace ui::mojom {
KeyData::KeyData()
    : key_code(),
      dom_code(),
      dom_key(),
      is_char() {}

KeyData::KeyData(
    int32_t key_code_in,
    uint32_t dom_code_in,
    int32_t dom_key_in,
    bool is_char_in)
    : key_code(std::move(key_code_in)),
      dom_code(std::move(dom_code_in)),
      dom_key(std::move(dom_key_in)),
      is_char(std::move(is_char_in)) {}

KeyData::~KeyData() = default;
size_t KeyData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key_code);
  seed = mojo::internal::Hash(seed, this->dom_code);
  seed = mojo::internal::Hash(seed, this->dom_key);
  seed = mojo::internal::Hash(seed, this->is_char);
  return seed;
}

void KeyData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_code"), this->key_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dom_code"), this->dom_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dom_key"), this->dom_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_char"), this->is_char,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KeyData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LocationData::LocationData()
    : relative_location(),
      root_location() {}

LocationData::LocationData(
    const ::gfx::PointF& relative_location_in,
    const ::gfx::PointF& root_location_in)
    : relative_location(std::move(relative_location_in)),
      root_location(std::move(root_location_in)) {}

LocationData::~LocationData() = default;

void LocationData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_location"), this->relative_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_location"), this->root_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LocationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GesturePinchData::GesturePinchData()
    : scale() {}

GesturePinchData::GesturePinchData(
    float scale_in)
    : scale(std::move(scale_in)) {}

GesturePinchData::~GesturePinchData() = default;
size_t GesturePinchData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->scale);
  return seed;
}

void GesturePinchData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale"), this->scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GesturePinchData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GestureSwipeData::GestureSwipeData()
    : left(),
      right(),
      up(),
      down() {}

GestureSwipeData::GestureSwipeData(
    bool left_in,
    bool right_in,
    bool up_in,
    bool down_in)
    : left(std::move(left_in)),
      right(std::move(right_in)),
      up(std::move(up_in)),
      down(std::move(down_in)) {}

GestureSwipeData::~GestureSwipeData() = default;
size_t GestureSwipeData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->left);
  seed = mojo::internal::Hash(seed, this->right);
  seed = mojo::internal::Hash(seed, this->up);
  seed = mojo::internal::Hash(seed, this->down);
  return seed;
}

void GestureSwipeData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left"), this->left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right"), this->right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "up"), this->up,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "down"), this->down,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GestureSwipeData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GestureData::GestureData()
    : location(),
      device_type(),
      details() {}

GestureData::GestureData(
    LocationDataPtr location_in,
    ::ui::GestureDeviceType device_type_in,
    GestureDataDetailsPtr details_in)
    : location(std::move(location_in)),
      device_type(std::move(device_type_in)),
      details(std::move(details_in)) {}

GestureData::~GestureData() = default;

void GestureData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LocationDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_type"), this->device_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::GestureDeviceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GestureDataDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GestureData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollData::ScrollData()
    : location(),
      x_offset(),
      y_offset(),
      x_offset_ordinal(),
      y_offset_ordinal(),
      finger_count(),
      momentum_phase(),
      scroll_event_phase() {}

ScrollData::ScrollData(
    LocationDataPtr location_in,
    float x_offset_in,
    float y_offset_in,
    float x_offset_ordinal_in,
    float y_offset_ordinal_in,
    int32_t finger_count_in,
    ::ui::EventMomentumPhase momentum_phase_in,
    ::ui::ScrollEventPhase scroll_event_phase_in)
    : location(std::move(location_in)),
      x_offset(std::move(x_offset_in)),
      y_offset(std::move(y_offset_in)),
      x_offset_ordinal(std::move(x_offset_ordinal_in)),
      y_offset_ordinal(std::move(y_offset_ordinal_in)),
      finger_count(std::move(finger_count_in)),
      momentum_phase(std::move(momentum_phase_in)),
      scroll_event_phase(std::move(scroll_event_phase_in)) {}

ScrollData::~ScrollData() = default;

void ScrollData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LocationDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x_offset"), this->x_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y_offset"), this->y_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x_offset_ordinal"), this->x_offset_ordinal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y_offset_ordinal"), this->y_offset_ordinal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "finger_count"), this->finger_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "momentum_phase"), this->momentum_phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::EventMomentumPhase>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_event_phase"), this->scroll_event_phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::ScrollEventPhase>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PointerDetails::PointerDetails()
    : pointer_type(),
      radius_x(),
      radius_y(),
      force(),
      tilt_x(),
      tilt_y(),
      tangential_pressure(),
      twist(),
      id(),
      offset_x(),
      offset_y() {}

PointerDetails::PointerDetails(
    ::ui::EventPointerType pointer_type_in,
    float radius_x_in,
    float radius_y_in,
    float force_in,
    float tilt_x_in,
    float tilt_y_in,
    float tangential_pressure_in,
    float twist_in,
    int32_t id_in,
    int32_t offset_x_in,
    int32_t offset_y_in)
    : pointer_type(std::move(pointer_type_in)),
      radius_x(std::move(radius_x_in)),
      radius_y(std::move(radius_y_in)),
      force(std::move(force_in)),
      tilt_x(std::move(tilt_x_in)),
      tilt_y(std::move(tilt_y_in)),
      tangential_pressure(std::move(tangential_pressure_in)),
      twist(std::move(twist_in)),
      id(std::move(id_in)),
      offset_x(std::move(offset_x_in)),
      offset_y(std::move(offset_y_in)) {}

PointerDetails::~PointerDetails() = default;

void PointerDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_type"), this->pointer_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::EventPointerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius_x"), this->radius_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius_y"), this->radius_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force"), this->force,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt_x"), this->tilt_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt_y"), this->tilt_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tangential_pressure"), this->tangential_pressure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "twist"), this->twist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_x"), this->offset_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_y"), this->offset_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PointerDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MouseData::MouseData()
    : changed_button_flags(),
      location(),
      pointer_details(),
      wheel_offset(),
      tick_120ths() {}

MouseData::MouseData(
    int32_t changed_button_flags_in,
    LocationDataPtr location_in,
    const ::ui::PointerDetails& pointer_details_in,
    const ::gfx::Vector2d& wheel_offset_in,
    const ::gfx::Vector2d& tick_120ths_in)
    : changed_button_flags(std::move(changed_button_flags_in)),
      location(std::move(location_in)),
      pointer_details(std::move(pointer_details_in)),
      wheel_offset(std::move(wheel_offset_in)),
      tick_120ths(std::move(tick_120ths_in)) {}

MouseData::~MouseData() = default;

void MouseData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "changed_button_flags"), this->changed_button_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LocationDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_details"), this->pointer_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::PointerDetails&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_offset"), this->wheel_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2d&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tick_120ths"), this->tick_120ths,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2d&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MouseData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchData::TouchData()
    : may_cause_scrolling(),
      hovering(),
      location(),
      pointer_details() {}

TouchData::TouchData(
    bool may_cause_scrolling_in,
    bool hovering_in,
    LocationDataPtr location_in,
    const ::ui::PointerDetails& pointer_details_in)
    : may_cause_scrolling(std::move(may_cause_scrolling_in)),
      hovering(std::move(hovering_in)),
      location(std::move(location_in)),
      pointer_details(std::move(pointer_details_in)) {}

TouchData::~TouchData() = default;

void TouchData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_cause_scrolling"), this->may_cause_scrolling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hovering"), this->hovering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LocationDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_details"), this->pointer_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::PointerDetails&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Event::Event()
    : action(),
      flags(),
      time_stamp(),
      latency(),
      key_data(),
      gesture_data(),
      scroll_data(),
      touch_data(),
      mouse_data(),
      properties() {}

Event::Event(
    ::ui::mojom::EventType action_in,
    int32_t flags_in,
    ::base::TimeTicks time_stamp_in,
    const ::ui::LatencyInfo& latency_in,
    KeyDataPtr key_data_in,
    GestureDataPtr gesture_data_in,
    ScrollDataPtr scroll_data_in,
    TouchDataPtr touch_data_in,
    MouseDataPtr mouse_data_in,
    const std::optional<base::flat_map<std::string, std::vector<uint8_t>>>& properties_in)
    : action(std::move(action_in)),
      flags(std::move(flags_in)),
      time_stamp(std::move(time_stamp_in)),
      latency(std::move(latency_in)),
      key_data(std::move(key_data_in)),
      gesture_data(std::move(gesture_data_in)),
      scroll_data(std::move(scroll_data_in)),
      touch_data(std::move(touch_data_in)),
      mouse_data(std::move(mouse_data_in)),
      properties(std::move(properties_in)) {}

Event::~Event() = default;

void Event::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::EventType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flags"), this->flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_stamp"), this->time_stamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency"), this->latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::LatencyInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_data"), this->key_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_data"), this->gesture_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GestureDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_data"), this->scroll_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_data"), this->touch_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TouchDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mouse_data"), this->mouse_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MouseDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "properties"), this->properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, std::vector<uint8_t>>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Event::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GestureDataDetails::GestureDataDetails() : tag_(Tag::kPinch) {
  data_.pinch = new GesturePinchDataPtr;
}

GestureDataDetails::~GestureDataDetails() {
  DestroyActive();
}


void GestureDataDetails::set_pinch(
    GesturePinchDataPtr pinch) {
  if (tag_ == Tag::kPinch) {
    *(data_.pinch) = std::move(pinch);
  } else {
    DestroyActive();
    tag_ = Tag::kPinch;
    data_.pinch = new GesturePinchDataPtr(
        std::move(pinch));
  }
}
void GestureDataDetails::set_swipe(
    GestureSwipeDataPtr swipe) {
  if (tag_ == Tag::kSwipe) {
    *(data_.swipe) = std::move(swipe);
  } else {
    DestroyActive();
    tag_ = Tag::kSwipe;
    data_.swipe = new GestureSwipeDataPtr(
        std::move(swipe));
  }
}

void GestureDataDetails::DestroyActive() {
  switch (tag_) {

    case Tag::kPinch:

      delete data_.pinch;
      break;
    case Tag::kSwipe:

      delete data_.swipe;
      break;
  }
}
size_t GestureDataDetails::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kPinch:
      return mojo::internal::Hash(seed, *data_.pinch);
    case Tag::kSwipe:
      return mojo::internal::Hash(seed, *data_.swipe);
    default:
      NOTREACHED();
  }
}

bool GestureDataDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // ui::mojom


namespace mojo {


// static
bool StructTraits<::ui::mojom::KeyData::DataView, ::ui::mojom::KeyDataPtr>::Read(
    ::ui::mojom::KeyData::DataView input,
    ::ui::mojom::KeyDataPtr* output) {
  bool success = true;
  ::ui::mojom::KeyDataPtr result(::ui::mojom::KeyData::New());
  
      if (success)
        result->key_code = input.key_code();
      if (success)
        result->dom_code = input.dom_code();
      if (success)
        result->dom_key = input.dom_key();
      if (success)
        result->is_char = input.is_char();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::LocationData::DataView, ::ui::mojom::LocationDataPtr>::Read(
    ::ui::mojom::LocationData::DataView input,
    ::ui::mojom::LocationDataPtr* output) {
  bool success = true;
  ::ui::mojom::LocationDataPtr result(::ui::mojom::LocationData::New());
  
      if (success && !input.ReadRelativeLocation(&result->relative_location))
        success = false;
      if (success && !input.ReadRootLocation(&result->root_location))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::GesturePinchData::DataView, ::ui::mojom::GesturePinchDataPtr>::Read(
    ::ui::mojom::GesturePinchData::DataView input,
    ::ui::mojom::GesturePinchDataPtr* output) {
  bool success = true;
  ::ui::mojom::GesturePinchDataPtr result(::ui::mojom::GesturePinchData::New());
  
      if (success)
        result->scale = input.scale();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::GestureSwipeData::DataView, ::ui::mojom::GestureSwipeDataPtr>::Read(
    ::ui::mojom::GestureSwipeData::DataView input,
    ::ui::mojom::GestureSwipeDataPtr* output) {
  bool success = true;
  ::ui::mojom::GestureSwipeDataPtr result(::ui::mojom::GestureSwipeData::New());
  
      if (success)
        result->left = input.left();
      if (success)
        result->right = input.right();
      if (success)
        result->up = input.up();
      if (success)
        result->down = input.down();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::GestureData::DataView, ::ui::mojom::GestureDataPtr>::Read(
    ::ui::mojom::GestureData::DataView input,
    ::ui::mojom::GestureDataPtr* output) {
  bool success = true;
  ::ui::mojom::GestureDataPtr result(::ui::mojom::GestureData::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadDeviceType(&result->device_type))
        success = false;
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::ScrollData::DataView, ::ui::mojom::ScrollDataPtr>::Read(
    ::ui::mojom::ScrollData::DataView input,
    ::ui::mojom::ScrollDataPtr* output) {
  bool success = true;
  ::ui::mojom::ScrollDataPtr result(::ui::mojom::ScrollData::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success)
        result->x_offset = input.x_offset();
      if (success)
        result->y_offset = input.y_offset();
      if (success)
        result->x_offset_ordinal = input.x_offset_ordinal();
      if (success)
        result->y_offset_ordinal = input.y_offset_ordinal();
      if (success)
        result->finger_count = input.finger_count();
      if (success && !input.ReadMomentumPhase(&result->momentum_phase))
        success = false;
      if (success && !input.ReadScrollEventPhase(&result->scroll_event_phase))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::PointerDetails::DataView, ::ui::mojom::PointerDetailsPtr>::Read(
    ::ui::mojom::PointerDetails::DataView input,
    ::ui::mojom::PointerDetailsPtr* output) {
  bool success = true;
  ::ui::mojom::PointerDetailsPtr result(::ui::mojom::PointerDetails::New());
  
      if (success && !input.ReadPointerType(&result->pointer_type))
        success = false;
      if (success)
        result->radius_x = input.radius_x();
      if (success)
        result->radius_y = input.radius_y();
      if (success)
        result->force = input.force();
      if (success)
        result->tilt_x = input.tilt_x();
      if (success)
        result->tilt_y = input.tilt_y();
      if (success)
        result->tangential_pressure = input.tangential_pressure();
      if (success)
        result->twist = input.twist();
      if (success)
        result->id = input.id();
      if (success)
        result->offset_x = input.offset_x();
      if (success)
        result->offset_y = input.offset_y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::MouseData::DataView, ::ui::mojom::MouseDataPtr>::Read(
    ::ui::mojom::MouseData::DataView input,
    ::ui::mojom::MouseDataPtr* output) {
  bool success = true;
  ::ui::mojom::MouseDataPtr result(::ui::mojom::MouseData::New());
  
      if (success)
        result->changed_button_flags = input.changed_button_flags();
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadPointerDetails(&result->pointer_details))
        success = false;
      if (success && !input.ReadWheelOffset(&result->wheel_offset))
        success = false;
      if (success && !input.ReadTick120ths(&result->tick_120ths))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::TouchData::DataView, ::ui::mojom::TouchDataPtr>::Read(
    ::ui::mojom::TouchData::DataView input,
    ::ui::mojom::TouchDataPtr* output) {
  bool success = true;
  ::ui::mojom::TouchDataPtr result(::ui::mojom::TouchData::New());
  
      if (success)
        result->may_cause_scrolling = input.may_cause_scrolling();
      if (success)
        result->hovering = input.hovering();
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadPointerDetails(&result->pointer_details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::Event::DataView, ::ui::mojom::EventPtr>::Read(
    ::ui::mojom::Event::DataView input,
    ::ui::mojom::EventPtr* output) {
  bool success = true;
  ::ui::mojom::EventPtr result(::ui::mojom::Event::New());
  
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success)
        result->flags = input.flags();
      if (success && !input.ReadTimeStamp(&result->time_stamp))
        success = false;
      if (success && !input.ReadLatency(&result->latency))
        success = false;
      if (success && !input.ReadKeyData(&result->key_data))
        success = false;
      if (success && !input.ReadGestureData(&result->gesture_data))
        success = false;
      if (success && !input.ReadScrollData(&result->scroll_data))
        success = false;
      if (success && !input.ReadTouchData(&result->touch_data))
        success = false;
      if (success && !input.ReadMouseData(&result->mouse_data))
        success = false;
      if (success && !input.ReadProperties(&result->properties))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::ui::mojom::GestureDataDetails::DataView, ::ui::mojom::GestureDataDetailsPtr>::Read(
    ::ui::mojom::GestureDataDetails::DataView input,
    ::ui::mojom::GestureDataDetailsPtr* output) {
  using UnionType = ::ui::mojom::GestureDataDetails;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPinch: {
      ::ui::mojom::GesturePinchDataPtr result_pinch;
      if (!input.ReadPinch(&result_pinch))
        return false;

      *output = UnionType::NewPinch(
          std::move(result_pinch));
      break;
    }
    case Tag::kSwipe: {
      ::ui::mojom::GestureSwipeDataPtr result_swipe;
      if (!input.ReadSwipe(&result_swipe))
        return false;

      *output = UnionType::NewSwipe(
          std::move(result_swipe));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ui::mojom {




}  // ui::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif