// third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-forward.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-forward.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class WorkletDevToolsHostProxy;

template <typename ImplRefTraits>
class WorkletDevToolsHostStub;

class WorkletDevToolsHostRequestValidator;


class BLINK_COMMON_EXPORT WorkletDevToolsHost
    : public WorkletDevToolsHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WorkletDevToolsHostInterfaceBase;
  using Proxy_ = WorkletDevToolsHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = WorkletDevToolsHostStub<ImplRefTraits>;

  using RequestValidator_ = WorkletDevToolsHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnReadyForInspectionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnReadyForInspection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WorkletDevToolsHost() = default;

  
  virtual void OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> agent_host) = 0;
};



class BLINK_COMMON_EXPORT WorkletDevToolsHostProxy
    : public WorkletDevToolsHost {
 public:
  using InterfaceType = WorkletDevToolsHost;

  explicit WorkletDevToolsHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> agent_host) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT WorkletDevToolsHostStubDispatch {
 public:
  static bool Accept(WorkletDevToolsHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WorkletDevToolsHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WorkletDevToolsHost>>
class WorkletDevToolsHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WorkletDevToolsHostStub() = default;
  ~WorkletDevToolsHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WorkletDevToolsHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WorkletDevToolsHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WorkletDevToolsHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT WorkletGlobalScopeCreationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WorkletGlobalScopeCreationParams, T>::value>;
  using DataView = WorkletGlobalScopeCreationParamsDataView;
  using Data_ = internal::WorkletGlobalScopeCreationParams_Data;

  template <typename... Args>
  static WorkletGlobalScopeCreationParamsPtr New(Args&&... args) {
    return WorkletGlobalScopeCreationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WorkletGlobalScopeCreationParamsPtr From(const U& u) {
    return mojo::TypeConverter<WorkletGlobalScopeCreationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WorkletGlobalScopeCreationParams>::Convert(*this);
  }


  WorkletGlobalScopeCreationParams();

  WorkletGlobalScopeCreationParams(
      const ::GURL& script_url,
      const ::url::Origin& starter_origin,
      std::vector<::blink::mojom::OriginTrialFeature> origin_trial_features,
      const ::base::UnguessableToken& devtools_token,
      ::mojo::PendingRemote<WorkletDevToolsHost> devtools_host,
      ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host,
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker,
      bool wait_for_debugger);

WorkletGlobalScopeCreationParams(const WorkletGlobalScopeCreationParams&) = delete;
WorkletGlobalScopeCreationParams& operator=(const WorkletGlobalScopeCreationParams&) = delete;

  ~WorkletGlobalScopeCreationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WorkletGlobalScopeCreationParamsPtr>
  WorkletGlobalScopeCreationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WorkletGlobalScopeCreationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WorkletGlobalScopeCreationParams_UnserializedMessageContext<
            UserType, WorkletGlobalScopeCreationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WorkletGlobalScopeCreationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WorkletGlobalScopeCreationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WorkletGlobalScopeCreationParams_UnserializedMessageContext<
            UserType, WorkletGlobalScopeCreationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WorkletGlobalScopeCreationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL script_url;
  
  ::url::Origin starter_origin;
  
  std::vector<::blink::mojom::OriginTrialFeature> origin_trial_features;
  
  ::base::UnguessableToken devtools_token;
  
  ::mojo::PendingRemote<WorkletDevToolsHost> devtools_host;
  
  ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host;
  
  ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker;
  
  bool wait_for_debugger;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WorkletGlobalScopeCreationParamsPtr WorkletGlobalScopeCreationParams::Clone() const {
  return New(
      mojo::Clone(script_url),
      mojo::Clone(starter_origin),
      mojo::Clone(origin_trial_features),
      mojo::Clone(devtools_token),
      mojo::Clone(devtools_host),
      mojo::Clone(code_cache_host),
      mojo::Clone(browser_interface_broker),
      mojo::Clone(wait_for_debugger)
  );
}

template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>*>
bool WorkletGlobalScopeCreationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->script_url, other_struct.script_url))
    return false;
  if (!mojo::Equals(this->starter_origin, other_struct.starter_origin))
    return false;
  if (!mojo::Equals(this->origin_trial_features, other_struct.origin_trial_features))
    return false;
  if (!mojo::Equals(this->devtools_token, other_struct.devtools_token))
    return false;
  if (!mojo::Equals(this->devtools_host, other_struct.devtools_host))
    return false;
  if (!mojo::Equals(this->code_cache_host, other_struct.code_cache_host))
    return false;
  if (!mojo::Equals(this->browser_interface_broker, other_struct.browser_interface_broker))
    return false;
  if (!mojo::Equals(this->wait_for_debugger, other_struct.wait_for_debugger))
    return false;
  return true;
}

template <typename T, WorkletGlobalScopeCreationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.script_url < rhs.script_url)
    return true;
  if (rhs.script_url < lhs.script_url)
    return false;
  if (lhs.starter_origin < rhs.starter_origin)
    return true;
  if (rhs.starter_origin < lhs.starter_origin)
    return false;
  if (lhs.origin_trial_features < rhs.origin_trial_features)
    return true;
  if (rhs.origin_trial_features < lhs.origin_trial_features)
    return false;
  if (lhs.devtools_token < rhs.devtools_token)
    return true;
  if (rhs.devtools_token < lhs.devtools_token)
    return false;
  if (lhs.devtools_host < rhs.devtools_host)
    return true;
  if (rhs.devtools_host < lhs.devtools_host)
    return false;
  if (lhs.code_cache_host < rhs.code_cache_host)
    return true;
  if (rhs.code_cache_host < lhs.code_cache_host)
    return false;
  if (lhs.browser_interface_broker < rhs.browser_interface_broker)
    return true;
  if (rhs.browser_interface_broker < lhs.browser_interface_broker)
    return false;
  if (lhs.wait_for_debugger < rhs.wait_for_debugger)
    return true;
  if (rhs.wait_for_debugger < lhs.wait_for_debugger)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WorkletGlobalScopeCreationParams::DataView,
                                         ::blink::mojom::WorkletGlobalScopeCreationParamsPtr> {
  static bool IsNull(const ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WorkletGlobalScopeCreationParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WorkletGlobalScopeCreationParams::script_url)& script_url(
      const ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) {
    return input->script_url;
  }

  static const decltype(::blink::mojom::WorkletGlobalScopeCreationParams::starter_origin)& starter_origin(
      const ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) {
    return input->starter_origin;
  }

  static const decltype(::blink::mojom::WorkletGlobalScopeCreationParams::origin_trial_features)& origin_trial_features(
      const ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) {
    return input->origin_trial_features;
  }

  static const decltype(::blink::mojom::WorkletGlobalScopeCreationParams::devtools_token)& devtools_token(
      const ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) {
    return input->devtools_token;
  }

  static  decltype(::blink::mojom::WorkletGlobalScopeCreationParams::devtools_host)& devtools_host(
       ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) {
    return input->devtools_host;
  }

  static  decltype(::blink::mojom::WorkletGlobalScopeCreationParams::code_cache_host)& code_cache_host(
       ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) {
    return input->code_cache_host;
  }

  static  decltype(::blink::mojom::WorkletGlobalScopeCreationParams::browser_interface_broker)& browser_interface_broker(
       ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) {
    return input->browser_interface_broker;
  }

  static decltype(::blink::mojom::WorkletGlobalScopeCreationParams::wait_for_debugger) wait_for_debugger(
      const ::blink::mojom::WorkletGlobalScopeCreationParamsPtr& input) {
    return input->wait_for_debugger;
  }

  static bool Read(::blink::mojom::WorkletGlobalScopeCreationParams::DataView input, ::blink::mojom::WorkletGlobalScopeCreationParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_H_