// third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_ACCESS_STORAGE_ACCESS_HANDLE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_ACCESS_STORAGE_ACCESS_HANDLE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/broadcastchannel/broadcast_channel.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/locks/lock_manager.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/modules/modules_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class StorageAccessHandleProxy;

template <typename ImplRefTraits>
class StorageAccessHandleStub;

class StorageAccessHandleRequestValidator;
class StorageAccessHandleResponseValidator;


class MODULES_EXPORT StorageAccessHandle
    : public StorageAccessHandleInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StorageAccessHandleInterfaceBase;
  using Proxy_ = StorageAccessHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = StorageAccessHandleStub<ImplRefTraits>;

  using RequestValidator_ = StorageAccessHandleRequestValidator;
  using ResponseValidator_ = StorageAccessHandleResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindIndexedDBMinVersion = 0,
    kBindLocksMinVersion = 0,
    kBindCachesMinVersion = 0,
    kGetDirectoryMinVersion = 0,
    kEstimateMinVersion = 0,
    kBindBlobStorageMinVersion = 0,
    kBindBroadcastChannelMinVersion = 0,
    kBindSharedWorkerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindIndexedDB_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindLocks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindCaches_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Estimate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindBlobStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindBroadcastChannel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindSharedWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StorageAccessHandle() = default;

  
  virtual void BindIndexedDB(::mojo::PendingReceiver<::blink::mojom::blink::IDBFactory> receiver) = 0;

  
  virtual void BindLocks(::mojo::PendingReceiver<::blink::mojom::blink::LockManager> receiver) = 0;

  
  virtual void BindCaches(::mojo::PendingReceiver<::blink::mojom::blink::CacheStorage> receiver) = 0;


  using GetDirectoryCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessDirectoryHandle>)>;
  
  virtual void GetDirectory(GetDirectoryCallback callback) = 0;


  using EstimateCallback = base::OnceCallback<void(int64_t, int64_t, bool)>;
  
  virtual void Estimate(EstimateCallback callback) = 0;

  
  virtual void BindBlobStorage(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BlobURLStore> receiver) = 0;

  
  virtual void BindBroadcastChannel(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BroadcastChannelProvider> receiver) = 0;

  
  virtual void BindSharedWorker(::mojo::PendingReceiver<::blink::mojom::blink::SharedWorkerConnector> receiver) = 0;
};



class MODULES_EXPORT StorageAccessHandleProxy
    : public StorageAccessHandle {
 public:
  using InterfaceType = StorageAccessHandle;

  explicit StorageAccessHandleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindIndexedDB(::mojo::PendingReceiver<::blink::mojom::blink::IDBFactory> receiver) final;
  
  void BindLocks(::mojo::PendingReceiver<::blink::mojom::blink::LockManager> receiver) final;
  
  void BindCaches(::mojo::PendingReceiver<::blink::mojom::blink::CacheStorage> receiver) final;
  
  void GetDirectory(GetDirectoryCallback callback) final;
  
  void Estimate(EstimateCallback callback) final;
  
  void BindBlobStorage(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BlobURLStore> receiver) final;
  
  void BindBroadcastChannel(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::BroadcastChannelProvider> receiver) final;
  
  void BindSharedWorker(::mojo::PendingReceiver<::blink::mojom::blink::SharedWorkerConnector> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class MODULES_EXPORT StorageAccessHandleStubDispatch {
 public:
  static bool Accept(StorageAccessHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StorageAccessHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StorageAccessHandle>>
class StorageAccessHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StorageAccessHandleStub() = default;
  ~StorageAccessHandleStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageAccessHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StorageAccessHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class MODULES_EXPORT StorageAccessHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class MODULES_EXPORT StorageAccessHandleResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_ACCESS_STORAGE_ACCESS_HANDLE_MOJOM_BLINK_H_