// third_party/blink/public/mojom/renderer_preferences.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "ui/gfx/mojom/font_render_params.mojom-shared.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class RendererPreferencesDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::RendererPreferencesDataView> {
  using Data = ::blink::mojom::internal::RendererPreferences_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class RendererPreferencesDataView {
 public:
  RendererPreferencesDataView() = default;

  RendererPreferencesDataView(
      internal::RendererPreferences_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool can_accept_load_drops() const {
    return data_->can_accept_load_drops;
  }
  bool should_antialias_text() const {
    return data_->should_antialias_text;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHinting(UserType* output) const {
    auto data_value = data_->hinting;
    return mojo::internal::Deserialize<::gfx::mojom::Hinting>(
        data_value, output);
  }
  ::gfx::mojom::Hinting hinting() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::Hinting>(data_->hinting));
  }
  bool use_autohinter() const {
    return data_->use_autohinter;
  }
  bool use_bitmaps() const {
    return data_->use_bitmaps;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSubpixelRendering(UserType* output) const {
    auto data_value = data_->subpixel_rendering;
    return mojo::internal::Deserialize<::gfx::mojom::SubpixelRendering>(
        data_value, output);
  }
  ::gfx::mojom::SubpixelRendering subpixel_rendering() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::SubpixelRendering>(data_->subpixel_rendering));
  }
  bool use_subpixel_positioning() const {
    return data_->use_subpixel_positioning;
  }
  uint32_t focus_ring_color() const {
    return data_->focus_ring_color;
  }
  uint32_t active_selection_bg_color() const {
    return data_->active_selection_bg_color;
  }
  uint32_t active_selection_fg_color() const {
    return data_->active_selection_fg_color;
  }
  uint32_t inactive_selection_bg_color() const {
    return data_->inactive_selection_bg_color;
  }
  uint32_t inactive_selection_fg_color() const {
    return data_->inactive_selection_fg_color;
  }
  bool browser_handles_all_top_level_requests() const {
    return data_->browser_handles_all_top_level_requests;
  }
  inline void GetCaretBlinkIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaretBlinkInterval(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `caret_blink_interval` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCaretBlinkInterval` instead "
    "of `ReadCaretBlinkInterval if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->caret_blink_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool use_custom_colors() const {
    return data_->use_custom_colors;
  }
  bool enable_referrers() const {
    return data_->enable_referrers;
  }
  bool allow_cross_origin_auth_prompt() const {
    return data_->allow_cross_origin_auth_prompt;
  }
  bool enable_do_not_track() const {
    return data_->enable_do_not_track;
  }
  bool enable_encrypted_media() const {
    return data_->enable_encrypted_media;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWebrtcIpHandlingPolicy(UserType* output) const {
    auto data_value = data_->webrtc_ip_handling_policy;
    return mojo::internal::Deserialize<::blink::mojom::WebRtcIpHandlingPolicy>(
        data_value, output);
  }
  ::blink::mojom::WebRtcIpHandlingPolicy webrtc_ip_handling_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebRtcIpHandlingPolicy>(data_->webrtc_ip_handling_policy));
  }
  inline void GetWebrtcIpHandlingUrlsDataView(
      mojo::ArrayDataView<::blink::mojom::WebRtcIpHandlingUrlEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebrtcIpHandlingUrls(UserType* output) {
    
    auto* pointer = data_->webrtc_ip_handling_urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebRtcIpHandlingUrlEntryDataView>>(
        pointer, output, message_);
  }
  uint16_t webrtc_udp_min_port() const {
    return data_->webrtc_udp_min_port;
  }
  uint16_t webrtc_udp_max_port() const {
    return data_->webrtc_udp_max_port;
  }
  inline void GetWebrtcLocalIpsAllowedUrlsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebrtcLocalIpsAllowedUrls(UserType* output) {
    
    auto* pointer = data_->webrtc_local_ips_allowed_urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetUserAgentOverrideDataView(
      ::blink::mojom::UserAgentOverrideDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAgentOverride(UserType* output) {
    
    auto* pointer = data_->user_agent_override.Get();
    return mojo::internal::Deserialize<::blink::mojom::UserAgentOverrideDataView>(
        pointer, output, message_);
  }
  inline void GetAcceptLanguagesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAcceptLanguages(UserType* output) {
    
    auto* pointer = data_->accept_languages.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool send_subresource_notification() const {
    return data_->send_subresource_notification;
  }
  bool plugin_fullscreen_allowed() const {
    return data_->plugin_fullscreen_allowed;
  }
  bool caret_browsing_enabled() const {
    return data_->caret_browsing_enabled;
  }
  inline void GetSystemFontFamilyNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSystemFontFamilyName(UserType* output) {
    
    auto* pointer = data_->system_font_family_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool selection_clipboard_buffer_available() const {
    return data_->selection_clipboard_buffer_available;
  }
  inline void GetExplicitlyAllowedNetworkPortsDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExplicitlyAllowedNetworkPorts(UserType* output) {
    
    auto* pointer = data_->explicitly_allowed_network_ports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
 private:
  internal::RendererPreferences_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RendererPreferencesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RendererPreferencesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RendererPreferences_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->can_accept_load_drops = Traits::can_accept_load_drops(input);
    fragment->should_antialias_text = Traits::should_antialias_text(input);
    mojo::internal::Serialize<::gfx::mojom::Hinting>(
        Traits::hinting(input), &fragment->hinting);
    fragment->use_autohinter = Traits::use_autohinter(input);
    fragment->use_bitmaps = Traits::use_bitmaps(input);
    mojo::internal::Serialize<::gfx::mojom::SubpixelRendering>(
        Traits::subpixel_rendering(input), &fragment->subpixel_rendering);
    fragment->use_subpixel_positioning = Traits::use_subpixel_positioning(input);
    fragment->focus_ring_color = Traits::focus_ring_color(input);
    fragment->active_selection_bg_color = Traits::active_selection_bg_color(input);
    fragment->active_selection_fg_color = Traits::active_selection_fg_color(input);
    fragment->inactive_selection_bg_color = Traits::inactive_selection_bg_color(input);
    fragment->inactive_selection_fg_color = Traits::inactive_selection_fg_color(input);
    fragment->browser_handles_all_top_level_requests = Traits::browser_handles_all_top_level_requests(input);
    decltype(Traits::caret_blink_interval(input)) in_caret_blink_interval = Traits::caret_blink_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->caret_blink_interval)::BaseType> caret_blink_interval_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_caret_blink_interval, caret_blink_interval_fragment);
    fragment->caret_blink_interval.Set(
        caret_blink_interval_fragment.is_null() ? nullptr : caret_blink_interval_fragment.data());
    fragment->use_custom_colors = Traits::use_custom_colors(input);
    fragment->enable_referrers = Traits::enable_referrers(input);
    fragment->allow_cross_origin_auth_prompt = Traits::allow_cross_origin_auth_prompt(input);
    fragment->enable_do_not_track = Traits::enable_do_not_track(input);
    fragment->enable_encrypted_media = Traits::enable_encrypted_media(input);
    mojo::internal::Serialize<::blink::mojom::WebRtcIpHandlingPolicy>(
        Traits::webrtc_ip_handling_policy(input), &fragment->webrtc_ip_handling_policy);
    decltype(Traits::webrtc_ip_handling_urls(input)) in_webrtc_ip_handling_urls = Traits::webrtc_ip_handling_urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->webrtc_ip_handling_urls)::BaseType>
        webrtc_ip_handling_urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& webrtc_ip_handling_urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebRtcIpHandlingUrlEntryDataView>>(
        in_webrtc_ip_handling_urls, webrtc_ip_handling_urls_fragment, &webrtc_ip_handling_urls_validate_params);
    fragment->webrtc_ip_handling_urls.Set(
        webrtc_ip_handling_urls_fragment.is_null() ? nullptr : webrtc_ip_handling_urls_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->webrtc_ip_handling_urls.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null webrtc_ip_handling_urls in RendererPreferences struct");
    fragment->webrtc_udp_min_port = Traits::webrtc_udp_min_port(input);
    fragment->webrtc_udp_max_port = Traits::webrtc_udp_max_port(input);
    decltype(Traits::webrtc_local_ips_allowed_urls(input)) in_webrtc_local_ips_allowed_urls = Traits::webrtc_local_ips_allowed_urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->webrtc_local_ips_allowed_urls)::BaseType>
        webrtc_local_ips_allowed_urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& webrtc_local_ips_allowed_urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_webrtc_local_ips_allowed_urls, webrtc_local_ips_allowed_urls_fragment, &webrtc_local_ips_allowed_urls_validate_params);
    fragment->webrtc_local_ips_allowed_urls.Set(
        webrtc_local_ips_allowed_urls_fragment.is_null() ? nullptr : webrtc_local_ips_allowed_urls_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->webrtc_local_ips_allowed_urls.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null webrtc_local_ips_allowed_urls in RendererPreferences struct");
    decltype(Traits::user_agent_override(input)) in_user_agent_override = Traits::user_agent_override(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_agent_override)::BaseType> user_agent_override_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::UserAgentOverrideDataView>(
        in_user_agent_override, user_agent_override_fragment);
    fragment->user_agent_override.Set(
        user_agent_override_fragment.is_null() ? nullptr : user_agent_override_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->user_agent_override.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_agent_override in RendererPreferences struct");
    decltype(Traits::accept_languages(input)) in_accept_languages = Traits::accept_languages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept_languages)::BaseType> accept_languages_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_accept_languages, accept_languages_fragment);
    fragment->accept_languages.Set(
        accept_languages_fragment.is_null() ? nullptr : accept_languages_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->accept_languages.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept_languages in RendererPreferences struct");
    fragment->send_subresource_notification = Traits::send_subresource_notification(input);
    fragment->plugin_fullscreen_allowed = Traits::plugin_fullscreen_allowed(input);
    fragment->caret_browsing_enabled = Traits::caret_browsing_enabled(input);
    decltype(Traits::system_font_family_name(input)) in_system_font_family_name = Traits::system_font_family_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->system_font_family_name)::BaseType> system_font_family_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_system_font_family_name, system_font_family_name_fragment);
    fragment->system_font_family_name.Set(
        system_font_family_name_fragment.is_null() ? nullptr : system_font_family_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->system_font_family_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null system_font_family_name in RendererPreferences struct");
    fragment->selection_clipboard_buffer_available = Traits::selection_clipboard_buffer_available(input);
    decltype(Traits::explicitly_allowed_network_ports(input)) in_explicitly_allowed_network_ports = Traits::explicitly_allowed_network_ports(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->explicitly_allowed_network_ports)::BaseType>
        explicitly_allowed_network_ports_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& explicitly_allowed_network_ports_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
        in_explicitly_allowed_network_ports, explicitly_allowed_network_ports_fragment, &explicitly_allowed_network_ports_validate_params);
    fragment->explicitly_allowed_network_ports.Set(
        explicitly_allowed_network_ports_fragment.is_null() ? nullptr : explicitly_allowed_network_ports_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->explicitly_allowed_network_ports.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null explicitly_allowed_network_ports in RendererPreferences struct");
  }

  static bool Deserialize(::blink::mojom::internal::RendererPreferences_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RendererPreferencesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void RendererPreferencesDataView::GetCaretBlinkIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->caret_blink_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void RendererPreferencesDataView::GetWebrtcIpHandlingUrlsDataView(
    mojo::ArrayDataView<::blink::mojom::WebRtcIpHandlingUrlEntryDataView>* output) {
  auto pointer = data_->webrtc_ip_handling_urls.Get();
  *output = mojo::ArrayDataView<::blink::mojom::WebRtcIpHandlingUrlEntryDataView>(pointer, message_);
}
inline void RendererPreferencesDataView::GetWebrtcLocalIpsAllowedUrlsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->webrtc_local_ips_allowed_urls.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void RendererPreferencesDataView::GetUserAgentOverrideDataView(
    ::blink::mojom::UserAgentOverrideDataView* output) {
  auto pointer = data_->user_agent_override.Get();
  *output = ::blink::mojom::UserAgentOverrideDataView(pointer, message_);
}
inline void RendererPreferencesDataView::GetAcceptLanguagesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->accept_languages.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RendererPreferencesDataView::GetSystemFontFamilyNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->system_font_family_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RendererPreferencesDataView::GetExplicitlyAllowedNetworkPortsDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->explicitly_allowed_network_ports.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_SHARED_H_