// third_party/blink/public/mojom/page/browsing_context_group_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_BROWSING_CONTEXT_GROUP_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_BROWSING_CONTEXT_GROUP_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page/browsing_context_group_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class BrowsingContextGroupInfoDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::BrowsingContextGroupInfoDataView> {
  using Data = ::blink::mojom::internal::BrowsingContextGroupInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class BrowsingContextGroupInfoDataView {
 public:
  BrowsingContextGroupInfoDataView() = default;

  BrowsingContextGroupInfoDataView(
      internal::BrowsingContextGroupInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBrowsingContextGroupTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowsingContextGroupToken(UserType* output) {
    
    auto* pointer = data_->browsing_context_group_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetCoopRelatedGroupTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCoopRelatedGroupToken(UserType* output) {
    
    auto* pointer = data_->coop_related_group_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::BrowsingContextGroupInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BrowsingContextGroupInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BrowsingContextGroupInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BrowsingContextGroupInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::browsing_context_group_token(input)) in_browsing_context_group_token = Traits::browsing_context_group_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browsing_context_group_token)::BaseType> browsing_context_group_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_browsing_context_group_token, browsing_context_group_token_fragment);
    fragment->browsing_context_group_token.Set(
        browsing_context_group_token_fragment.is_null() ? nullptr : browsing_context_group_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->browsing_context_group_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null browsing_context_group_token in BrowsingContextGroupInfo struct");
    decltype(Traits::coop_related_group_token(input)) in_coop_related_group_token = Traits::coop_related_group_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coop_related_group_token)::BaseType> coop_related_group_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_coop_related_group_token, coop_related_group_token_fragment);
    fragment->coop_related_group_token.Set(
        coop_related_group_token_fragment.is_null() ? nullptr : coop_related_group_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coop_related_group_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coop_related_group_token in BrowsingContextGroupInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::BrowsingContextGroupInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BrowsingContextGroupInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void BrowsingContextGroupInfoDataView::GetBrowsingContextGroupTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->browsing_context_group_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void BrowsingContextGroupInfoDataView::GetCoopRelatedGroupTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->coop_related_group_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_BROWSING_CONTEXT_GROUP_INFO_MOJOM_SHARED_H_