// third_party/blink/public/mojom/loader/local_resource_loader_config.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/local_resource_loader_config.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {









class BLINK_COMMON_EXPORT LocalResourceSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocalResourceSource, T>::value>;
  using DataView = LocalResourceSourceDataView;
  using Data_ = internal::LocalResourceSource_Data;

  template <typename... Args>
  static LocalResourceSourcePtr New(Args&&... args) {
    return LocalResourceSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalResourceSourcePtr From(const U& u) {
    return mojo::TypeConverter<LocalResourceSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalResourceSource>::Convert(*this);
  }


  LocalResourceSource();

  LocalResourceSource(
      const std::string& headers,
      bool should_replace_i18n_in_js,
      const base::flat_map<std::string, int32_t>& path_to_resource_id_map,
      const base::flat_map<std::string, std::string>& replacement_strings);


  ~LocalResourceSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalResourceSourcePtr>
  LocalResourceSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalResourceSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalResourceSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocalResourceSource_UnserializedMessageContext<
            UserType, LocalResourceSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LocalResourceSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LocalResourceSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocalResourceSource_UnserializedMessageContext<
            UserType, LocalResourceSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocalResourceSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string headers;
  
  bool should_replace_i18n_in_js;
  
  base::flat_map<std::string, int32_t> path_to_resource_id_map;
  
  base::flat_map<std::string, std::string> replacement_strings;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocalResourceSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT LocalResourceLoaderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocalResourceLoaderConfig, T>::value>;
  using DataView = LocalResourceLoaderConfigDataView;
  using Data_ = internal::LocalResourceLoaderConfig_Data;

  template <typename... Args>
  static LocalResourceLoaderConfigPtr New(Args&&... args) {
    return LocalResourceLoaderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocalResourceLoaderConfigPtr From(const U& u) {
    return mojo::TypeConverter<LocalResourceLoaderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalResourceLoaderConfig>::Convert(*this);
  }


  LocalResourceLoaderConfig();

  explicit LocalResourceLoaderConfig(
      base::flat_map<::url::Origin, LocalResourceSourcePtr> sources);

LocalResourceLoaderConfig(const LocalResourceLoaderConfig&) = delete;
LocalResourceLoaderConfig& operator=(const LocalResourceLoaderConfig&) = delete;

  ~LocalResourceLoaderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocalResourceLoaderConfigPtr>
  LocalResourceLoaderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocalResourceLoaderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalResourceLoaderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocalResourceLoaderConfig_UnserializedMessageContext<
            UserType, LocalResourceLoaderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LocalResourceLoaderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LocalResourceLoaderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocalResourceLoaderConfig_UnserializedMessageContext<
            UserType, LocalResourceLoaderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocalResourceLoaderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<::url::Origin, LocalResourceSourcePtr> sources;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LocalResourceSourcePtr LocalResourceSource::Clone() const {
  return New(
      mojo::Clone(headers),
      mojo::Clone(should_replace_i18n_in_js),
      mojo::Clone(path_to_resource_id_map),
      mojo::Clone(replacement_strings)
  );
}

template <typename T, LocalResourceSource::EnableIfSame<T>*>
bool LocalResourceSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->should_replace_i18n_in_js, other_struct.should_replace_i18n_in_js))
    return false;
  if (!mojo::Equals(this->path_to_resource_id_map, other_struct.path_to_resource_id_map))
    return false;
  if (!mojo::Equals(this->replacement_strings, other_struct.replacement_strings))
    return false;
  return true;
}

template <typename T, LocalResourceSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.should_replace_i18n_in_js < rhs.should_replace_i18n_in_js)
    return true;
  if (rhs.should_replace_i18n_in_js < lhs.should_replace_i18n_in_js)
    return false;
  if (lhs.path_to_resource_id_map < rhs.path_to_resource_id_map)
    return true;
  if (rhs.path_to_resource_id_map < lhs.path_to_resource_id_map)
    return false;
  if (lhs.replacement_strings < rhs.replacement_strings)
    return true;
  if (rhs.replacement_strings < lhs.replacement_strings)
    return false;
  return false;
}
template <typename StructPtrType>
LocalResourceLoaderConfigPtr LocalResourceLoaderConfig::Clone() const {
  return New(
      mojo::Clone(sources)
  );
}

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>*>
bool LocalResourceLoaderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sources, other_struct.sources))
    return false;
  return true;
}

template <typename T, LocalResourceLoaderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sources < rhs.sources)
    return true;
  if (rhs.sources < lhs.sources)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::LocalResourceSource::DataView,
                                         ::blink::mojom::LocalResourceSourcePtr> {
  static bool IsNull(const ::blink::mojom::LocalResourceSourcePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::LocalResourceSourcePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::LocalResourceSource::headers)& headers(
      const ::blink::mojom::LocalResourceSourcePtr& input) {
    return input->headers;
  }

  static decltype(::blink::mojom::LocalResourceSource::should_replace_i18n_in_js) should_replace_i18n_in_js(
      const ::blink::mojom::LocalResourceSourcePtr& input) {
    return input->should_replace_i18n_in_js;
  }

  static const decltype(::blink::mojom::LocalResourceSource::path_to_resource_id_map)& path_to_resource_id_map(
      const ::blink::mojom::LocalResourceSourcePtr& input) {
    return input->path_to_resource_id_map;
  }

  static const decltype(::blink::mojom::LocalResourceSource::replacement_strings)& replacement_strings(
      const ::blink::mojom::LocalResourceSourcePtr& input) {
    return input->replacement_strings;
  }

  static bool Read(::blink::mojom::LocalResourceSource::DataView input, ::blink::mojom::LocalResourceSourcePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::LocalResourceLoaderConfig::DataView,
                                         ::blink::mojom::LocalResourceLoaderConfigPtr> {
  static bool IsNull(const ::blink::mojom::LocalResourceLoaderConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::LocalResourceLoaderConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::LocalResourceLoaderConfig::sources)& sources(
      const ::blink::mojom::LocalResourceLoaderConfigPtr& input) {
    return input->sources;
  }

  static bool Read(::blink::mojom::LocalResourceLoaderConfig::DataView input, ::blink::mojom::LocalResourceLoaderConfigPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_LOCAL_RESOURCE_LOADER_CONFIG_MOJOM_H_