// third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LCP_CRITICAL_PATH_PREDICTOR_LCP_CRITICAL_PATH_PREDICTOR_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LCP_CRITICAL_PATH_PREDICTOR_LCP_CRITICAL_PATH_PREDICTOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class LCPCriticalPathPredictorNavigationTimeHintDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView> {
  using Data = ::blink::mojom::internal::LCPCriticalPathPredictorNavigationTimeHint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class LCPCriticalPathPredictorHostInterfaceBase {};

using LCPCriticalPathPredictorHostPtrDataView =
    mojo::InterfacePtrDataView<LCPCriticalPathPredictorHostInterfaceBase>;
using LCPCriticalPathPredictorHostRequestDataView =
    mojo::InterfaceRequestDataView<LCPCriticalPathPredictorHostInterfaceBase>;
using LCPCriticalPathPredictorHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LCPCriticalPathPredictorHostInterfaceBase>;
using LCPCriticalPathPredictorHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LCPCriticalPathPredictorHostInterfaceBase>;


class LCPCriticalPathPredictorNavigationTimeHintDataView {
 public:
  LCPCriticalPathPredictorNavigationTimeHintDataView() = default;

  LCPCriticalPathPredictorNavigationTimeHintDataView(
      internal::LCPCriticalPathPredictorNavigationTimeHint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLcpElementLocatorsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLcpElementLocators(UserType* output) {
    
    auto* pointer = data_->lcp_element_locators.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
        pointer, output, message_);
  }
  inline void GetLcpInfluencerScriptsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLcpInfluencerScripts(UserType* output) {
    
    auto* pointer = data_->lcp_influencer_scripts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetFetchedFontsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchedFonts(UserType* output) {
    
    auto* pointer = data_->fetched_fonts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetPreconnectOriginsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreconnectOrigins(UserType* output) {
    
    auto* pointer = data_->preconnect_origins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetUnusedPreloadsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnusedPreloads(UserType* output) {
    
    auto* pointer = data_->unused_preloads.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::LCPCriticalPathPredictorNavigationTimeHint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LCPCriticalPathPredictorNavigationTimeHint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::lcp_element_locators(input)) in_lcp_element_locators = Traits::lcp_element_locators(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lcp_element_locators)::BaseType>
        lcp_element_locators_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& lcp_element_locators_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
        in_lcp_element_locators, lcp_element_locators_fragment, &lcp_element_locators_validate_params);
    fragment->lcp_element_locators.Set(
        lcp_element_locators_fragment.is_null() ? nullptr : lcp_element_locators_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->lcp_element_locators.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lcp_element_locators in LCPCriticalPathPredictorNavigationTimeHint struct");
    decltype(Traits::lcp_influencer_scripts(input)) in_lcp_influencer_scripts = Traits::lcp_influencer_scripts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lcp_influencer_scripts)::BaseType>
        lcp_influencer_scripts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& lcp_influencer_scripts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_lcp_influencer_scripts, lcp_influencer_scripts_fragment, &lcp_influencer_scripts_validate_params);
    fragment->lcp_influencer_scripts.Set(
        lcp_influencer_scripts_fragment.is_null() ? nullptr : lcp_influencer_scripts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->lcp_influencer_scripts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lcp_influencer_scripts in LCPCriticalPathPredictorNavigationTimeHint struct");
    decltype(Traits::fetched_fonts(input)) in_fetched_fonts = Traits::fetched_fonts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetched_fonts)::BaseType>
        fetched_fonts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fetched_fonts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_fetched_fonts, fetched_fonts_fragment, &fetched_fonts_validate_params);
    fragment->fetched_fonts.Set(
        fetched_fonts_fragment.is_null() ? nullptr : fetched_fonts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fetched_fonts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fetched_fonts in LCPCriticalPathPredictorNavigationTimeHint struct");
    decltype(Traits::preconnect_origins(input)) in_preconnect_origins = Traits::preconnect_origins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->preconnect_origins)::BaseType>
        preconnect_origins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& preconnect_origins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_preconnect_origins, preconnect_origins_fragment, &preconnect_origins_validate_params);
    fragment->preconnect_origins.Set(
        preconnect_origins_fragment.is_null() ? nullptr : preconnect_origins_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->preconnect_origins.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null preconnect_origins in LCPCriticalPathPredictorNavigationTimeHint struct");
    decltype(Traits::unused_preloads(input)) in_unused_preloads = Traits::unused_preloads(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unused_preloads)::BaseType>
        unused_preloads_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& unused_preloads_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_unused_preloads, unused_preloads_fragment, &unused_preloads_validate_params);
    fragment->unused_preloads.Set(
        unused_preloads_fragment.is_null() ? nullptr : unused_preloads_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->unused_preloads.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null unused_preloads in LCPCriticalPathPredictorNavigationTimeHint struct");
  }

  static bool Deserialize(::blink::mojom::internal::LCPCriticalPathPredictorNavigationTimeHint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void LCPCriticalPathPredictorNavigationTimeHintDataView::GetLcpElementLocatorsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>* output) {
  auto pointer = data_->lcp_element_locators.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>(pointer, message_);
}
inline void LCPCriticalPathPredictorNavigationTimeHintDataView::GetLcpInfluencerScriptsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->lcp_influencer_scripts.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void LCPCriticalPathPredictorNavigationTimeHintDataView::GetFetchedFontsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->fetched_fonts.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void LCPCriticalPathPredictorNavigationTimeHintDataView::GetPreconnectOriginsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->preconnect_origins.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void LCPCriticalPathPredictorNavigationTimeHintDataView::GetUnusedPreloadsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->unused_preloads.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LCP_CRITICAL_PATH_PREDICTOR_LCP_CRITICAL_PATH_PREDICTOR_MOJOM_SHARED_H_