// third_party/blink/public/mojom/frame/frame_replication_state.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include "third_party/blink/public/mojom/permissions_policy/permissions_policy.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-forward.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT FrameReplicationState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameReplicationState, T>::value>;
  using DataView = FrameReplicationStateDataView;
  using Data_ = internal::FrameReplicationState_Data;

  template <typename... Args>
  static FrameReplicationStatePtr New(Args&&... args) {
    return FrameReplicationStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameReplicationStatePtr From(const U& u) {
    return mojo::TypeConverter<FrameReplicationStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameReplicationState>::Convert(*this);
  }


  FrameReplicationState();

  FrameReplicationState(
      const ::url::Origin& origin,
      const std::string& name,
      const std::string& unique_name,
      std::vector<::blink::ParsedPermissionsPolicyDeclaration> permissions_policy_header,
      ::network::mojom::WebSandboxFlags active_sandbox_flags,
      const ::blink::FramePolicy& frame_policy,
      ::blink::mojom::InsecureRequestPolicy insecure_request_policy,
      std::vector<uint32_t> insecure_navigations_set,
      bool has_potentially_trustworthy_unique_origin,
      bool has_active_user_gesture,
      bool has_received_user_gesture_before_nav,
      bool is_ad_frame);


  ~FrameReplicationState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameReplicationStatePtr>
  FrameReplicationStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameReplicationState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameReplicationState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameReplicationState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameReplicationState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameReplicationState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameReplicationState_UnserializedMessageContext<
            UserType, FrameReplicationState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameReplicationState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameReplicationState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameReplicationState_UnserializedMessageContext<
            UserType, FrameReplicationState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameReplicationState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  std::string name;
  
  std::string unique_name;
  
  std::vector<::blink::ParsedPermissionsPolicyDeclaration> permissions_policy_header;
  
  ::network::mojom::WebSandboxFlags active_sandbox_flags;
  
  ::blink::FramePolicy frame_policy;
  
  ::blink::mojom::InsecureRequestPolicy insecure_request_policy;
  
  std::vector<uint32_t> insecure_navigations_set;
  
  bool has_potentially_trustworthy_unique_origin;
  
  bool has_active_user_gesture;
  
  bool has_received_user_gesture_before_nav;
  
  bool is_ad_frame;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameReplicationState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameReplicationState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameReplicationState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameReplicationState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameReplicationStatePtr FrameReplicationState::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(name),
      mojo::Clone(unique_name),
      mojo::Clone(permissions_policy_header),
      mojo::Clone(active_sandbox_flags),
      mojo::Clone(frame_policy),
      mojo::Clone(insecure_request_policy),
      mojo::Clone(insecure_navigations_set),
      mojo::Clone(has_potentially_trustworthy_unique_origin),
      mojo::Clone(has_active_user_gesture),
      mojo::Clone(has_received_user_gesture_before_nav),
      mojo::Clone(is_ad_frame)
  );
}

template <typename T, FrameReplicationState::EnableIfSame<T>*>
bool FrameReplicationState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->unique_name, other_struct.unique_name))
    return false;
  if (!mojo::Equals(this->permissions_policy_header, other_struct.permissions_policy_header))
    return false;
  if (!mojo::Equals(this->active_sandbox_flags, other_struct.active_sandbox_flags))
    return false;
  if (!mojo::Equals(this->frame_policy, other_struct.frame_policy))
    return false;
  if (!mojo::Equals(this->insecure_request_policy, other_struct.insecure_request_policy))
    return false;
  if (!mojo::Equals(this->insecure_navigations_set, other_struct.insecure_navigations_set))
    return false;
  if (!mojo::Equals(this->has_potentially_trustworthy_unique_origin, other_struct.has_potentially_trustworthy_unique_origin))
    return false;
  if (!mojo::Equals(this->has_active_user_gesture, other_struct.has_active_user_gesture))
    return false;
  if (!mojo::Equals(this->has_received_user_gesture_before_nav, other_struct.has_received_user_gesture_before_nav))
    return false;
  if (!mojo::Equals(this->is_ad_frame, other_struct.is_ad_frame))
    return false;
  return true;
}

template <typename T, FrameReplicationState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.unique_name < rhs.unique_name)
    return true;
  if (rhs.unique_name < lhs.unique_name)
    return false;
  if (lhs.permissions_policy_header < rhs.permissions_policy_header)
    return true;
  if (rhs.permissions_policy_header < lhs.permissions_policy_header)
    return false;
  if (lhs.active_sandbox_flags < rhs.active_sandbox_flags)
    return true;
  if (rhs.active_sandbox_flags < lhs.active_sandbox_flags)
    return false;
  if (lhs.frame_policy < rhs.frame_policy)
    return true;
  if (rhs.frame_policy < lhs.frame_policy)
    return false;
  if (lhs.insecure_request_policy < rhs.insecure_request_policy)
    return true;
  if (rhs.insecure_request_policy < lhs.insecure_request_policy)
    return false;
  if (lhs.insecure_navigations_set < rhs.insecure_navigations_set)
    return true;
  if (rhs.insecure_navigations_set < lhs.insecure_navigations_set)
    return false;
  if (lhs.has_potentially_trustworthy_unique_origin < rhs.has_potentially_trustworthy_unique_origin)
    return true;
  if (rhs.has_potentially_trustworthy_unique_origin < lhs.has_potentially_trustworthy_unique_origin)
    return false;
  if (lhs.has_active_user_gesture < rhs.has_active_user_gesture)
    return true;
  if (rhs.has_active_user_gesture < lhs.has_active_user_gesture)
    return false;
  if (lhs.has_received_user_gesture_before_nav < rhs.has_received_user_gesture_before_nav)
    return true;
  if (rhs.has_received_user_gesture_before_nav < lhs.has_received_user_gesture_before_nav)
    return false;
  if (lhs.is_ad_frame < rhs.is_ad_frame)
    return true;
  if (rhs.is_ad_frame < lhs.is_ad_frame)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FrameReplicationState::DataView,
                                         ::blink::mojom::FrameReplicationStatePtr> {
  static bool IsNull(const ::blink::mojom::FrameReplicationStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FrameReplicationStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::FrameReplicationState::origin)& origin(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->origin;
  }

  static const decltype(::blink::mojom::FrameReplicationState::name)& name(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::FrameReplicationState::unique_name)& unique_name(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->unique_name;
  }

  static const decltype(::blink::mojom::FrameReplicationState::permissions_policy_header)& permissions_policy_header(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->permissions_policy_header;
  }

  static decltype(::blink::mojom::FrameReplicationState::active_sandbox_flags) active_sandbox_flags(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->active_sandbox_flags;
  }

  static const decltype(::blink::mojom::FrameReplicationState::frame_policy)& frame_policy(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->frame_policy;
  }

  static decltype(::blink::mojom::FrameReplicationState::insecure_request_policy) insecure_request_policy(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->insecure_request_policy;
  }

  static const decltype(::blink::mojom::FrameReplicationState::insecure_navigations_set)& insecure_navigations_set(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->insecure_navigations_set;
  }

  static decltype(::blink::mojom::FrameReplicationState::has_potentially_trustworthy_unique_origin) has_potentially_trustworthy_unique_origin(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->has_potentially_trustworthy_unique_origin;
  }

  static decltype(::blink::mojom::FrameReplicationState::has_active_user_gesture) has_active_user_gesture(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->has_active_user_gesture;
  }

  static decltype(::blink::mojom::FrameReplicationState::has_received_user_gesture_before_nav) has_received_user_gesture_before_nav(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->has_received_user_gesture_before_nav;
  }

  static decltype(::blink::mojom::FrameReplicationState::is_ad_frame) is_ad_frame(
      const ::blink::mojom::FrameReplicationStatePtr& input) {
    return input->is_ad_frame;
  }

  static bool Read(::blink::mojom::FrameReplicationState::DataView input, ::blink::mojom::FrameReplicationStatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_REPLICATION_STATE_MOJOM_H_