// third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared-internal.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class AdAuctionDataDataView;

class URNConfigPairDataView;

class SharedStorageBudgetMetadataDataView;

class ParentPermissionsInfoDataView;

class FencedFrameConfigDataView;

class FencedFramePropertiesDataView;

class PotentiallyOpaqueURLDataView;
class PotentiallyOpaqueSizeDataView;
class PotentiallyOpaqueBoolDataView;
class PotentiallyOpaqueAdAuctionDataDataView;
class PotentiallyOpaqueConfigVectorDataView;
class PotentiallyOpaqueURNConfigVectorDataView;
class PotentiallyOpaqueSharedStorageBudgetMetadataDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AdAuctionDataDataView> {
  using Data = ::blink::mojom::internal::AdAuctionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::URNConfigPairDataView> {
  using Data = ::blink::mojom::internal::URNConfigPair_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SharedStorageBudgetMetadataDataView> {
  using Data = ::blink::mojom::internal::SharedStorageBudgetMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ParentPermissionsInfoDataView> {
  using Data = ::blink::mojom::internal::ParentPermissionsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FencedFrameConfigDataView> {
  using Data = ::blink::mojom::internal::FencedFrameConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FencedFramePropertiesDataView> {
  using Data = ::blink::mojom::internal::FencedFrameProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueURLDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueURL_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueSizeDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueSize_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueBoolDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueBool_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueAdAuctionData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueConfigVectorDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueConfigVector_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueURNConfigVector_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView> {
  using Data = ::blink::mojom::internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ReportingDestination : int32_t {
  
  kBuyer = 0,
  
  kSeller = 1,
  
  kComponentSeller = 2,
  
  kSharedStorageSelectUrl = 3,
  
  kDirectSeller = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ReportingDestination value);
inline bool IsKnownEnumValue(ReportingDestination value) {
  return internal::ReportingDestination_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeprecatedFencedFrameMode : int32_t {
  
  kDefault = 0,
  
  kOpaqueAds = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DeprecatedFencedFrameMode value);
inline bool IsKnownEnumValue(DeprecatedFencedFrameMode value) {
  return internal::DeprecatedFencedFrameMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Opaque : int32_t {
  
  kOpaque = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, Opaque value);
inline bool IsKnownEnumValue(Opaque value) {
  return internal::Opaque_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AutomaticBeaconType : int32_t {
  
  kDeprecatedTopNavigation = 0,
  
  kTopNavigationStart = 1,
  
  kTopNavigationCommit = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AutomaticBeaconType value);
inline bool IsKnownEnumValue(AutomaticBeaconType value) {
  return internal::AutomaticBeaconType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AdAuctionDataDataView {
 public:
  AdAuctionDataDataView() = default;

  AdAuctionDataDataView(
      internal::AdAuctionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInterestGroupOwnerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroupOwner(UserType* output) {
    
    auto* pointer = data_->interest_group_owner.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetInterestGroupNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterestGroupName(UserType* output) {
    
    auto* pointer = data_->interest_group_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AdAuctionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URNConfigPairDataView {
 public:
  URNConfigPairDataView() = default;

  URNConfigPairDataView(
      internal::URNConfigPair_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrnDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrn(UserType* output) {
    
    auto* pointer = data_->urn.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetConfigDataView(
      FencedFrameConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::blink::mojom::FencedFrameConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::URNConfigPair_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedStorageBudgetMetadataDataView {
 public:
  SharedStorageBudgetMetadataDataView() = default;

  SharedStorageBudgetMetadataDataView(
      internal::SharedStorageBudgetMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  double budget_to_charge() const {
    return data_->budget_to_charge;
  }
  bool top_navigated() const {
    return data_->top_navigated;
  }
 private:
  internal::SharedStorageBudgetMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParentPermissionsInfoDataView {
 public:
  ParentPermissionsInfoDataView() = default;

  ParentPermissionsInfoDataView(
      internal::ParentPermissionsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParsedPermissionsPolicyDataView(
      mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsedPermissionsPolicy(UserType* output) {
    
    auto* pointer = data_->parsed_permissions_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::ParentPermissionsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FencedFrameConfigDataView {
 public:
  FencedFrameConfigDataView() = default;

  FencedFrameConfigDataView(
      internal::FencedFrameConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMappedUrlDataView(
      PotentiallyOpaqueURLDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMappedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueURLDataView, UserType>(),
    "Attempting to read the optional `mapped_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMappedUrl` instead "
    "of `ReadMappedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->mapped_url.is_null() ? &data_->mapped_url : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueURLDataView>(
        pointer, output, message_);
  }
  inline void GetContainerSizeDataView(
      PotentiallyOpaqueSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainerSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>(),
    "Attempting to read the optional `container_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContainerSize` instead "
    "of `ReadContainerSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->container_size.is_null() ? &data_->container_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        pointer, output, message_);
  }
  inline void GetContentSizeDataView(
      PotentiallyOpaqueSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>(),
    "Attempting to read the optional `content_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentSize` instead "
    "of `ReadContentSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->content_size.is_null() ? &data_->content_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        pointer, output, message_);
  }
  inline void GetDeprecatedShouldFreezeInitialSizeDataView(
      PotentiallyOpaqueBoolDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedShouldFreezeInitialSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueBoolDataView, UserType>(),
    "Attempting to read the optional `deprecated_should_freeze_initial_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeprecatedShouldFreezeInitialSize` instead "
    "of `ReadDeprecatedShouldFreezeInitialSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->deprecated_should_freeze_initial_size.is_null() ? &data_->deprecated_should_freeze_initial_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueBoolDataView>(
        pointer, output, message_);
  }
  inline void GetAdAuctionDataDataView(
      PotentiallyOpaqueAdAuctionDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdAuctionData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView, UserType>(),
    "Attempting to read the optional `ad_auction_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdAuctionData` instead "
    "of `ReadAdAuctionData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->ad_auction_data.is_null() ? &data_->ad_auction_data : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView>(
        pointer, output, message_);
  }
  inline void GetNestedConfigsDataView(
      PotentiallyOpaqueConfigVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNestedConfigs(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueConfigVectorDataView, UserType>(),
    "Attempting to read the optional `nested_configs` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNestedConfigs` instead "
    "of `ReadNestedConfigs if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->nested_configs.is_null() ? &data_->nested_configs : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueConfigVectorDataView>(
        pointer, output, message_);
  }
  inline void GetSharedStorageBudgetMetadataDataView(
      PotentiallyOpaqueSharedStorageBudgetMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedStorageBudgetMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView, UserType>(),
    "Attempting to read the optional `shared_storage_budget_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedStorageBudgetMetadata` instead "
    "of `ReadSharedStorageBudgetMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->shared_storage_budget_metadata.is_null() ? &data_->shared_storage_budget_metadata : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetUrnUuidDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrnUuid(UserType* output) {
    
    auto* pointer = data_->urn_uuid.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::DeprecatedFencedFrameMode>(
        data_value, output);
  }
  DeprecatedFencedFrameMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DeprecatedFencedFrameMode>(data_->mode));
  }
  inline void GetEffectiveEnabledPermissionsDataView(
      mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveEnabledPermissions(UserType* output) {
    
    auto* pointer = data_->effective_enabled_permissions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>>(
        pointer, output, message_);
  }
  inline void GetParentPermissionsInfoDataView(
      ParentPermissionsInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentPermissionsInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ParentPermissionsInfoDataView, UserType>(),
    "Attempting to read the optional `parent_permissions_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentPermissionsInfo` instead "
    "of `ReadParentPermissionsInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parent_permissions_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ParentPermissionsInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::FencedFrameConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FencedFramePropertiesDataView {
 public:
  FencedFramePropertiesDataView() = default;

  FencedFramePropertiesDataView(
      internal::FencedFrameProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMappedUrlDataView(
      PotentiallyOpaqueURLDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMappedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueURLDataView, UserType>(),
    "Attempting to read the optional `mapped_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMappedUrl` instead "
    "of `ReadMappedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->mapped_url.is_null() ? &data_->mapped_url : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueURLDataView>(
        pointer, output, message_);
  }
  inline void GetContainerSizeDataView(
      PotentiallyOpaqueSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainerSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>(),
    "Attempting to read the optional `container_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContainerSize` instead "
    "of `ReadContainerSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->container_size.is_null() ? &data_->container_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        pointer, output, message_);
  }
  inline void GetContentSizeDataView(
      PotentiallyOpaqueSizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>(),
    "Attempting to read the optional `content_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentSize` instead "
    "of `ReadContentSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->content_size.is_null() ? &data_->content_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        pointer, output, message_);
  }
  inline void GetDeprecatedShouldFreezeInitialSizeDataView(
      PotentiallyOpaqueBoolDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedShouldFreezeInitialSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueBoolDataView, UserType>(),
    "Attempting to read the optional `deprecated_should_freeze_initial_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeprecatedShouldFreezeInitialSize` instead "
    "of `ReadDeprecatedShouldFreezeInitialSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->deprecated_should_freeze_initial_size.is_null() ? &data_->deprecated_should_freeze_initial_size : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueBoolDataView>(
        pointer, output, message_);
  }
  inline void GetAdAuctionDataDataView(
      PotentiallyOpaqueAdAuctionDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdAuctionData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView, UserType>(),
    "Attempting to read the optional `ad_auction_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdAuctionData` instead "
    "of `ReadAdAuctionData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->ad_auction_data.is_null() ? &data_->ad_auction_data : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView>(
        pointer, output, message_);
  }
  inline void GetNestedUrnConfigPairsDataView(
      PotentiallyOpaqueURNConfigVectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNestedUrnConfigPairs(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView, UserType>(),
    "Attempting to read the optional `nested_urn_config_pairs` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNestedUrnConfigPairs` instead "
    "of `ReadNestedUrnConfigPairs if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->nested_urn_config_pairs.is_null() ? &data_->nested_urn_config_pairs : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView>(
        pointer, output, message_);
  }
  inline void GetSharedStorageBudgetMetadataDataView(
      PotentiallyOpaqueSharedStorageBudgetMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedStorageBudgetMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView, UserType>(),
    "Attempting to read the optional `shared_storage_budget_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedStorageBudgetMetadata` instead "
    "of `ReadSharedStorageBudgetMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->shared_storage_budget_metadata.is_null() ? &data_->shared_storage_budget_metadata : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::DeprecatedFencedFrameMode>(
        data_value, output);
  }
  DeprecatedFencedFrameMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DeprecatedFencedFrameMode>(data_->mode));
  }
  inline void GetEffectiveEnabledPermissionsDataView(
      mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveEnabledPermissions(UserType* output) {
    
    auto* pointer = data_->effective_enabled_permissions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>>(
        pointer, output, message_);
  }
  inline void GetParentPermissionsInfoDataView(
      ParentPermissionsInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentPermissionsInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ParentPermissionsInfoDataView, UserType>(),
    "Attempting to read the optional `parent_permissions_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentPermissionsInfo` instead "
    "of `ReadParentPermissionsInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parent_permissions_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ParentPermissionsInfoDataView>(
        pointer, output, message_);
  }
  bool can_disable_untrusted_network() const {
    return data_->can_disable_untrusted_network;
  }
  bool is_cross_origin_content() const {
    return data_->is_cross_origin_content;
  }
  bool allow_cross_origin_event_reporting() const {
    return data_->allow_cross_origin_event_reporting;
  }
 private:
  internal::FencedFrameProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PotentiallyOpaqueURLDataView {
 public:
  using Tag = internal::PotentiallyOpaqueURL_Data::PotentiallyOpaqueURL_Tag;

  PotentiallyOpaqueURLDataView() = default;

  PotentiallyOpaqueURLDataView(
      internal::PotentiallyOpaqueURL_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      ::url::mojom::UrlDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueURL_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueSizeDataView {
 public:
  using Tag = internal::PotentiallyOpaqueSize_Data::PotentiallyOpaqueSize_Tag;

  PotentiallyOpaqueSizeDataView() = default;

  PotentiallyOpaqueSizeDataView(
      internal::PotentiallyOpaqueSize_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      ::gfx::mojom::SizeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueSize_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueBoolDataView {
 public:
  using Tag = internal::PotentiallyOpaqueBool_Data::PotentiallyOpaqueBool_Tag;

  PotentiallyOpaqueBoolDataView() = default;

  PotentiallyOpaqueBoolDataView(
      internal::PotentiallyOpaqueBool_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  bool transparent() const {
    CHECK(is_transparent());
    return data_->data.f_transparent;
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueBool_Data* data_ = nullptr;
};



class PotentiallyOpaqueAdAuctionDataDataView {
 public:
  using Tag = internal::PotentiallyOpaqueAdAuctionData_Data::PotentiallyOpaqueAdAuctionData_Tag;

  PotentiallyOpaqueAdAuctionDataDataView() = default;

  PotentiallyOpaqueAdAuctionDataDataView(
      internal::PotentiallyOpaqueAdAuctionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      AdAuctionDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<::blink::mojom::AdAuctionDataDataView>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueAdAuctionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueConfigVectorDataView {
 public:
  using Tag = internal::PotentiallyOpaqueConfigVector_Data::PotentiallyOpaqueConfigVector_Tag;

  PotentiallyOpaqueConfigVectorDataView() = default;

  PotentiallyOpaqueConfigVectorDataView(
      internal::PotentiallyOpaqueConfigVector_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      mojo::ArrayDataView<FencedFrameConfigDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FencedFrameConfigDataView>>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueConfigVector_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueURNConfigVectorDataView {
 public:
  using Tag = internal::PotentiallyOpaqueURNConfigVector_Data::PotentiallyOpaqueURNConfigVector_Tag;

  PotentiallyOpaqueURNConfigVectorDataView() = default;

  PotentiallyOpaqueURNConfigVectorDataView(
      internal::PotentiallyOpaqueURNConfigVector_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      mojo::ArrayDataView<URNConfigPairDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::URNConfigPairDataView>>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueURNConfigVector_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PotentiallyOpaqueSharedStorageBudgetMetadataDataView {
 public:
  using Tag = internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data::PotentiallyOpaqueSharedStorageBudgetMetadata_Tag;

  PotentiallyOpaqueSharedStorageBudgetMetadataDataView() = default;

  PotentiallyOpaqueSharedStorageBudgetMetadataDataView(
      internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transparent() const { return data_->tag == Tag::kTransparent; }
  inline void GetTransparentDataView(
      SharedStorageBudgetMetadataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTransparent(UserType* output) const {
    
    CHECK(is_transparent());
    return mojo::internal::Deserialize<::blink::mojom::SharedStorageBudgetMetadataDataView>(
        data_->data.f_transparent.Get(), output, message_);
  }
  bool is_opaque() const { return data_->tag == Tag::kOpaque; }
  template <typename UserType>
  [[nodiscard]] bool ReadOpaque(UserType* output) const {
    CHECK(is_opaque());
    return mojo::internal::Deserialize<::blink::mojom::Opaque>(
        data_->data.f_opaque, output);
  }
  Opaque opaque() const {
    CHECK(is_opaque());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(data_->data.f_opaque));
  }

 private:
  internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::ReportingDestination>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ReportingDestination> {};

template <>
struct hash<::blink::mojom::DeprecatedFencedFrameMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::DeprecatedFencedFrameMode> {};

template <>
struct hash<::blink::mojom::Opaque>
    : public mojo::internal::EnumHashImpl<::blink::mojom::Opaque> {};

template <>
struct hash<::blink::mojom::AutomaticBeaconType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AutomaticBeaconType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ReportingDestination, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ReportingDestination, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ReportingDestination>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DeprecatedFencedFrameMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::DeprecatedFencedFrameMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::DeprecatedFencedFrameMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::Opaque, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::Opaque, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Opaque>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AutomaticBeaconType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AutomaticBeaconType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AutomaticBeaconType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AdAuctionDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AdAuctionDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AdAuctionData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::interest_group_owner(input)) in_interest_group_owner = Traits::interest_group_owner(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interest_group_owner)::BaseType> interest_group_owner_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_interest_group_owner, interest_group_owner_fragment);
    fragment->interest_group_owner.Set(
        interest_group_owner_fragment.is_null() ? nullptr : interest_group_owner_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->interest_group_owner.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interest_group_owner in AdAuctionData struct");
    decltype(Traits::interest_group_name(input)) in_interest_group_name = Traits::interest_group_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interest_group_name)::BaseType> interest_group_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_interest_group_name, interest_group_name_fragment);
    fragment->interest_group_name.Set(
        interest_group_name_fragment.is_null() ? nullptr : interest_group_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->interest_group_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interest_group_name in AdAuctionData struct");
  }

  static bool Deserialize(::blink::mojom::internal::AdAuctionData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AdAuctionDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::URNConfigPairDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::URNConfigPairDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::URNConfigPair_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::urn(input)) in_urn = Traits::urn(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->urn)::BaseType> urn_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_urn, urn_fragment);
    fragment->urn.Set(
        urn_fragment.is_null() ? nullptr : urn_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->urn.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null urn in URNConfigPair struct");
    decltype(Traits::config(input)) in_config = Traits::config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->config)::BaseType> config_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FencedFrameConfigDataView>(
        in_config, config_fragment);
    fragment->config.Set(
        config_fragment.is_null() ? nullptr : config_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->config.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null config in URNConfigPair struct");
  }

  static bool Deserialize(::blink::mojom::internal::URNConfigPair_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::URNConfigPairDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageBudgetMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedStorageBudgetMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedStorageBudgetMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::site(input)) in_site = Traits::site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site)::BaseType> site_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
        in_site, site_fragment);
    fragment->site.Set(
        site_fragment.is_null() ? nullptr : site_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->site.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site in SharedStorageBudgetMetadata struct");
    fragment->budget_to_charge = Traits::budget_to_charge(input);
    fragment->top_navigated = Traits::top_navigated(input);
  }

  static bool Deserialize(::blink::mojom::internal::SharedStorageBudgetMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedStorageBudgetMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ParentPermissionsInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ParentPermissionsInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ParentPermissionsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::parsed_permissions_policy(input)) in_parsed_permissions_policy = Traits::parsed_permissions_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parsed_permissions_policy)::BaseType>
        parsed_permissions_policy_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& parsed_permissions_policy_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        in_parsed_permissions_policy, parsed_permissions_policy_fragment, &parsed_permissions_policy_validate_params);
    fragment->parsed_permissions_policy.Set(
        parsed_permissions_policy_fragment.is_null() ? nullptr : parsed_permissions_policy_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->parsed_permissions_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parsed_permissions_policy in ParentPermissionsInfo struct");
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in ParentPermissionsInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ParentPermissionsInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ParentPermissionsInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FencedFrameConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FencedFrameConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FencedFrameConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mapped_url(input)) in_mapped_url = Traits::mapped_url(input);
    mojo::internal::MessageFragment<decltype(fragment->mapped_url)>
        mapped_url_fragment(fragment.message());
    mapped_url_fragment.Claim(&fragment->mapped_url);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueURLDataView>(
        in_mapped_url, mapped_url_fragment, true);
    decltype(Traits::container_size(input)) in_container_size = Traits::container_size(input);
    mojo::internal::MessageFragment<decltype(fragment->container_size)>
        container_size_fragment(fragment.message());
    container_size_fragment.Claim(&fragment->container_size);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        in_container_size, container_size_fragment, true);
    decltype(Traits::content_size(input)) in_content_size = Traits::content_size(input);
    mojo::internal::MessageFragment<decltype(fragment->content_size)>
        content_size_fragment(fragment.message());
    content_size_fragment.Claim(&fragment->content_size);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        in_content_size, content_size_fragment, true);
    decltype(Traits::deprecated_should_freeze_initial_size(input)) in_deprecated_should_freeze_initial_size = Traits::deprecated_should_freeze_initial_size(input);
    mojo::internal::MessageFragment<decltype(fragment->deprecated_should_freeze_initial_size)>
        deprecated_should_freeze_initial_size_fragment(fragment.message());
    deprecated_should_freeze_initial_size_fragment.Claim(&fragment->deprecated_should_freeze_initial_size);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueBoolDataView>(
        in_deprecated_should_freeze_initial_size, deprecated_should_freeze_initial_size_fragment, true);
    decltype(Traits::ad_auction_data(input)) in_ad_auction_data = Traits::ad_auction_data(input);
    mojo::internal::MessageFragment<decltype(fragment->ad_auction_data)>
        ad_auction_data_fragment(fragment.message());
    ad_auction_data_fragment.Claim(&fragment->ad_auction_data);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView>(
        in_ad_auction_data, ad_auction_data_fragment, true);
    decltype(Traits::nested_configs(input)) in_nested_configs = Traits::nested_configs(input);
    mojo::internal::MessageFragment<decltype(fragment->nested_configs)>
        nested_configs_fragment(fragment.message());
    nested_configs_fragment.Claim(&fragment->nested_configs);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueConfigVectorDataView>(
        in_nested_configs, nested_configs_fragment, true);
    decltype(Traits::shared_storage_budget_metadata(input)) in_shared_storage_budget_metadata = Traits::shared_storage_budget_metadata(input);
    mojo::internal::MessageFragment<decltype(fragment->shared_storage_budget_metadata)>
        shared_storage_budget_metadata_fragment(fragment.message());
    shared_storage_budget_metadata_fragment.Claim(&fragment->shared_storage_budget_metadata);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView>(
        in_shared_storage_budget_metadata, shared_storage_budget_metadata_fragment, true);
    decltype(Traits::urn_uuid(input)) in_urn_uuid = Traits::urn_uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->urn_uuid)::BaseType> urn_uuid_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_urn_uuid, urn_uuid_fragment);
    fragment->urn_uuid.Set(
        urn_uuid_fragment.is_null() ? nullptr : urn_uuid_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->urn_uuid.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null urn_uuid in FencedFrameConfig struct");
    mojo::internal::Serialize<::blink::mojom::DeprecatedFencedFrameMode>(
        Traits::mode(input), &fragment->mode);
    decltype(Traits::effective_enabled_permissions(input)) in_effective_enabled_permissions = Traits::effective_enabled_permissions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->effective_enabled_permissions)::BaseType>
        effective_enabled_permissions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& effective_enabled_permissions_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::PermissionsPolicyFeature_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>>(
        in_effective_enabled_permissions, effective_enabled_permissions_fragment, &effective_enabled_permissions_validate_params);
    fragment->effective_enabled_permissions.Set(
        effective_enabled_permissions_fragment.is_null() ? nullptr : effective_enabled_permissions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->effective_enabled_permissions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null effective_enabled_permissions in FencedFrameConfig struct");
    decltype(Traits::parent_permissions_info(input)) in_parent_permissions_info = Traits::parent_permissions_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parent_permissions_info)::BaseType> parent_permissions_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ParentPermissionsInfoDataView>(
        in_parent_permissions_info, parent_permissions_info_fragment);
    fragment->parent_permissions_info.Set(
        parent_permissions_info_fragment.is_null() ? nullptr : parent_permissions_info_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::FencedFrameConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FencedFrameConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FencedFramePropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FencedFramePropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FencedFrameProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mapped_url(input)) in_mapped_url = Traits::mapped_url(input);
    mojo::internal::MessageFragment<decltype(fragment->mapped_url)>
        mapped_url_fragment(fragment.message());
    mapped_url_fragment.Claim(&fragment->mapped_url);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueURLDataView>(
        in_mapped_url, mapped_url_fragment, true);
    decltype(Traits::container_size(input)) in_container_size = Traits::container_size(input);
    mojo::internal::MessageFragment<decltype(fragment->container_size)>
        container_size_fragment(fragment.message());
    container_size_fragment.Claim(&fragment->container_size);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        in_container_size, container_size_fragment, true);
    decltype(Traits::content_size(input)) in_content_size = Traits::content_size(input);
    mojo::internal::MessageFragment<decltype(fragment->content_size)>
        content_size_fragment(fragment.message());
    content_size_fragment.Claim(&fragment->content_size);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueSizeDataView>(
        in_content_size, content_size_fragment, true);
    decltype(Traits::deprecated_should_freeze_initial_size(input)) in_deprecated_should_freeze_initial_size = Traits::deprecated_should_freeze_initial_size(input);
    mojo::internal::MessageFragment<decltype(fragment->deprecated_should_freeze_initial_size)>
        deprecated_should_freeze_initial_size_fragment(fragment.message());
    deprecated_should_freeze_initial_size_fragment.Claim(&fragment->deprecated_should_freeze_initial_size);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueBoolDataView>(
        in_deprecated_should_freeze_initial_size, deprecated_should_freeze_initial_size_fragment, true);
    decltype(Traits::ad_auction_data(input)) in_ad_auction_data = Traits::ad_auction_data(input);
    mojo::internal::MessageFragment<decltype(fragment->ad_auction_data)>
        ad_auction_data_fragment(fragment.message());
    ad_auction_data_fragment.Claim(&fragment->ad_auction_data);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView>(
        in_ad_auction_data, ad_auction_data_fragment, true);
    decltype(Traits::nested_urn_config_pairs(input)) in_nested_urn_config_pairs = Traits::nested_urn_config_pairs(input);
    mojo::internal::MessageFragment<decltype(fragment->nested_urn_config_pairs)>
        nested_urn_config_pairs_fragment(fragment.message());
    nested_urn_config_pairs_fragment.Claim(&fragment->nested_urn_config_pairs);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView>(
        in_nested_urn_config_pairs, nested_urn_config_pairs_fragment, true);
    decltype(Traits::shared_storage_budget_metadata(input)) in_shared_storage_budget_metadata = Traits::shared_storage_budget_metadata(input);
    mojo::internal::MessageFragment<decltype(fragment->shared_storage_budget_metadata)>
        shared_storage_budget_metadata_fragment(fragment.message());
    shared_storage_budget_metadata_fragment.Claim(&fragment->shared_storage_budget_metadata);
    mojo::internal::Serialize<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView>(
        in_shared_storage_budget_metadata, shared_storage_budget_metadata_fragment, true);
    mojo::internal::Serialize<::blink::mojom::DeprecatedFencedFrameMode>(
        Traits::mode(input), &fragment->mode);
    decltype(Traits::effective_enabled_permissions(input)) in_effective_enabled_permissions = Traits::effective_enabled_permissions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->effective_enabled_permissions)::BaseType>
        effective_enabled_permissions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& effective_enabled_permissions_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::PermissionsPolicyFeature_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>>(
        in_effective_enabled_permissions, effective_enabled_permissions_fragment, &effective_enabled_permissions_validate_params);
    fragment->effective_enabled_permissions.Set(
        effective_enabled_permissions_fragment.is_null() ? nullptr : effective_enabled_permissions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->effective_enabled_permissions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null effective_enabled_permissions in FencedFrameProperties struct");
    decltype(Traits::parent_permissions_info(input)) in_parent_permissions_info = Traits::parent_permissions_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parent_permissions_info)::BaseType> parent_permissions_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ParentPermissionsInfoDataView>(
        in_parent_permissions_info, parent_permissions_info_fragment);
    fragment->parent_permissions_info.Set(
        parent_permissions_info_fragment.is_null() ? nullptr : parent_permissions_info_fragment.data());
    fragment->can_disable_untrusted_network = Traits::can_disable_untrusted_network(input);
    fragment->is_cross_origin_content = Traits::is_cross_origin_content(input);
    fragment->allow_cross_origin_event_reporting = Traits::allow_cross_origin_event_reporting(input);
  }

  static bool Deserialize(::blink::mojom::internal::FencedFrameProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FencedFramePropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PotentiallyOpaqueURLDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PotentiallyOpaqueURLDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PotentiallyOpaqueURL_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PotentiallyOpaqueURLDataView::Tag::kTransparent: {
        decltype(Traits::transparent(input))
            in_transparent = Traits::transparent(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_transparent)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::url::mojom::UrlDataView>(
            in_transparent, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null transparent in PotentiallyOpaqueURL union");
        fragment->data.f_transparent.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PotentiallyOpaqueURLDataView::Tag::kOpaque: {
        decltype(Traits::opaque(input))
            in_opaque = Traits::opaque(input);
        mojo::internal::Serialize<::blink::mojom::Opaque>(
            in_opaque, &fragment->data.f_opaque);
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PotentiallyOpaqueURL_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PotentiallyOpaqueURLDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PotentiallyOpaqueSizeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PotentiallyOpaqueSizeDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PotentiallyOpaqueSize_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PotentiallyOpaqueSizeDataView::Tag::kTransparent: {
        decltype(Traits::transparent(input))
            in_transparent = Traits::transparent(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_transparent)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
            in_transparent, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null transparent in PotentiallyOpaqueSize union");
        fragment->data.f_transparent.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PotentiallyOpaqueSizeDataView::Tag::kOpaque: {
        decltype(Traits::opaque(input))
            in_opaque = Traits::opaque(input);
        mojo::internal::Serialize<::blink::mojom::Opaque>(
            in_opaque, &fragment->data.f_opaque);
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PotentiallyOpaqueSize_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PotentiallyOpaqueSizeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PotentiallyOpaqueBoolDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PotentiallyOpaqueBoolDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PotentiallyOpaqueBool_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PotentiallyOpaqueBoolDataView::Tag::kTransparent: {
        decltype(Traits::transparent(input))
            in_transparent = Traits::transparent(input);
        fragment->data.f_transparent = in_transparent;
        break;
      }
      case ::blink::mojom::PotentiallyOpaqueBoolDataView::Tag::kOpaque: {
        decltype(Traits::opaque(input))
            in_opaque = Traits::opaque(input);
        mojo::internal::Serialize<::blink::mojom::Opaque>(
            in_opaque, &fragment->data.f_opaque);
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PotentiallyOpaqueBool_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PotentiallyOpaqueBoolDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PotentiallyOpaqueAdAuctionData_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView::Tag::kTransparent: {
        decltype(Traits::transparent(input))
            in_transparent = Traits::transparent(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_transparent)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::AdAuctionDataDataView>(
            in_transparent, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null transparent in PotentiallyOpaqueAdAuctionData union");
        fragment->data.f_transparent.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView::Tag::kOpaque: {
        decltype(Traits::opaque(input))
            in_opaque = Traits::opaque(input);
        mojo::internal::Serialize<::blink::mojom::Opaque>(
            in_opaque, &fragment->data.f_opaque);
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PotentiallyOpaqueAdAuctionData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PotentiallyOpaqueAdAuctionDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PotentiallyOpaqueConfigVectorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PotentiallyOpaqueConfigVectorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PotentiallyOpaqueConfigVector_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PotentiallyOpaqueConfigVectorDataView::Tag::kTransparent: {
        decltype(Traits::transparent(input))
            in_transparent = Traits::transparent(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_transparent)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& transparent_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FencedFrameConfigDataView>>(
            in_transparent, value_fragment, &transparent_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null transparent in PotentiallyOpaqueConfigVector union");
        fragment->data.f_transparent.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PotentiallyOpaqueConfigVectorDataView::Tag::kOpaque: {
        decltype(Traits::opaque(input))
            in_opaque = Traits::opaque(input);
        mojo::internal::Serialize<::blink::mojom::Opaque>(
            in_opaque, &fragment->data.f_opaque);
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PotentiallyOpaqueConfigVector_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PotentiallyOpaqueConfigVectorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PotentiallyOpaqueURNConfigVector_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView::Tag::kTransparent: {
        decltype(Traits::transparent(input))
            in_transparent = Traits::transparent(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_transparent)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& transparent_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::URNConfigPairDataView>>(
            in_transparent, value_fragment, &transparent_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null transparent in PotentiallyOpaqueURNConfigVector union");
        fragment->data.f_transparent.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView::Tag::kOpaque: {
        decltype(Traits::opaque(input))
            in_opaque = Traits::opaque(input);
        mojo::internal::Serialize<::blink::mojom::Opaque>(
            in_opaque, &fragment->data.f_opaque);
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PotentiallyOpaqueURNConfigVector_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PotentiallyOpaqueURNConfigVectorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView::Tag::kTransparent: {
        decltype(Traits::transparent(input))
            in_transparent = Traits::transparent(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_transparent)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::SharedStorageBudgetMetadataDataView>(
            in_transparent, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null transparent in PotentiallyOpaqueSharedStorageBudgetMetadata union");
        fragment->data.f_transparent.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView::Tag::kOpaque: {
        decltype(Traits::opaque(input))
            in_opaque = Traits::opaque(input);
        mojo::internal::Serialize<::blink::mojom::Opaque>(
            in_opaque, &fragment->data.f_opaque);
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void AdAuctionDataDataView::GetInterestGroupOwnerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->interest_group_owner.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void AdAuctionDataDataView::GetInterestGroupNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->interest_group_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void URNConfigPairDataView::GetUrnDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->urn.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URNConfigPairDataView::GetConfigDataView(
    FencedFrameConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = FencedFrameConfigDataView(pointer, message_);
}


inline void SharedStorageBudgetMetadataDataView::GetSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}


inline void ParentPermissionsInfoDataView::GetParsedPermissionsPolicyDataView(
    mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>* output) {
  auto pointer = data_->parsed_permissions_policy.Get();
  *output = mojo::ArrayDataView<::blink::mojom::ParsedPermissionsPolicyDeclarationDataView>(pointer, message_);
}
inline void ParentPermissionsInfoDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void FencedFrameConfigDataView::GetMappedUrlDataView(
    PotentiallyOpaqueURLDataView* output) {
  auto pointer = &data_->mapped_url;
  *output = PotentiallyOpaqueURLDataView(pointer, message_);
}
inline void FencedFrameConfigDataView::GetContainerSizeDataView(
    PotentiallyOpaqueSizeDataView* output) {
  auto pointer = &data_->container_size;
  *output = PotentiallyOpaqueSizeDataView(pointer, message_);
}
inline void FencedFrameConfigDataView::GetContentSizeDataView(
    PotentiallyOpaqueSizeDataView* output) {
  auto pointer = &data_->content_size;
  *output = PotentiallyOpaqueSizeDataView(pointer, message_);
}
inline void FencedFrameConfigDataView::GetDeprecatedShouldFreezeInitialSizeDataView(
    PotentiallyOpaqueBoolDataView* output) {
  auto pointer = &data_->deprecated_should_freeze_initial_size;
  *output = PotentiallyOpaqueBoolDataView(pointer, message_);
}
inline void FencedFrameConfigDataView::GetAdAuctionDataDataView(
    PotentiallyOpaqueAdAuctionDataDataView* output) {
  auto pointer = &data_->ad_auction_data;
  *output = PotentiallyOpaqueAdAuctionDataDataView(pointer, message_);
}
inline void FencedFrameConfigDataView::GetNestedConfigsDataView(
    PotentiallyOpaqueConfigVectorDataView* output) {
  auto pointer = &data_->nested_configs;
  *output = PotentiallyOpaqueConfigVectorDataView(pointer, message_);
}
inline void FencedFrameConfigDataView::GetSharedStorageBudgetMetadataDataView(
    PotentiallyOpaqueSharedStorageBudgetMetadataDataView* output) {
  auto pointer = &data_->shared_storage_budget_metadata;
  *output = PotentiallyOpaqueSharedStorageBudgetMetadataDataView(pointer, message_);
}
inline void FencedFrameConfigDataView::GetUrnUuidDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->urn_uuid.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FencedFrameConfigDataView::GetEffectiveEnabledPermissionsDataView(
    mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>* output) {
  auto pointer = data_->effective_enabled_permissions.Get();
  *output = mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>(pointer, message_);
}
inline void FencedFrameConfigDataView::GetParentPermissionsInfoDataView(
    ParentPermissionsInfoDataView* output) {
  auto pointer = data_->parent_permissions_info.Get();
  *output = ParentPermissionsInfoDataView(pointer, message_);
}


inline void FencedFramePropertiesDataView::GetMappedUrlDataView(
    PotentiallyOpaqueURLDataView* output) {
  auto pointer = &data_->mapped_url;
  *output = PotentiallyOpaqueURLDataView(pointer, message_);
}
inline void FencedFramePropertiesDataView::GetContainerSizeDataView(
    PotentiallyOpaqueSizeDataView* output) {
  auto pointer = &data_->container_size;
  *output = PotentiallyOpaqueSizeDataView(pointer, message_);
}
inline void FencedFramePropertiesDataView::GetContentSizeDataView(
    PotentiallyOpaqueSizeDataView* output) {
  auto pointer = &data_->content_size;
  *output = PotentiallyOpaqueSizeDataView(pointer, message_);
}
inline void FencedFramePropertiesDataView::GetDeprecatedShouldFreezeInitialSizeDataView(
    PotentiallyOpaqueBoolDataView* output) {
  auto pointer = &data_->deprecated_should_freeze_initial_size;
  *output = PotentiallyOpaqueBoolDataView(pointer, message_);
}
inline void FencedFramePropertiesDataView::GetAdAuctionDataDataView(
    PotentiallyOpaqueAdAuctionDataDataView* output) {
  auto pointer = &data_->ad_auction_data;
  *output = PotentiallyOpaqueAdAuctionDataDataView(pointer, message_);
}
inline void FencedFramePropertiesDataView::GetNestedUrnConfigPairsDataView(
    PotentiallyOpaqueURNConfigVectorDataView* output) {
  auto pointer = &data_->nested_urn_config_pairs;
  *output = PotentiallyOpaqueURNConfigVectorDataView(pointer, message_);
}
inline void FencedFramePropertiesDataView::GetSharedStorageBudgetMetadataDataView(
    PotentiallyOpaqueSharedStorageBudgetMetadataDataView* output) {
  auto pointer = &data_->shared_storage_budget_metadata;
  *output = PotentiallyOpaqueSharedStorageBudgetMetadataDataView(pointer, message_);
}
inline void FencedFramePropertiesDataView::GetEffectiveEnabledPermissionsDataView(
    mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>* output) {
  auto pointer = data_->effective_enabled_permissions.Get();
  *output = mojo::ArrayDataView<::network::mojom::PermissionsPolicyFeature>(pointer, message_);
}
inline void FencedFramePropertiesDataView::GetParentPermissionsInfoDataView(
    ParentPermissionsInfoDataView* output) {
  auto pointer = data_->parent_permissions_info.Get();
  *output = ParentPermissionsInfoDataView(pointer, message_);
}


inline void PotentiallyOpaqueURLDataView::GetTransparentDataView(
    ::url::mojom::UrlDataView* output) const {
  CHECK(is_transparent());
  *output = ::url::mojom::UrlDataView(data_->data.f_transparent.Get(), message_);
}

inline void PotentiallyOpaqueSizeDataView::GetTransparentDataView(
    ::gfx::mojom::SizeDataView* output) const {
  CHECK(is_transparent());
  *output = ::gfx::mojom::SizeDataView(data_->data.f_transparent.Get(), message_);
}


inline void PotentiallyOpaqueAdAuctionDataDataView::GetTransparentDataView(
    AdAuctionDataDataView* output) const {
  CHECK(is_transparent());
  *output = AdAuctionDataDataView(data_->data.f_transparent.Get(), message_);
}

inline void PotentiallyOpaqueConfigVectorDataView::GetTransparentDataView(
    mojo::ArrayDataView<FencedFrameConfigDataView>* output) const {
  CHECK(is_transparent());
  *output = mojo::ArrayDataView<FencedFrameConfigDataView>(data_->data.f_transparent.Get(), message_);
}

inline void PotentiallyOpaqueURNConfigVectorDataView::GetTransparentDataView(
    mojo::ArrayDataView<URNConfigPairDataView>* output) const {
  CHECK(is_transparent());
  *output = mojo::ArrayDataView<URNConfigPairDataView>(data_->data.f_transparent.Get(), message_);
}

inline void PotentiallyOpaqueSharedStorageBudgetMetadataDataView::GetTransparentDataView(
    SharedStorageBudgetMetadataDataView* output) const {
  CHECK(is_transparent());
  *output = SharedStorageBudgetMetadataDataView(data_->data.f_transparent.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ReportingDestination> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ReportingDestination value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::DeprecatedFencedFrameMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::DeprecatedFencedFrameMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::Opaque> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::Opaque value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AutomaticBeaconType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AutomaticBeaconType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_SHARED_H_