// third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* MenuItem_TypeToStringHelper(MenuItem_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MenuItem_Type::kOption:
      return "kOption";
    case MenuItem_Type::kCheckableOption:
      return "kCheckableOption";
    case MenuItem_Type::kGroup:
      return "kGroup";
    case MenuItem_Type::kSeparator:
      return "kSeparator";
    case MenuItem_Type::kSubMenu:
      return "kSubMenu";
    default:
      return nullptr;
  }
}

std::string MenuItem_TypeToString(MenuItem_Type value) {
  const char *str = MenuItem_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MenuItem_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MenuItem_Type value) {
  return os << MenuItem_TypeToString(value);
}

namespace internal {


// static
bool MenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MenuItem_Data* object =
      static_cast<const MenuItem_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& tool_tip_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tool_tip, validation_context,
                                         &tool_tip_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::MenuItem_Type_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  return true;
}

MenuItem_Data::MenuItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PopupMenuClient_DidAcceptIndices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PopupMenuClient_DidAcceptIndices_Params_Data* object =
      static_cast<const PopupMenuClient_DidAcceptIndices_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->indices, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& indices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->indices, validation_context,
                                         &indices_validate_params)) {
    return false;
  }

  return true;
}

PopupMenuClient_DidAcceptIndices_Params_Data::PopupMenuClient_DidAcceptIndices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PopupMenuClient_DidCancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PopupMenuClient_DidCancel_Params_Data* object =
      static_cast<const PopupMenuClient_DidCancel_Params_Data*>(data);

  return true;
}

PopupMenuClient_DidCancel_Params_Data::PopupMenuClient_DidCancel_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::MenuItem_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::MenuItem_Type value) {
  return std::move(context).WriteString(::blink::mojom::MenuItem_TypeToString(value));
}

} // namespace perfetto