// services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_AGGREGATED_HIT_TEST_REGION_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_AGGREGATED_HIT_TEST_REGION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/transform.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT AggregatedHitTestRegion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AggregatedHitTestRegion, T>::value>;
  using DataView = AggregatedHitTestRegionDataView;
  using Data_ = internal::AggregatedHitTestRegion_Data;

  template <typename... Args>
  static AggregatedHitTestRegionPtr New(Args&&... args) {
    return AggregatedHitTestRegionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AggregatedHitTestRegionPtr From(const U& u) {
    return mojo::TypeConverter<AggregatedHitTestRegionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AggregatedHitTestRegion>::Convert(*this);
  }


  AggregatedHitTestRegion();

  AggregatedHitTestRegion(
      const ::viz::FrameSinkId& frame_sink_id,
      uint32_t flags,
      uint32_t async_hit_test_reasons,
      const ::gfx::Rect& rect,
      uint32_t child_count,
      const ::gfx::Transform& transform);


  ~AggregatedHitTestRegion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AggregatedHitTestRegionPtr>
  AggregatedHitTestRegionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AggregatedHitTestRegion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AggregatedHitTestRegion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AggregatedHitTestRegion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AggregatedHitTestRegion::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AggregatedHitTestRegion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AggregatedHitTestRegion_UnserializedMessageContext<
            UserType, AggregatedHitTestRegion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AggregatedHitTestRegion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AggregatedHitTestRegion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AggregatedHitTestRegion_UnserializedMessageContext<
            UserType, AggregatedHitTestRegion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AggregatedHitTestRegion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::FrameSinkId frame_sink_id;
  
  uint32_t flags;
  
  uint32_t async_hit_test_reasons;
  
  ::gfx::Rect rect;
  
  uint32_t child_count;
  
  ::gfx::Transform transform;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AggregatedHitTestRegion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AggregatedHitTestRegion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AggregatedHitTestRegion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AggregatedHitTestRegion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AggregatedHitTestRegionPtr AggregatedHitTestRegion::Clone() const {
  return New(
      mojo::Clone(frame_sink_id),
      mojo::Clone(flags),
      mojo::Clone(async_hit_test_reasons),
      mojo::Clone(rect),
      mojo::Clone(child_count),
      mojo::Clone(transform)
  );
}

template <typename T, AggregatedHitTestRegion::EnableIfSame<T>*>
bool AggregatedHitTestRegion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_sink_id, other_struct.frame_sink_id))
    return false;
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->async_hit_test_reasons, other_struct.async_hit_test_reasons))
    return false;
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  if (!mojo::Equals(this->child_count, other_struct.child_count))
    return false;
  if (!mojo::Equals(this->transform, other_struct.transform))
    return false;
  return true;
}

template <typename T, AggregatedHitTestRegion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_sink_id < rhs.frame_sink_id)
    return true;
  if (rhs.frame_sink_id < lhs.frame_sink_id)
    return false;
  if (lhs.flags < rhs.flags)
    return true;
  if (rhs.flags < lhs.flags)
    return false;
  if (lhs.async_hit_test_reasons < rhs.async_hit_test_reasons)
    return true;
  if (rhs.async_hit_test_reasons < lhs.async_hit_test_reasons)
    return false;
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  if (lhs.child_count < rhs.child_count)
    return true;
  if (rhs.child_count < lhs.child_count)
    return false;
  if (lhs.transform < rhs.transform)
    return true;
  if (rhs.transform < lhs.transform)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::AggregatedHitTestRegion::DataView,
                                         ::viz::mojom::blink::AggregatedHitTestRegionPtr> {
  static bool IsNull(const ::viz::mojom::blink::AggregatedHitTestRegionPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::AggregatedHitTestRegionPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::AggregatedHitTestRegion::frame_sink_id)& frame_sink_id(
      const ::viz::mojom::blink::AggregatedHitTestRegionPtr& input) {
    return input->frame_sink_id;
  }

  static decltype(::viz::mojom::blink::AggregatedHitTestRegion::flags) flags(
      const ::viz::mojom::blink::AggregatedHitTestRegionPtr& input) {
    return input->flags;
  }

  static decltype(::viz::mojom::blink::AggregatedHitTestRegion::async_hit_test_reasons) async_hit_test_reasons(
      const ::viz::mojom::blink::AggregatedHitTestRegionPtr& input) {
    return input->async_hit_test_reasons;
  }

  static const decltype(::viz::mojom::blink::AggregatedHitTestRegion::rect)& rect(
      const ::viz::mojom::blink::AggregatedHitTestRegionPtr& input) {
    return input->rect;
  }

  static decltype(::viz::mojom::blink::AggregatedHitTestRegion::child_count) child_count(
      const ::viz::mojom::blink::AggregatedHitTestRegionPtr& input) {
    return input->child_count;
  }

  static const decltype(::viz::mojom::blink::AggregatedHitTestRegion::transform)& transform(
      const ::viz::mojom::blink::AggregatedHitTestRegionPtr& input) {
    return input->transform;
  }

  static bool Read(::viz::mojom::blink::AggregatedHitTestRegion::DataView input, ::viz::mojom::blink::AggregatedHitTestRegionPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_AGGREGATED_HIT_TEST_REGION_MOJOM_BLINK_H_