// services/viz/public/mojom/compositing/tiling.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/tiling.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace viz::mojom {
class TileResourceDataView;

class TileDataView;

class TilingDataView;

class TileContentsDataView;


}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::TileResourceDataView> {
  using Data = ::viz::mojom::internal::TileResource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TileDataView> {
  using Data = ::viz::mojom::internal::Tile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TilingDataView> {
  using Data = ::viz::mojom::internal::Tiling_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TileContentsDataView> {
  using Data = ::viz::mojom::internal::TileContents_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class MissingTileReason : int32_t {
  
  kOutOfMemory = 0,
  
  kResourceNotReady = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, MissingTileReason value);
inline bool IsKnownEnumValue(MissingTileReason value) {
  return internal::MissingTileReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class TileResourceDataView {
 public:
  TileResourceDataView() = default;

  TileResourceDataView(
      internal::TileResource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResourceDataView(
      ::viz::mojom::TransferableResourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResource(UserType* output) {
    
    auto* pointer = data_->resource.Get();
    return mojo::internal::Deserialize<::viz::mojom::TransferableResourceDataView>(
        pointer, output, message_);
  }
  bool is_premultiplied() const {
    return data_->is_premultiplied;
  }
  bool is_checkered() const {
    return data_->is_checkered;
  }
 private:
  internal::TileResource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TileDataView {
 public:
  TileDataView() = default;

  TileDataView(
      internal::Tile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t column_index() const {
    return data_->column_index;
  }
  uint32_t row_index() const {
    return data_->row_index;
  }
  inline void GetContentsDataView(
      TileContentsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContents(UserType* output) {
    
    auto* pointer = !data_->contents.is_null() ? &data_->contents : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::TileContentsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TilingDataView {
 public:
  TilingDataView() = default;

  TilingDataView(
      internal::Tiling_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t layer_id() const {
    return data_->layer_id;
  }
  inline void GetRasterTranslationDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRasterTranslation(UserType* output) {
    
    auto* pointer = data_->raster_translation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetRasterScaleDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRasterScale(UserType* output) {
    
    auto* pointer = data_->raster_scale.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetTileSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTileSize(UserType* output) {
    
    auto* pointer = data_->tile_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetTilingRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTilingRect(UserType* output) {
    
    auto* pointer = data_->tiling_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetTilesDataView(
      mojo::ArrayDataView<TileDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTiles(UserType* output) {
    
    auto* pointer = data_->tiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TileDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Tiling_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TileContentsDataView {
 public:
  using Tag = internal::TileContents_Data::TileContents_Tag;

  TileContentsDataView() = default;

  TileContentsDataView(
      internal::TileContents_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_missing_reason() const { return data_->tag == Tag::kMissingReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadMissingReason(UserType* output) const {
    CHECK(is_missing_reason());
    return mojo::internal::Deserialize<::viz::mojom::MissingTileReason>(
        data_->data.f_missing_reason, output);
  }
  MissingTileReason missing_reason() const {
    CHECK(is_missing_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::MissingTileReason>(data_->data.f_missing_reason));
  }
  bool is_resource() const { return data_->tag == Tag::kResource; }
  inline void GetResourceDataView(
      TileResourceDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadResource(UserType* output) const {
    
    CHECK(is_resource());
    return mojo::internal::Deserialize<::viz::mojom::TileResourceDataView>(
        data_->data.f_resource.Get(), output, message_);
  }
  bool is_solid_color() const { return data_->tag == Tag::kSolidColor; }
  inline void GetSolidColorDataView(
      ::skia::mojom::SkColor4fDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSolidColor(UserType* output) const {
    
    CHECK(is_solid_color());
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        data_->data.f_solid_color.Get(), output, message_);
  }

 private:
  internal::TileContents_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

namespace std {

template <>
struct hash<::viz::mojom::MissingTileReason>
    : public mojo::internal::EnumHashImpl<::viz::mojom::MissingTileReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::MissingTileReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::MissingTileReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::MissingTileReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TileResourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TileResourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TileResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::resource(input)) in_resource = Traits::resource(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resource)::BaseType> resource_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::TransferableResourceDataView>(
        in_resource, resource_fragment);
    fragment->resource.Set(
        resource_fragment.is_null() ? nullptr : resource_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->resource.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resource in TileResource struct");
    fragment->is_premultiplied = Traits::is_premultiplied(input);
    fragment->is_checkered = Traits::is_checkered(input);
  }

  static bool Deserialize(::viz::mojom::internal::TileResource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TileResourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Tile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->column_index = Traits::column_index(input);
    fragment->row_index = Traits::row_index(input);
    decltype(Traits::contents(input)) in_contents = Traits::contents(input);
    mojo::internal::MessageFragment<decltype(fragment->contents)>
        contents_fragment(fragment.message());
    contents_fragment.Claim(&fragment->contents);
    mojo::internal::Serialize<::viz::mojom::TileContentsDataView>(
        in_contents, contents_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->contents.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contents in Tile struct");
  }

  static bool Deserialize(::viz::mojom::internal::Tile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TilingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TilingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Tiling_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->layer_id = Traits::layer_id(input);
    decltype(Traits::raster_translation(input)) in_raster_translation = Traits::raster_translation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raster_translation)::BaseType> raster_translation_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_raster_translation, raster_translation_fragment);
    fragment->raster_translation.Set(
        raster_translation_fragment.is_null() ? nullptr : raster_translation_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->raster_translation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raster_translation in Tiling struct");
    decltype(Traits::raster_scale(input)) in_raster_scale = Traits::raster_scale(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raster_scale)::BaseType> raster_scale_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_raster_scale, raster_scale_fragment);
    fragment->raster_scale.Set(
        raster_scale_fragment.is_null() ? nullptr : raster_scale_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->raster_scale.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null raster_scale in Tiling struct");
    decltype(Traits::tile_size(input)) in_tile_size = Traits::tile_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tile_size)::BaseType> tile_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_tile_size, tile_size_fragment);
    fragment->tile_size.Set(
        tile_size_fragment.is_null() ? nullptr : tile_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tile_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tile_size in Tiling struct");
    decltype(Traits::tiling_rect(input)) in_tiling_rect = Traits::tiling_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tiling_rect)::BaseType> tiling_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_tiling_rect, tiling_rect_fragment);
    fragment->tiling_rect.Set(
        tiling_rect_fragment.is_null() ? nullptr : tiling_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tiling_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tiling_rect in Tiling struct");
    decltype(Traits::tiles(input)) in_tiles = Traits::tiles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tiles)::BaseType>
        tiles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tiles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TileDataView>>(
        in_tiles, tiles_fragment, &tiles_validate_params);
    fragment->tiles.Set(
        tiles_fragment.is_null() ? nullptr : tiles_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tiles.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tiles in Tiling struct");
  }

  static bool Deserialize(::viz::mojom::internal::Tiling_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TilingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TileContentsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::TileContentsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::TileContents_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::viz::mojom::TileContentsDataView::Tag::kMissingReason: {
        decltype(Traits::missing_reason(input))
            in_missing_reason = Traits::missing_reason(input);
        mojo::internal::Serialize<::viz::mojom::MissingTileReason>(
            in_missing_reason, &fragment->data.f_missing_reason);
        break;
      }
      case ::viz::mojom::TileContentsDataView::Tag::kResource: {
        decltype(Traits::resource(input))
            in_resource = Traits::resource(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_resource)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::viz::mojom::TileResourceDataView>(
            in_resource, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null resource in TileContents union");
        fragment->data.f_resource.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::TileContentsDataView::Tag::kSolidColor: {
        decltype(Traits::solid_color(input))
            in_solid_color = Traits::solid_color(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_solid_color)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
            in_solid_color, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null solid_color in TileContents union");
        fragment->data.f_solid_color.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::viz::mojom::internal::TileContents_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TileContentsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void TileResourceDataView::GetResourceDataView(
    ::viz::mojom::TransferableResourceDataView* output) {
  auto pointer = data_->resource.Get();
  *output = ::viz::mojom::TransferableResourceDataView(pointer, message_);
}


inline void TileDataView::GetContentsDataView(
    TileContentsDataView* output) {
  auto pointer = &data_->contents;
  *output = TileContentsDataView(pointer, message_);
}


inline void TilingDataView::GetRasterTranslationDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->raster_translation.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void TilingDataView::GetRasterScaleDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->raster_scale.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void TilingDataView::GetTileSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->tile_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void TilingDataView::GetTilingRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->tiling_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void TilingDataView::GetTilesDataView(
    mojo::ArrayDataView<TileDataView>* output) {
  auto pointer = data_->tiles.Get();
  *output = mojo::ArrayDataView<TileDataView>(pointer, message_);
}


inline void TileContentsDataView::GetResourceDataView(
    TileResourceDataView* output) const {
  CHECK(is_resource());
  *output = TileResourceDataView(data_->data.f_resource.Get(), message_);
}
inline void TileContentsDataView::GetSolidColorDataView(
    ::skia::mojom::SkColor4fDataView* output) const {
  CHECK(is_solid_color());
  *output = ::skia::mojom::SkColor4fDataView(data_->data.f_solid_color.Get(), message_);
}


}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::MissingTileReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::MissingTileReason value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SHARED_H_