// services/viz/public/mojom/compositing/filter_operation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/filter_operation.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/paint_filter.mojom-shared.h"
#include "skia/public/mojom/tile_mode.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace viz::mojom {
class FilterOperationDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FilterOperationDataView> {
  using Data = ::viz::mojom::internal::FilterOperation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class FilterType : int32_t {
  
  GRAYSCALE = 0,
  
  SEPIA = 1,
  
  SATURATE = 2,
  
  HUE_ROTATE = 3,
  
  INVERT = 4,
  
  BRIGHTNESS = 5,
  
  CONTRAST = 6,
  
  OPACITY = 7,
  
  BLUR = 8,
  
  DROP_SHADOW = 9,
  
  COLOR_MATRIX = 10,
  
  ZOOM = 11,
  
  REFERENCE = 12,
  
  SATURATING_BRIGHTNESS = 13,
  
  ALPHA_THRESHOLD = 14,
  
  OFFSET = 15,
  
  FILTER_TYPE_LAST = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

 std::ostream& operator<<(std::ostream& os, FilterType value);
inline bool IsKnownEnumValue(FilterType value) {
  return internal::FilterType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FilterOperationDataView {
 public:
  FilterOperationDataView() = default;

  FilterOperationDataView(
      internal::FilterOperation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::FilterType>(
        data_value, output);
  }
  FilterType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::FilterType>(data_->type));
  }
  float amount() const {
    return data_->amount;
  }
  inline void GetOffsetDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffset(UserType* output) {
    
    auto* pointer = data_->offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetDropShadowColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDropShadowColor(UserType* output) {
    
    auto* pointer = data_->drop_shadow_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetImageFilterDataView(
      ::viz::mojom::PaintFilterDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageFilter(UserType* output) {
    
    auto* pointer = data_->image_filter.Get();
    return mojo::internal::Deserialize<::viz::mojom::PaintFilterDataView>(
        pointer, output, message_);
  }
  inline void GetMatrixDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatrix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `matrix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMatrix` instead "
    "of `ReadMatrix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->matrix.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  int32_t zoom_inset() const {
    return data_->zoom_inset;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBlurTileMode(UserType* output) const {
    auto data_value = data_->blur_tile_mode;
    return mojo::internal::Deserialize<::skia::mojom::TileMode>(
        data_value, output);
  }
  ::skia::mojom::TileMode blur_tile_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::TileMode>(data_->blur_tile_mode));
  }
  inline void GetShapeDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShape(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::gfx::mojom::RectDataView>, UserType>(),
    "Attempting to read the optional `shape` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShape` instead "
    "of `ReadShape if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shape.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FilterOperation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

template <>
struct hash<::viz::mojom::FilterType>
    : public mojo::internal::EnumHashImpl<::viz::mojom::FilterType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FilterType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::FilterType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::FilterType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FilterOperationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FilterOperationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FilterOperation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::viz::mojom::FilterType>(
        Traits::type(input), &fragment->type);
    fragment->amount = Traits::amount(input);
    decltype(Traits::offset(input)) in_offset = Traits::offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset)::BaseType> offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_offset, offset_fragment);
    fragment->offset.Set(
        offset_fragment.is_null() ? nullptr : offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null offset in FilterOperation struct");
    decltype(Traits::drop_shadow_color(input)) in_drop_shadow_color = Traits::drop_shadow_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->drop_shadow_color)::BaseType> drop_shadow_color_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
        in_drop_shadow_color, drop_shadow_color_fragment);
    fragment->drop_shadow_color.Set(
        drop_shadow_color_fragment.is_null() ? nullptr : drop_shadow_color_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->drop_shadow_color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null drop_shadow_color in FilterOperation struct");
    decltype(Traits::image_filter(input)) in_image_filter = Traits::image_filter(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_filter)::BaseType> image_filter_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::PaintFilterDataView>(
        in_image_filter, image_filter_fragment);
    fragment->image_filter.Set(
        image_filter_fragment.is_null() ? nullptr : image_filter_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->image_filter.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_filter in FilterOperation struct");
    decltype(Traits::matrix(input)) in_matrix = Traits::matrix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->matrix)::BaseType>
        matrix_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& matrix_validate_params =
        mojo::internal::GetArrayValidator<20, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_matrix, matrix_fragment, &matrix_validate_params);
    fragment->matrix.Set(
        matrix_fragment.is_null() ? nullptr : matrix_fragment.data());
    fragment->zoom_inset = Traits::zoom_inset(input);
    mojo::internal::Serialize<::skia::mojom::TileMode>(
        Traits::blur_tile_mode(input), &fragment->blur_tile_mode);
    decltype(Traits::shape(input)) in_shape = Traits::shape(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shape)::BaseType>
        shape_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shape_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        in_shape, shape_fragment, &shape_validate_params);
    fragment->shape.Set(
        shape_fragment.is_null() ? nullptr : shape_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::FilterOperation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FilterOperationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void FilterOperationDataView::GetOffsetDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->offset.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void FilterOperationDataView::GetDropShadowColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->drop_shadow_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void FilterOperationDataView::GetImageFilterDataView(
    ::viz::mojom::PaintFilterDataView* output) {
  auto pointer = data_->image_filter.Get();
  *output = ::viz::mojom::PaintFilterDataView(pointer, message_);
}
inline void FilterOperationDataView::GetMatrixDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->matrix.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void FilterOperationDataView::GetShapeDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->shape.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::FilterType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::FilterType value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SHARED_H_