// services/video_effects/public/mojom/video_effects_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_SERVICE_MOJOM_H_
#define SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_effects/public/mojom/video_effects_service.mojom-features.h"  // IWYU pragma: export
#include "services/video_effects/public/mojom/video_effects_service.mojom-shared.h"  // IWYU pragma: export
#include "services/video_effects/public/mojom/video_effects_service.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_effects_manager.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include "services/video_effects/public/mojom/video_effects_processor.mojom-forward.h"
#include "services/viz/public/mojom/gpu.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"





constexpr ::sandbox::mojom::Sandbox kVideoEffectsSandbox = ::sandbox::mojom::Sandbox::kVideoEffects;


namespace video_effects::mojom {

class VideoEffectsServiceProxy;

template <typename ImplRefTraits>
class VideoEffectsServiceStub;

class VideoEffectsServiceRequestValidator;


class VideoEffectsService
    : public VideoEffectsServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kVideoEffects;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoEffectsServiceInterfaceBase;
  using Proxy_ = VideoEffectsServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEffectsServiceStub<ImplRefTraits>;

  using RequestValidator_ = VideoEffectsServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateEffectsProcessorMinVersion = 0,
    kSetBackgroundSegmentationModelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateEffectsProcessor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundSegmentationModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoEffectsService() = default;

  
  virtual void CreateEffectsProcessor(const std::string& device_id, ::mojo::PendingRemote<::viz::mojom::Gpu> gpu, ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager> manager, ::mojo::PendingReceiver<::video_effects::mojom::VideoEffectsProcessor> processor) = 0;

  
  virtual void SetBackgroundSegmentationModel(::base::File model_file) = 0;
};



class  VideoEffectsServiceProxy
    : public VideoEffectsService {
 public:
  using InterfaceType = VideoEffectsService;

  explicit VideoEffectsServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateEffectsProcessor(const std::string& device_id, ::mojo::PendingRemote<::viz::mojom::Gpu> gpu, ::mojo::PendingRemote<::media::mojom::ReadonlyVideoEffectsManager> manager, ::mojo::PendingReceiver<::video_effects::mojom::VideoEffectsProcessor> processor) final;
  
  void SetBackgroundSegmentationModel(::base::File model_file) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoEffectsServiceStubDispatch {
 public:
  static bool Accept(VideoEffectsService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEffectsService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEffectsService>>
class VideoEffectsServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEffectsServiceStub() = default;
  ~VideoEffectsServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEffectsServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEffectsServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoEffectsServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // video_effects::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_SERVICE_MOJOM_H_