// services/tracing/public/mojom/background_tracing_agent.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_SHARED_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/tracing/public/mojom/background_tracing_agent.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace tracing::mojom {
class BackgroundTracingRuleDataView;



}  // tracing::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tracing::mojom::BackgroundTracingRuleDataView> {
  using Data = ::tracing::mojom::internal::BackgroundTracingRule_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tracing::mojom {
// Interface base classes. They are used for type safety check.
class BackgroundTracingAgentClientInterfaceBase {};

using BackgroundTracingAgentClientPtrDataView =
    mojo::InterfacePtrDataView<BackgroundTracingAgentClientInterfaceBase>;
using BackgroundTracingAgentClientRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundTracingAgentClientInterfaceBase>;
using BackgroundTracingAgentClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundTracingAgentClientInterfaceBase>;
using BackgroundTracingAgentClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundTracingAgentClientInterfaceBase>;
class BackgroundTracingAgentInterfaceBase {};

using BackgroundTracingAgentPtrDataView =
    mojo::InterfacePtrDataView<BackgroundTracingAgentInterfaceBase>;
using BackgroundTracingAgentRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundTracingAgentInterfaceBase>;
using BackgroundTracingAgentAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundTracingAgentInterfaceBase>;
using BackgroundTracingAgentAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundTracingAgentInterfaceBase>;
class BackgroundTracingAgentProviderInterfaceBase {};

using BackgroundTracingAgentProviderPtrDataView =
    mojo::InterfacePtrDataView<BackgroundTracingAgentProviderInterfaceBase>;
using BackgroundTracingAgentProviderRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundTracingAgentProviderInterfaceBase>;
using BackgroundTracingAgentProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundTracingAgentProviderInterfaceBase>;
using BackgroundTracingAgentProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundTracingAgentProviderInterfaceBase>;


class BackgroundTracingRuleDataView {
 public:
  BackgroundTracingRuleDataView() = default;

  BackgroundTracingRuleDataView(
      internal::BackgroundTracingRule_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRuleIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRuleId(UserType* output) {
    
    auto* pointer = data_->rule_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BackgroundTracingRule_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tracing::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::BackgroundTracingRuleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::BackgroundTracingRuleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::BackgroundTracingRule_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::rule_id(input)) in_rule_id = Traits::rule_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rule_id)::BaseType> rule_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_rule_id, rule_id_fragment);
    fragment->rule_id.Set(
        rule_id_fragment.is_null() ? nullptr : rule_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rule_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rule_id in BackgroundTracingRule struct");
  }

  static bool Deserialize(::tracing::mojom::internal::BackgroundTracingRule_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::BackgroundTracingRuleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tracing::mojom {

inline void BackgroundTracingRuleDataView::GetRuleIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rule_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // tracing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_SHARED_H_