// services/network/public/mojom/url_loader_completion_status.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_loader_completion_status.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"



#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace network::mojom {
class BlockedByResponseReasonWrapperDataView;

class URLLoaderCompletionStatusDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::BlockedByResponseReasonWrapperDataView> {
  using Data = ::network::mojom::internal::BlockedByResponseReasonWrapper_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLLoaderCompletionStatusDataView> {
  using Data = ::network::mojom::internal::URLLoaderCompletionStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class BlockedByResponseReasonWrapperDataView {
 public:
  BlockedByResponseReasonWrapperDataView() = default;

  BlockedByResponseReasonWrapperDataView(
      internal::BlockedByResponseReasonWrapper_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::network::mojom::BlockedByResponseReason>(
        data_value, output);
  }
  ::network::mojom::BlockedByResponseReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::BlockedByResponseReason>(data_->reason));
  }
 private:
  internal::BlockedByResponseReasonWrapper_Data* data_ = nullptr;
};


class URLLoaderCompletionStatusDataView {
 public:
  URLLoaderCompletionStatusDataView() = default;

  URLLoaderCompletionStatusDataView(
      internal::URLLoaderCompletionStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t error_code() const {
    return data_->error_code;
  }
  int32_t extended_error_code() const {
    return data_->extended_error_code;
  }
  bool exists_in_cache() const {
    return data_->exists_in_cache;
  }
  bool exists_in_memory_cache() const {
    return data_->exists_in_memory_cache;
  }
  inline void GetCompletionTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCompletionTime(UserType* output) {
    
    auto* pointer = data_->completion_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  int64_t encoded_data_length() const {
    return data_->encoded_data_length;
  }
  int64_t encoded_body_length() const {
    return data_->encoded_body_length;
  }
  int64_t decoded_body_length() const {
    return data_->decoded_body_length;
  }
  inline void GetCorsErrorStatusDataView(
      ::network::mojom::CorsErrorStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsErrorStatus(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CorsErrorStatusDataView, UserType>(),
    "Attempting to read the optional `cors_error_status` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCorsErrorStatus` instead "
    "of `ReadCorsErrorStatus if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cors_error_status.Get();
    return mojo::internal::Deserialize<::network::mojom::CorsErrorStatusDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrivateNetworkAccessPreflightResult(UserType* output) const {
    auto data_value = data_->private_network_access_preflight_result;
    return mojo::internal::Deserialize<::network::mojom::PrivateNetworkAccessPreflightResult>(
        data_value, output);
  }
  ::network::mojom::PrivateNetworkAccessPreflightResult private_network_access_preflight_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::PrivateNetworkAccessPreflightResult>(data_->private_network_access_preflight_result));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenOperationStatus(UserType* output) const {
    auto data_value = data_->trust_token_operation_status;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationStatus>(
        data_value, output);
  }
  ::network::mojom::TrustTokenOperationStatus trust_token_operation_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationStatus>(data_->trust_token_operation_status));
  }
  inline void GetSslInfoDataView(
      ::network::mojom::SSLInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSslInfo(UserType* output) {
    
    auto* pointer = data_->ssl_info.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLInfoDataView>(
        pointer, output, message_);
  }
  inline void GetBlockedByResponseReasonDataView(
      BlockedByResponseReasonWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockedByResponseReason(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::BlockedByResponseReasonWrapperDataView, UserType>(),
    "Attempting to read the optional `blocked_by_response_reason` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlockedByResponseReason` instead "
    "of `ReadBlockedByResponseReason if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blocked_by_response_reason.Get();
    return mojo::internal::Deserialize<::network::mojom::BlockedByResponseReasonWrapperDataView>(
        pointer, output, message_);
  }
  bool should_report_orb_blocking() const {
    return data_->should_report_orb_blocking;
  }
  inline void GetResolveErrorInfoDataView(
      ::network::mojom::ResolveErrorInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResolveErrorInfo(UserType* output) {
    
    auto* pointer = data_->resolve_error_info.Get();
    return mojo::internal::Deserialize<::network::mojom::ResolveErrorInfoDataView>(
        pointer, output, message_);
  }
  bool should_collapse_initiator() const {
    return data_->should_collapse_initiator;
  }
 private:
  internal::URLLoaderCompletionStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::BlockedByResponseReasonWrapperDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::BlockedByResponseReasonWrapperDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::BlockedByResponseReasonWrapper_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::BlockedByResponseReason>(
        Traits::reason(input), &fragment->reason);
  }

  static bool Deserialize(::network::mojom::internal::BlockedByResponseReasonWrapper_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::BlockedByResponseReasonWrapperDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLLoaderCompletionStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLLoaderCompletionStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLLoaderCompletionStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->error_code = Traits::error_code(input);
    fragment->extended_error_code = Traits::extended_error_code(input);
    fragment->exists_in_cache = Traits::exists_in_cache(input);
    fragment->exists_in_memory_cache = Traits::exists_in_memory_cache(input);
    decltype(Traits::completion_time(input)) in_completion_time = Traits::completion_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->completion_time)::BaseType> completion_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_completion_time, completion_time_fragment);
    fragment->completion_time.Set(
        completion_time_fragment.is_null() ? nullptr : completion_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->completion_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null completion_time in URLLoaderCompletionStatus struct");
    fragment->encoded_data_length = Traits::encoded_data_length(input);
    fragment->encoded_body_length = Traits::encoded_body_length(input);
    fragment->decoded_body_length = Traits::decoded_body_length(input);
    decltype(Traits::cors_error_status(input)) in_cors_error_status = Traits::cors_error_status(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cors_error_status)::BaseType> cors_error_status_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::CorsErrorStatusDataView>(
        in_cors_error_status, cors_error_status_fragment);
    fragment->cors_error_status.Set(
        cors_error_status_fragment.is_null() ? nullptr : cors_error_status_fragment.data());
    mojo::internal::Serialize<::network::mojom::PrivateNetworkAccessPreflightResult>(
        Traits::private_network_access_preflight_result(input), &fragment->private_network_access_preflight_result);
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
        Traits::trust_token_operation_status(input), &fragment->trust_token_operation_status);
    decltype(Traits::ssl_info(input)) in_ssl_info = Traits::ssl_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ssl_info)::BaseType> ssl_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
        in_ssl_info, ssl_info_fragment);
    fragment->ssl_info.Set(
        ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());
    decltype(Traits::blocked_by_response_reason(input)) in_blocked_by_response_reason = Traits::blocked_by_response_reason(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blocked_by_response_reason)::BaseType> blocked_by_response_reason_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::BlockedByResponseReasonWrapperDataView>(
        in_blocked_by_response_reason, blocked_by_response_reason_fragment);
    fragment->blocked_by_response_reason.Set(
        blocked_by_response_reason_fragment.is_null() ? nullptr : blocked_by_response_reason_fragment.data());
    fragment->should_report_orb_blocking = Traits::should_report_orb_blocking(input);
    decltype(Traits::resolve_error_info(input)) in_resolve_error_info = Traits::resolve_error_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resolve_error_info)::BaseType> resolve_error_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ResolveErrorInfoDataView>(
        in_resolve_error_info, resolve_error_info_fragment);
    fragment->resolve_error_info.Set(
        resolve_error_info_fragment.is_null() ? nullptr : resolve_error_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->resolve_error_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resolve_error_info in URLLoaderCompletionStatus struct");
    fragment->should_collapse_initiator = Traits::should_collapse_initiator(input);
  }

  static bool Deserialize(::network::mojom::internal::URLLoaderCompletionStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLLoaderCompletionStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {



inline void URLLoaderCompletionStatusDataView::GetCompletionTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->completion_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void URLLoaderCompletionStatusDataView::GetCorsErrorStatusDataView(
    ::network::mojom::CorsErrorStatusDataView* output) {
  auto pointer = data_->cors_error_status.Get();
  *output = ::network::mojom::CorsErrorStatusDataView(pointer, message_);
}
inline void URLLoaderCompletionStatusDataView::GetSslInfoDataView(
    ::network::mojom::SSLInfoDataView* output) {
  auto pointer = data_->ssl_info.Get();
  *output = ::network::mojom::SSLInfoDataView(pointer, message_);
}
inline void URLLoaderCompletionStatusDataView::GetBlockedByResponseReasonDataView(
    BlockedByResponseReasonWrapperDataView* output) {
  auto pointer = data_->blocked_by_response_reason.Get();
  *output = BlockedByResponseReasonWrapperDataView(pointer, message_);
}
inline void URLLoaderCompletionStatusDataView::GetResolveErrorInfoDataView(
    ::network::mojom::ResolveErrorInfoDataView* output) {
  auto pointer = data_->resolve_error_info.Get();
  *output = ::network::mojom::ResolveErrorInfoDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_COMPLETION_STATUS_MOJOM_SHARED_H_