// services/network/public/mojom/client_security_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/client_security_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/client_security_state.mojom-params-data.h"
#include "services/network/public/mojom/client_security_state.mojom-shared-message-ids.h"

#include "services/network/public/mojom/client_security_state.mojom-import-headers.h"
#include "services/network/public/mojom/client_security_state.mojom-test-utils.h"


namespace network::mojom {
ClientSecurityState::ClientSecurityState()
    : cross_origin_embedder_policy(),
      is_web_secure_context(false),
      ip_address_space(::network::mojom::IPAddressSpace::kUnknown),
      private_network_request_policy(PrivateNetworkRequestPolicy::kAllow),
      document_isolation_policy() {}

ClientSecurityState::ClientSecurityState(
    const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy_in,
    bool is_web_secure_context_in,
    ::network::mojom::IPAddressSpace ip_address_space_in,
    PrivateNetworkRequestPolicy private_network_request_policy_in,
    const ::network::DocumentIsolationPolicy& document_isolation_policy_in)
    : cross_origin_embedder_policy(std::move(cross_origin_embedder_policy_in)),
      is_web_secure_context(std::move(is_web_secure_context_in)),
      ip_address_space(std::move(ip_address_space_in)),
      private_network_request_policy(std::move(private_network_request_policy_in)),
      document_isolation_policy(std::move(document_isolation_policy_in)) {}

ClientSecurityState::~ClientSecurityState() = default;

void ClientSecurityState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_embedder_policy"), this->cross_origin_embedder_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::CrossOriginEmbedderPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_web_secure_context"), this->is_web_secure_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_address_space"), this->ip_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_network_request_policy"), this->private_network_request_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PrivateNetworkRequestPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_isolation_policy"), this->document_isolation_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::DocumentIsolationPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClientSecurityState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::ClientSecurityState::DataView, ::network::mojom::ClientSecurityStatePtr>::Read(
    ::network::mojom::ClientSecurityState::DataView input,
    ::network::mojom::ClientSecurityStatePtr* output) {
  bool success = true;
  ::network::mojom::ClientSecurityStatePtr result(::network::mojom::ClientSecurityState::New());
  
      if (success && !input.ReadCrossOriginEmbedderPolicy(&result->cross_origin_embedder_policy))
        success = false;
      if (success)
        result->is_web_secure_context = input.is_web_secure_context();
      if (success && !input.ReadIpAddressSpace(&result->ip_address_space))
        success = false;
      if (success && !input.ReadPrivateNetworkRequestPolicy(&result->private_network_request_policy))
        success = false;
      if (success && !input.ReadDocumentIsolationPolicy(&result->document_isolation_policy))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif