// services/device/public/mojom/input_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/input_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/input_service.mojom-params-data.h"
#include "services/device/public/mojom/input_service.mojom-shared-message-ids.h"

#include "services/device/public/mojom/input_service.mojom-import-headers.h"
#include "services/device/public/mojom/input_service.mojom-test-utils.h"


namespace device::mojom {
InputDeviceInfo::InputDeviceInfo()
    : id(),
      name(),
      subsystem(),
      type(),
      is_accelerometer(),
      is_joystick(),
      is_key(),
      is_keyboard(),
      is_mouse(),
      is_tablet(),
      is_touchpad(),
      is_touchscreen() {}

InputDeviceInfo::InputDeviceInfo(
    const std::string& id_in,
    const std::string& name_in,
    InputDeviceSubsystem subsystem_in,
    InputDeviceType type_in,
    bool is_accelerometer_in,
    bool is_joystick_in,
    bool is_key_in,
    bool is_keyboard_in,
    bool is_mouse_in,
    bool is_tablet_in,
    bool is_touchpad_in,
    bool is_touchscreen_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      subsystem(std::move(subsystem_in)),
      type(std::move(type_in)),
      is_accelerometer(std::move(is_accelerometer_in)),
      is_joystick(std::move(is_joystick_in)),
      is_key(std::move(is_key_in)),
      is_keyboard(std::move(is_keyboard_in)),
      is_mouse(std::move(is_mouse_in)),
      is_tablet(std::move(is_tablet_in)),
      is_touchpad(std::move(is_touchpad_in)),
      is_touchscreen(std::move(is_touchscreen_in)) {}

InputDeviceInfo::~InputDeviceInfo() = default;
size_t InputDeviceInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->subsystem);
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->is_accelerometer);
  seed = mojo::internal::Hash(seed, this->is_joystick);
  seed = mojo::internal::Hash(seed, this->is_key);
  seed = mojo::internal::Hash(seed, this->is_keyboard);
  seed = mojo::internal::Hash(seed, this->is_mouse);
  seed = mojo::internal::Hash(seed, this->is_tablet);
  seed = mojo::internal::Hash(seed, this->is_touchpad);
  seed = mojo::internal::Hash(seed, this->is_touchscreen);
  return seed;
}

void InputDeviceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subsystem"), this->subsystem,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InputDeviceSubsystem>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InputDeviceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_accelerometer"), this->is_accelerometer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_joystick"), this->is_joystick,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_key"), this->is_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_keyboard"), this->is_keyboard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_mouse"), this->is_mouse,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_tablet"), this->is_tablet,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_touchpad"), this->is_touchpad,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_touchscreen"), this->is_touchscreen,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InputDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char InputDeviceManagerClient::Name_[] = "device.mojom.InputDeviceManagerClient";

InputDeviceManagerClient::IPCStableHashFunction InputDeviceManagerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InputDeviceManagerClient>(message.name())) {
    case messages::InputDeviceManagerClient::kInputDeviceAdded: {
      return &InputDeviceManagerClient::InputDeviceAdded_Sym::IPCStableHash;
    }
    case messages::InputDeviceManagerClient::kInputDeviceRemoved: {
      return &InputDeviceManagerClient::InputDeviceRemoved_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InputDeviceManagerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InputDeviceManagerClient>(message.name())) {
      case messages::InputDeviceManagerClient::kInputDeviceAdded:
            return "Receive device::mojom::InputDeviceManagerClient::InputDeviceAdded";
      case messages::InputDeviceManagerClient::kInputDeviceRemoved:
            return "Receive device::mojom::InputDeviceManagerClient::InputDeviceRemoved";
    }
  } else {
    switch (static_cast<messages::InputDeviceManagerClient>(message.name())) {
      case messages::InputDeviceManagerClient::kInputDeviceAdded:
            return "Receive reply device::mojom::InputDeviceManagerClient::InputDeviceAdded";
      case messages::InputDeviceManagerClient::kInputDeviceRemoved:
            return "Receive reply device::mojom::InputDeviceManagerClient::InputDeviceRemoved";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InputDeviceManagerClient::InputDeviceAdded_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::InputDeviceManagerClient::InputDeviceAdded");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InputDeviceManagerClient::InputDeviceRemoved_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::InputDeviceManagerClient::InputDeviceRemoved");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

InputDeviceManagerClientProxy::InputDeviceManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InputDeviceManagerClientProxy::InputDeviceAdded(
    InputDeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::InputDeviceManagerClient::InputDeviceAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type InputDeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputDeviceManagerClient::kInputDeviceAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::InputDeviceManagerClient_InputDeviceAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::InputDeviceInfoDataView>(
      in_device_info, device_info_fragment);
  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in InputDeviceManagerClient.InputDeviceAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputDeviceManagerClient::Name_);
  message.set_method_name("InputDeviceAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void InputDeviceManagerClientProxy::InputDeviceRemoved(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::InputDeviceManagerClient::InputDeviceRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputDeviceManagerClient::kInputDeviceRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::InputDeviceManagerClient_InputDeviceRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in InputDeviceManagerClient.InputDeviceRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputDeviceManagerClient::Name_);
  message.set_method_name("InputDeviceRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool InputDeviceManagerClientStubDispatch::Accept(
    InputDeviceManagerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InputDeviceManagerClient>(message->header()->name)) {
    case messages::InputDeviceManagerClient::kInputDeviceAdded: {
      DCHECK(message->is_serialized());
      internal::InputDeviceManagerClient_InputDeviceAdded_Params_Data* params =
          reinterpret_cast<internal::InputDeviceManagerClient_InputDeviceAdded_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for InputDeviceManagerClient.0
      bool success = true;
      InputDeviceInfoPtr p_device_info{};
      InputDeviceManagerClient_InputDeviceAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputDeviceManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InputDeviceAdded(        
        std::move(p_device_info));
      return true;
    }
    case messages::InputDeviceManagerClient::kInputDeviceRemoved: {
      DCHECK(message->is_serialized());
      internal::InputDeviceManagerClient_InputDeviceRemoved_Params_Data* params =
          reinterpret_cast<internal::InputDeviceManagerClient_InputDeviceRemoved_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for InputDeviceManagerClient.1
      bool success = true;
      std::string p_id{};
      InputDeviceManagerClient_InputDeviceRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputDeviceManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InputDeviceRemoved(        
        std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool InputDeviceManagerClientStubDispatch::AcceptWithResponder(
    InputDeviceManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InputDeviceManagerClient>(message->header()->name)) {
    case messages::InputDeviceManagerClient::kInputDeviceAdded: {
      break;
    }
    case messages::InputDeviceManagerClient::kInputDeviceRemoved: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kInputDeviceManagerClientValidationInfo[] = {
    {base::to_underlying(messages::InputDeviceManagerClient::kInputDeviceAdded),
     { &internal::InputDeviceManagerClient_InputDeviceAdded_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::InputDeviceManagerClient::kInputDeviceRemoved),
     { &internal::InputDeviceManagerClient_InputDeviceRemoved_Params_Data::Validate,
      nullptr /* no response */}},
};

bool InputDeviceManagerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::InputDeviceManagerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kInputDeviceManagerClientValidationInfo);
}

const char InputDeviceManager::Name_[] = "device.mojom.InputDeviceManager";

InputDeviceManager::IPCStableHashFunction InputDeviceManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InputDeviceManager>(message.name())) {
    case messages::InputDeviceManager::kGetDevicesAndSetClient: {
      return &InputDeviceManager::GetDevicesAndSetClient_Sym::IPCStableHash;
    }
    case messages::InputDeviceManager::kGetDevices: {
      return &InputDeviceManager::GetDevices_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InputDeviceManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InputDeviceManager>(message.name())) {
      case messages::InputDeviceManager::kGetDevicesAndSetClient:
            return "Receive device::mojom::InputDeviceManager::GetDevicesAndSetClient";
      case messages::InputDeviceManager::kGetDevices:
            return "Receive device::mojom::InputDeviceManager::GetDevices";
    }
  } else {
    switch (static_cast<messages::InputDeviceManager>(message.name())) {
      case messages::InputDeviceManager::kGetDevicesAndSetClient:
            return "Receive reply device::mojom::InputDeviceManager::GetDevicesAndSetClient";
      case messages::InputDeviceManager::kGetDevices:
            return "Receive reply device::mojom::InputDeviceManager::GetDevices";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InputDeviceManager::GetDevicesAndSetClient_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::InputDeviceManager::GetDevicesAndSetClient");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InputDeviceManager::GetDevices_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::InputDeviceManager::GetDevices");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class InputDeviceManager_GetDevicesAndSetClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputDeviceManager_GetDevicesAndSetClient_ForwardToCallback(
      InputDeviceManager::GetDevicesAndSetClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  InputDeviceManager_GetDevicesAndSetClient_ForwardToCallback(const InputDeviceManager_GetDevicesAndSetClient_ForwardToCallback&) = delete;
  InputDeviceManager_GetDevicesAndSetClient_ForwardToCallback& operator=(const InputDeviceManager_GetDevicesAndSetClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InputDeviceManager::GetDevicesAndSetClientCallback callback_;
};

class InputDeviceManager_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InputDeviceManager_GetDevices_ForwardToCallback(
      InputDeviceManager::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  InputDeviceManager_GetDevices_ForwardToCallback(const InputDeviceManager_GetDevices_ForwardToCallback&) = delete;
  InputDeviceManager_GetDevices_ForwardToCallback& operator=(const InputDeviceManager_GetDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InputDeviceManager::GetDevicesCallback callback_;
};

InputDeviceManagerProxy::InputDeviceManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InputDeviceManagerProxy::GetDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<InputDeviceManagerClient> in_client, GetDevicesAndSetClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::InputDeviceManager::GetDevicesAndSetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<InputDeviceManagerClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputDeviceManager::kGetDevicesAndSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::InputDeviceManager_GetDevicesAndSetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::InputDeviceManagerClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in InputDeviceManager.GetDevicesAndSetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputDeviceManager::Name_);
  message.set_method_name("GetDevicesAndSetClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputDeviceManager_GetDevicesAndSetClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void InputDeviceManagerProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::InputDeviceManager::GetDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputDeviceManager::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::InputDeviceManager_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputDeviceManager::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InputDeviceManager_GetDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class InputDeviceManager_GetDevicesAndSetClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InputDeviceManager::GetDevicesAndSetClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InputDeviceManager_GetDevicesAndSetClient_ProxyToResponder> proxy(
        new InputDeviceManager_GetDevicesAndSetClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InputDeviceManager_GetDevicesAndSetClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputDeviceManager_GetDevicesAndSetClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InputDeviceManager_GetDevicesAndSetClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputDeviceManager::GetDevicesAndSetClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<InputDeviceInfoPtr> in_devices);
};

bool InputDeviceManager_GetDevicesAndSetClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for InputDeviceManager.0
  bool success = true;
  std::vector<InputDeviceInfoPtr> p_devices{};
  InputDeviceManager_GetDevicesAndSetClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputDeviceManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_devices));
  return true;
}

void InputDeviceManager_GetDevicesAndSetClient_ProxyToResponder::Run(
    std::vector<InputDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::InputDeviceManager::GetDevicesAndSetClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type std::vector<InputDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputDeviceManager::kGetDevicesAndSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::InputDeviceInfoDataView>>(
      in_devices, devices_fragment, &devices_validate_params);
  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputDeviceManager::Name_);
  message.set_method_name("GetDevicesAndSetClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class InputDeviceManager_GetDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InputDeviceManager::GetDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InputDeviceManager_GetDevices_ProxyToResponder> proxy(
        new InputDeviceManager_GetDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InputDeviceManager_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InputDeviceManager_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InputDeviceManager_GetDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "InputDeviceManager::GetDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<InputDeviceInfoPtr> in_devices);
};

bool InputDeviceManager_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InputDeviceManager_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InputDeviceManager_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for InputDeviceManager.1
  bool success = true;
  std::vector<InputDeviceInfoPtr> p_devices{};
  InputDeviceManager_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InputDeviceManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_devices));
  return true;
}

void InputDeviceManager_GetDevices_ProxyToResponder::Run(
    std::vector<InputDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::InputDeviceManager::GetDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type std::vector<InputDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InputDeviceManager::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::InputDeviceManager_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::InputDeviceInfoDataView>>(
      in_devices, devices_fragment, &devices_validate_params);
  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InputDeviceManager::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InputDeviceManagerStubDispatch::Accept(
    InputDeviceManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InputDeviceManager>(message->header()->name)) {
    case messages::InputDeviceManager::kGetDevicesAndSetClient: {
      break;
    }
    case messages::InputDeviceManager::kGetDevices: {
      break;
    }
  }
  return false;
}

// static
bool InputDeviceManagerStubDispatch::AcceptWithResponder(
    InputDeviceManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InputDeviceManager>(message->header()->name)) {
    case messages::InputDeviceManager::kGetDevicesAndSetClient: {
      internal::InputDeviceManager_GetDevicesAndSetClient_Params_Data* params =
          reinterpret_cast<
              internal::InputDeviceManager_GetDevicesAndSetClient_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for InputDeviceManager.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<InputDeviceManagerClient> p_client{};
      InputDeviceManager_GetDevicesAndSetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputDeviceManager::Name_, 0, false);
        return false;
      }
      InputDeviceManager::GetDevicesAndSetClientCallback callback =
          InputDeviceManager_GetDevicesAndSetClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevicesAndSetClient(        
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::InputDeviceManager::kGetDevices: {
      internal::InputDeviceManager_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::InputDeviceManager_GetDevices_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for InputDeviceManager.1
      bool success = true;
      InputDeviceManager_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InputDeviceManager::Name_, 1, false);
        return false;
      }
      InputDeviceManager::GetDevicesCallback callback =
          InputDeviceManager_GetDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kInputDeviceManagerValidationInfo[] = {
    {base::to_underlying(messages::InputDeviceManager::kGetDevicesAndSetClient),
     { &internal::InputDeviceManager_GetDevicesAndSetClient_Params_Data::Validate,
      &internal::InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::InputDeviceManager::kGetDevices),
     { &internal::InputDeviceManager_GetDevices_Params_Data::Validate,
      &internal::InputDeviceManager_GetDevices_ResponseParams_Data::Validate}},
};

bool InputDeviceManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::InputDeviceManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kInputDeviceManagerValidationInfo);
}

bool InputDeviceManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::InputDeviceManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kInputDeviceManagerValidationInfo);

}


}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::InputDeviceInfo::DataView, ::device::mojom::InputDeviceInfoPtr>::Read(
    ::device::mojom::InputDeviceInfo::DataView input,
    ::device::mojom::InputDeviceInfoPtr* output) {
  bool success = true;
  ::device::mojom::InputDeviceInfoPtr result(::device::mojom::InputDeviceInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadSubsystem(&result->subsystem))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->is_accelerometer = input.is_accelerometer();
      if (success)
        result->is_joystick = input.is_joystick();
      if (success)
        result->is_key = input.is_key();
      if (success)
        result->is_keyboard = input.is_keyboard();
      if (success)
        result->is_mouse = input.is_mouse();
      if (success)
        result->is_tablet = input.is_tablet();
      if (success)
        result->is_touchpad = input.is_touchpad();
      if (success)
        result->is_touchscreen = input.is_touchscreen();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void InputDeviceManagerClientInterceptorForTesting::InputDeviceAdded(InputDeviceInfoPtr device_info) {
  GetForwardingInterface()->InputDeviceAdded(
    std::move(device_info)
    );
}
void InputDeviceManagerClientInterceptorForTesting::InputDeviceRemoved(const std::string& id) {
  GetForwardingInterface()->InputDeviceRemoved(
    std::move(id)
    );
}
InputDeviceManagerClientAsyncWaiter::InputDeviceManagerClientAsyncWaiter(
    InputDeviceManagerClient* proxy) : proxy_(proxy) {}

InputDeviceManagerClientAsyncWaiter::~InputDeviceManagerClientAsyncWaiter() = default;




void InputDeviceManagerInterceptorForTesting::GetDevicesAndSetClient(::mojo::PendingAssociatedRemote<InputDeviceManagerClient> client, GetDevicesAndSetClientCallback callback) {
  GetForwardingInterface()->GetDevicesAndSetClient(
    std::move(client)
    , std::move(callback));
}
void InputDeviceManagerInterceptorForTesting::GetDevices(GetDevicesCallback callback) {
  GetForwardingInterface()->GetDevices(std::move(callback));
}
InputDeviceManagerAsyncWaiter::InputDeviceManagerAsyncWaiter(
    InputDeviceManager* proxy) : proxy_(proxy) {}

InputDeviceManagerAsyncWaiter::~InputDeviceManagerAsyncWaiter() = default;

void InputDeviceManagerAsyncWaiter::GetDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<InputDeviceManagerClient> client, std::vector<InputDeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetDevicesAndSetClient(
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<InputDeviceInfoPtr>* out_devices
,
             std::vector<InputDeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

std::vector<InputDeviceInfoPtr> InputDeviceManagerAsyncWaiter::GetDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<InputDeviceManagerClient> client) {
  std::vector<InputDeviceInfoPtr> async_wait_result;
  GetDevicesAndSetClient(std::move(client),&async_wait_result);
  return async_wait_result;
}

void InputDeviceManagerAsyncWaiter::GetDevices(
    std::vector<InputDeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<InputDeviceInfoPtr>* out_devices
,
             std::vector<InputDeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

std::vector<InputDeviceInfoPtr> InputDeviceManagerAsyncWaiter::GetDevices(
    ) {
  std::vector<InputDeviceInfoPtr> async_wait_result;
  GetDevices(&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif