// services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-params-data.h"
#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared-message-ids.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-import-headers.h"
#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-test-utils.h"


namespace cert_verifier::mojom {
CertVerifierCreationParams::CertVerifierCreationParams()
    : initial_additional_certificates(),
      wait_for_update(false) {}

CertVerifierCreationParams::CertVerifierCreationParams(
    ::cert_verifier::mojom::AdditionalCertificatesPtr initial_additional_certificates_in,
    bool wait_for_update_in)
    : initial_additional_certificates(std::move(initial_additional_certificates_in)),
      wait_for_update(std::move(wait_for_update_in)) {}

CertVerifierCreationParams::~CertVerifierCreationParams() = default;

void CertVerifierCreationParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_additional_certificates"), this->initial_additional_certificates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cert_verifier::mojom::AdditionalCertificatesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_update"), this->wait_for_update,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CertVerifierCreationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ChromeRootCertInfo::ChromeRootCertInfo()
    : sha256hash_hex(),
      cert() {}

ChromeRootCertInfo::ChromeRootCertInfo(
    const std::string& sha256hash_hex_in,
    std::vector<uint8_t> cert_in)
    : sha256hash_hex(std::move(sha256hash_hex_in)),
      cert(std::move(cert_in)) {}

ChromeRootCertInfo::~ChromeRootCertInfo() = default;

void ChromeRootCertInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sha256hash_hex"), this->sha256hash_hex,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert"), this->cert,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChromeRootCertInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ChromeRootStoreInfo::ChromeRootStoreInfo()
    : version(),
      root_cert_info() {}

ChromeRootStoreInfo::ChromeRootStoreInfo(
    int64_t version_in,
    std::vector<ChromeRootCertInfoPtr> root_cert_info_in)
    : version(std::move(version_in)),
      root_cert_info(std::move(root_cert_info_in)) {}

ChromeRootStoreInfo::~ChromeRootStoreInfo() = default;

void ChromeRootStoreInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_cert_info"), this->root_cert_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ChromeRootCertInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChromeRootStoreInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PlatformCertInfo::PlatformCertInfo()
    : cert(),
      trust_setting() {}

PlatformCertInfo::PlatformCertInfo(
    std::vector<uint8_t> cert_in,
    CertificateTrust trust_setting_in)
    : cert(std::move(cert_in)),
      trust_setting(std::move(trust_setting_in)) {}

PlatformCertInfo::~PlatformCertInfo() = default;

void PlatformCertInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert"), this->cert,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_setting"), this->trust_setting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CertificateTrust>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PlatformCertInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PlatformRootStoreInfo::PlatformRootStoreInfo()
    : user_added_certs() {}

PlatformRootStoreInfo::PlatformRootStoreInfo(
    std::vector<PlatformCertInfoPtr> user_added_certs_in)
    : user_added_certs(std::move(user_added_certs_in)) {}

PlatformRootStoreInfo::~PlatformRootStoreInfo() = default;

void PlatformRootStoreInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_added_certs"), this->user_added_certs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PlatformCertInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PlatformRootStoreInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CertVerifierServiceFactory::Name_[] = "cert_verifier.mojom.CertVerifierServiceFactory";

CertVerifierServiceFactory::IPCStableHashFunction CertVerifierServiceFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertVerifierServiceFactory>(message.name())) {
    case messages::CertVerifierServiceFactory::kGetNewCertVerifier: {
      return &CertVerifierServiceFactory::GetNewCertVerifier_Sym::IPCStableHash;
    }
    case messages::CertVerifierServiceFactory::kUpdateCRLSet: {
      return &CertVerifierServiceFactory::UpdateCRLSet_Sym::IPCStableHash;
    }
    case messages::CertVerifierServiceFactory::kUpdateCtLogList: {
      return &CertVerifierServiceFactory::UpdateCtLogList_Sym::IPCStableHash;
    }
    case messages::CertVerifierServiceFactory::kUpdateChromeRootStore: {
      return &CertVerifierServiceFactory::UpdateChromeRootStore_Sym::IPCStableHash;
    }
    case messages::CertVerifierServiceFactory::kGetChromeRootStoreInfo: {
      return &CertVerifierServiceFactory::GetChromeRootStoreInfo_Sym::IPCStableHash;
    }
    case messages::CertVerifierServiceFactory::kGetPlatformRootStoreInfo: {
      return &CertVerifierServiceFactory::GetPlatformRootStoreInfo_Sym::IPCStableHash;
    }
    case messages::CertVerifierServiceFactory::kUpdateNetworkTime: {
      return &CertVerifierServiceFactory::UpdateNetworkTime_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertVerifierServiceFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertVerifierServiceFactory>(message.name())) {
      case messages::CertVerifierServiceFactory::kGetNewCertVerifier:
            return "Receive cert_verifier::mojom::CertVerifierServiceFactory::GetNewCertVerifier";
      case messages::CertVerifierServiceFactory::kUpdateCRLSet:
            return "Receive cert_verifier::mojom::CertVerifierServiceFactory::UpdateCRLSet";
      case messages::CertVerifierServiceFactory::kUpdateCtLogList:
            return "Receive cert_verifier::mojom::CertVerifierServiceFactory::UpdateCtLogList";
      case messages::CertVerifierServiceFactory::kUpdateChromeRootStore:
            return "Receive cert_verifier::mojom::CertVerifierServiceFactory::UpdateChromeRootStore";
      case messages::CertVerifierServiceFactory::kGetChromeRootStoreInfo:
            return "Receive cert_verifier::mojom::CertVerifierServiceFactory::GetChromeRootStoreInfo";
      case messages::CertVerifierServiceFactory::kGetPlatformRootStoreInfo:
            return "Receive cert_verifier::mojom::CertVerifierServiceFactory::GetPlatformRootStoreInfo";
      case messages::CertVerifierServiceFactory::kUpdateNetworkTime:
            return "Receive cert_verifier::mojom::CertVerifierServiceFactory::UpdateNetworkTime";
    }
  } else {
    switch (static_cast<messages::CertVerifierServiceFactory>(message.name())) {
      case messages::CertVerifierServiceFactory::kGetNewCertVerifier:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceFactory::GetNewCertVerifier";
      case messages::CertVerifierServiceFactory::kUpdateCRLSet:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceFactory::UpdateCRLSet";
      case messages::CertVerifierServiceFactory::kUpdateCtLogList:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceFactory::UpdateCtLogList";
      case messages::CertVerifierServiceFactory::kUpdateChromeRootStore:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceFactory::UpdateChromeRootStore";
      case messages::CertVerifierServiceFactory::kGetChromeRootStoreInfo:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceFactory::GetChromeRootStoreInfo";
      case messages::CertVerifierServiceFactory::kGetPlatformRootStoreInfo:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceFactory::GetPlatformRootStoreInfo";
      case messages::CertVerifierServiceFactory::kUpdateNetworkTime:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceFactory::UpdateNetworkTime";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertVerifierServiceFactory::GetNewCertVerifier_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::GetNewCertVerifier");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierServiceFactory::UpdateCRLSet_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::UpdateCRLSet");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierServiceFactory::UpdateCtLogList_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::UpdateCtLogList");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierServiceFactory::UpdateChromeRootStore_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::UpdateChromeRootStore");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierServiceFactory::GetChromeRootStoreInfo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::GetChromeRootStoreInfo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierServiceFactory::GetPlatformRootStoreInfo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::GetPlatformRootStoreInfo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierServiceFactory::UpdateNetworkTime_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::UpdateNetworkTime");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CertVerifierServiceFactory_UpdateCRLSet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertVerifierServiceFactory_UpdateCRLSet_ForwardToCallback(
      CertVerifierServiceFactory::UpdateCRLSetCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertVerifierServiceFactory_UpdateCRLSet_ForwardToCallback(const CertVerifierServiceFactory_UpdateCRLSet_ForwardToCallback&) = delete;
  CertVerifierServiceFactory_UpdateCRLSet_ForwardToCallback& operator=(const CertVerifierServiceFactory_UpdateCRLSet_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertVerifierServiceFactory::UpdateCRLSetCallback callback_;
};

class CertVerifierServiceFactory_UpdateCtLogList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertVerifierServiceFactory_UpdateCtLogList_ForwardToCallback(
      CertVerifierServiceFactory::UpdateCtLogListCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertVerifierServiceFactory_UpdateCtLogList_ForwardToCallback(const CertVerifierServiceFactory_UpdateCtLogList_ForwardToCallback&) = delete;
  CertVerifierServiceFactory_UpdateCtLogList_ForwardToCallback& operator=(const CertVerifierServiceFactory_UpdateCtLogList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertVerifierServiceFactory::UpdateCtLogListCallback callback_;
};

class CertVerifierServiceFactory_UpdateChromeRootStore_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertVerifierServiceFactory_UpdateChromeRootStore_ForwardToCallback(
      CertVerifierServiceFactory::UpdateChromeRootStoreCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertVerifierServiceFactory_UpdateChromeRootStore_ForwardToCallback(const CertVerifierServiceFactory_UpdateChromeRootStore_ForwardToCallback&) = delete;
  CertVerifierServiceFactory_UpdateChromeRootStore_ForwardToCallback& operator=(const CertVerifierServiceFactory_UpdateChromeRootStore_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertVerifierServiceFactory::UpdateChromeRootStoreCallback callback_;
};

class CertVerifierServiceFactory_GetChromeRootStoreInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertVerifierServiceFactory_GetChromeRootStoreInfo_ForwardToCallback(
      CertVerifierServiceFactory::GetChromeRootStoreInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertVerifierServiceFactory_GetChromeRootStoreInfo_ForwardToCallback(const CertVerifierServiceFactory_GetChromeRootStoreInfo_ForwardToCallback&) = delete;
  CertVerifierServiceFactory_GetChromeRootStoreInfo_ForwardToCallback& operator=(const CertVerifierServiceFactory_GetChromeRootStoreInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertVerifierServiceFactory::GetChromeRootStoreInfoCallback callback_;
};

class CertVerifierServiceFactory_GetPlatformRootStoreInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertVerifierServiceFactory_GetPlatformRootStoreInfo_ForwardToCallback(
      CertVerifierServiceFactory::GetPlatformRootStoreInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertVerifierServiceFactory_GetPlatformRootStoreInfo_ForwardToCallback(const CertVerifierServiceFactory_GetPlatformRootStoreInfo_ForwardToCallback&) = delete;
  CertVerifierServiceFactory_GetPlatformRootStoreInfo_ForwardToCallback& operator=(const CertVerifierServiceFactory_GetPlatformRootStoreInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertVerifierServiceFactory::GetPlatformRootStoreInfoCallback callback_;
};

CertVerifierServiceFactoryProxy::CertVerifierServiceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertVerifierServiceFactoryProxy::GetNewCertVerifier(
    ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierService> in_receiver, ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceUpdater> in_updater, ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierServiceClient> in_client, CertVerifierCreationParamsPtr in_creation_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierServiceFactory::GetNewCertVerifier", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updater"), in_updater,
                        "<value of type ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceUpdater>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierServiceClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("creation_params"), in_creation_params,
                        "<value of type CertVerifierCreationParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kGetNewCertVerifier), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::cert_verifier::mojom::CertVerifierServiceInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in CertVerifierServiceFactory.GetNewCertVerifier request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::cert_verifier::mojom::CertVerifierServiceUpdaterInterfaceBase>>(
      in_updater, &params->updater, &params.message());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::CertVerifierServiceClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in CertVerifierServiceFactory.GetNewCertVerifier request");
  mojo::internal::MessageFragment<
      typename decltype(params->creation_params)::BaseType> creation_params_fragment(
          params.message());
  mojo::internal::Serialize<::cert_verifier::mojom::CertVerifierCreationParamsDataView>(
      in_creation_params, creation_params_fragment);
  params->creation_params.Set(
      creation_params_fragment.is_null() ? nullptr : creation_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("GetNewCertVerifier");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CertVerifierServiceFactoryProxy::UpdateCRLSet(
    ::mojo_base::BigBuffer in_crl_set, UpdateCRLSetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierServiceFactory::UpdateCRLSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("crl_set"), in_crl_set,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kUpdateCRLSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_UpdateCRLSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->crl_set)>
      crl_set_fragment(params.message());
  crl_set_fragment.Claim(&params->crl_set);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_crl_set, crl_set_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->crl_set.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null crl_set in CertVerifierServiceFactory.UpdateCRLSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("UpdateCRLSet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertVerifierServiceFactory_UpdateCRLSet_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertVerifierServiceFactoryProxy::UpdateCtLogList(
    std::vector<::network::mojom::CTLogInfoPtr> in_log_list, ::base::Time in_update_time, UpdateCtLogListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierServiceFactory::UpdateCtLogList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_list"), in_log_list,
                        "<value of type std::vector<::network::mojom::CTLogInfoPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_time"), in_update_time,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kUpdateCtLogList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_UpdateCtLogList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->log_list)::BaseType>
      log_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& log_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CTLogInfoDataView>>(
      in_log_list, log_list_fragment, &log_list_validate_params);
  params->log_list.Set(
      log_list_fragment.is_null() ? nullptr : log_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->log_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null log_list in CertVerifierServiceFactory.UpdateCtLogList request");
  mojo::internal::MessageFragment<
      typename decltype(params->update_time)::BaseType> update_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_update_time, update_time_fragment);
  params->update_time.Set(
      update_time_fragment.is_null() ? nullptr : update_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->update_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null update_time in CertVerifierServiceFactory.UpdateCtLogList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("UpdateCtLogList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertVerifierServiceFactory_UpdateCtLogList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertVerifierServiceFactoryProxy::UpdateChromeRootStore(
    ::mojo_base::ProtoWrapper in_new_root_store, UpdateChromeRootStoreCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierServiceFactory::UpdateChromeRootStore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_root_store"), in_new_root_store,
                        "<value of type ::mojo_base::ProtoWrapper>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kUpdateChromeRootStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_root_store)::BaseType> new_root_store_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
      in_new_root_store, new_root_store_fragment);
  params->new_root_store.Set(
      new_root_store_fragment.is_null() ? nullptr : new_root_store_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_root_store.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_root_store in CertVerifierServiceFactory.UpdateChromeRootStore request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("UpdateChromeRootStore");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertVerifierServiceFactory_UpdateChromeRootStore_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertVerifierServiceFactoryProxy::GetChromeRootStoreInfo(
    GetChromeRootStoreInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send cert_verifier::mojom::CertVerifierServiceFactory::GetChromeRootStoreInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kGetChromeRootStoreInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("GetChromeRootStoreInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertVerifierServiceFactory_GetChromeRootStoreInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertVerifierServiceFactoryProxy::GetPlatformRootStoreInfo(
    GetPlatformRootStoreInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send cert_verifier::mojom::CertVerifierServiceFactory::GetPlatformRootStoreInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kGetPlatformRootStoreInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("GetPlatformRootStoreInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertVerifierServiceFactory_GetPlatformRootStoreInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertVerifierServiceFactoryProxy::UpdateNetworkTime(
    ::base::Time in_system_time, ::base::TimeTicks in_system_ticks, ::base::Time in_current_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierServiceFactory::UpdateNetworkTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("system_time"), in_system_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("system_ticks"), in_system_ticks,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_time"), in_current_time,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kUpdateNetworkTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_UpdateNetworkTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->system_time)::BaseType> system_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_system_time, system_time_fragment);
  params->system_time.Set(
      system_time_fragment.is_null() ? nullptr : system_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->system_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null system_time in CertVerifierServiceFactory.UpdateNetworkTime request");
  mojo::internal::MessageFragment<
      typename decltype(params->system_ticks)::BaseType> system_ticks_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_system_ticks, system_ticks_fragment);
  params->system_ticks.Set(
      system_ticks_fragment.is_null() ? nullptr : system_ticks_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->system_ticks.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null system_ticks in CertVerifierServiceFactory.UpdateNetworkTime request");
  mojo::internal::MessageFragment<
      typename decltype(params->current_time)::BaseType> current_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_current_time, current_time_fragment);
  params->current_time.Set(
      current_time_fragment.is_null() ? nullptr : current_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->current_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null current_time in CertVerifierServiceFactory.UpdateNetworkTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("UpdateNetworkTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CertVerifierServiceFactory_UpdateCRLSet_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertVerifierServiceFactory::UpdateCRLSetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertVerifierServiceFactory_UpdateCRLSet_ProxyToResponder> proxy(
        new CertVerifierServiceFactory_UpdateCRLSet_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertVerifierServiceFactory_UpdateCRLSet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertVerifierServiceFactory_UpdateCRLSet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertVerifierServiceFactory_UpdateCRLSet_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CertVerifierServiceFactory::UpdateCRLSetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool CertVerifierServiceFactory_UpdateCRLSet_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for CertVerifierServiceFactory.1
  bool success = true;
  CertVerifierServiceFactory_UpdateCRLSet_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertVerifierServiceFactory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CertVerifierServiceFactory_UpdateCRLSet_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply cert_verifier::mojom::CertVerifierServiceFactory::UpdateCRLSet");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kUpdateCRLSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("UpdateCRLSet");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertVerifierServiceFactory_UpdateCtLogList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertVerifierServiceFactory::UpdateCtLogListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertVerifierServiceFactory_UpdateCtLogList_ProxyToResponder> proxy(
        new CertVerifierServiceFactory_UpdateCtLogList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertVerifierServiceFactory_UpdateCtLogList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertVerifierServiceFactory_UpdateCtLogList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertVerifierServiceFactory_UpdateCtLogList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CertVerifierServiceFactory::UpdateCtLogListCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool CertVerifierServiceFactory_UpdateCtLogList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for CertVerifierServiceFactory.2
  bool success = true;
  CertVerifierServiceFactory_UpdateCtLogList_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertVerifierServiceFactory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CertVerifierServiceFactory_UpdateCtLogList_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply cert_verifier::mojom::CertVerifierServiceFactory::UpdateCtLogList");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kUpdateCtLogList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("UpdateCtLogList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertVerifierServiceFactory_UpdateChromeRootStore_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertVerifierServiceFactory::UpdateChromeRootStoreCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertVerifierServiceFactory_UpdateChromeRootStore_ProxyToResponder> proxy(
        new CertVerifierServiceFactory_UpdateChromeRootStore_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertVerifierServiceFactory_UpdateChromeRootStore_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertVerifierServiceFactory_UpdateChromeRootStore_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertVerifierServiceFactory_UpdateChromeRootStore_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CertVerifierServiceFactory::UpdateChromeRootStoreCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool CertVerifierServiceFactory_UpdateChromeRootStore_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for CertVerifierServiceFactory.3
  bool success = true;
  CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertVerifierServiceFactory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CertVerifierServiceFactory_UpdateChromeRootStore_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply cert_verifier::mojom::CertVerifierServiceFactory::UpdateChromeRootStore");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kUpdateChromeRootStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("UpdateChromeRootStore");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertVerifierServiceFactory_GetChromeRootStoreInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertVerifierServiceFactory::GetChromeRootStoreInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertVerifierServiceFactory_GetChromeRootStoreInfo_ProxyToResponder> proxy(
        new CertVerifierServiceFactory_GetChromeRootStoreInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertVerifierServiceFactory_GetChromeRootStoreInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertVerifierServiceFactory_GetChromeRootStoreInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertVerifierServiceFactory_GetChromeRootStoreInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CertVerifierServiceFactory::GetChromeRootStoreInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ChromeRootStoreInfoPtr in_root_store_info);
};

bool CertVerifierServiceFactory_GetChromeRootStoreInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for CertVerifierServiceFactory.4
  bool success = true;
  ChromeRootStoreInfoPtr p_root_store_info{};
  CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRootStoreInfo(&p_root_store_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertVerifierServiceFactory::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_root_store_info));
  return true;
}

void CertVerifierServiceFactory_GetChromeRootStoreInfo_ProxyToResponder::Run(
    ChromeRootStoreInfoPtr in_root_store_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply cert_verifier::mojom::CertVerifierServiceFactory::GetChromeRootStoreInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_store_info"), in_root_store_info,
                        "<value of type ChromeRootStoreInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kGetChromeRootStoreInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_store_info)::BaseType> root_store_info_fragment(
          params.message());
  mojo::internal::Serialize<::cert_verifier::mojom::ChromeRootStoreInfoDataView>(
      in_root_store_info, root_store_info_fragment);
  params->root_store_info.Set(
      root_store_info_fragment.is_null() ? nullptr : root_store_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->root_store_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null root_store_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("GetChromeRootStoreInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertVerifierServiceFactory_GetPlatformRootStoreInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertVerifierServiceFactory::GetPlatformRootStoreInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertVerifierServiceFactory_GetPlatformRootStoreInfo_ProxyToResponder> proxy(
        new CertVerifierServiceFactory_GetPlatformRootStoreInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertVerifierServiceFactory_GetPlatformRootStoreInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertVerifierServiceFactory_GetPlatformRootStoreInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertVerifierServiceFactory_GetPlatformRootStoreInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CertVerifierServiceFactory::GetPlatformRootStoreInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PlatformRootStoreInfoPtr in_root_store_info);
};

bool CertVerifierServiceFactory_GetPlatformRootStoreInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for CertVerifierServiceFactory.5
  bool success = true;
  PlatformRootStoreInfoPtr p_root_store_info{};
  CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRootStoreInfo(&p_root_store_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertVerifierServiceFactory::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_root_store_info));
  return true;
}

void CertVerifierServiceFactory_GetPlatformRootStoreInfo_ProxyToResponder::Run(
    PlatformRootStoreInfoPtr in_root_store_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply cert_verifier::mojom::CertVerifierServiceFactory::GetPlatformRootStoreInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_store_info"), in_root_store_info,
                        "<value of type PlatformRootStoreInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceFactory::kGetPlatformRootStoreInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_store_info)::BaseType> root_store_info_fragment(
          params.message());
  mojo::internal::Serialize<::cert_verifier::mojom::PlatformRootStoreInfoDataView>(
      in_root_store_info, root_store_info_fragment);
  params->root_store_info.Set(
      root_store_info_fragment.is_null() ? nullptr : root_store_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->root_store_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null root_store_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("GetPlatformRootStoreInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CertVerifierServiceFactoryStubDispatch::Accept(
    CertVerifierServiceFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertVerifierServiceFactory>(message->header()->name)) {
    case messages::CertVerifierServiceFactory::kGetNewCertVerifier: {
      DCHECK(message->is_serialized());
      internal::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data* params =
          reinterpret_cast<internal::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CertVerifierServiceFactory.0
      bool success = true;
      ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierService> p_receiver{};
      ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceUpdater> p_updater{};
      ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierServiceClient> p_client{};
      CertVerifierCreationParamsPtr p_creation_params{};
      CertVerifierServiceFactory_GetNewCertVerifier_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_updater =
            input_data_view.TakeUpdater<decltype(p_updater)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadCreationParams(&p_creation_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNewCertVerifier(        
        std::move(p_receiver), 
        std::move(p_updater), 
        std::move(p_client), 
        std::move(p_creation_params));
      return true;
    }
    case messages::CertVerifierServiceFactory::kUpdateCRLSet: {
      break;
    }
    case messages::CertVerifierServiceFactory::kUpdateCtLogList: {
      break;
    }
    case messages::CertVerifierServiceFactory::kUpdateChromeRootStore: {
      break;
    }
    case messages::CertVerifierServiceFactory::kGetChromeRootStoreInfo: {
      break;
    }
    case messages::CertVerifierServiceFactory::kGetPlatformRootStoreInfo: {
      break;
    }
    case messages::CertVerifierServiceFactory::kUpdateNetworkTime: {
      DCHECK(message->is_serialized());
      internal::CertVerifierServiceFactory_UpdateNetworkTime_Params_Data* params =
          reinterpret_cast<internal::CertVerifierServiceFactory_UpdateNetworkTime_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CertVerifierServiceFactory.6
      bool success = true;
      ::base::Time p_system_time{};
      ::base::TimeTicks p_system_ticks{};
      ::base::Time p_current_time{};
      CertVerifierServiceFactory_UpdateNetworkTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSystemTime(&p_system_time))
        success = false;
      if (success && !input_data_view.ReadSystemTicks(&p_system_ticks))
        success = false;
      if (success && !input_data_view.ReadCurrentTime(&p_current_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceFactory::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateNetworkTime(        
        std::move(p_system_time), 
        std::move(p_system_ticks), 
        std::move(p_current_time));
      return true;
    }
  }
  return false;
}

// static
bool CertVerifierServiceFactoryStubDispatch::AcceptWithResponder(
    CertVerifierServiceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertVerifierServiceFactory>(message->header()->name)) {
    case messages::CertVerifierServiceFactory::kGetNewCertVerifier: {
      break;
    }
    case messages::CertVerifierServiceFactory::kUpdateCRLSet: {
      internal::CertVerifierServiceFactory_UpdateCRLSet_Params_Data* params =
          reinterpret_cast<
              internal::CertVerifierServiceFactory_UpdateCRLSet_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for CertVerifierServiceFactory.1
      bool success = true;
      ::mojo_base::BigBuffer p_crl_set{};
      CertVerifierServiceFactory_UpdateCRLSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCrlSet(&p_crl_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceFactory::Name_, 1, false);
        return false;
      }
      CertVerifierServiceFactory::UpdateCRLSetCallback callback =
          CertVerifierServiceFactory_UpdateCRLSet_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCRLSet(        
        std::move(p_crl_set), std::move(callback));
      return true;
    }
    case messages::CertVerifierServiceFactory::kUpdateCtLogList: {
      internal::CertVerifierServiceFactory_UpdateCtLogList_Params_Data* params =
          reinterpret_cast<
              internal::CertVerifierServiceFactory_UpdateCtLogList_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for CertVerifierServiceFactory.2
      bool success = true;
      std::vector<::network::mojom::CTLogInfoPtr> p_log_list{};
      ::base::Time p_update_time{};
      CertVerifierServiceFactory_UpdateCtLogList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLogList(&p_log_list))
        success = false;
      if (success && !input_data_view.ReadUpdateTime(&p_update_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceFactory::Name_, 2, false);
        return false;
      }
      CertVerifierServiceFactory::UpdateCtLogListCallback callback =
          CertVerifierServiceFactory_UpdateCtLogList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCtLogList(        
        std::move(p_log_list), 
        std::move(p_update_time), std::move(callback));
      return true;
    }
    case messages::CertVerifierServiceFactory::kUpdateChromeRootStore: {
      internal::CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data* params =
          reinterpret_cast<
              internal::CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for CertVerifierServiceFactory.3
      bool success = true;
      ::mojo_base::ProtoWrapper p_new_root_store{mojo::internal::DefaultConstructTag()};
      CertVerifierServiceFactory_UpdateChromeRootStore_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewRootStore(&p_new_root_store))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceFactory::Name_, 3, false);
        return false;
      }
      CertVerifierServiceFactory::UpdateChromeRootStoreCallback callback =
          CertVerifierServiceFactory_UpdateChromeRootStore_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateChromeRootStore(        
        std::move(p_new_root_store), std::move(callback));
      return true;
    }
    case messages::CertVerifierServiceFactory::kGetChromeRootStoreInfo: {
      internal::CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data* params =
          reinterpret_cast<
              internal::CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for CertVerifierServiceFactory.4
      bool success = true;
      CertVerifierServiceFactory_GetChromeRootStoreInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceFactory::Name_, 4, false);
        return false;
      }
      CertVerifierServiceFactory::GetChromeRootStoreInfoCallback callback =
          CertVerifierServiceFactory_GetChromeRootStoreInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetChromeRootStoreInfo(std::move(callback));
      return true;
    }
    case messages::CertVerifierServiceFactory::kGetPlatformRootStoreInfo: {
      internal::CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data* params =
          reinterpret_cast<
              internal::CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for CertVerifierServiceFactory.5
      bool success = true;
      CertVerifierServiceFactory_GetPlatformRootStoreInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceFactory::Name_, 5, false);
        return false;
      }
      CertVerifierServiceFactory::GetPlatformRootStoreInfoCallback callback =
          CertVerifierServiceFactory_GetPlatformRootStoreInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPlatformRootStoreInfo(std::move(callback));
      return true;
    }
    case messages::CertVerifierServiceFactory::kUpdateNetworkTime: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCertVerifierServiceFactoryValidationInfo[] = {
    {base::to_underlying(messages::CertVerifierServiceFactory::kGetNewCertVerifier),
     { &internal::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CertVerifierServiceFactory::kUpdateCRLSet),
     { &internal::CertVerifierServiceFactory_UpdateCRLSet_Params_Data::Validate,
      &internal::CertVerifierServiceFactory_UpdateCRLSet_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CertVerifierServiceFactory::kUpdateCtLogList),
     { &internal::CertVerifierServiceFactory_UpdateCtLogList_Params_Data::Validate,
      &internal::CertVerifierServiceFactory_UpdateCtLogList_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CertVerifierServiceFactory::kUpdateChromeRootStore),
     { &internal::CertVerifierServiceFactory_UpdateChromeRootStore_Params_Data::Validate,
      &internal::CertVerifierServiceFactory_UpdateChromeRootStore_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CertVerifierServiceFactory::kGetChromeRootStoreInfo),
     { &internal::CertVerifierServiceFactory_GetChromeRootStoreInfo_Params_Data::Validate,
      &internal::CertVerifierServiceFactory_GetChromeRootStoreInfo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CertVerifierServiceFactory::kGetPlatformRootStoreInfo),
     { &internal::CertVerifierServiceFactory_GetPlatformRootStoreInfo_Params_Data::Validate,
      &internal::CertVerifierServiceFactory_GetPlatformRootStoreInfo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CertVerifierServiceFactory::kUpdateNetworkTime),
     { &internal::CertVerifierServiceFactory_UpdateNetworkTime_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CertVerifierServiceFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::cert_verifier::mojom::CertVerifierServiceFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCertVerifierServiceFactoryValidationInfo);
}

bool CertVerifierServiceFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::cert_verifier::mojom::CertVerifierServiceFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCertVerifierServiceFactoryValidationInfo);

}


}  // cert_verifier::mojom


namespace mojo {


// static
bool StructTraits<::cert_verifier::mojom::CertVerifierCreationParams::DataView, ::cert_verifier::mojom::CertVerifierCreationParamsPtr>::Read(
    ::cert_verifier::mojom::CertVerifierCreationParams::DataView input,
    ::cert_verifier::mojom::CertVerifierCreationParamsPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::CertVerifierCreationParamsPtr result(::cert_verifier::mojom::CertVerifierCreationParams::New());
  
      if (success && !input.ReadInitialAdditionalCertificates(&result->initial_additional_certificates))
        success = false;
      if (success)
        result->wait_for_update = input.wait_for_update();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cert_verifier::mojom::ChromeRootCertInfo::DataView, ::cert_verifier::mojom::ChromeRootCertInfoPtr>::Read(
    ::cert_verifier::mojom::ChromeRootCertInfo::DataView input,
    ::cert_verifier::mojom::ChromeRootCertInfoPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::ChromeRootCertInfoPtr result(::cert_verifier::mojom::ChromeRootCertInfo::New());
  
      if (success && !input.ReadSha256hashHex(&result->sha256hash_hex))
        success = false;
      if (success && !input.ReadCert(&result->cert))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cert_verifier::mojom::ChromeRootStoreInfo::DataView, ::cert_verifier::mojom::ChromeRootStoreInfoPtr>::Read(
    ::cert_verifier::mojom::ChromeRootStoreInfo::DataView input,
    ::cert_verifier::mojom::ChromeRootStoreInfoPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::ChromeRootStoreInfoPtr result(::cert_verifier::mojom::ChromeRootStoreInfo::New());
  
      if (success)
        result->version = input.version();
      if (success && !input.ReadRootCertInfo(&result->root_cert_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cert_verifier::mojom::PlatformCertInfo::DataView, ::cert_verifier::mojom::PlatformCertInfoPtr>::Read(
    ::cert_verifier::mojom::PlatformCertInfo::DataView input,
    ::cert_verifier::mojom::PlatformCertInfoPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::PlatformCertInfoPtr result(::cert_verifier::mojom::PlatformCertInfo::New());
  
      if (success && !input.ReadCert(&result->cert))
        success = false;
      if (success && !input.ReadTrustSetting(&result->trust_setting))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cert_verifier::mojom::PlatformRootStoreInfo::DataView, ::cert_verifier::mojom::PlatformRootStoreInfoPtr>::Read(
    ::cert_verifier::mojom::PlatformRootStoreInfo::DataView input,
    ::cert_verifier::mojom::PlatformRootStoreInfoPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::PlatformRootStoreInfoPtr result(::cert_verifier::mojom::PlatformRootStoreInfo::New());
  
      if (success && !input.ReadUserAddedCerts(&result->user_added_certs))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace cert_verifier::mojom {


void CertVerifierServiceFactoryInterceptorForTesting::GetNewCertVerifier(::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierService> receiver, ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceUpdater> updater, ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierServiceClient> client, CertVerifierCreationParamsPtr creation_params) {
  GetForwardingInterface()->GetNewCertVerifier(
    std::move(receiver)
    , 
    std::move(updater)
    , 
    std::move(client)
    , 
    std::move(creation_params)
    );
}
void CertVerifierServiceFactoryInterceptorForTesting::UpdateCRLSet(::mojo_base::BigBuffer crl_set, UpdateCRLSetCallback callback) {
  GetForwardingInterface()->UpdateCRLSet(
    std::move(crl_set)
    , std::move(callback));
}
void CertVerifierServiceFactoryInterceptorForTesting::UpdateCtLogList(std::vector<::network::mojom::CTLogInfoPtr> log_list, ::base::Time update_time, UpdateCtLogListCallback callback) {
  GetForwardingInterface()->UpdateCtLogList(
    std::move(log_list)
    , 
    std::move(update_time)
    , std::move(callback));
}
void CertVerifierServiceFactoryInterceptorForTesting::UpdateChromeRootStore(::mojo_base::ProtoWrapper new_root_store, UpdateChromeRootStoreCallback callback) {
  GetForwardingInterface()->UpdateChromeRootStore(
    std::move(new_root_store)
    , std::move(callback));
}
void CertVerifierServiceFactoryInterceptorForTesting::GetChromeRootStoreInfo(GetChromeRootStoreInfoCallback callback) {
  GetForwardingInterface()->GetChromeRootStoreInfo(std::move(callback));
}
void CertVerifierServiceFactoryInterceptorForTesting::GetPlatformRootStoreInfo(GetPlatformRootStoreInfoCallback callback) {
  GetForwardingInterface()->GetPlatformRootStoreInfo(std::move(callback));
}
void CertVerifierServiceFactoryInterceptorForTesting::UpdateNetworkTime(::base::Time system_time, ::base::TimeTicks system_ticks, ::base::Time current_time) {
  GetForwardingInterface()->UpdateNetworkTime(
    std::move(system_time)
    , 
    std::move(system_ticks)
    , 
    std::move(current_time)
    );
}
CertVerifierServiceFactoryAsyncWaiter::CertVerifierServiceFactoryAsyncWaiter(
    CertVerifierServiceFactory* proxy) : proxy_(proxy) {}

CertVerifierServiceFactoryAsyncWaiter::~CertVerifierServiceFactoryAsyncWaiter() = default;

void CertVerifierServiceFactoryAsyncWaiter::UpdateCRLSet(
    ::mojo_base::BigBuffer crl_set) {
  base::RunLoop loop;
  proxy_->UpdateCRLSet(
      std::move(crl_set),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void CertVerifierServiceFactoryAsyncWaiter::UpdateCtLogList(
    std::vector<::network::mojom::CTLogInfoPtr> log_list, ::base::Time update_time) {
  base::RunLoop loop;
  proxy_->UpdateCtLogList(
      std::move(log_list),
      std::move(update_time),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void CertVerifierServiceFactoryAsyncWaiter::UpdateChromeRootStore(
    ::mojo_base::ProtoWrapper new_root_store) {
  base::RunLoop loop;
  proxy_->UpdateChromeRootStore(
      std::move(new_root_store),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void CertVerifierServiceFactoryAsyncWaiter::GetChromeRootStoreInfo(
    ChromeRootStoreInfoPtr* out_root_store_info) {
  base::RunLoop loop;
  proxy_->GetChromeRootStoreInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             ChromeRootStoreInfoPtr* out_root_store_info
,
             ChromeRootStoreInfoPtr root_store_info) {*out_root_store_info = std::move(root_store_info);
            loop->Quit();
          },
          &loop,
          out_root_store_info));
  loop.Run();
}

ChromeRootStoreInfoPtr CertVerifierServiceFactoryAsyncWaiter::GetChromeRootStoreInfo(
    ) {
  ChromeRootStoreInfoPtr async_wait_result;
  GetChromeRootStoreInfo(&async_wait_result);
  return async_wait_result;
}

void CertVerifierServiceFactoryAsyncWaiter::GetPlatformRootStoreInfo(
    PlatformRootStoreInfoPtr* out_root_store_info) {
  base::RunLoop loop;
  proxy_->GetPlatformRootStoreInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             PlatformRootStoreInfoPtr* out_root_store_info
,
             PlatformRootStoreInfoPtr root_store_info) {*out_root_store_info = std::move(root_store_info);
            loop->Quit();
          },
          &loop,
          out_root_store_info));
  loop.Run();
}

PlatformRootStoreInfoPtr CertVerifierServiceFactoryAsyncWaiter::GetPlatformRootStoreInfo(
    ) {
  PlatformRootStoreInfoPtr async_wait_result;
  GetPlatformRootStoreInfo(&async_wait_result);
  return async_wait_result;
}






}  // cert_verifier::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif