// qtwebengine/browser/qtwebenginepage.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/browser/qtwebenginepage.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/browser/qtwebenginepage.mojom-params-data.h"
#include "qtwebengine/browser/qtwebenginepage.mojom-shared-message-ids.h"

#include "qtwebengine/browser/qtwebenginepage.mojom-import-headers.h"
#include "qtwebengine/browser/qtwebenginepage.mojom-test-utils.h"


namespace qtwebenginepage::mojom {
const char WebEnginePageRenderFrame::Name_[] = "qtwebenginepage.mojom.WebEnginePageRenderFrame";

WebEnginePageRenderFrame::IPCStableHashFunction WebEnginePageRenderFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebEnginePageRenderFrame>(message.name())) {
    case messages::WebEnginePageRenderFrame::kFetchDocumentMarkup: {
      return &WebEnginePageRenderFrame::FetchDocumentMarkup_Sym::IPCStableHash;
    }
    case messages::WebEnginePageRenderFrame::kFetchDocumentInnerText: {
      return &WebEnginePageRenderFrame::FetchDocumentInnerText_Sym::IPCStableHash;
    }
    case messages::WebEnginePageRenderFrame::kSetBackgroundColor: {
      return &WebEnginePageRenderFrame::SetBackgroundColor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebEnginePageRenderFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebEnginePageRenderFrame>(message.name())) {
      case messages::WebEnginePageRenderFrame::kFetchDocumentMarkup:
            return "Receive qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkup";
      case messages::WebEnginePageRenderFrame::kFetchDocumentInnerText:
            return "Receive qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerText";
      case messages::WebEnginePageRenderFrame::kSetBackgroundColor:
            return "Receive qtwebenginepage::mojom::WebEnginePageRenderFrame::SetBackgroundColor";
    }
  } else {
    switch (static_cast<messages::WebEnginePageRenderFrame>(message.name())) {
      case messages::WebEnginePageRenderFrame::kFetchDocumentMarkup:
            return "Receive reply qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkup";
      case messages::WebEnginePageRenderFrame::kFetchDocumentInnerText:
            return "Receive reply qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerText";
      case messages::WebEnginePageRenderFrame::kSetBackgroundColor:
            return "Receive reply qtwebenginepage::mojom::WebEnginePageRenderFrame::SetBackgroundColor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebEnginePageRenderFrame::FetchDocumentMarkup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebEnginePageRenderFrame::FetchDocumentInnerText_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerText");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebEnginePageRenderFrame::SetBackgroundColor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::SetBackgroundColor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback(
      WebEnginePageRenderFrame::FetchDocumentMarkupCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback(const WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback&) = delete;
  WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback& operator=(const WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebEnginePageRenderFrame::FetchDocumentMarkupCallback callback_;
};

class WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback(
      WebEnginePageRenderFrame::FetchDocumentInnerTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback(const WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback&) = delete;
  WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback& operator=(const WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebEnginePageRenderFrame::FetchDocumentInnerTextCallback callback_;
};

WebEnginePageRenderFrameProxy::WebEnginePageRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebEnginePageRenderFrameProxy::FetchDocumentMarkup(
    uint64_t in_requestId, FetchDocumentMarkupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requestId"), in_requestId,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebEnginePageRenderFrame::kFetchDocumentMarkup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_FetchDocumentMarkup_Params_Data> params(
          message);
  params.Allocate();
  params->requestId = in_requestId;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("FetchDocumentMarkup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebEnginePageRenderFrameProxy::FetchDocumentInnerText(
    uint64_t in_requestId, FetchDocumentInnerTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requestId"), in_requestId,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebEnginePageRenderFrame::kFetchDocumentInnerText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_FetchDocumentInnerText_Params_Data> params(
          message);
  params.Allocate();
  params->requestId = in_requestId;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("FetchDocumentInnerText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebEnginePageRenderFrameProxy::SetBackgroundColor(
    uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebenginepage::mojom::WebEnginePageRenderFrame::SetBackgroundColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebEnginePageRenderFrame::kSetBackgroundColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_SetBackgroundColor_Params_Data> params(
          message);
  params.Allocate();
  params->color = in_color;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("SetBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebEnginePageRenderFrame::FetchDocumentMarkupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder> proxy(
        new WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebEnginePageRenderFrame::FetchDocumentMarkupCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_requestId, const std::string& in_markup);
};

bool WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for WebEnginePageRenderFrame.0
  bool success = true;
  uint64_t p_requestId{};
  std::string p_markup{};
  WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_requestId = input_data_view.requestId();
  if (success && !input_data_view.ReadMarkup(&p_markup))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebEnginePageRenderFrame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_requestId), 
std::move(p_markup));
  return true;
}

void WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder::Run(
    uint64_t in_requestId, const std::string& in_markup) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requestId"), in_requestId,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), in_markup,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebEnginePageRenderFrame::kFetchDocumentMarkup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->requestId = in_requestId;
  mojo::internal::MessageFragment<
      typename decltype(params->markup)::BaseType> markup_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_markup, markup_fragment);
  params->markup.Set(
      markup_fragment.is_null() ? nullptr : markup_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->markup.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null markup in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("FetchDocumentMarkup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebEnginePageRenderFrame::FetchDocumentInnerTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder> proxy(
        new WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebEnginePageRenderFrame::FetchDocumentInnerTextCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_requestId, const std::string& in_text);
};

bool WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for WebEnginePageRenderFrame.1
  bool success = true;
  uint64_t p_requestId{};
  std::string p_text{};
  WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_requestId = input_data_view.requestId();
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebEnginePageRenderFrame::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_requestId), 
std::move(p_text));
  return true;
}

void WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder::Run(
    uint64_t in_requestId, const std::string& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerText", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requestId"), in_requestId,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebEnginePageRenderFrame::kFetchDocumentInnerText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->requestId = in_requestId;
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_text, text_fragment);
  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("FetchDocumentInnerText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebEnginePageRenderFrameStubDispatch::Accept(
    WebEnginePageRenderFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebEnginePageRenderFrame>(message->header()->name)) {
    case messages::WebEnginePageRenderFrame::kFetchDocumentMarkup: {
      break;
    }
    case messages::WebEnginePageRenderFrame::kFetchDocumentInnerText: {
      break;
    }
    case messages::WebEnginePageRenderFrame::kSetBackgroundColor: {
      DCHECK(message->is_serialized());
      internal::WebEnginePageRenderFrame_SetBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::WebEnginePageRenderFrame_SetBackgroundColor_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for WebEnginePageRenderFrame.2
      bool success = true;
      uint32_t p_color{};
      WebEnginePageRenderFrame_SetBackgroundColor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_color = input_data_view.color();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebEnginePageRenderFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundColor(        
        std::move(p_color));
      return true;
    }
  }
  return false;
}

// static
bool WebEnginePageRenderFrameStubDispatch::AcceptWithResponder(
    WebEnginePageRenderFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebEnginePageRenderFrame>(message->header()->name)) {
    case messages::WebEnginePageRenderFrame::kFetchDocumentMarkup: {
      internal::WebEnginePageRenderFrame_FetchDocumentMarkup_Params_Data* params =
          reinterpret_cast<
              internal::WebEnginePageRenderFrame_FetchDocumentMarkup_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for WebEnginePageRenderFrame.0
      bool success = true;
      uint64_t p_requestId{};
      WebEnginePageRenderFrame_FetchDocumentMarkup_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_requestId = input_data_view.requestId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebEnginePageRenderFrame::Name_, 0, false);
        return false;
      }
      WebEnginePageRenderFrame::FetchDocumentMarkupCallback callback =
          WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchDocumentMarkup(        
        std::move(p_requestId), std::move(callback));
      return true;
    }
    case messages::WebEnginePageRenderFrame::kFetchDocumentInnerText: {
      internal::WebEnginePageRenderFrame_FetchDocumentInnerText_Params_Data* params =
          reinterpret_cast<
              internal::WebEnginePageRenderFrame_FetchDocumentInnerText_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for WebEnginePageRenderFrame.1
      bool success = true;
      uint64_t p_requestId{};
      WebEnginePageRenderFrame_FetchDocumentInnerText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_requestId = input_data_view.requestId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebEnginePageRenderFrame::Name_, 1, false);
        return false;
      }
      WebEnginePageRenderFrame::FetchDocumentInnerTextCallback callback =
          WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchDocumentInnerText(        
        std::move(p_requestId), std::move(callback));
      return true;
    }
    case messages::WebEnginePageRenderFrame::kSetBackgroundColor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebEnginePageRenderFrameValidationInfo[] = {
    {base::to_underlying(messages::WebEnginePageRenderFrame::kFetchDocumentMarkup),
     { &internal::WebEnginePageRenderFrame_FetchDocumentMarkup_Params_Data::Validate,
      &internal::WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::WebEnginePageRenderFrame::kFetchDocumentInnerText),
     { &internal::WebEnginePageRenderFrame_FetchDocumentInnerText_Params_Data::Validate,
      &internal::WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::WebEnginePageRenderFrame::kSetBackgroundColor),
     { &internal::WebEnginePageRenderFrame_SetBackgroundColor_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebEnginePageRenderFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebenginepage::mojom::WebEnginePageRenderFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebEnginePageRenderFrameValidationInfo);
}

bool WebEnginePageRenderFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebenginepage::mojom::WebEnginePageRenderFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kWebEnginePageRenderFrameValidationInfo);

}


}  // qtwebenginepage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace qtwebenginepage::mojom {


void WebEnginePageRenderFrameInterceptorForTesting::FetchDocumentMarkup(uint64_t requestId, FetchDocumentMarkupCallback callback) {
  GetForwardingInterface()->FetchDocumentMarkup(
    std::move(requestId)
    , std::move(callback));
}
void WebEnginePageRenderFrameInterceptorForTesting::FetchDocumentInnerText(uint64_t requestId, FetchDocumentInnerTextCallback callback) {
  GetForwardingInterface()->FetchDocumentInnerText(
    std::move(requestId)
    , std::move(callback));
}
void WebEnginePageRenderFrameInterceptorForTesting::SetBackgroundColor(uint32_t color) {
  GetForwardingInterface()->SetBackgroundColor(
    std::move(color)
    );
}
WebEnginePageRenderFrameAsyncWaiter::WebEnginePageRenderFrameAsyncWaiter(
    WebEnginePageRenderFrame* proxy) : proxy_(proxy) {}

WebEnginePageRenderFrameAsyncWaiter::~WebEnginePageRenderFrameAsyncWaiter() = default;

void WebEnginePageRenderFrameAsyncWaiter::FetchDocumentMarkup(
    uint64_t requestId, uint64_t* out_requestId, std::string* out_markup) {
  base::RunLoop loop;
  proxy_->FetchDocumentMarkup(
      std::move(requestId),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_requestId
,
             std::string* out_markup
,
             uint64_t requestId,
             const std::string& markup) {*out_requestId = std::move(requestId);*out_markup = std::move(markup);
            loop->Quit();
          },
          &loop,
          out_requestId,
          out_markup));
  loop.Run();
}



void WebEnginePageRenderFrameAsyncWaiter::FetchDocumentInnerText(
    uint64_t requestId, uint64_t* out_requestId, std::string* out_text) {
  base::RunLoop loop;
  proxy_->FetchDocumentInnerText(
      std::move(requestId),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_requestId
,
             std::string* out_text
,
             uint64_t requestId,
             const std::string& text) {*out_requestId = std::move(requestId);*out_text = std::move(text);
            loop->Quit();
          },
          &loop,
          out_requestId,
          out_text));
  loop.Run();
}








}  // qtwebenginepage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif