// mojo/public/interfaces/bindings/native_struct.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_NATIVE_STRUCT_MOJOM_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_NATIVE_STRUCT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/interfaces/bindings/native_struct.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/interfaces/bindings/native_struct.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "base/component_export.h"




namespace mojo::native {









class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) SerializedHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerializedHandle, T>::value>;
  using DataView = SerializedHandleDataView;
  using Data_ = internal::SerializedHandle_Data;

  template <typename... Args>
  static SerializedHandlePtr New(Args&&... args) {
    return SerializedHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerializedHandlePtr From(const U& u) {
    return mojo::TypeConverter<SerializedHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializedHandle>::Convert(*this);
  }


  SerializedHandle();

  SerializedHandle(
      ::mojo::ScopedHandle the_handle,
      SerializedHandleType type);

SerializedHandle(const SerializedHandle&) = delete;
SerializedHandle& operator=(const SerializedHandle&) = delete;

  ~SerializedHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerializedHandlePtr>
  SerializedHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerializedHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerializedHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerializedHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializedHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerializedHandle_UnserializedMessageContext<
            UserType, SerializedHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerializedHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerializedHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerializedHandle_UnserializedMessageContext<
            UserType, SerializedHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerializedHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::ScopedHandle the_handle;
  
  SerializedHandleType type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerializedHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerializedHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerializedHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerializedHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) NativeStruct {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativeStruct, T>::value>;
  using DataView = NativeStructDataView;
  using Data_ = internal::NativeStruct_Data;

  template <typename... Args>
  static NativeStructPtr New(Args&&... args) {
    return NativeStructPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativeStructPtr From(const U& u) {
    return mojo::TypeConverter<NativeStructPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativeStruct>::Convert(*this);
  }


  NativeStruct();

  NativeStruct(
      std::vector<uint8_t> data,
      std::optional<std::vector<SerializedHandlePtr>> handles);

NativeStruct(const NativeStruct&) = delete;
NativeStruct& operator=(const NativeStruct&) = delete;

  ~NativeStruct();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativeStructPtr>
  NativeStructPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativeStruct::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NativeStruct::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NativeStruct::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativeStruct::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativeStruct_UnserializedMessageContext<
            UserType, NativeStruct::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NativeStruct::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NativeStruct::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativeStruct_UnserializedMessageContext<
            UserType, NativeStruct::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativeStruct::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> data;
  
  std::optional<std::vector<SerializedHandlePtr>> handles;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativeStruct::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativeStruct::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativeStruct::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativeStruct::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SerializedHandlePtr SerializedHandle::Clone() const {
  return New(
      mojo::Clone(the_handle),
      mojo::Clone(type)
  );
}

template <typename T, SerializedHandle::EnableIfSame<T>*>
bool SerializedHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->the_handle, other_struct.the_handle))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, SerializedHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.the_handle < rhs.the_handle)
    return true;
  if (rhs.the_handle < lhs.the_handle)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
NativeStructPtr NativeStruct::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(handles)
  );
}

template <typename T, NativeStruct::EnableIfSame<T>*>
bool NativeStruct::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->handles, other_struct.handles))
    return false;
  return true;
}

template <typename T, NativeStruct::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.handles < rhs.handles)
    return true;
  if (rhs.handles < lhs.handles)
    return false;
  return false;
}


}  // mojo::native

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::native::SerializedHandle::DataView,
                                         ::mojo::native::SerializedHandlePtr> {
  static bool IsNull(const ::mojo::native::SerializedHandlePtr& input) { return !input; }
  static void SetToNull(::mojo::native::SerializedHandlePtr* output) { output->reset(); }

  static  decltype(::mojo::native::SerializedHandle::the_handle)& the_handle(
       ::mojo::native::SerializedHandlePtr& input) {
    return input->the_handle;
  }

  static decltype(::mojo::native::SerializedHandle::type) type(
      const ::mojo::native::SerializedHandlePtr& input) {
    return input->type;
  }

  static bool Read(::mojo::native::SerializedHandle::DataView input, ::mojo::native::SerializedHandlePtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::native::NativeStruct::DataView,
                                         ::mojo::native::NativeStructPtr> {
  static bool IsNull(const ::mojo::native::NativeStructPtr& input) { return !input; }
  static void SetToNull(::mojo::native::NativeStructPtr* output) { output->reset(); }

  static const decltype(::mojo::native::NativeStruct::data)& data(
      const ::mojo::native::NativeStructPtr& input) {
    return input->data;
  }

  static  decltype(::mojo::native::NativeStruct::handles)& handles(
       ::mojo::native::NativeStructPtr& input) {
    return input->handles;
  }

  static bool Read(::mojo::native::NativeStruct::DataView input, ::mojo::native::NativeStructPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_NATIVE_STRUCT_MOJOM_H_